/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.OrbitElementsSet;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.scene.system.update.GraphUpdater;
import gaiasky.scene.system.update.ModelUpdater;
import gaiasky.scene.system.update.TrajectoryUpdater;
import gaiasky.util.time.ITimeFrameProvider;

public class ElementsSetUpdater
extends AbstractUpdateSystem {
    private final GraphUpdater graphUpdater;
    private final TrajectoryUpdater trajectoryUpdater;
    private final ModelUpdater modelUpdater;

    public ElementsSetUpdater(Family family, int priority) {
        super(family, priority);
        this.graphUpdater = new GraphUpdater(null, 0, GaiaSky.instance.time);
        this.trajectoryUpdater = new TrajectoryUpdater(null, 0);
        this.modelUpdater = new ModelUpdater(null, 0);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        ITimeFrameProvider time = GaiaSky.instance.time;
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if (graph.children != null) {
            Base base = (Base)Mapper.base.get(entity);
            OrbitElementsSet set = (OrbitElementsSet)Mapper.orbitElementsSet.get(entity);
            this.graphUpdater.setCamera(GaiaSky.instance.cameraManager);
            if (set.initialUpdate) {
                for (int i = 0; i < graph.children.size; ++i) {
                    Entity child = (Entity)graph.children.get(i);
                    this.update(child, deltaTime, time, graph, base);
                }
                set.initialUpdate = false;
            } else {
                for (int i = 0; i < set.alwaysUpdate.size; ++i) {
                    Entity child = (Entity)set.alwaysUpdate.get(i);
                    this.update(child, deltaTime, time, graph, base);
                }
            }
        }
    }

    private void update(Entity entity, float deltaTime, ITimeFrameProvider time, GraphNode parentGraph, Base parentBase) {
        this.graphUpdater.update(entity, time, parentGraph.translation, parentBase.opacity);
        if (Mapper.trajectory.has(entity)) {
            this.trajectoryUpdater.updateEntity(entity, deltaTime);
        } else if (Mapper.model.has(entity)) {
            this.modelUpdater.updateEntity(entity, deltaTime);
        }
    }
}

