/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.Gdx;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.LocationMark;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.MotorEngine;
import gaiasky.scene.component.Orientation;
import gaiasky.scene.component.ParticleExtra;
import gaiasky.scene.component.ProperMotion;
import gaiasky.scene.component.Shape;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.component.tag.TagNoProcess;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.scene.view.SpacecraftView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import net.jafama.FastMath;

public class GraphUpdater
extends AbstractUpdateSystem {
    private static final Logger.Log logger = Logger.getLogger(GraphUpdater.class);
    private final ITimeFrameProvider time;
    int processed = 0;
    int lastProcessed;
    private ICamera camera;
    private final Vector3D D31;
    private final Vector3Q B31;
    private final SpacecraftView view;

    public GraphUpdater(Family family, int priority, ITimeFrameProvider time) {
        super(family, priority);
        this.time = time;
        this.D31 = new Vector3D();
        this.B31 = new Vector3Q();
        this.view = new SpacecraftView();
    }

    public void setCamera(ICamera camera) {
        this.camera = camera;
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.processed = 0;
        this.updateEntity(entity, deltaTime);
        if (this.lastProcessed != this.processed) {
            logger.debug("Number of nodes (new): " + this.processed);
            this.lastProcessed = this.processed;
            this.printTree(entity, " ", 0, new AtomicInteger(1));
        }
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        GraphNode root = (GraphNode)entity.getComponent(GraphNode.class);
        root.translation.set(this.camera.getInversePos());
        this.update(entity, this.time, null, 1.0f);
    }

    public void printTree(Entity entity, String tab, int level, AtomicInteger count) {
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if (graph.mustUpdateFunction == null || graph.mustUpdateFunction.apply(this, entity, graph).booleanValue()) {
            boolean processChildren;
            Base base = (Base)Mapper.base.get(entity);
            logger.debug(count.getAndIncrement() + "|" + level + ":" + tab + base.getName() + " (" + (graph.children != null ? graph.children.size : 0) + ")" + (String)(base.archetype != null ? " [" + base.archetype.getName() + "]" : ""));
            boolean bl = processChildren = !Mapper.tagNoProcessChildren.has(entity);
            if (processChildren && graph.children != null) {
                for (int i = 0; i < graph.children.size; ++i) {
                    Entity child = (Entity)graph.children.get(i);
                    this.printTree(child, tab + "  ", level + 1, count);
                }
            }
        }
    }

    public void update(Entity entity, ITimeFrameProvider time, Vector3Q parentTranslation, float opacity) {
        ++this.processed;
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if (graph.mustUpdateFunction == null || graph.mustUpdateFunction.apply(this, entity, graph).booleanValue()) {
            boolean processChildren;
            Orientation orientation;
            Base base = (Base)Mapper.base.get(entity);
            Body body = (Body)Mapper.body.get(entity);
            Fade fade = (Fade)Mapper.fade.get(entity);
            if (time.getHdiff() != 0.0 && (orientation = (Orientation)Mapper.orientation.get(entity)) != null && orientation.rotationComponent != null) {
                orientation.rotationComponent.update(time);
            }
            if (graph.positionUpdaterConsumer != null) {
                graph.positionUpdaterConsumer.apply(this, entity, body, graph);
            }
            graph.translation.set(parentTranslation).add(body.pos);
            this.B31.set(this.D31.set(graph.translation).add(this.camera.getPos()));
            Coordinates.cartesianToSpherical(this.B31, this.D31);
            body.posSph.set((float)(57.29577951308232 * this.D31.x), (float)(57.29577951308232 * this.D31.y));
            if (fade != null && (fade.fadeIn != null || fade.fadeOut != null)) {
                Base parentBase;
                base.opacity = fade.fadeInMap == null || fade.fadeInMap.x <= 0.0 ? opacity : (graph.parent != null ? ((parentBase = (Base)Mapper.base.get(graph.parent)).isVisible() ? parentBase.getVisibilityOpacityFactor() : 0.0f) : 1.0f);
                this.updateFadeDistance(entity, body, fade);
                this.updateFadeOpacity(base, fade);
            } else {
                base.opacity = opacity;
            }
            base.opacity *= base.getVisibilityOpacityFactor();
            body.distToCamera = graph.translation.lenDouble();
            if (Mapper.extra.has(entity)) {
                body.solidAngle = ((ParticleExtra)Mapper.extra.get((Entity)entity)).radius / body.distToCamera;
                body.solidAngleApparent = body.solidAngle * (double)Settings.settings.scene.star.brightness / (double)this.camera.getFovFactor();
            } else {
                Model model = (Model)Mapper.model.get(entity);
                double modelSize = model != null ? model.modelSize : 1.0;
                body.solidAngle = FastMath.atan((double)((double)body.size * modelSize / body.distToCamera));
                body.solidAngleApparent = body.solidAngle / (double)this.camera.getFovFactor();
            }
            DatasetDescription ds = (DatasetDescription)Mapper.datasetDescription.get(entity);
            boolean bl = processChildren = Mapper.tagCopy.has(entity) || !Mapper.tagNoProcessChildren.has(entity) && (ds == null || GaiaSky.instance.isOn(base.ct));
            if (processChildren && graph.children != null && opacity > 0.0f) {
                for (int i = 0; i < graph.children.size; ++i) {
                    Entity child = (Entity)graph.children.get(i);
                    this.update(child, time, graph.translation, this.getChildrenOpacity(entity, child, base, fade, opacity));
                }
            }
        }
    }

    private float getChildrenOpacity(Entity entity, Entity child, Base base, Fade fade, float opacity) {
        if (Mapper.billboardSet.has(entity) && Mapper.tagBackgroundModel.has(child)) {
            return 1.0f - base.opacity;
        }
        if (fade != null) {
            return base.opacity;
        }
        return opacity;
    }

    private void updateFadeDistance(Entity entity, Body body, Fade fade) {
        fade.currentDistance = fade.fadePositionObject != null ? ((Body)Mapper.body.get((Entity)fade.fadePositionObject)).distToCamera : (fade.fadePosition != null ? this.D31.set(fade.fadePosition).sub(this.camera.getPos()).len() * (double)this.camera.getFovFactor() : this.D31.set(this.camera.getPos()).len() * (double)this.camera.getFovFactor());
        body.distToCamera = fade.fadePositionObject == null || fade.fadePositionObject == entity ? body.pos.dst(this.camera.getPos(), this.B31).doubleValue() : ((Body)Mapper.body.get((Entity)fade.fadePositionObject)).distToCamera;
    }

    private void updateFadeOpacity(Base base, Fade fade) {
        if (fade.fadeIn != null) {
            base.opacity *= (float)MathUtilsDouble.lint(fade.currentDistance, fade.fadeIn.x, fade.fadeIn.y, fade.fadeInMap.x, fade.fadeInMap.y);
        }
        if (fade.fadeOut != null) {
            base.opacity *= (float)MathUtilsDouble.lint(fade.currentDistance, fade.fadeOut.x, fade.fadeOut.y, fade.fadeOutMap.x, fade.fadeOutMap.y);
        }
    }

    protected float getVisibilityOpacityFactor(Base base) {
        long msSinceStateChange = this.msSinceStateChange(base);
        if (msSinceStateChange > Settings.settings.scene.fadeMs) {
            return base.visible ? 1.0f : 0.0f;
        }
        float fadeOpacity = MathUtilsDouble.lint(msSinceStateChange, 0L, Settings.settings.scene.fadeMs, 0.0f, 1.0f);
        if (!base.visible) {
            fadeOpacity = 1.0f - fadeOpacity;
        }
        return fadeOpacity;
    }

    protected long msSinceStateChange(Base base) {
        return (long)(GaiaSky.instance.getT() * 1000.0) - base.lastStateChangeTimeMs;
    }

    public boolean mustUpdatePerimeter(Entity entity, GraphNode graph) {
        boolean enabled = GaiaSky.instance.sceneRenderer.isOn(ComponentTypes.ComponentType.Countries);
        if (enabled) {
            entity.remove(TagNoProcess.class);
        } else if (entity.getComponent(TagNoProcess.class) == null) {
            entity.add(this.getEngine().createComponent(TagNoProcess.class));
        }
        return enabled;
    }

    public boolean mustUpdateLoc(Entity entity, GraphNode graph) {
        boolean enabled = GaiaSky.instance.sceneRenderer.isOn(ComponentTypes.ComponentType.Locations);
        if (enabled) {
            boolean update;
            Body parentBody = (Body)Mapper.body.get(graph.parent);
            SolidAngle parentSa = (SolidAngle)Mapper.sa.get(graph.parent);
            boolean bl = update = parentBody.solidAngle > parentSa.thresholdQuad * 30.0;
            if (update) {
                entity.remove(TagNoProcess.class);
            } else if (entity.getComponent(TagNoProcess.class) == null) {
                entity.add(this.getEngine().createComponent(TagNoProcess.class));
            }
            return update;
        }
        if (!Mapper.tagNoProcess.has(entity)) {
            entity.add(this.getEngine().createComponent(TagNoProcess.class));
        }
        return false;
    }

    public void updatePositionDefault(Entity entity, Body body, GraphNode graph) {
        ProperMotion pm = (ProperMotion)Mapper.pm.get(entity);
        if (this.time.getHdiff() != 0.0 || pm != null && pm.hasPm) {
            gaiasky.scene.component.Coordinates coordinates = (gaiasky.scene.component.Coordinates)Mapper.coordinates.get(entity);
            if (coordinates != null && coordinates.coordinates != null) {
                coordinates.timeOverflow = coordinates.coordinates.getEquatorialCartesianCoordinates(this.time.getTime(), body.pos) == null;
            } else if (!body.positionSetInScript) {
                body.pos.set(body.posEpoch);
            }
            if (pm != null && pm.hasPm) {
                Vector3D pmv = this.D31.set(pm.pm).scl(AstroUtils.getMsSince(this.time.getTime(), pm.epochJd) * 3.168808781402895E-11);
                body.pos.add(pmv);
            }
        }
    }

    public void updatePositionLocationMark(Entity entity, Body body, GraphNode graph) {
        LocationMark loc = (LocationMark)Mapper.loc.get(entity);
        body.pos.set(loc.location3d);
    }

    public void updateShapeObject(Entity entity, Body body, GraphNode graph) {
        Shape shape = (Shape)Mapper.shape.get(entity);
        if (shape != null && shape.track != null) {
            EntityUtils.getAbsolutePosition(shape.track.getEntity(), shape.trackName.toLowerCase(Locale.ROOT), body.pos);
        } else {
            this.updatePositionDefault(entity, body, graph);
        }
    }

    public void updateSpacecraft(Entity entity, Body body, GraphNode graph) {
        this.view.setEntity(entity);
        MotorEngine engine = this.view.engine;
        if (engine.yawv != 0.0 || engine.pitchv != 0.0 || engine.rollv != 0.0 || engine.vel.len2() != 0.0 || engine.render) {
            gaiasky.scene.component.Coordinates coordinates = (gaiasky.scene.component.Coordinates)Mapper.coordinates.get(entity);
            if (this.camera.getMode().isSpacecraft()) {
                this.view.pollKeys(Gdx.graphics.getDeltaTime());
            }
            double dt = this.time.getDt();
            coordinates.coordinates.getEquatorialCartesianCoordinates(this.time.getTime(), this.view.body.pos);
            if (engine.leveling) {
                if (engine.yawv != 0.0) {
                    engine.yawp = -Math.signum(engine.yawv) * MathUtilsDouble.clamp(Math.abs(engine.yawv), 0.0, 1.0);
                }
                if (engine.pitchv != 0.0) {
                    engine.pitchp = -Math.signum(engine.pitchv) * MathUtilsDouble.clamp(Math.abs(engine.pitchv), 0.0, 1.0);
                }
                if (engine.rollv != 0.0) {
                    engine.rollp = -Math.signum(engine.rollv) * MathUtilsDouble.clamp(Math.abs(engine.rollv), 0.0, 1.0);
                }
                if (Math.abs(engine.yawv) < 0.001 && FastMath.abs((double)engine.pitchv) < 0.001 && FastMath.abs((double)engine.rollv) < 0.001) {
                    engine.setYawPower(0.0);
                    engine.setPitchPower(0.0);
                    engine.setRollPower(0.0);
                    engine.yawv = 0.0;
                    engine.pitchv = 0.0;
                    engine.rollv = 0.0;
                    EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, false);
                }
            }
            double rollDiff = this.view.computeDirectionUp(dt, engine.dirup);
            double len = engine.direction.len();
            engine.pitch = FastMath.asin((double)(engine.direction.y / len));
            engine.yaw = FastMath.atan2((double)engine.direction.z, (double)engine.direction.x);
            engine.roll += rollDiff;
            engine.pitch = FastMath.toDegrees((double)engine.pitch);
            engine.yaw = FastMath.toDegrees((double)engine.yaw);
        }
        Vector3Q camPos = this.B31.set(this.view.body.pos).add(this.camera.getInversePos());
        camPos.put(engine.posf);
        engine.direction.put(engine.directionf);
        engine.up.put(engine.upf);
    }
}

