/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.GridRecursive;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.Constants;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import net.jafama.FastMath;

public class GridRecUpdater
extends AbstractUpdateSystem {
    private final Vector3D D33 = new Vector3D();
    private final Vector3D D34 = new Vector3D();
    private final Vector3 F31 = new Vector3();
    private final Vector3 F34 = new Vector3();
    private final Vector3Q B31 = new Vector3Q();
    private final Matrix4D mat4 = new Matrix4D();

    public GridRecUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        IFocus focus;
        ICamera camera = GaiaSky.instance.getICamera();
        Body body = (Body)Mapper.body.get(entity);
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Fade fade = (Fade)Mapper.fade.get(entity);
        GridRecursive gr = (GridRecursive)Mapper.gridRec.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        fade.currentDistance = body.distToCamera = this.getDistanceToOrigin(camera) * (double)camera.getFovFactor();
        gr.regime = (byte)(body.distToCamera * Constants.DISTANCE_SCALE_FACTOR > 5.0E7 * Constants.PC_TO_U ? 2 : 1);
        if (Settings.settings.program.recursiveGrid.origin.isFocus() && camera.hasFocus()) {
            focus = camera.getFocus();
            base.opacity *= (float)MathUtilsDouble.flint(body.distToCamera, focus.getRadius() * 4.0, focus.getRadius() * 10.0, 0.0, 1.0);
        }
        gr.fovFactor = camera.getFovFactor() * 7.5E-4f;
        this.updateLocalTransform(camera, body, gr, graph, transform);
        this.getGridScaling(body.distToCamera, gr.scalingFading);
        if (Settings.settings.program.recursiveGrid.origin.isRefSys() && Settings.settings.program.recursiveGrid.projectionLines && camera.hasFocus()) {
            focus = camera.getFocus();
            Vector3D cPos = this.D33;
            Vector3D fPos = this.D34;
            this.getCFPos(cPos, fPos, camera, focus, transform);
            this.getZXLine(gr.a, gr.b, cPos, fPos, transform);
            gr.d01 = gr.p01.set(gr.b).sub(gr.a).len();
            gr.p01.setLength(gr.d01 / 2.0).add(gr.a);
            this.getYLine(gr.c, gr.d, cPos, fPos, transform);
            gr.d02 = gr.p02.set(gr.c).sub(gr.d).len();
            gr.p02.setLength(gr.d02 / 2.0).add(gr.d);
        } else {
            gr.d01 = -1.0;
            gr.d02 = -1.0;
        }
    }

    private void updateLocalTransform(ICamera camera, Body body, GridRecursive gr, GraphNode graph, RefSysTransform transform) {
        IFocus focus = camera.getFocus();
        graph.localTransform.idt();
        Vector3 vrOffset = this.F34;
        float vrScl = 1.0f;
        if (Settings.settings.runtime.openXr) {
            vrScl = 100.0f;
            if (camera.getCurrent() instanceof NaturalCamera) {
                ((NaturalCamera)camera.getCurrent()).vrOffset.put(vrOffset);
                vrOffset.scl((float)(1.0 / Constants.M_TO_U));
            }
        } else {
            vrOffset.set(0.0f, 0.0f, 0.0f);
        }
        if (Settings.settings.program.recursiveGrid.origin.isRefSys() || focus == null) {
            if (gr.regime == 1) {
                graph.localTransform.translate(camera.getInversePos().put(this.F31));
            } else {
                graph.localTransform.translate(camera.getInversePos().put(this.F31).setLength(vrScl).add(vrOffset));
            }
        } else if (gr.regime == 1) {
            graph.localTransform.translate(focus.getAbsolutePosition(this.B31).sub(camera.getPos()).put(this.F31));
        } else {
            graph.localTransform.translate(focus.getAbsolutePosition(this.B31).sub(camera.getPos()).setLength(vrScl).add(vrOffset).put(this.F31));
        }
        if (gr.regime == 1) {
            graph.localTransform.scl((float)(body.distToCamera * 0.023 * Constants.AU_TO_U / Constants.DISTANCE_SCALE_FACTOR));
        } else {
            graph.localTransform.scl((float)((double)(0.023f * vrScl) * Constants.AU_TO_U / Constants.DISTANCE_SCALE_FACTOR));
        }
        if (transform.matrixf != null) {
            graph.localTransform.mul(transform.matrixf);
        }
        graph.localTransform.rotate(1.0f, 0.0f, 0.0f, 90.0f);
    }

    private void getGridScaling(double cameraDistance, Pair<Double, Double> res) {
        double au = cameraDistance * Constants.U_TO_AU;
        res.set(au, 0.0);
        for (int i = -25; i < 25; ++i) {
            if (!(au < FastMath.pow((double)10.0, (double)i))) continue;
            double fading = MathUtilsDouble.lint(au, FastMath.pow((double)10.0, (double)(i - 1)), FastMath.pow((double)10.0, (double)i), 1.0, 0.0);
            res.setFirst(au * FastMath.pow((double)10.0, (double)(-i)));
            res.setSecond(fading);
            return;
        }
    }

    private double getDistanceToOrigin(ICamera camera) {
        if (Settings.settings.program.recursiveGrid.origin.isRefSys() || !camera.hasFocus()) {
            return camera.getPos().lenDouble();
        }
        IFocus focus = camera.getFocus();
        return focus.getDistToCamera();
    }

    private void getCFPos(Vector3D cPos, Vector3D fPos, ICamera camera, IFocus focus, RefSysTransform tr) {
        Matrix4D inv = tr.matrix;
        Matrix4D trf = inv != null ? this.mat4.set(inv).inv() : this.mat4.idt();
        camera.getPos().put(cPos).mul(trf);
        Vector3Q v3b = new Vector3Q(fPos);
        focus.getPredictedPosition(v3b, GaiaSky.instance.time, camera, false).mul(trf);
        v3b.put(fPos).sub(cPos);
    }

    private void getZXLine(Vector3D a, Vector3D b, Vector3D cPos, Vector3D fPos, RefSysTransform tr) {
        Matrix4D inv = tr.matrix;
        a.set(-cPos.x, -cPos.y, -cPos.z);
        b.set(fPos.x, -cPos.y, fPos.z);
        if (inv != null) {
            a.mul(inv);
            b.mul(inv);
        }
    }

    private void getYLine(Vector3D a, Vector3D b, Vector3D cPos, Vector3D fPos, RefSysTransform tr) {
        Matrix4D inv = tr.matrix;
        a.set(fPos.x, -cPos.y, fPos.z);
        b.set(fPos.x, fPos.y, fPos.z);
        if (inv != null) {
            a.mul(inv);
            b.mul(inv);
        }
    }
}

