/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.data.util.PointCloudData;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Keyframes;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.scene.system.update.GraphUpdater;
import gaiasky.scene.view.VertsView;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class KeyframeUpdater
extends AbstractUpdateSystem {
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3D D33 = new Vector3D();
    private final GraphUpdater graphUpdater;
    private final VertsView view;

    public KeyframeUpdater(Family family, int priority) {
        super(family, priority);
        this.graphUpdater = new GraphUpdater(null, 0, GaiaSky.instance.time);
        this.view = new VertsView();
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Keyframes kf = (Keyframes)Mapper.keyframes.get(entity);
        ICamera camera = GaiaSky.instance.getICamera();
        this.graphUpdater.setCamera(camera);
        for (Entity object : kf.objects) {
            this.graphUpdater.update(object, GaiaSky.instance.time, graph.translation, base.opacity);
        }
        for (Entity vo : kf.orientations) {
            Vector3D p0 = this.D31;
            Vector3D p1 = this.D32;
            this.view.setEntity(vo);
            PointCloudData p = this.view.getPointCloud();
            PointCloudData.PointSample pt0 = p.samples.get(0);
            p0.set(pt0.x(), pt0.y(), pt0.z());
            PointCloudData.PointSample pt1 = p.samples.get(1);
            p1.set(pt1.x(), pt1.y(), pt1.z());
            Vector3D c = this.D33.set(camera.getPos());
            double len = FastMath.max((double)1.0E-9, (double)(FastMath.atan((double)0.03) * c.dst(p0)));
            Vector3D v = c.set(p1).sub(p0).nor().scl(len);
            p.samples.set(1, new PointCloudData.PointSample(p0.x + v.x, p0.y + v.y, p0.z + v.z));
            this.view.markForUpdate();
        }
    }
}

