/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.LocationMark;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.scene.system.update.ModelUpdater;

public class LocUpdater
extends AbstractUpdateSystem {
    private final ModelUpdater updater = new ModelUpdater(null, 0);

    public LocUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        LocationMark loc = (LocationMark)Mapper.loc.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        ICamera cam = GaiaSky.instance.getICamera();
        this.updateLocalValues(entity, graph, loc, cam);
    }

    public void updateLocalValues(Entity entity, GraphNode graph, LocationMark loc, ICamera cam) {
        Label label = (Label)Mapper.label.get(entity);
        Entity papa = graph.parent;
        Body pBody = (Body)Mapper.body.get(papa);
        GraphNode pGraph = (GraphNode)Mapper.graph.get(papa);
        this.updater.setToLocalTransform(papa, pBody, pGraph, pBody.size, loc.distFactor, graph.localTransform, false);
        loc.location3d.set(0.0f, 0.0f, -0.5f);
        loc.location3d.rotate(loc.location.y, 1.0f, 0.0f, 0.0f);
        loc.location3d.rotate(loc.location.x + 90.0f, 0.0f, 1.0f, 0.0f);
        loc.location3d.mul(graph.localTransform);
        label.labelPosition.set(loc.location3d).add(cam.getPos());
    }
}

