/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Mesh;
import gaiasky.scene.component.Model;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.system.update.AbstractUpdateSystem;

public class MeshUpdater
extends AbstractUpdateSystem {
    private final float[] auxArray = new float[3];

    public MeshUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Model model = (Model)Mapper.model.get(entity);
        ModelComponent mc = model.model;
        if (mc != null) {
            DirectionalLight directional = mc.dirLight(0);
            if (directional != null) {
                directional.direction.set(1.0f, 0.0f, 0.0f);
                directional.color.set(1.0f, 1.0f, 1.0f, 1.0f);
            }
            Body body = (Body)Mapper.body.get(entity);
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            Mesh mesh = (Mesh)Mapper.mesh.get(entity);
            float[] trn = graph.translation.valuesF(this.auxArray);
            graph.localTransform.idt().translate(trn[0], trn[1], trn[2]).scl(body.size).mul(mesh.coordinateSystem);
        }
    }
}

