/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Atmosphere;
import gaiasky.scene.component.AttitudeComponent;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Cloud;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.MotorEngine;
import gaiasky.scene.component.Orientation;
import gaiasky.scene.entity.LightingUtils;
import gaiasky.scene.record.RotationComponent;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.DecalUtils;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.time.ITimeFrameProvider;

public class ModelUpdater
extends AbstractUpdateSystem {
    private final ICamera camera;
    private final Vector3D D32;
    private final Matrix4D MD4;
    private final Quaternion QF;
    private final QuaternionDouble QD;

    public ModelUpdater(Family family, int priority) {
        super(family, priority);
        this.camera = GaiaSky.instance.cameraManager;
        this.D32 = new Vector3D();
        this.QD = new QuaternionDouble();
        this.QF = new Quaternion();
        this.MD4 = new Matrix4D();
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Body body = (Body)Mapper.body.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        Atmosphere atmosphere = (Atmosphere)Mapper.atmosphere.get(entity);
        Cloud cloud = (Cloud)Mapper.cloud.get(entity);
        MotorEngine engine = (MotorEngine)Mapper.engine.get(entity);
        LightingUtils.updateLights(model, body, graph, this.camera);
        this.updateLocalTransform(entity, body, graph, scaffolding);
        if (atmosphere != null && atmosphere.atmosphere != null) {
            atmosphere.atmosphere.update(graph.translation);
        }
        if (cloud != null && cloud.cloud != null) {
            cloud.cloud.update(graph.translation);
            this.setToLocalTransform(entity, body, graph, cloud.cloud.size, 1.0f, cloud.cloud.localTransform, true);
        }
        if (engine != null && engine.render) {
            EventManager.publish(Event.SPACECRAFT_INFO, this, engine.yaw % 360.0, engine.pitch % 360.0, engine.roll % 360.0, engine.vel.len(), MotorEngine.thrustFactor[engine.thrustFactorIndex], engine.currentEnginePower, engine.yawp, engine.pitchp, engine.rollp);
        }
    }

    protected void updateLocalTransform(Entity entity, Body body, GraphNode graph, ModelScaffolding scaffolding) {
        this.setToLocalTransform(entity, body, graph, scaffolding.sizeScaleFactor, graph.localTransform, true);
    }

    public void setToLocalTransform(Entity entity, Body body, GraphNode graph, float sizeFactor, Matrix4 localTransform, boolean forceUpdate) {
        this.setToLocalTransform(entity, body, graph, body.size, sizeFactor, localTransform, forceUpdate);
    }

    public void setToLocalTransform(Entity entity, Body body, GraphNode graph, float size, float sizeFactor, Matrix4 localTransform, boolean forceUpdate) {
        ITimeFrameProvider time = GaiaSky.instance.time;
        Orientation orientation = (Orientation)Mapper.orientation.get(entity);
        if (Mapper.tagHeliotropic.has(entity) && orientation != null && orientation.attitudeComponent != null && (time.getHdiff() != 0.0 || forceUpdate)) {
            AttitudeComponent quaternionOrientation = orientation.attitudeComponent;
            if (quaternionOrientation.nonRotatedPos != null) {
                quaternionOrientation.nonRotatedPos.set(body.pos);
                quaternionOrientation.nonRotatedPos.mul(Coordinates.eqToEcl()).rotate(-AstroUtils.getSunLongitude(time.getTime()) - 180.0, 0.0, 1.0, 0.0);
                if (quaternionOrientation.orientationServer != null) {
                    quaternionOrientation.orientationServer.updateOrientation(time.getTime());
                }
            }
        }
        if (sizeFactor != 1.0f || forceUpdate) {
            RotationComponent rigidRotation;
            ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
            AttitudeComponent quaternionOrientation = orientation != null ? orientation.attitudeComponent : null;
            RotationComponent rotationComponent = rigidRotation = orientation != null ? orientation.rotationComponent : null;
            if (quaternionOrientation != null) {
                quaternionOrientation.updateOrientation(time.getTime());
            }
            if (Mapper.tagBillboard.has(entity)) {
                DecalUtils.setBillboardRotation(this.QF, body.pos.put(this.D32).nor(), new Vector3D(0.0, 1.0, 0.0));
                graph.translation.setToTranslation(localTransform).scl(size).rotate(this.QF);
            } else if (Mapper.engine.has(entity)) {
                MotorEngine engine = (MotorEngine)Mapper.engine.get(entity);
                localTransform.idt().setToLookAt(engine.posf, engine.directionf.add(engine.posf), engine.upf);
                try {
                    localTransform.inv();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                localTransform.scale(size, size, size);
                engine.rotationMatrix.idt().setToLookAt(engine.directionf, engine.upf);
                if (engine.qf != null) {
                    engine.rotationMatrix.getRotation(engine.qf);
                }
            } else if (quaternionOrientation != null) {
                boolean hasOrientationServer;
                graph.translation.setToTranslation(localTransform).scl(size * sizeFactor);
                boolean bl = hasOrientationServer = quaternionOrientation.orientationServer != null && quaternionOrientation.orientationServer.hasOrientation();
                if (hasOrientationServer) {
                    this.QD.set(quaternionOrientation.getCurrentQuaternion());
                    this.QF.set((float)this.QD.x, (float)this.QD.y, (float)this.QD.z, (float)this.QD.w);
                } else {
                    this.QD.setFromAxis(0.0, 1.0, 0.0, AstroUtils.getSunLongitude(GaiaSky.instance.time.getTime()));
                }
                graph.orientation.idt().rotate(this.QD);
                if (hasOrientationServer) {
                    graph.orientation.rotate(0.0, 0.0, 1.0, 180.0);
                }
                this.MD4.set(localTransform).mul(graph.orientation);
                this.MD4.putIn(localTransform);
            } else if (rigidRotation != null) {
                graph.translation.setToTranslation(localTransform).scl(size * sizeFactor).rotate(0.0f, 1.0f, 0.0f, (float)rigidRotation.ascendingNode).mul(Coordinates.getTransformF(scaffolding.refPlaneTransform)).rotate(0.0f, 0.0f, 1.0f, (float)(rigidRotation.inclination + rigidRotation.axialTilt)).rotate(0.0f, 1.0f, 0.0f, (float)rigidRotation.angle);
                graph.orientation.idt().rotate(0.0, 1.0, 0.0, (float)rigidRotation.ascendingNode).mul(Coordinates.getTransformD(scaffolding.refPlaneTransform)).rotate(0.0, 0.0, 1.0, (float)(rigidRotation.inclination + rigidRotation.axialTilt));
            } else {
                graph.translation.setToTranslation(localTransform).scl(size * sizeFactor).mul(Coordinates.getTransformF(scaffolding.refPlaneTransform));
                graph.orientation.idt().mul(Coordinates.getTransformD(scaffolding.refPlaneTransform));
            }
        } else {
            localTransform.set(graph.localTransform);
        }
        AffineTransformations affine = (AffineTransformations)Mapper.affine.get(entity);
        affine.apply(localTransform);
    }
}

