/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Octant;
import gaiasky.scene.component.Octree;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.scene.system.update.GraphUpdater;
import gaiasky.scene.system.update.ParticleSetUpdater;
import gaiasky.scene.view.OctreeObjectView;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import gaiasky.util.tree.OctreeNode;

public class OctreeUpdater
extends AbstractUpdateSystem {
    private final GraphUpdater graphUpdater;
    private final ParticleSetUpdater particleSetUpdater;
    private final Scene scene;

    public OctreeUpdater(Scene scene, Family family, int priority) {
        super(family, priority);
        this.scene = scene;
        this.graphUpdater = new GraphUpdater(null, 0, GaiaSky.instance.time);
        this.particleSetUpdater = new ParticleSetUpdater(null, 0);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Octant root = (Octant)Mapper.octant.get(entity);
        Octree octree = (Octree)Mapper.octree.get(entity);
        if (base.isVisible() && !base.copy) {
            OctreeNode parent;
            IFocus focus;
            Entity star;
            OctreeNode.nOctantsObserved = 0;
            OctreeNode.nObjectsObserved = 0;
            CameraManager camera = GaiaSky.instance.cameraManager;
            root.octant.update(graph.translation, camera, octree.roulette, base.opacity, root.octant.numChildrenRec > 4);
            this.updateOctreeObjects(base, graph, octree, deltaTime);
            if (camera.hasFocus() && (star = (focus = camera.getFocus()).getFirstStarAncestorEntity()) != null && (parent = octree.parenthood.get(star)) != null && !parent.isObserved()) {
                GraphNode starGraph = (GraphNode)Mapper.graph.get(star);
                Vector3Q starParentTranslation = starGraph.translation;
                this.scene.updateEntityGraph(star, GaiaSky.instance.time, starParentTranslation, 1.0f);
                this.scene.updateEntity(star, (float)GaiaSky.instance.time.getDt());
            }
        }
    }

    protected void updateOctreeObjects(Base base, GraphNode graph, Octree octree, float deltaTime) {
        this.updateGraph(base, graph, octree, GaiaSky.instance.time);
        this.updateParticleSets(octree, deltaTime);
    }

    private void updateGraph(Base base, GraphNode graph, Octree octree, ITimeFrameProvider time) {
        int size = octree.roulette.size();
        this.graphUpdater.setCamera(GaiaSky.instance.cameraManager);
        for (int i = 0; i < size; ++i) {
            Entity entity = ((OctreeObjectView)octree.roulette.get(i)).getEntity();
            Octant octant = (Octant)Mapper.octant.get(entity);
            this.graphUpdater.update(entity, time, graph.translation, base.opacity * octant.octant.opacity);
        }
    }

    private void updateParticleSets(Octree octree, float deltaTime) {
        int size = octree.roulette.size();
        for (int i = 0; i < size; ++i) {
            Entity entity = ((OctreeObjectView)octree.roulette.get(i)).getEntity();
            this.particleSetUpdater.updateEntity(entity, deltaTime);
        }
    }
}

