/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.scene.view.FocusView;
import gaiasky.util.coord.AstroUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import net.jafama.FastMath;

public class ParticleSetUpdater
extends AbstractUpdateSystem {
    private final ParticleUtils utils = new ParticleUtils();

    public ParticleSetUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        ParticleSet set;
        CameraManager camera = GaiaSky.instance.cameraManager;
        ParticleSet particleSet = set = Mapper.particleSet.has(entity) ? (ParticleSet)Mapper.particleSet.get(entity) : (ParticleSet)Mapper.starSet.get(entity);
        if (set != null) {
            this.updateCommon(camera, set);
            if (set instanceof StarSet) {
                StarSet ss = (StarSet)set;
                this.updateStarSet(camera, ss, (DatasetDescription)Mapper.datasetDescription.get(entity));
            } else {
                this.updateParticleSet(camera, set);
            }
        }
    }

    private void updateCommon(ICamera camera, ParticleSet set) {
        IParticleRecord bean;
        int idxNearest;
        if (set.proximityLoadingFlag && (idxNearest = set.indices[0]) >= 0 && (bean = set.pointData.get(idxNearest)) != null) {
            boolean beanSelected;
            double sa = set.getSolidAngleApparent(idxNearest);
            boolean bl = beanSelected = camera.getMode().isFocus() && camera.getFocus().isValid() && ((FocusView)camera.getFocus()).getSet() == set && camera.getFocus().hasName(bean.names()[0]);
            if (!set.proximityLoaded.contains(idxNearest)) {
                if (sa > set.proximityThreshold) {
                    String name = bean.names()[0];
                    Path path = set.proximityDescriptorsPath.resolve(name + ".json");
                    if (Files.exists(path, new LinkOption[0])) {
                        for (String key : bean.names()) {
                            String k = key.toLowerCase(Locale.ROOT).trim();
                            GaiaSky.instance.scene.index().remove(k);
                        }
                        GaiaSky.postRunnable(() -> GaiaSky.instance.scripting().loadJsonDataset(name, path.toString(), beanSelected, true));
                        set.proximityLoaded.add(idxNearest);
                    } else {
                        set.proximityLoaded.add(idxNearest);
                        set.proximityMissing.add(idxNearest);
                    }
                }
            } else if (!set.proximityMissing.contains(idxNearest) && beanSelected) {
                GaiaSky.instance.scripting().setCameraFocus(bean.names()[0]);
            }
        }
    }

    private void updateParticleSet(ICamera camera, ParticleSet particleSet) {
        particleSet.currDeltaYears = AstroUtils.getMsSince(GaiaSky.instance.time.getTime(), particleSet.epochJd) * 3.168808781402895E-11;
        if (particleSet.pointData != null) {
            particleSet.cPosD.set(camera.getPos());
            if (particleSet.focusIndex >= 0) {
                particleSet.updateFocus(camera);
            }
            if (particleSet.updaterTask != null) {
                particleSet.updaterTask.update(camera);
            }
        }
    }

    private void updateStarSet(ICamera camera, StarSet set, DatasetDescription datasetDesc) {
        if (set.indices != null && set.indices.length > 0 && set.pointData != null) {
            this.updateParticleSet(camera, set);
            int j = 0;
            for (int i = 0; i < FastMath.min((int)set.proximity.updating.length, (int)set.indices.length); ++i) {
                if (set.indices[i] < 0 || !this.utils.filter(set.indices[i], set, datasetDesc) || !set.isVisible(set.indices[i])) continue;
                IParticleRecord closeStar = (IParticleRecord)set.pointData.get(set.indices[i]);
                set.proximity.set(j, set.indices[i], closeStar, camera, set.currDeltaYears);
                camera.checkClosestParticle(set.proximity.updating[j]);
                if (j == 0) {
                    set.modelDist = 172.4643429 * closeStar.radius();
                }
                ++j;
            }
        }
    }
}

