/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Perimeter;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.scene.system.update.ModelUpdater;
import gaiasky.util.math.MathUtilsDouble;
import net.jafama.FastMath;

public class PerimeterUpdater
extends AbstractUpdateSystem {
    private final Vector3 aux3 = new Vector3();
    private final ModelUpdater updater = new ModelUpdater(null, 0);

    public PerimeterUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        ICamera camera = GaiaSky.instance.getICamera();
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        Perimeter perimeter = (Perimeter)Mapper.perimeter.get(entity);
        Entity parent = graph.parent;
        SolidAngle parentSa = (SolidAngle)Mapper.sa.get(parent);
        Body parentBody = (Body)Mapper.body.get(parent);
        float angleLow = (float)parentSa.thresholdQuad * camera.getFovFactor() * 30.0f;
        float angleHigh = angleLow * 3.0f;
        if (GaiaSky.instance.isOn(base.ct) && parentBody.solidAngleApparent > (double)angleLow && parentBody.solidAngle < 1.09) {
            graph.localTransform.idt();
            this.toCartesian(perimeter.loc2d[0][0][0], perimeter.loc2d[0][0][1], perimeter.cart0, graph.localTransform);
            this.updateLocalValues(parent, parentBody, graph, perimeter);
            graph.translation.add(body.pos);
            base.opacity = (float)MathUtilsDouble.flint(parentBody.solidAngleApparent, angleLow, angleHigh, 0.0, 1.0);
            base.opacity *= base.getVisibilityOpacityFactor();
            body.distToCamera = (float)graph.translation.lenDouble();
            body.solidAngle = (float)FastMath.atan((double)((double)body.size / body.distToCamera));
            body.solidAngleApparent = body.solidAngle / (double)camera.getFovFactor();
        } else {
            base.opacity = 0.0f;
        }
    }

    public void updateLocalValues(Entity papa, Body papaBody, GraphNode graph, Perimeter perimeter) {
        GraphNode papaGraph = (GraphNode)Mapper.graph.get(papa);
        this.updater.setToLocalTransform(papa, papaBody, papaGraph, 1.0f, graph.localTransform, false);
        int lineIndex = 0;
        for (float[][] line : perimeter.loc2d) {
            int pointIndex = 0;
            for (float[] point : line) {
                this.toCartesian(point[0], point[1], this.aux3, graph.localTransform);
                perimeter.loc3d[lineIndex][pointIndex][0] = this.aux3.x;
                perimeter.loc3d[lineIndex][pointIndex][1] = this.aux3.y;
                perimeter.loc3d[lineIndex][pointIndex][2] = this.aux3.z;
                ++pointIndex;
            }
            ++lineIndex;
        }
    }

    private void toCartesian(float lon, float lat, Vector3 res, Matrix4 localTransform) {
        res.set(0.0f, 0.0f, -0.5015f);
        res.rotate(lat, 1.0f, 0.0f, 0.0f);
        res.rotate(lon + 90.0f, 0.0f, 1.0f, 0.0f);
        res.mul(localTransform);
    }
}

