/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Raymarching;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.Logger;

public class RaymarchingUpdater
extends AbstractUpdateSystem {
    private static final Logger.Log logger = Logger.getLogger(RaymarchingUpdater.class);

    public RaymarchingUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Raymarching rm = (Raymarching)Mapper.raymarching.get(entity);
        if (rm != null && rm.raymarchingShader != null) {
            Base base = (Base)Mapper.base.get(entity);
            Body body = (Body)Mapper.body.get(entity);
            double solidAngleThreshold = 0.005;
            if (body.solidAngleApparent > solidAngleThreshold) {
                if (!rm.isOn) {
                    logger.info("Ray marching effect enabled: " + base.getName());
                    EventManager.publish(Event.RAYMARCHING_CMD, this, base.getName(), true, entity);
                    rm.isOn = true;
                }
            } else if (rm.isOn) {
                logger.info("Ray marching effect disabled: " + base.getName());
                EventManager.publish(Event.RAYMARCHING_CMD, this, base.getName(), false, entity);
                rm.isOn = false;
            }
        }
    }
}

