/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Ruler;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.GlobalResources;
import gaiasky.util.Pair;
import gaiasky.util.Settings;

public class RulerUpdater
extends AbstractUpdateSystem {
    public RulerUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Ruler ruler = (Ruler)Mapper.ruler.get(entity);
        ruler.rulerOk = GaiaSky.instance.scene.getObjectPosition(ruler.name0, ruler.pos0) != null;
        boolean bl = ruler.rulerOk = ruler.rulerOk && GaiaSky.instance.scene.getObjectPosition(ruler.name1, ruler.pos1) != null;
        if (ruler.rulerOk) {
            GraphNode parentGraph = (GraphNode)Mapper.graph.get(graph.parent);
            ruler.p0.set(ruler.pos0).add(parentGraph.translation);
            ruler.p1.set(ruler.pos1).add(parentGraph.translation);
            ruler.m.set(ruler.p1).sub(ruler.p0).scl(0.5).add(ruler.p0);
            body.pos.set(ruler.m).sub(parentGraph.translation);
            graph.translation.set(parentGraph.translation).add(body.pos);
            body.distToCamera = graph.translation.lenDouble();
            double dst = ruler.p0.dst(ruler.p1);
            Pair<Double, String> d = GlobalResources.doubleToDistanceString(dst, Settings.settings.program.ui.distanceUnits);
            ruler.dist = GlobalResources.formatNumber(d.getFirst()) + " " + d.getSecond();
            GaiaSky.postRunnable(() -> EventManager.publish(Event.RULER_DIST, entity, dst, ruler.dist));
        } else {
            ruler.dist = null;
        }
    }
}

