/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.entity.LightingUtils;
import gaiasky.scene.system.update.AbstractUpdateSystem;

public class ShapeUpdater
extends AbstractUpdateSystem {
    private final Vector3 F31 = new Vector3();

    public ShapeUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        AffineTransformations affine = (AffineTransformations)Mapper.affine.get(entity);
        if (model.model != null && !model.model.isStaticLight()) {
            LightingUtils.updateLights(model, body, graph, GaiaSky.instance.cameraManager);
        }
        graph.localTransform.idt().translate(graph.translation.put(this.F31)).scl(body.size);
        if (transform.matrixf != null) {
            graph.localTransform.mul(transform.matrixf);
        }
        if (affine.transformations != null && !affine.transformations.isEmpty()) {
            affine.apply(graph.localTransform);
        }
    }
}

