/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.TrajectoryUtils;
import gaiasky.scene.record.OrbitComponent;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.time.ITimeFrameProvider;
import java.time.Instant;

public class TrajectoryUpdater
extends AbstractUpdateSystem {
    private final TrajectoryUtils utils;
    private final ITimeFrameProvider time;

    public TrajectoryUpdater(Family family, int priority) {
        super(family, priority);
        this.time = GaiaSky.instance.time;
        this.utils = new TrajectoryUtils();
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
        Verts verts = (Verts)Mapper.verts.get(entity);
        if (trajectory.model == Trajectory.OrbitOrientationModel.EXTRASOLAR_SYSTEM) {
            this.utils.computeExtrasolarSystemTransformMatrix(graph, transform);
        }
        if (verts.pointCloudData != null) {
            if (verts.pointCloudData.hasTime()) {
                long t1;
                long t1t0;
                long t0;
                long now = this.time.getTime().toEpochMilli();
                long nowt0 = (now - (t0 = verts.pointCloudData.samples.get(0).toEpochMilli())) % (t1t0 = (t1 = verts.pointCloudData.samples.get(verts.pointCloudData.getNumPoints() - 1).toEpochMilli()) - t0);
                if (nowt0 < 0L) {
                    nowt0 += t1t0;
                }
                trajectory.coord = (double)nowt0 / (double)t1t0 % 1.0;
            } else {
                trajectory.coord = 1.0;
            }
        }
        if (trajectory.bodyRepresentation.isOrbit()) {
            if (Mapper.tagHeliotropic.has(entity)) {
                this.updateLocalTransformHeliotropic(GaiaSky.instance.time.getTime(), graph, trajectory);
            } else {
                this.updateLocalTransformRegular(graph, trajectory, transform);
            }
        }
    }

    protected void updateLocalTransformHeliotropic(Instant date, GraphNode graph, Trajectory trajectory) {
        Matrix4D localTransformD = trajectory.localTransformD;
        double sunLongitude = AstroUtils.getSunLongitude(date);
        graph.translation.setToTranslation(localTransformD).mul(Coordinates.eclToEq()).rotate(0.0, 1.0, 0.0, sunLongitude + 180.0);
        localTransformD.putIn(graph.localTransform);
    }

    protected void updateLocalTransformRegular(GraphNode graph, Trajectory trajectory, RefSysTransform transform) {
        Matrix4D localTransformD = trajectory.localTransformD;
        Matrix4D transformFunction = transform.matrix;
        GraphNode parentGraph = graph.parent != null ? (GraphNode)Mapper.graph.get(graph.parent) : null;
        graph.translation.setToTranslation(localTransformD);
        if (trajectory.newMethod) {
            if (transformFunction != null) {
                localTransformD.mul(transformFunction);
            }
            if (transformFunction == null && parentGraph != null && parentGraph.orientation != null) {
                localTransformD.mul(parentGraph.orientation);
            }
            if (trajectory.model.isExtrasolar()) {
                localTransformD.rotate(0.0, 1.0, 0.0, 90.0);
            }
        } else if (trajectory.oc != null) {
            OrbitComponent oc = trajectory.oc;
            if (transformFunction == null && parentGraph != null && parentGraph.orientation != null) {
                localTransformD.mul(parentGraph.orientation);
            }
            if (transformFunction != null) {
                localTransformD.mul(transformFunction);
            }
            localTransformD.rotate(0.0, 1.0, 0.0, oc.argOfPericenter).rotate(0.0, 0.0, 1.0, oc.i).rotate(0.0, 1.0, 0.0, oc.ascendingNode);
        }
        localTransformD.putIn(graph.localTransform);
    }
}

