/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.VRDevice;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;

public class VRDeviceUpdater
extends AbstractUpdateSystem {
    private final Vector3D aux = new Vector3D();
    private final Matrix4D deviceTransform = new Matrix4D();

    public VRDeviceUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        VRDevice vr = (VRDevice)Mapper.vr.get(entity);
        vr.beamP0.set(0.0, -0.01f, 0.0);
        vr.beamP1.set(0.0, -0.42f, -0.6f);
        vr.beamP2.set(0.0, -700.0, -1000.0);
        vr.beamPn.set(0.0, -7000.0, -10000.0);
        if (vr.hitUI) {
            if (vr.interacting) {
                vr.beamP1.set(vr.intersection);
                vr.beamP2.set(vr.intersection);
            } else {
                this.aux.set(vr.beamP1).sub(vr.beamP0).nor().scl(0.001);
                vr.beamP1.set(vr.beamP0).add(this.aux);
                this.aux.set(vr.beamP2).sub(vr.beamP0).nor().scl(0.002);
                vr.beamP2.set(vr.beamP0).add(this.aux);
            }
        }
        if (vr.device.isActive()) {
            this.deviceTransform.set(vr.device.aimTransform);
            vr.beamP0.mul(this.deviceTransform);
            if (!vr.hitUI || !vr.interacting) {
                vr.beamP1.mul(this.deviceTransform);
                vr.beamP2.mul(this.deviceTransform);
            }
            vr.beamPn.mul(this.deviceTransform);
        }
        if (vr.intersection != null) {
            vr.intersectionModel.transform.idt().translate((float)vr.intersection.x, (float)vr.intersection.y, (float)vr.intersection.z).scale(0.01f, 0.01f, 0.01f);
        }
    }
}

