/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.task;

import com.badlogic.ashley.core.Entity;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.TopNBuffer;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.ds.GaiaSkyExecutorService;
import gaiasky.util.math.Vector3D;
import gaiasky.util.time.ITimeFrameProvider;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

public class ParticleSetUpdaterTask
implements Runnable,
IObserver {
    protected static final double UPDATE_INTERVAL_S = 0.05;
    protected static final double UPDATE_INTERVAL_S_2 = 0.1;
    protected static final double CAM_DX_TH = 100.0 * Constants.PC_TO_U;
    protected static final double CAM_DX_TH_SQ = CAM_DX_TH * CAM_DX_TH;
    private final Base base;
    private final ParticleSet particleSet;
    private final BiConsumer<ITimeFrameProvider, ICamera> updateMetadataConsumer;
    private final DatasetDescription datasetDescription;
    private final ParticleUtils utils;
    private final TopNBuffer buffer;
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3D D34 = new Vector3D();
    private final GaiaSkyExecutorService executor;
    private volatile UpdateStage stage;

    public ParticleSetUpdaterTask(Entity entity, ParticleSet particleSet) {
        this.base = (Base)Mapper.base.get(entity);
        this.particleSet = particleSet;
        this.datasetDescription = (DatasetDescription)Mapper.datasetDescription.get(entity);
        this.utils = new ParticleUtils();
        this.buffer = new TopNBuffer(this.particleSet.indices.length);
        this.stage = UpdateStage.SORT1;
        this.executor = GaiaSky.instance.getExecutorService();
        this.updateMetadataConsumer = particleSet.isStars ? this::updateMetadataParticlesExt : (this.particleSet.isExtended ? this::updateMetadataParticlesExt : this::updateMetadataParticles);
        EventManager.instance.subscribe((IObserver)this, Event.FOCUS_CHANGED);
    }

    public void update(ICamera camera) {
        List<IParticleRecord> pointData = this.particleSet.pointData;
        if (pointData != null && !pointData.isEmpty() && pointData.getFirst().names() != null) {
            double t = GaiaSky.instance.getT() - this.particleSet.lastSortTime;
            switch (this.stage.ordinal()) {
                case 0: {
                    if (!(this.base.opacity > 0.0f) || !(t > 0.1 || this.particleSet.lastSortCameraPos.dst2D(camera.getPos()) > CAM_DX_TH_SQ && t > 0.05) && (!(GaiaSky.instance.time.getWarpFactor() > 1.0E12) || !(t > 0.05))) break;
                    this.executor.execute(this);
                    break;
                }
                case 1: 
                case 2: {
                    this.executor.execute(this);
                }
            }
        }
    }

    @Override
    public void run() {
        ITimeFrameProvider time = GaiaSky.instance.time;
        ICamera camera = GaiaSky.instance.getICamera();
        switch (this.stage.ordinal()) {
            case 0: {
                this.stage = UpdateStage.BUSY;
                this.updateMetadataConsumer.accept(time, camera);
                this.stage = UpdateStage.SORT1;
                break;
            }
            case 1: {
                this.stage = UpdateStage.BUSY;
                int totalCount = this.particleSet.pointData.size();
                double[] metadata = this.particleSet.metadata;
                this.buffer.clear();
                int n = totalCount / 2;
                for (int i = 0; i < n; ++i) {
                    this.buffer.add(i, metadata[i]);
                }
                this.stage = UpdateStage.SORT2;
                break;
            }
            case 2: {
                int n;
                this.stage = UpdateStage.BUSY;
                int totalCount = this.particleSet.pointData.size();
                double[] metadata = this.particleSet.metadata;
                for (int i = n = totalCount / 2 + 1; i < totalCount; ++i) {
                    this.buffer.add(i, metadata[i]);
                }
                this.buffer.sort();
                int[] topIndices = this.buffer.indexArray();
                int[] targetIndices = this.particleSet.indices;
                System.arraycopy(topIndices, 0, targetIndices, 0, topIndices.length);
                GaiaSky.postRunnable(() -> {
                    this.particleSet.lastSortCameraPos.set(camera.getPos());
                    this.particleSet.lastSortTime = GaiaSky.instance.getT();
                    this.stage = UpdateStage.METADATA;
                });
            }
        }
    }

    private void updateMetadataParticles(ITimeFrameProvider time, ICamera camera) {
        Vector3D camPos = camera.getPos().tov3d(this.D34);
        int n = this.particleSet.pointData.size();
        for (int i = 0; i < n; ++i) {
            IParticleRecord d = this.particleSet.pointData.get(i);
            Vector3D x = this.D31.set(d.x(), d.y(), d.z());
            this.particleSet.metadata[i] = this.utils.filter(i, this.particleSet, this.datasetDescription) ? camPos.dst2(x) : Double.MAX_VALUE;
        }
    }

    public static double brightnessProxy(float absMag, double distanceSquared) {
        int index = (int)Math.floor((absMag - -10.0f) / 0.01f);
        if (index < 0 || index >= StarBrightness.BRIGHTNESS_TABLE.length) {
            return 0.0;
        }
        return (double)(-StarBrightness.BRIGHTNESS_TABLE[index]) / distanceSquared;
    }

    private void updateMetadataParticlesExt(ITimeFrameProvider time, ICamera camera) {
        Vector3D camPos = camera.getPos().tov3d(this.D34);
        double deltaYears = AstroUtils.getMsSince(time.getTime(), this.particleSet.epochJd) * 3.168808781402895E-11;
        if (this.particleSet.pointData != null) {
            int n = this.particleSet.pointData.size();
            for (int i = 0; i < n; ++i) {
                IParticleRecord d = this.particleSet.pointData.get(i);
                Vector3D dx = this.D32.set(d.vx(), d.vy(), d.vz()).scl(deltaYears);
                Vector3D pos = this.D31.set(d.x(), d.y(), d.z()).add(dx);
                this.particleSet.metadata[i] = this.utils.filter(i, this.particleSet, this.datasetDescription) ? ParticleSetUpdaterTask.brightnessProxy(d.absMag(), camPos.dst2(pos)) : Double.MAX_VALUE;
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (Objects.requireNonNull(event) == Event.FOCUS_CHANGED) {
            FocusView view;
            this.particleSet.focusIndex = data[0] instanceof String ? (data[0].equals(this.base.getName()) ? this.particleSet.focusIndex : -1) : ((view = (FocusView)data[0]).getSet() == this.particleSet ? this.particleSet.focusIndex : -1);
            this.utils.updateFocusDataPos(this.particleSet);
        }
    }

    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    static enum UpdateStage {
        METADATA,
        SORT1,
        SORT2,
        BUSY;

    }

    private static class StarBrightness {
        private static final float MIN_MAG = -10.0f;
        private static final float STEP = 0.01f;
        public static final float[] BRIGHTNESS_TABLE = new float[3001];

        private StarBrightness() {
        }

        static {
            for (int i = 0; i < BRIGHTNESS_TABLE.length; ++i) {
                float mag = -10.0f + (float)i * 0.01f;
                StarBrightness.BRIGHTNESS_TABLE[i] = (float)Math.pow(10.0, -0.4 * (double)mag);
            }
        }
    }
}

