/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Entity;
import gaiasky.scene.view.BaseView;
import gaiasky.scene.view.PositionView;

public abstract sealed class AbstractView
permits BaseView, PositionView {
    protected Entity entity;

    protected AbstractView() {
    }

    protected AbstractView(Entity entity) {
        this.setEntity(entity);
    }

    protected abstract boolean componentsCheck(Entity var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEntity() {
        AbstractView abstractView = this;
        synchronized (abstractView) {
            this.entity = null;
            this.entityCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity getEntity() {
        AbstractView abstractView = this;
        synchronized (abstractView) {
            return this.entity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntity(Entity entity) {
        AbstractView abstractView = this;
        synchronized (abstractView) {
            if (!(entity == null || this.entity == entity && this.componentsCheck(entity))) {
                this.clearEntity();
                this.entityCheck(entity);
                this.entity = entity;
                this.entityChanged();
            }
        }
    }

    public boolean isValid() {
        if (!this.isEmpty()) {
            return this.entity.getComponents().size() > 0;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.entity == null;
    }

    protected void check(Entity entity, ComponentMapper mapper, Class<? extends Component> componentClass) {
        if (!mapper.has(entity)) {
            throw new RuntimeException("The given entity does not have a " + componentClass.getSimpleName() + " component: Can't be a " + this.getClass().getSimpleName() + ".");
        }
    }

    protected abstract void entityCheck(Entity var1);

    protected abstract void entityChanged();

    protected abstract void entityCleared();
}

