/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import gaiasky.GaiaSky;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.view.AbstractView;
import gaiasky.util.Settings;

public non-sealed class BaseView
extends AbstractView {
    public Base base;
    public Body body;

    public BaseView() {
    }

    public BaseView(Entity entity) {
        super(entity);
    }

    @Override
    protected boolean componentsCheck(Entity entity) {
        return entity != null && Mapper.base.get(entity) == this.base && Mapper.body.get(entity) == this.body;
    }

    @Override
    protected void entityCheck(Entity entity) {
        this.check(entity, Mapper.base, Base.class);
        this.check(entity, Mapper.body, Body.class);
    }

    @Override
    protected void entityChanged() {
        this.base = (Base)Mapper.base.get(this.entity);
        this.body = (Body)Mapper.body.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        this.base = null;
        this.body = null;
    }

    public void setColor(float[] color) {
        this.body.setColor(color);
    }

    public <T extends Component> T getComponent(Class<T> c) {
        return (T)this.entity.getComponent(c);
    }

    public float getOpacity() {
        assert (this.base != null);
        return this.base.opacity;
    }

    public ComponentTypes getComponentType() {
        return this.base.ct;
    }

    public Base getBase() {
        return this.base;
    }

    public Body getBody() {
        return this.body;
    }

    public boolean isVisible() {
        return this.base.visible || this.base.msSinceStateChange() <= Settings.settings.scene.fadeMs;
    }

    public void setVisible(boolean visible) {
        this.base.visible = visible;
        this.base.lastStateChangeTimeMs = (long)(GaiaSky.instance.getT() * 1000.0);
    }

    public void setVisible(boolean visible, String name) {
        this.setVisible(visible);
    }

    public boolean isVisible(boolean attributeValue) {
        if (attributeValue) {
            return this.base.visible;
        }
        return this.isVisible();
    }

    public boolean hasCt(ComponentTypes.ComponentType ct) {
        return ct != null && this.base.ct.isEnabled(ct);
    }
}

