/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.api.IVisibilitySwitch;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.Hip;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Magnitude;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.Octant;
import gaiasky.scene.component.OrbitElementsSet;
import gaiasky.scene.component.Orientation;
import gaiasky.scene.component.ParticleExtra;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.ProperMotion;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.entity.FocusActive;
import gaiasky.scene.entity.FocusHit;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.record.RotationComponent;
import gaiasky.scene.system.update.ModelUpdater;
import gaiasky.scene.view.BaseView;
import gaiasky.scene.view.OctreeObjectView;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.filter.attrib.IAttribute;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import gaiasky.util.tree.IOctreeObject;
import gaiasky.util.tree.OctreeNode;

public class FocusView
extends BaseView
implements IFocus,
IVisibilitySwitch {
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3Q B31 = new Vector3Q();
    private final Vector3Q B33 = new Vector3Q();
    private final Matrix4 matAux = new Matrix4();
    private final Matrix4D matDAux = new Matrix4D();
    protected ParticleExtra extra;
    private Focus focus;
    private GraphNode graph;
    private Octant octant;
    private Magnitude mag;
    private ParticleSet particleSet;
    private StarSet starSet;
    private Highlight hl;
    private final FocusHit focusHit;
    private Scene scene;
    private FocusActive focusActive;
    private FocusView auxView;
    private ModelUpdater updater;

    public FocusView(Scene scene) {
        this.scene = scene;
        this.focusHit = new FocusHit();
        this.focusActive = new FocusActive();
        this.updater = new ModelUpdater(null, 0);
    }

    public FocusView() {
        this((Scene)null);
    }

    public FocusView(Entity entity) {
        super(entity);
        this.focusHit = new FocusHit();
    }

    @Override
    protected void entityCheck(Entity entity) {
        super.entityCheck(entity);
        this.check(entity, Mapper.graph, GraphNode.class);
    }

    @Override
    protected void entityChanged() {
        super.entityChanged();
        this.focus = (Focus)Mapper.focus.get(this.entity);
        this.graph = (GraphNode)Mapper.graph.get(this.entity);
        this.octant = (Octant)Mapper.octant.get(this.entity);
        this.mag = (Magnitude)Mapper.magnitude.get(this.entity);
        this.extra = (ParticleExtra)Mapper.extra.get(this.entity);
        this.particleSet = (ParticleSet)Mapper.particleSet.get(this.entity);
        this.starSet = (StarSet)Mapper.starSet.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        this.focus = null;
        this.graph = null;
        this.octant = null;
        this.mag = null;
        this.extra = null;
        this.particleSet = null;
        this.starSet = null;
        this.hl = null;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public boolean isParticle() {
        return this.isValid() && this.extra != null;
    }

    @Override
    public long getId() {
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getId();
        }
        return this.base.id;
    }

    @Override
    public long getCandidateId() {
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getCandidateId();
        }
        return this.base.id;
    }

    @Override
    public String getLocalizedName() {
        ParticleSet set = this.getSet();
        if (set != null) {
            String particleName = set.getLocalizedName();
            if (particleName == null) {
                return this.base.getLocalizedName();
            }
            return particleName;
        }
        return this.base.getLocalizedName();
    }

    @Override
    public String getName() {
        String name;
        ParticleSet set = this.getSet();
        if (set != null && (name = set.getName()) != null) {
            return name;
        }
        return this.base.getName();
    }

    @Override
    public void setName(String name) {
        this.base.setName(name);
    }

    @Override
    public String[] getNames() {
        String[] names;
        ParticleSet set = this.getSet();
        if (set != null && (names = set.getNames()) != null) {
            return names;
        }
        return this.base.names;
    }

    @Override
    public boolean hasName(String name) {
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.hasName(name);
        }
        return this.base.hasName(name);
    }

    @Override
    public boolean hasName(String name, boolean matchCase) {
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.hasName(name, matchCase);
        }
        return this.base.hasName(name, matchCase);
    }

    @Override
    public String getDescription() {
        if (Mapper.datasetDescription.has(this.entity)) {
            return ((DatasetDescription)Mapper.datasetDescription.get((Entity)this.entity)).description;
        }
        return null;
    }

    @Override
    public void setDescription(String description) {
        if (Mapper.datasetDescription.has(this.entity)) {
            ((DatasetDescription)Mapper.datasetDescription.get((Entity)this.entity)).description = description;
        }
    }

    public int getNumParticles() {
        ParticleSet set = this.getSet();
        if (set != null && set.data() != null) {
            return set.data().size();
        }
        if (Mapper.octree.has(this.entity)) {
            return ((Octant)Mapper.octant.get((Entity)this.entity)).octant.numObjectsRec;
        }
        if (Mapper.datasetDescription.has(this.entity)) {
            if (this.graph.children != null && !this.graph.children.isEmpty()) {
                return this.graph.numChildren;
            }
            return 1;
        }
        return 1;
    }

    public String getDataFile() {
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.datafile;
        }
        return null;
    }

    @Override
    public boolean isVisible(String name) {
        ParticleSet set = this.getSet();
        if (set != null && set.index.containsKey(name)) {
            return set.isVisible(set.index.get(name));
        }
        return this.isVisible();
    }

    public boolean isVisibleGroup() {
        return this.isVisibleGroup(false);
    }

    public void setVisibleGroup(boolean visibility) {
        this.setVisible(visibility);
    }

    public boolean isVisibleGroup(boolean attributeValue) {
        return this.isVisible(attributeValue);
    }

    @Override
    public void setVisible(boolean visible, String name) {
        ParticleSet set = this.getSet();
        if (set != null) {
            set.setVisible(visible, name, (Render)Mapper.render.get(this.entity));
        } else {
            this.setVisible(visible);
        }
    }

    @Override
    public String getClosestName() {
        if (this.getSet() != null) {
            return this.getSet().getClosestName();
        }
        return this.getName();
    }

    @Override
    public String getClosestLocalizedName() {
        if (this.getSet() != null) {
            return this.getSet().getClosestLocalizedName();
        }
        return this.getLocalizedName();
    }

    @Override
    public String getCandidateName() {
        if (this.getSet() != null) {
            return this.getSet().getCandidateName();
        }
        return this.getName();
    }

    @Override
    public ComponentTypes getCt() {
        return this.base.ct;
    }

    @Override
    public boolean isFocusActive() {
        return this.focus.activeFunction.apply(this.focusActive, this.entity, this.base);
    }

    @Override
    public Vector3Q getPos() {
        return this.body.pos;
    }

    @Override
    public IFocus getFirstStarAncestor() {
        Entity out = this.getFirstStarAncestorEntity();
        if (out == null) {
            return null;
        }
        if (out == this.entity) {
            return this;
        }
        return new FocusView(out);
    }

    public IFocus getFirstStarAncestor(FocusView view) {
        Entity out = this.getFirstStarAncestorEntity();
        if (out == null) {
            return null;
        }
        view.setEntity(out);
        return view;
    }

    @Override
    public Entity getFirstStarAncestorEntity() {
        return this.getStarAncestor(this.entity);
    }

    private Entity getStarAncestor(Entity me) {
        if (me == null) {
            return null;
        }
        if (Mapper.hip.has(me) || Mapper.starSet.has(me) || Mapper.particleSet.has(me)) {
            return me;
        }
        if (Mapper.graph.has(me)) {
            GraphNode graph = (GraphNode)Mapper.graph.get(me);
            return this.getStarAncestor(graph.parent);
        }
        return null;
    }

    @Override
    public Vector3Q getAbsolutePosition(Vector3Q out) {
        if (this.getSet() != null) {
            return this.getSet().getAbsolutePosition(out);
        }
        return EntityUtils.getAbsolutePosition(this.entity, out);
    }

    @Override
    public Vector3Q getAbsolutePosition(String name, Vector3Q out) {
        if (this.getSet() != null) {
            return this.getSet().getAbsolutePosition(name, out);
        }
        return EntityUtils.getAbsolutePosition(this.entity, out);
    }

    public void getPositionAboveSurface(double longitude, double latitude, double distance, Vector3Q out) {
        Vector3D aux1 = this.D31;
        Vector3D aux2 = this.D32;
        double rad = 1.0;
        Coordinates.sphericalToCartesian(longitude *= Math.PI / 180, latitude *= Math.PI / 180, rad, aux1);
        aux2.set(aux1.z, aux1.y, aux1.x).scl(1.0, -1.0, -1.0).scl(-(this.getRadius() + distance * Constants.KM_TO_U));
        Matrix4D ori = new Matrix4D(this.graph.orientation);
        RotationComponent rotation = this.getRotationComponent();
        if (rotation != null) {
            ori.rotate(0.0, 1.0, 0.0, rotation.angle);
        }
        aux2.mul(ori);
        this.getAbsolutePosition(out).add(aux2);
    }

    @Override
    public Vector3Q getClosestAbsolutePos(Vector3Q out) {
        if (this.starSet != null) {
            return out.set(this.starSet.proximity.updating[0].absolutePos);
        }
        return this.getAbsolutePosition(out);
    }

    @Override
    public Vector2D getPosSph() {
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getPosSph();
        }
        return this.body.posSph;
    }

    protected boolean mustUpdatePosition(ITimeFrameProvider time) {
        return time.getHdiff() != 0.0;
    }

    @Override
    public Vector3Q getPredictedPosition(Vector3Q out, ITimeFrameProvider time, ICamera unused, boolean force) {
        return this.getPredictedPosition(out, null, time, force);
    }

    public Vector3Q getPredictedPosition(Vector3Q out, String name, ITimeFrameProvider time, boolean force) {
        if (!this.isValid()) {
            return out;
        }
        if (this.getSet() != null) {
            if (name != null && !name.isBlank()) {
                return this.getSet().getAbsolutePosition(name, time.getTime(), out);
            }
            return this.getSet().getAbsolutePosition(time.getTime(), out);
        }
        if (!this.mustUpdatePosition(time) && !force) {
            return this.getAbsolutePosition(out);
        }
        return this.getPredictedPosition(out, time.getHdiff());
    }

    @Override
    public Vector3Q getPredictedPosition(Vector3Q out, double deltaTime) {
        Entity copy = this.scene.getLineCopy(this.entity);
        GraphNode copyGraph = (GraphNode)Mapper.graph.get(copy);
        Entity root = copyGraph.getRoot(copy);
        this.scene.updateEntity(root, (float)deltaTime);
        this.scene.updateEntity(copy, (float)deltaTime);
        EntityUtils.getAbsolutePosition(copy, out);
        this.scene.returnCopyObject(copy);
        return out;
    }

    @Override
    public double getDistToCamera() {
        if (!this.isValid()) {
            return 0.0;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getDistToCamera();
        }
        return this.body.distToCamera;
    }

    @Override
    public double getClosestDistToCamera() {
        if (!this.isValid()) {
            return 0.0;
        }
        if (this.starSet != null) {
            return this.starSet.getClosestDistToCamera();
        }
        return this.getDistToCamera();
    }

    @Override
    public double getSolidAngle() {
        if (!this.isValid()) {
            return 0.0;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getSolidAngle();
        }
        return this.body.solidAngle;
    }

    @Override
    public double getSolidAngleApparent() {
        if (!this.isValid()) {
            return 0.0;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getSolidAngleApparent();
        }
        return this.body.solidAngleApparent;
    }

    @Override
    public double getCandidateSolidAngleApparent() {
        if (!this.isValid()) {
            return 0.0;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getCandidateSolidAngleApparent();
        }
        return this.getSolidAngleApparent();
    }

    @Override
    public double getAlpha() {
        if (!this.isValid()) {
            return 0.0;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getAlpha();
        }
        return this.body.posSph.x;
    }

    @Override
    public double getDelta() {
        if (!this.isValid()) {
            return 0.0;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getDelta();
        }
        return this.body.posSph.y;
    }

    @Override
    public double getSize() {
        if (!this.isValid()) {
            return 0.0;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getSize();
        }
        return this.body.size;
    }

    @Override
    public double getRadius() {
        if (!this.isValid()) {
            return 0.0;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            return set.getRadius();
        }
        return this.extra != null ? this.extra.radius : (double)this.body.size / 2.0;
    }

    @Override
    public double getTEff() {
        if (!this.isValid()) {
            return 0.0;
        }
        StarSet set = this.getStarSet();
        if (set != null) {
            return set.getTEff();
        }
        return this.extra != null ? this.extra.tEff : -1.0;
    }

    @Override
    public double getElevationAt(Vector3Q camPos) {
        if (!this.isValid()) {
            return 0.0;
        }
        if (this.isModel()) {
            return this.getElevationAt(camPos, false);
        }
        return this.getRadius();
    }

    @Override
    public double getElevationAt(Vector3Q camPos, boolean useFuturePosition) {
        if (this.isBillboard()) {
            return 0.0;
        }
        if (this.isModel()) {
            if (useFuturePosition) {
                Vector3Q nextPos = this.getPredictedPosition(this.B33, GaiaSky.instance.time, GaiaSky.instance.getICamera(), false);
                return this.getElevationAt(camPos, nextPos);
            }
            return this.getElevationAt(camPos, null);
        }
        return this.getRadius();
    }

    @Override
    public double getElevationAt(Vector3Q camPos, Vector3Q nextPos) {
        if (this.isBillboard()) {
            return 0.0;
        }
        if (this.isModel()) {
            Model model = (Model)Mapper.model.get(this.entity);
            ModelComponent mc = model.model;
            double multiplier = Settings.settings.scene.renderer.elevation.multiplier;
            double height = 0.0;
            if (mc != null && mc.mtc != null && mc.mtc.heightData != null) {
                double dCam;
                Vector3Q cart = this.B31;
                if (nextPos != null) {
                    cart.set(nextPos);
                    dCam = this.D32.set(camPos).sub(cart).len();
                } else {
                    this.getAbsolutePosition(cart);
                    dCam = this.getDistToCamera();
                }
                if (dCam < this.getRadius() + (double)mc.mtc.heightScale.floatValue() * multiplier) {
                    cart.scl(-1.0).add(camPos).nor();
                    this.updater.setToLocalTransform(this.entity, this.body, this.graph, 1.0f, this.matAux, false);
                    this.matAux.inv();
                    this.matDAux.set(this.matAux.getValues());
                    cart.mul(this.matDAux);
                    Vector3D sph = this.D32;
                    Coordinates.cartesianToSpherical(cart, sph);
                    double u = (sph.x * 57.29577951308232 + 270.0) % 360.0 / 360.0;
                    double v = (sph.y * 57.29577951308232 + 90.0) / 180.0;
                    double heightNormalized = mc.mtc.heightData.getNormalizedHeight(u, v);
                    height = heightNormalized * (double)mc.mtc.heightScale.floatValue();
                }
            }
            return this.getRadius() + height * multiplier;
        }
        return this.getRadius();
    }

    @Override
    public double getHeightScale() {
        if (this.isModel() && !this.isBillboard()) {
            Model model = (Model)Mapper.model.get(this.entity);
            ModelComponent mc = model.model;
            if (mc != null && mc.mtc != null && mc.mtc.heightData != null) {
                return mc.mtc.heightScale.floatValue();
            }
        }
        return 0.0;
    }

    @Override
    public float getAppmag() {
        if (this.starSet != null) {
            return this.starSet.focus.appMag();
        }
        if (this.particleSet != null) {
            return 0.0f;
        }
        if (this.mag != null) {
            return this.mag.appMag;
        }
        return 0.0f;
    }

    @Override
    public float getAbsmag() {
        if (this.starSet != null && this.starSet.focus != null) {
            return this.starSet.focus.absMag();
        }
        if (this.particleSet != null) {
            return 0.0f;
        }
        if (this.mag != null) {
            return this.mag.absMag;
        }
        return 0.0f;
    }

    @Override
    public Matrix4D getOrientation() {
        return this.graph.orientation;
    }

    @Override
    public RotationComponent getRotationComponent() {
        Orientation orientation = (Orientation)Mapper.orientation.get(this.entity);
        return orientation != null ? orientation.rotationComponent : null;
    }

    @Override
    public QuaternionDouble getOrientationQuaternion() {
        if (Mapper.orientation.has(this.entity)) {
            Orientation orientation = (Orientation)Mapper.orientation.get(this.entity);
            if (orientation.attitudeComponent != null) {
                return orientation.attitudeComponent.getCurrentQuaternion();
            }
        }
        return null;
    }

    @Override
    public void addHitCoordinate(int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<IFocus> hits) {
    }

    @Override
    public void addEntityHitCoordinate(int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<Entity> hits) {
        if (this.focus != null && this.focus.focusable && this.focus.hitCoordinatesConsumer != null) {
            this.focus.hitCoordinatesConsumer.apply(this.focusHit, this, screenX, screenY, w, h, pixelDist, camera, hits);
        }
    }

    @Override
    public void addHitRay(Vector3D p0, Vector3D p1, NaturalCamera camera, Array<IFocus> hits) {
    }

    @Override
    public void addEntityHitRay(Vector3D p0, Vector3D p1, NaturalCamera camera, Array<Entity> hits) {
        if (this.focus != null && this.focus.focusable && this.focus.hitRayConsumer != null) {
            this.focus.hitRayConsumer.apply(this.focusHit, this, p0, p1, camera, hits);
        }
    }

    @Override
    public void makeFocus() {
        if (this.isSet()) {
            this.getSet().makeFocus();
        }
    }

    @Override
    public IFocus getFocus(String name) {
        if (name != null && this.isSet()) {
            this.getSet().setFocusIndex(name);
        }
        return this;
    }

    @Override
    public boolean isCoordinatesTimeOverflow() {
        return this.isValid() && Mapper.coordinates.has(this.entity) && ((gaiasky.scene.component.Coordinates)Mapper.coordinates.get((Entity)this.entity)).timeOverflow;
    }

    @Override
    public int getSceneGraphDepth() {
        return this.graph.getSceneGraphDepth();
    }

    @Override
    public OctreeNode getOctant() {
        return this.octant != null ? this.octant.octant : null;
    }

    public int getHip() {
        if (this.starSet != null) {
            if (this.starSet.focus != null && this.starSet.focus.hip() > 0) {
                return this.starSet.focus.hip();
            }
        } else if (Mapper.hip.has(this.entity)) {
            return ((Hip)Mapper.hip.get((Entity)this.entity)).hip;
        }
        return -1;
    }

    public void setForceLabel(Boolean forceLabel, String name) {
        if (this.isSet()) {
            this.getSet().setForceLabel(forceLabel, name);
        } else if (Mapper.label.has(this.entity)) {
            ((Label)Mapper.label.get(this.entity)).setForceLabel(forceLabel);
        }
    }

    @Override
    public boolean isForceLabel(String name) {
        if (this.isValid() && this.isSet()) {
            return this.getSet().isForceLabel(name);
        }
        return this.isForceLabel();
    }

    public boolean equals(Object other) {
        if (other instanceof FocusView) {
            return this.entity == ((FocusView)other).getEntity();
        }
        return false;
    }

    @Override
    public boolean isForceLabel() {
        if (this.isValid() && Mapper.label.has(this.entity)) {
            return ((Label)Mapper.label.get((Entity)this.entity)).forceLabel;
        }
        return false;
    }

    public void setLabelColor(float[] color) {
        this.body.labelColor = color;
    }

    public void setLabelColor(float[] color, String name) {
        if (this.isSet()) {
            this.getSet().setLabelColor(color, name);
        } else {
            this.setLabelColor(color);
        }
    }

    @Override
    public boolean isCopy() {
        return this.base.copy;
    }

    @Override
    public boolean isFocusable() {
        return this.focus == null || this.focus.focusable;
    }

    @Override
    public boolean isCameraCollision() {
        return this.body != null && this.body.cameraCollision;
    }

    @Override
    public float[] getColor() {
        return this.body.color;
    }

    public GraphNode getGraph() {
        return this.graph;
    }

    public Magnitude getMag() {
        return this.mag;
    }

    public ParticleExtra getExtra() {
        return this.extra;
    }

    public ParticleSet getParticleSet() {
        return this.particleSet;
    }

    public StarSet getStarSet() {
        return this.starSet;
    }

    public boolean isSet() {
        return this.isValid() && (this.particleSet != null || this.starSet != null);
    }

    public boolean isParticleSet() {
        return this.isValid() && this.particleSet != null;
    }

    public boolean isStarSet() {
        return this.isValid() && this.starSet != null;
    }

    public ParticleSet getSet() {
        return this.particleSet != null ? this.particleSet : this.starSet;
    }

    public boolean isModel() {
        return this.isValid() && Mapper.modelScaffolding.has(this.entity);
    }

    public boolean isBillboard() {
        return this.isValid() && (Mapper.tagBillboard.has(this.entity) || Mapper.tagBillboardGalaxy.has(this.entity));
    }

    public boolean isCluster() {
        return this.isValid() && Mapper.cluster.has(this.entity);
    }

    public boolean isCelestial() {
        return this.isValid() && Mapper.celestial.has(this.entity);
    }

    public boolean hasProperMotion() {
        return this.isValid() && Mapper.pm.has(this.entity) || this.starSet != null;
    }

    public double getMuAlpha() {
        if (this.isSet()) {
            ParticleSet set = this.getSet();
            if (set.focus != null && set.focus.hasProperMotion()) {
                return set.focus.muAlpha();
            }
            return 0.0;
        }
        if (Mapper.pm.has(this.entity)) {
            ProperMotion pm = (ProperMotion)Mapper.pm.get(this.entity);
            if (pm.pmSph != null) {
                return pm.pmSph.x;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getMuDelta() {
        if (this.isSet()) {
            ParticleSet set = this.getSet();
            if (set.focus != null && set.focus.hasProperMotion()) {
                return set.focus.muDelta();
            }
            return 0.0;
        }
        if (this.isValid() && Mapper.pm.has(this.entity)) {
            ProperMotion pm = (ProperMotion)Mapper.pm.get(this.entity);
            if (pm.pmSph != null) {
                return pm.pmSph.y;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getRadialVelocity() {
        if (this.isSet()) {
            ParticleSet set = this.getSet();
            if (set.focus != null && set.focus.hasProperMotion()) {
                return set.focus.radVel();
            }
            return 0.0;
        }
        if (this.isValid() && Mapper.pm.has(this.entity)) {
            ProperMotion pm = (ProperMotion)Mapper.pm.get(this.entity);
            if (pm.pmSph != null) {
                return pm.pmSph.z;
            }
            return 0.0;
        }
        return 0.0;
    }

    public Entity getChildByNameAndArchetype(String name, Archetype archetype) {
        int size = this.graph.children.size;
        for (int i = 0; i < size; ++i) {
            Base base;
            Entity child = (Entity)this.graph.children.get(i);
            if (child == null || !(base = (Base)Mapper.base.get(child)).getName().equalsIgnoreCase(name.trim()) || !archetype.matches(child)) continue;
            return child;
        }
        return null;
    }

    private void initAuxView() {
        if (this.auxView == null) {
            this.auxView = new FocusView();
        }
    }

    private void initHighlight() {
        if (this.isValid() && this.hl == null) {
            this.hl = (Highlight)Mapper.highlight.get(this.entity);
        }
    }

    public void markForUpdate() {
        if (!this.isValid()) {
            return;
        }
        ParticleSet set = this.getSet();
        if (set != null) {
            set.markForUpdate((Render)Mapper.render.get(this.entity));
        }
        if (Mapper.orbitElementsSet.has(this.entity)) {
            ((OrbitElementsSet)Mapper.orbitElementsSet.get(this.entity)).markForUpdate((Render)Mapper.render.get(this.entity));
        }
        if (Mapper.verts.has(this.entity)) {
            ((Verts)Mapper.verts.get(this.entity)).markForUpdate((Render)Mapper.render.get(this.entity));
        }
    }

    public void highlight(boolean state, float[] color, boolean allVisible) {
        Array<Entity> l;
        this.initHighlight();
        this.markForUpdate();
        this.hl.highlighted = state;
        this.hl.dirty = true;
        if (state) {
            this.hl.hlplain = true;
            this.hl.hlallvisible = allVisible;
            System.arraycopy(color, 0, this.hl.hlc, 0, color.length);
        }
        if (Mapper.octree.has(this.entity) && this.octant != null && (l = this.getOctreeObjects((Array<Entity>)new Array())) != null && l.size > 0) {
            this.initAuxView();
            for (Entity e : l) {
                this.auxView.setEntity(e);
                this.auxView.highlight(state, color, allVisible);
            }
        }
    }

    public void highlight(boolean state, int cmi, float cmAlpha, IAttribute cma, double cmMin, double cmMax, boolean allVisible) {
        Array<Entity> l;
        this.initHighlight();
        this.markForUpdate();
        this.hl.highlighted = state;
        this.hl.dirty = true;
        if (state) {
            this.hl.hlplain = false;
            this.hl.hlallvisible = allVisible;
            this.hl.hlcmi = cmi;
            this.hl.hlcmAlpha = cmAlpha;
            this.hl.hlcma = cma;
            this.hl.hlcmmin = cmMin;
            this.hl.hlcmmax = cmMax;
        }
        if (Mapper.octree.has(this.entity) && this.octant != null && (l = this.getOctreeObjects((Array<Entity>)new Array())) != null && l.size > 0) {
            this.initAuxView();
            for (Entity e : l) {
                this.auxView.setEntity(e);
                this.auxView.highlight(state, cmi, cmAlpha, cma, cmMin, cmMax, allVisible);
            }
        }
    }

    public boolean isHighlighted() {
        this.initHighlight();
        return this.hl.highlighted;
    }

    public boolean isOctree() {
        return this.isValid() && Mapper.octree.has(this.entity);
    }

    public Array<Entity> getOctreeObjects(Array<Entity> list) {
        if (this.octant == null) {
            return list;
        }
        return this.getOctreeObjects(this.octant.octant, list);
    }

    public boolean isPlanet() {
        return this.isValid() && this.base.archetype != null && this.base.archetype.getName().equals("Planet");
    }

    public boolean isSingleStar() {
        return this.isValid() && this.base.archetype != null && this.base.archetype.getName().equals("Star");
    }

    public boolean isStar() {
        return this.isValid() && (this.isStarSet() || this.isSingleStar());
    }

    private Array<Entity> getOctreeObjects(OctreeNode node, Array<Entity> list) {
        if (node != null && node.objects != null) {
            for (IOctreeObject object : node.objects) {
                if (!(object instanceof OctreeObjectView)) continue;
                OctreeObjectView oov = (OctreeObjectView)object;
                list.add((Object)oov.getEntity());
            }
            if (node.children != null) {
                for (OctreeNode child : node.children) {
                    if (child == null) continue;
                    this.getOctreeObjects(child, list);
                }
            }
        }
        return list;
    }
}

