/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Keyframes;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.KeyframeUtils;
import gaiasky.scene.view.BaseView;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.VertsView;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.camera.rec.Keyframe;
import gaiasky.util.camera.rec.KeyframesManager;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.List;
import net.jafama.FastMath;

public class KeyframesView
extends BaseView {
    private final VertsView verts;
    private final FocusView focus;
    private Keyframes kf;
    private final Scene scene;
    private final KeyframeUtils utils;
    private final Vector3 F31 = new Vector3();
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();

    public KeyframesView(Scene scene) {
        this.scene = scene;
        this.verts = new VertsView();
        this.focus = new FocusView();
        this.utils = new KeyframeUtils(scene);
    }

    @Override
    protected void entityCheck(Entity entity) {
        super.entityCheck(entity);
        this.check(entity, Mapper.keyframes, Keyframes.class);
    }

    @Override
    protected void entityChanged() {
        super.entityChanged();
        this.kf = (Keyframes)Mapper.keyframes.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        this.kf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshData() {
        Object object;
        List<Keyframe> keyframes = this.kf.keyframes;
        Array kfPositionsSep = new Array();
        double[] kfPositions = new double[keyframes.size() * 3];
        double[] kfDirections = new double[keyframes.size() * 3];
        double[] kfUps = new double[keyframes.size() * 3];
        boolean[] kfSeams = new boolean[keyframes.size()];
        Array current = new Array();
        int i = 0;
        for (Keyframe kf : keyframes) {
            if (kf.seam && i > 0 && i < keyframes.size() - 1) {
                current.add((Object)kf.pos);
                kfPositionsSep.add((Object)current);
                current = new Array();
            }
            current.add((Object)kf.pos);
            kfPositions[i * 3] = kf.pos.x;
            kfPositions[i * 3 + 1] = kf.pos.y;
            kfPositions[i * 3 + 2] = kf.pos.z;
            kfDirections[i * 3] = kf.dir.x;
            kfDirections[i * 3 + 1] = kf.dir.y;
            kfDirections[i * 3 + 2] = kf.dir.z;
            kfUps[i * 3] = kf.up.x;
            kfUps[i * 3 + 1] = kf.up.y;
            kfUps[i * 3 + 2] = kf.up.z;
            kfSeams[i] = kf.seam;
            ++i;
        }
        kfPositionsSep.add((Object)current);
        this.setPathKnots(kfPositions, kfDirections, kfUps, kfSeams);
        if (keyframes.size() > 1) {
            object = this.verts;
            synchronized (object) {
                this.verts.setEntity(this.kf.segments);
                this.verts.setPoints(kfPositions);
            }
            double[] pathSamples = KeyframesManager.instance.samplePaths((Array<Array<Vector3D>>)kfPositionsSep, kfPositions, 20, Settings.settings.camrecorder.keyframe.position);
            VertsView vertsView = this.verts;
            synchronized (vertsView) {
                this.verts.setEntity(this.kf.path);
                this.verts.setPoints(pathSamples);
            }
        }
        object = this.verts;
        synchronized (object) {
            this.verts.setEntity(this.kf.segments);
            this.verts.clear();
        }
        object = this.verts;
        synchronized (object) {
            this.verts.setEntity(this.kf.path);
            this.verts.clear();
        }
    }

    public void refreshOrientations() {
        int i = 0;
        for (Keyframe keyframe : this.kf.keyframes) {
            Entity dir = (Entity)this.kf.orientations.get(i);
            Entity up = (Entity)this.kf.orientations.get(i + 1);
            this.refreshSingleVector(dir, keyframe.pos, keyframe.dir);
            this.refreshSingleVector(up, keyframe.pos, keyframe.up);
            i += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSingleVector(Entity vo, Vector3D pos, Vector3D vec) {
        VertsView vertsView = this.verts;
        synchronized (vertsView) {
            this.verts.setEntity(vo);
            PointCloudData p = this.verts.getPointCloud();
            p.samples.set(0, new PointCloudData.PointSample(pos));
            p.samples.set(1, new PointCloudData.PointSample(pos.x + vec.x, pos.y + vec.y, pos.z + vec.z));
            this.verts.markForUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resamplePath() {
        List<Keyframe> keyframes = this.kf.keyframes;
        if (!keyframes.isEmpty()) {
            Array kfPositionsSep = new Array();
            double[] kfPositions = new double[keyframes.size() * 3];
            Array current = new Array();
            int i = 0;
            for (Keyframe kf : keyframes) {
                if (kf.seam && i > 0 && i < keyframes.size() - 1) {
                    current.add((Object)kf.pos);
                    kfPositionsSep.add((Object)current);
                    current = new Array();
                }
                current.add((Object)kf.pos);
                kfPositions[i * 3] = kf.pos.x;
                kfPositions[i * 3 + 1] = kf.pos.y;
                kfPositions[i * 3 + 2] = kf.pos.z;
                ++i;
            }
            kfPositionsSep.add((Object)current);
            double[] pathSamples = KeyframesManager.instance.samplePaths((Array<Array<Vector3D>>)kfPositionsSep, kfPositions, 20, Settings.settings.camrecorder.keyframe.position);
            VertsView vertsView = this.verts;
            synchronized (vertsView) {
                this.verts.setEntity(this.kf.path);
                this.verts.setPoints(pathSamples);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathKnots(double[] kts, double[] dirs, double[] ups, boolean[] seams) {
        int nSeams = 0;
        int nNoSeams = 0;
        for (boolean seam : seams) {
            if (seam) {
                ++nSeams;
                continue;
            }
            ++nNoSeams;
        }
        double[] ktsS = new double[nSeams * 3];
        double[] ktsN = new double[nNoSeams * 3];
        int ktsi = 0;
        int ktsni = 0;
        for (int i = 0; i < seams.length; ++i) {
            if (seams[i]) {
                ktsS[ktsi] = kts[i * 3];
                ktsS[ktsi + 1] = kts[i * 3 + 1];
                ktsS[ktsi + 2] = kts[i * 3 + 2];
                ktsi += 3;
                continue;
            }
            ktsN[ktsni] = kts[i * 3];
            ktsN[ktsni + 1] = kts[i * 3 + 1];
            ktsN[ktsni + 2] = kts[i * 3 + 2];
            ktsni += 3;
        }
        VertsView i = this.verts;
        synchronized (i) {
            this.verts.setEntity(this.kf.knots);
            this.verts.setPoints(ktsN);
        }
        i = this.verts;
        synchronized (i) {
            this.verts.setEntity(this.kf.knotsSeam);
            this.verts.setPoints(ktsS);
        }
        int n = kts.length;
        if (this.kf.orientations.size == (dirs.length + ups.length) / 3) {
            int j = 0;
            for (int i2 = 0; i2 < this.kf.orientations.size; ++i2) {
                double[] targ = i2 % 2 == 0 ? dirs : ups;
                Entity vo = (Entity)this.kf.orientations.get(i2);
                PointCloudData p = ((Verts)Mapper.verts.get((Entity)vo)).pointCloudData;
                p.samples.set(0, new PointCloudData.PointSample(kts[i2 / 2 * 3], kts[i2 / 2 * 3 + 1], kts[i2 / 2 * 3 + 2]));
                p.samples.set(1, new PointCloudData.PointSample(kts[i2 / 2 * 3] + targ[j], kts[i2 / 2 * 3 + 1] + targ[j + 1], kts[i2 / 2 * 3 + 2] + targ[j + 2]));
                if (i2 % 2 != 1) continue;
                j += 3;
            }
        } else {
            this.kf.clearOrientations();
            for (int i3 = 0; i3 < n; i3 += 3) {
                this.addKnotOrientation(i3 / 3, kts[i3], kts[i3 + 1], kts[i3 + 2], dirs[i3], dirs[i3 + 1], dirs[i3 + 2], ups[i3], ups[i3 + 1], ups[i3 + 2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKnot(Vector3D knot, Vector3D dir, Vector3D up, boolean seam) {
        if (seam) {
            VertsView vertsView = this.verts;
            synchronized (vertsView) {
                this.verts.setEntity(this.kf.knotsSeam);
                this.verts.addPoint(knot);
            }
        }
        VertsView vertsView = this.verts;
        synchronized (vertsView) {
            this.verts.setEntity(this.kf.knots);
            this.verts.addPoint(knot);
        }
        this.addKnotOrientation(this.kf.orientations.size / 2, knot.x, knot.y, knot.z, dir.x, dir.y, dir.z, up.x, up.y, up.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKnotOrientation(int idx, double px, double py, double pz, double dx, double dy, double dz, double ux, double uy, double uz) {
        Entity dir = this.utils.newVerts(this.scene, "Keyframes.dir", this.base.ct, "gaiasky.scenegraph.Polyline", ColorUtils.gRed, RenderGroup.LINE, false, 0.6f * this.kf.ss);
        Entity up = this.utils.newVerts(this.scene, "Keyframes.up", this.base.ct, "gaiasky.scenegraph.Polyline", ColorUtils.gBlue, RenderGroup.LINE, false, 0.6f * this.kf.ss);
        VertsView vertsView = this.verts;
        synchronized (vertsView) {
            this.verts.setEntity(dir);
            this.verts.setPoints(new double[]{px, py, pz, px + dx, py + dy, pz + dz});
        }
        vertsView = this.verts;
        synchronized (vertsView) {
            this.verts.setEntity(up);
            this.verts.setPoints(new double[]{px, py, pz, px + ux, py + uy, pz + uz});
        }
        this.kf.objects.add((Object)dir);
        this.kf.objects.add((Object)up);
        this.kf.orientations.add((Object)dir);
        this.kf.orientations.add((Object)up);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FocusView select(int screenX, int screenY, int minPixDist, NaturalCamera camera) {
        Vector3 pos = this.F31;
        Vector3D aux = this.D31;
        for (Keyframe keyframe : this.kf.keyframes) {
            PerspectiveCamera perspectiveCamera;
            Vector3D posd = aux.set(keyframe.pos).add(camera.getInversePos());
            pos.set(posd.valuesF());
            if (!(camera.direction.dot(posd) > 0.0)) continue;
            double angle = 1.0E-4;
            if (Settings.settings.program.modeStereo.active) {
                perspectiveCamera = (float)screenX < (float)Gdx.graphics.getWidth() / 2.0f ? camera.getCameraStereoLeft() : camera.getCameraStereoRight();
                perspectiveCamera.update();
            } else {
                perspectiveCamera = camera.camera;
            }
            angle = (float)FastMath.toDegrees((double)(angle * (double)camera.getFovFactor())) * (40.0f / perspectiveCamera.fieldOfView);
            double pixelSize = FastMath.max((double)minPixDist, (double)(angle * (double)perspectiveCamera.viewportHeight / (double)perspectiveCamera.fieldOfView / 2.0));
            perspectiveCamera.project(pos);
            pos.y = perspectiveCamera.viewportHeight - pos.y;
            if (Settings.settings.program.modeStereo.active) {
                pos.x /= 2.0f;
            }
            if (!this.checkClickDistance(screenX, screenY, pos, camera, perspectiveCamera, pixelSize)) continue;
            this.select(keyframe);
            this.initFocus();
            FocusView focusView = this.focus;
            synchronized (focusView) {
                this.focus.setEntity(this.kf.focus);
                this.focus.getPos().set(this.kf.selected.pos);
                ((Base)Mapper.base.get(this.kf.focus)).setName(this.kf.selected.name);
            }
            return this.focus;
        }
        return null;
    }

    protected boolean checkClickDistance(int screenX, int screenY, Vector3 pos, NaturalCamera camera, PerspectiveCamera pcamera, double pixelSize) {
        return (double)pos.dst((float)screenX % pcamera.viewportWidth, (float)screenY, pos.z) <= pixelSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlight(Keyframe keyframe) {
        this.unhighlight();
        this.kf.highlighted = keyframe;
        VertsView vertsView = this.verts;
        synchronized (vertsView) {
            this.verts.setEntity(this.kf.highlightedKnot);
            this.verts.setPoints(keyframe.pos.values());
        }
    }

    public void unhighlight(Keyframe keyframe) {
        if (this.kf.highlighted == keyframe) {
            this.unhighlight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unhighlight() {
        if (this.kf.highlighted != null) {
            this.kf.highlighted = null;
            VertsView vertsView = this.verts;
            synchronized (vertsView) {
                this.verts.setEntity(this.kf.highlightedKnot);
                this.verts.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(Keyframe keyframe) {
        this.unselect();
        this.kf.selected = keyframe;
        VertsView vertsView = this.verts;
        synchronized (vertsView) {
            this.verts.setEntity(this.kf.selectedKnot);
            this.verts.setPoints(keyframe.pos.values());
            if (this.kf.selected.seam) {
                this.verts.setColor(ColorUtils.gRed);
            } else {
                this.verts.setColor(ColorUtils.gPink);
            }
        }
        int i = this.kf.keyframes.indexOf(keyframe) * 2;
        if (i >= 0) {
            Entity dir = (Entity)this.kf.orientations.get(i);
            Entity up = (Entity)this.kf.orientations.get(i + 1);
            VertsView vertsView2 = this.verts;
            synchronized (vertsView2) {
                this.verts.setEntity(dir);
                this.verts.setPrimitiveSize(0.8f * this.kf.ss);
            }
            vertsView2 = this.verts;
            synchronized (vertsView2) {
                this.verts.setEntity(up);
                this.verts.setPrimitiveSize(0.8f * this.kf.ss);
            }
        }
        EventManager.publish(Event.KEYFRAME_SELECT, this, keyframe);
    }

    private void initFocus() {
        if (this.kf.focus == null || ((GraphNode)Mapper.graph.get((Entity)this.kf.focus)).parent == null) {
            Entity focus = this.scene.archetypes().get("gaiasky.scenegraph.Invisible").createEntity();
            Base base = (Base)Mapper.base.get(focus);
            base.setName("");
            base.setCt("Invisible");
            Body body = (Body)Mapper.body.get(focus);
            body.size = (float)(0.01 * Constants.KM_TO_U);
            GraphNode graph = (GraphNode)Mapper.graph.get(focus);
            graph.translation = new Vector3Q();
            this.scene.initializeEntity(focus);
            this.kf.focus = focus;
            EventManager.publish(Event.SCENE_ADD_OBJECT_CMD, this, focus, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselect() {
        if (this.kf.selected != null) {
            FocusView dir;
            int i = this.kf.keyframes.indexOf(this.kf.selected) * 2;
            if (i >= 0) {
                dir = (Entity)this.kf.orientations.get(i);
                Entity up = (Entity)this.kf.orientations.get(i + 1);
                VertsView vertsView = this.verts;
                synchronized (vertsView) {
                    this.verts.setEntity((Entity)dir);
                    this.verts.setPrimitiveSize(0.6f * this.kf.ss);
                }
                vertsView = this.verts;
                synchronized (vertsView) {
                    this.verts.setEntity(up);
                    this.verts.setPrimitiveSize(0.6f * this.kf.ss);
                }
            }
            this.initFocus();
            dir = this.focus;
            synchronized (dir) {
                this.focus.setEntity(this.kf.focus);
                this.focus.setName("");
            }
            Keyframe aux = this.kf.selected;
            this.kf.selected = null;
            VertsView vertsView = this.verts;
            synchronized (vertsView) {
                this.verts.setEntity(this.kf.selectedKnot);
                this.verts.clear();
            }
            EventManager.publish(Event.KEYFRAME_UNSELECT, this, aux);
        }
    }

    public boolean isSelected() {
        return this.kf.selected != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveSelection(int screenX, int screenY, NaturalCamera camera) {
        if (this.kf.selected != null) {
            double originalDist = this.D31.set(this.kf.selected.pos).add(camera.getInversePos()).len();
            Vector3 aux = this.F31.set((float)screenX, (float)screenY, 0.5f);
            camera.getCamera().unproject(aux);
            Vector3D newLocation = this.D32.set(aux).setLength(originalDist);
            this.kf.selected.pos.set(newLocation).add(camera.getPos());
            VertsView vertsView = this.verts;
            synchronized (vertsView) {
                this.verts.setEntity(this.kf.selectedKnot);
                this.verts.setPoints(this.kf.selected.pos.values());
            }
            this.refreshData();
            return true;
        }
        return false;
    }

    public boolean rotateAroundDir(double dx, double dy, NaturalCamera camera) {
        if (this.kf.selected != null) {
            this.kf.selected.up.rotate(this.kf.selected.dir, (float)((dx + dy) * 500.0));
            this.refreshOrientations();
            return true;
        }
        return false;
    }

    public boolean rotateAroundUp(double dx, double dy, NaturalCamera camera) {
        if (this.kf.selected != null) {
            this.kf.selected.dir.rotate(this.kf.selected.up, (float)((dx + dy) * 500.0));
            this.refreshOrientations();
            return true;
        }
        return false;
    }

    public boolean rotateAroundCrs(double dx, double dy, NaturalCamera camera) {
        if (this.kf.selected != null) {
            Vector3D crs = this.D31.set(this.kf.selected.dir).crs(this.kf.selected.up);
            this.kf.selected.dir.rotate(crs, (float)((dx + dy) * 500.0));
            this.kf.selected.up.rotate(crs, (float)((dx + dy) * 500.0));
            this.refreshOrientations();
            return true;
        }
        return false;
    }

    public void clearOrientations() {
        for (Entity vo : this.kf.orientations) {
            this.kf.objects.removeValue((Object)vo, true);
        }
        this.kf.orientations.clear();
    }

    public void clear() {
        VertsView v = new VertsView();
        for (Entity vo : this.kf.objects) {
            v.setEntity(vo);
            v.clear();
        }
        this.clearOrientations();
        this.unselect();
    }
}

