/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderingContext;
import gaiasky.render.api.I3DTextRenderable;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.BillboardSet;
import gaiasky.scene.component.Cluster;
import gaiasky.scene.component.Constel;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Keyframes;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.LocationMark;
import gaiasky.scene.component.Mesh;
import gaiasky.scene.component.Ruler;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.system.render.draw.TextRenderer;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.RenderView;
import gaiasky.util.Constants;
import gaiasky.util.DecalUtils;
import gaiasky.util.GlobalResources;
import gaiasky.util.Settings;
import gaiasky.util.gdx.g2d.BitmapFont;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class LabelView
extends RenderView
implements I3DTextRenderable {
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3 F31 = new Vector3();
    private final Vector3 F32 = new Vector3();
    public Label label;
    public GraphNode graph;
    public SolidAngle sa;
    public Cluster cluster;
    public BillboardSet bbSet;
    public Constel constel;
    public Mesh mesh;
    public Ruler ruler;
    public LocationMark loc;
    private final LabelEntityRenderSystem renderSystem;
    private final double rad02 = FastMath.toRadians((double)2.0);
    private final double rad40 = FastMath.toRadians((double)40.0);

    public LabelView() {
        this.renderSystem = new LabelEntityRenderSystem();
    }

    @Override
    protected void entityCheck(Entity entity) {
        super.entityCheck(entity);
        this.check(entity, Mapper.graph, GraphNode.class);
    }

    @Override
    protected void entityChanged() {
        super.entityChanged();
        this.label = (Label)Mapper.label.get(this.entity);
        this.graph = (GraphNode)Mapper.graph.get(this.entity);
        this.sa = (SolidAngle)Mapper.sa.get(this.entity);
        this.cluster = (Cluster)Mapper.cluster.get(this.entity);
        this.bbSet = (BillboardSet)Mapper.billboardSet.get(this.entity);
        this.constel = (Constel)Mapper.constel.get(this.entity);
        this.mesh = (Mesh)Mapper.mesh.get(this.entity);
        this.ruler = (Ruler)Mapper.ruler.get(this.entity);
        this.loc = (LocationMark)Mapper.loc.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        this.label = null;
        this.graph = null;
        this.sa = null;
        this.cluster = null;
        this.bbSet = null;
        this.constel = null;
        this.mesh = null;
        this.ruler = null;
    }

    public boolean renderTextCelestial() {
        return this.base.names != null && this.renderTextBase() && (this.label.forceLabel || FastMath.pow((double)this.body.solidAngleApparent, (double)this.label.solidAnglePow) >= this.sa.thresholdLabel / (double)this.label.labelBias);
    }

    public boolean renderTextParticle() {
        return this.extra.computedSize > 0.0 && this.renderTextBase() && this.body.solidAngleApparent >= this.sa.thresholdLabel / (double)(this.label.labelBias * GaiaSky.instance.cameraManager.getFovFactor());
    }

    public boolean renderTextLocation() {
        if (this.renderTextBase() && (this.body.solidAngle >= (double)5.0E-4f && (this.body.solidAngle <= (double)0.0045f || this.loc.ignoreSolidAngleLimit) || this.label.forceLabel)) {
            Vector3D aux = this.D31;
            this.graph.translation.put(aux).sub(this.body.pos).scl(-1.0);
            double fov = ((double)GaiaSky.instance.cameraManager.getCamera().fieldOfView - 1.0) * 0.5 / 149.0;
            return aux.add(this.loc.location3d).scl(-1.0).nor().dot(GaiaSky.instance.cameraManager.getDirection()) > 0.5 + fov;
        }
        return false;
    }

    public boolean renderTextKeyframe() {
        Keyframes kf = (Keyframes)Mapper.keyframes.get(this.entity);
        return kf.selected != null;
    }

    public boolean renderTextRuler() {
        return this.renderTextBase() && this.ruler.rulerOk;
    }

    public boolean renderTextBackgroundModel() {
        return this.renderTextBase() && this.label.label;
    }

    public boolean renderTextTitle() {
        return !Settings.settings.program.modeCubemap.active;
    }

    public boolean renderTextTrajectory() {
        return this.renderTextBase() && this.label.forceLabel;
    }

    public boolean renderTextGridRec() {
        return this.label.label;
    }

    public boolean renderTextEssential() {
        return this.base.names != null && this.renderTextBase() && this.base.opacity > 0.0f;
    }

    public boolean renderTextBase() {
        return GaiaSky.instance.isOn(ComponentTypes.ComponentType.Labels);
    }

    @Override
    public boolean renderText() {
        return this.label.renderFunction == null || this.label.renderFunction.apply(this) != false;
    }

    @Override
    public void render(ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        if (this.label.renderConsumer != null && this.renderText()) {
            this.label.renderConsumer.apply(this.renderSystem, this, batch, shader, sys, rc, camera);
        }
    }

    @Override
    public float textSize() {
        if (this.constel != null) {
            return 2000000.0f * (float)Constants.DISTANCE_SCALE_FACTOR;
        }
        if (this.loc != null) {
            return this.body.size * this.label.labelFactor;
        }
        if (Mapper.keyframes.has(this.entity)) {
            return this.label.labelMax * (float)Constants.DISTANCE_SCALE_FACTOR;
        }
        return (float)((double)this.label.labelMax * this.body.distToCamera * (double)this.label.labelFactor);
    }

    @Override
    public float textScale() {
        if (this.starSet != null || this.particleSet != null) {
            return this.label.textScale / Settings.settings.scene.label.size;
        }
        if (this.constel != null) {
            return 0.2f / Settings.settings.scene.label.size;
        }
        if (this.loc != null) {
            return this.loc.sizeKm * this.label.textScale / this.textSize() * (float)Constants.DISTANCE_SCALE_FACTOR;
        }
        return this.label.textScale >= 0.0f ? this.label.textScale : (float)FastMath.atan((double)this.label.labelMax) * this.label.labelFactor * 400.0f;
    }

    @Override
    public void textPosition(ICamera cam, Vector3D out) {
        if (this.label != null && this.label.labelPosition != null) {
            out.set(this.label.labelPosition).add(cam.getInversePos());
        } else {
            if (this.ruler == null) {
                this.graph.translation.put(out);
            } else {
                out.set(this.ruler.m);
            }
            double distToCamera = out.len();
            out.clamp(0.0, distToCamera - this.getRadius()).scl(0.9f);
            Vector3D offset = this.D32;
            offset.set(cam.getUp());
            offset.crs(out).nor();
            float displacement = (float)MathUtilsDouble.flint(this.body.solidAngleApparent, this.rad02, this.rad40, 1.0, 20.0);
            float dist = -0.015f * displacement * cam.getFovFactor() * (float)out.len();
            offset.add(cam.getUp()).nor().scl(dist);
            out.add(offset);
        }
        GlobalResources.applyRelativisticAberration(out, cam);
        RelativisticEffectsManager.getInstance().gravitationalWavePos(out);
    }

    @Override
    public String text() {
        if (this.ruler != null) {
            return this.ruler.dist;
        }
        if (this.loc != null) {
            return this.loc.displayName;
        }
        return this.base.getLocalizedName();
    }

    @Override
    public void textDepthBuffer() {
        this.label.depthBufferConsumer.accept(this);
    }

    public void defaultTextDepthBuffer() {
        Gdx.gl.glEnable(2929);
        Gdx.gl.glDepthMask(false);
    }

    public void noTextDepthBuffer() {
        Gdx.gl.glDisable(2929);
        Gdx.gl.glDepthMask(false);
    }

    public void emptyTextDepthBuffer() {
    }

    @Override
    public boolean isLabel() {
        return this.label == null || this.label.label;
    }

    public boolean isLocation() {
        return this.loc != null;
    }

    @Override
    public float getTextOpacity() {
        return this.base.opacity;
    }

    protected void render2DLabel(ExtSpriteBatch batch, ExtShaderProgram shader, RenderingContext rc, BitmapFont font, ICamera camera, String label, Vector3D pos3d) {
        Vector3 p = this.F31;
        pos3d.setVector3(p);
        camera.getCamera().project(p);
        p.x += 15.0f;
        p.y -= 15.0f;
        shader.setUniformf("scale", 1.0f);
        DecalUtils.drawFont2D(font, batch, label, p);
    }

    protected void render2DLabel(ExtSpriteBatch batch, ExtShaderProgram shader, RenderingContext rc, BitmapFont font, ICamera camera, String label, float x, float y, float scale, int align) {
        shader.setUniformf("u_scale", scale);
        DecalUtils.drawFont2D(font, batch, rc, label, x, y, scale, align);
    }

    protected void render2DLabel(ExtSpriteBatch batch, ExtShaderProgram shader, RenderingContext rc, BitmapFont font, ICamera camera, String label, float x, float y) {
        this.render2DLabel(batch, shader, rc, font, camera, label, x, y, 1.0f);
    }

    protected void render2DLabel(ExtSpriteBatch batch, ExtShaderProgram shader, RenderingContext rc, BitmapFont font, ICamera camera, String label, float x, float y, float scale) {
        this.render2DLabel(batch, shader, rc, font, camera, label, x, y, scale, -1);
    }

    protected void render3DLabel(ExtSpriteBatch batch, ExtShaderProgram shader, BitmapFont font, ICamera camera, RenderingContext rc, String label, Vector3D pos, double distToCamera, float scale, double size, double radius, boolean forceLabel) {
        this.render3DLabel(batch, shader, font, camera, rc, label, pos, distToCamera, scale, size, radius, -1.0f, -1.0f, forceLabel);
    }

    protected void render3DLabel(ExtSpriteBatch batch, ExtShaderProgram shader, BitmapFont font, ICamera camera, RenderingContext rc, String label, Vector3D pos, double distToCamera, float scale, double size, double radius, float minSizeDegrees, float maxSizeDegrees, boolean forceLabel) {
        shader.setUniformf("u_scale", Settings.settings.scene.label.size * scale / camera.getFovFactor());
        if (forceLabel || radius == 0.0 || distToCamera > radius * 2.0) {
            size *= (double)Settings.settings.scene.label.size;
            float rot = 0.0f;
            if (rc.cubemapSide == RenderingContext.CubemapSide.SIDE_UP || rc.cubemapSide == RenderingContext.CubemapSide.SIDE_DOWN) {
                Vector3 v1 = this.F31;
                Vector3 v2 = this.F32;
                camera.getCamera().project(v1.set((float)pos.x, (float)pos.y, (float)pos.z));
                v1.z = 0.0f;
                v2.set((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, 0.0f);
                rot = GlobalResources.angle2d(v1, v2) + (rc.cubemapSide == RenderingContext.CubemapSide.SIDE_UP ? 90.0f : -90.0f);
            }
            shader.setUniformf("u_pos", pos);
            this.textDepthBuffer();
            DecalUtils.drawFont3D(font, batch, label, (float)pos.x, (float)pos.y, (float)pos.z, size, rot, camera, !rc.isCubemap(), minSizeDegrees, maxSizeDegrees);
        }
    }
}

