/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Entity;
import gaiasky.render.ComponentTypes;
import gaiasky.render.api.ILineRenderable;
import gaiasky.render.system.LineRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.system.render.draw.LinePrimitiveRenderer;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.scene.view.BaseView;

public class LineView
extends BaseView
implements ILineRenderable {
    public Trajectory trajectory;
    public Verts verts;
    public Line line;
    private LineEntityRenderSystem renderSystem;

    public LineView() {
        this.renderSystem = new LineEntityRenderSystem(this);
    }

    public LineView(Entity entity) {
        super(entity);
    }

    @Override
    protected void entityChanged() {
        super.entityChanged();
        this.trajectory = (Trajectory)Mapper.trajectory.get(this.entity);
        this.verts = (Verts)Mapper.verts.get(this.entity);
        this.line = (Line)Mapper.line.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        this.trajectory = null;
        this.verts = null;
        this.line = null;
    }

    @Override
    public float getLineWidth() {
        return this.verts != null ? this.verts.primitiveSize : (this.line != null ? this.line.lineWidth : 1.0f);
    }

    @Override
    public void render(LineRenderSystem renderer, ICamera camera, float alpha) {
        if (this.line != null && this.line.renderConsumer != null) {
            this.line.renderConsumer.apply(this.renderSystem, this.entity, (LinePrimitiveRenderer)renderer, camera, Float.valueOf(alpha));
        }
    }

    @Override
    public int getGlPrimitive() {
        return this.verts != null ? this.verts.glPrimitive : 1;
    }

    @Override
    public ComponentTypes getComponentType() {
        return this.base.ct;
    }

    @Override
    public double getDistToCamera() {
        return this.body.distToCamera;
    }

    @Override
    public float getOpacity() {
        return this.base.opacity;
    }
}

