/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Entity;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.view.AbstractView;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.tree.IPosition;

public non-sealed class PositionView
extends AbstractView
implements IPosition {
    private Body body;

    public PositionView(Entity entity) {
        super(entity);
    }

    @Override
    protected boolean componentsCheck(Entity entity) {
        return entity != null && Mapper.body.get(entity) == this.body;
    }

    @Override
    protected void entityCheck(Entity entity) {
        if (!Mapper.body.has(entity)) {
            throw new RuntimeException("The given entity does not have a " + Body.class.getSimpleName() + " component: Can't be a " + this.getClass().getSimpleName() + ".");
        }
    }

    @Override
    protected void entityChanged() {
        this.body = (Body)Mapper.body.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        this.body = null;
    }

    @Override
    public Vector3Q getPosition() {
        return this.body.pos;
    }

    @Override
    public Vector3D getVelocity() {
        return null;
    }
}

