/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Entity;
import gaiasky.render.api.IRenderable;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.ParticleExtra;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.view.BaseView;
import java.util.Locale;

public class RenderView
extends BaseView
implements IRenderable {
    public ParticleExtra extra;
    public ParticleSet particleSet;
    public StarSet starSet;

    public RenderView() {
    }

    public RenderView(Entity entity) {
        super(entity);
    }

    @Override
    protected void entityChanged() {
        super.entityChanged();
        this.extra = (ParticleExtra)Mapper.extra.get(this.entity);
        this.particleSet = (ParticleSet)Mapper.particleSet.get(this.entity);
        this.starSet = (StarSet)Mapper.starSet.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        this.extra = null;
        this.particleSet = null;
        this.starSet = null;
    }

    @Override
    public double getDistToCamera() {
        return this.body.distToCamera;
    }

    @Override
    public float getOpacity() {
        return this.base.opacity;
    }

    public double getRadius() {
        return this.extra == null ? (double)this.body.size / 2.0 : this.extra.radius;
    }

    public float[] textColour() {
        return this.body.labelColor;
    }

    public float[] textColour(String name) {
        int idx;
        assert (this.starSet != null) : "Called the wrong method!";
        if (this.starSet.index.containsKey(name = name.toLowerCase(Locale.ROOT).trim()) && this.starSet.labelColors.containsKey(idx = this.starSet.index.get(name))) {
            return (float[])this.starSet.labelColors.get(idx);
        }
        return this.body.labelColor;
    }
}

