/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Quaternion;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.ISpacecraft;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.MotorEngine;
import gaiasky.scene.record.MachineDefinition;
import gaiasky.scene.view.BaseView;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;

public class SpacecraftView
extends BaseView
implements ISpacecraft {
    private static final Logger.Log logger = Logger.getLogger(SpacecraftView.class);
    private final Vector3D D31 = new Vector3D();
    public MotorEngine engine;
    public Coordinates coord;

    @Override
    protected void entityCheck(Entity entity) {
        super.entityCheck(entity);
        this.check(entity, Mapper.engine, MotorEngine.class);
        this.check(entity, Mapper.coordinates, Coordinates.class);
    }

    @Override
    protected void entityChanged() {
        super.entityChanged();
        this.engine = (MotorEngine)Mapper.engine.get(this.entity);
        this.coord = (Coordinates)Mapper.coordinates.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        super.entityCleared();
        this.engine = null;
        this.coord = null;
    }

    public boolean isStopping() {
        return this.engine.stopping;
    }

    public boolean isStabilising() {
        return this.engine.leveling;
    }

    public MachineDefinition[] getMachines() {
        return this.engine.machines;
    }

    public int getCurrentMachine() {
        return this.engine.currentMachine;
    }

    @Override
    public Vector3D force() {
        return this.engine.force;
    }

    @Override
    public Vector3D accel() {
        return this.engine.accel;
    }

    public Vector3Q pos() {
        return this.body.pos;
    }

    @Override
    public Vector3D vel() {
        return this.engine.vel;
    }

    @Override
    public Vector3D direction() {
        return this.engine.direction;
    }

    @Override
    public Vector3D up() {
        return this.engine.up;
    }

    @Override
    public Vector3D thrust() {
        return this.engine.thrust;
    }

    public float size() {
        return this.body.size;
    }

    public double getResponsiveness() {
        return this.engine.responsiveness;
    }

    public double getDrag() {
        return this.engine.drag;
    }

    @Override
    public double currentEnginePower() {
        return this.engine.currentEnginePower;
    }

    @Override
    public void currentEnginePower(double power) {
        this.engine.currentEnginePower = power;
    }

    @Override
    public double thrustMagnitude() {
        return this.engine.thrustMagnitude();
    }

    @Override
    public double[] thrustFactor() {
        return this.engine.thrustFactor();
    }

    @Override
    public double relativisticSpeedCap() {
        return this.engine.relativisticSpeedCap();
    }

    @Override
    public double drag() {
        return this.engine.drag();
    }

    @Override
    public double mass() {
        return this.engine.mass();
    }

    @Override
    public int thrustFactorIndex() {
        return this.engine.thrustFactorIndex();
    }

    @Override
    public boolean leveling() {
        return this.engine.leveling();
    }

    @Override
    public boolean stopping() {
        return this.engine.stopping();
    }

    public Quaternion getRotationQuaternion() {
        return this.engine.qf;
    }

    public IBodyCoordinates getCoordinates() {
        return this.coord.coordinates;
    }

    public double getYawPower() {
        return this.engine.yawp;
    }

    public void setYawPower(double yawp) {
        this.engine.setYawPower(yawp);
    }

    public double getPitchPower() {
        return this.engine.pitchp;
    }

    public void setPitchPower(double pitchp) {
        this.engine.setPitchPower(pitchp);
    }

    public double getRollPower() {
        return this.engine.rollp;
    }

    public void setRollPower(double rollp) {
        this.engine.setRollPower(rollp);
    }

    public void setCurrentEnginePower(double currentEnginePower) {
        this.engine.setCurrentEnginePower(currentEnginePower);
    }

    @Override
    public void stopAllMovement() {
        this.engine.setCurrentEnginePower(0.0);
        this.engine.setYawPower(0.0);
        this.engine.setPitchPower(0.0);
        this.engine.setRollPower(0.0);
        this.engine.leveling = false;
        this.engine.stopping = false;
    }

    public void increaseThrustFactorIndex(boolean broadcast) {
        this.engine.thrustFactorIndex = (this.engine.thrustFactorIndex + 1) % MotorEngine.thrustFactor.length;
        logger.info("Thrust factor: " + MotorEngine.thrustFactor[this.engine.thrustFactorIndex]);
        if (broadcast) {
            EventManager.publish(Event.SPACECRAFT_THRUST_INFO, this, this.engine.thrustFactorIndex);
        }
    }

    public void decreaseThrustFactorIndex(boolean broadcast) {
        --this.engine.thrustFactorIndex;
        if (this.engine.thrustFactorIndex < 0) {
            this.engine.thrustFactorIndex = MotorEngine.thrustFactor.length - 1;
        }
        logger.info("Thrust factor: " + MotorEngine.thrustFactor[this.engine.thrustFactorIndex]);
        if (broadcast) {
            EventManager.publish(Event.SPACECRAFT_THRUST_INFO, this, this.engine.thrustFactorIndex);
        }
    }

    public void setThrustFactorIndex(int i, boolean broadcast) {
        assert (i >= 0 && i < MotorEngine.thrustFactor.length) : "Index " + i + " out of range of thrustFactor vector: [0.." + (MotorEngine.thrustFactor.length - 1);
        this.engine.thrustFactorIndex = i;
        logger.info("Thrust factor: " + MotorEngine.thrustFactor[this.engine.thrustFactorIndex]);
        if (broadcast) {
            EventManager.publish(Event.SPACECRAFT_THRUST_INFO, this, this.engine.thrustFactorIndex);
        }
    }

    public double computeDirectionUp(double dt, Pair<Vector3D, Vector3D> pair) {
        this.engine.yawf = this.engine.yawp * this.engine.responsiveness;
        this.engine.pitchf = this.engine.pitchp * this.engine.responsiveness;
        this.engine.rollf = this.engine.rollp * this.engine.responsiveness;
        double friction = this.engine.drag * 2.0E7 * dt;
        this.engine.yawf -= this.engine.yawv * friction;
        this.engine.pitchf -= this.engine.pitchv * friction;
        this.engine.rollf -= this.engine.rollv * friction;
        this.engine.yawa = this.engine.yawf / this.engine.mass;
        this.engine.pitcha = this.engine.pitchf / this.engine.mass;
        this.engine.rolla = this.engine.rollf / this.engine.mass;
        this.engine.yawv += this.engine.yawa * dt;
        this.engine.pitchv += this.engine.pitcha * dt;
        this.engine.rollv += this.engine.rolla * dt;
        double yawDiff = this.engine.yawv * dt % 360.0;
        double pitchDiff = this.engine.pitchv * dt % 360.0;
        double rollDiff = this.engine.rollv * dt % 360.0;
        Vector3D direction = pair.getFirst();
        Vector3D up = pair.getSecond();
        direction.rotate(up, yawDiff);
        Vector3D aux1 = this.D31.set(direction).crs(up);
        direction.rotate(aux1, pitchDiff);
        up.rotate(aux1, pitchDiff);
        up.rotate(direction, -rollDiff);
        return rollDiff;
    }

    public void pollKeys(double dt) {
        double powerStep = dt / this.engine.fullPowerTime;
        if (Gdx.input.isKeyPressed(51)) {
            this.setCurrentEnginePower(this.engine.currentEnginePower + powerStep);
        }
        if (Gdx.input.isKeyPressed(47)) {
            this.setCurrentEnginePower(this.engine.currentEnginePower - powerStep);
        }
        if (Gdx.input.isKeyPressed(29)) {
            this.setRollPower(this.engine.rollp + powerStep);
        }
        if (Gdx.input.isKeyPressed(32)) {
            this.setRollPower(this.engine.rollp - powerStep);
        }
        if (Gdx.input.isKeyPressed(20)) {
            this.setPitchPower(this.engine.pitchp + powerStep);
        }
        if (Gdx.input.isKeyPressed(19)) {
            this.setPitchPower(this.engine.pitchp - powerStep);
        }
        if (Gdx.input.isKeyPressed(21)) {
            this.setYawPower(this.engine.yawp + powerStep);
        }
        if (Gdx.input.isKeyPressed(22)) {
            this.setYawPower(this.engine.yawp - powerStep);
        }
    }
}

