/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.view;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IGPUVertsRenderable;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.entity.TrajectoryUtils;
import gaiasky.scene.view.BaseView;
import gaiasky.util.math.Vector3D;

public class VertsView
extends BaseView
implements IGPUVertsRenderable {
    private final TrajectoryUtils utils = new TrajectoryUtils();
    private Verts verts;
    private GraphNode graph;
    private Trajectory trajectory;

    public VertsView() {
    }

    public VertsView(Entity entity) {
        super(entity);
    }

    @Override
    protected void entityCheck(Entity entity) {
        super.entityCheck(entity);
        this.check(entity, Mapper.verts, Verts.class);
        this.check(entity, Mapper.graph, GraphNode.class);
    }

    @Override
    protected void entityChanged() {
        super.entityChanged();
        this.verts = (Verts)Mapper.verts.get(this.entity);
        this.graph = (GraphNode)Mapper.graph.get(this.entity);
        this.trajectory = (Trajectory)Mapper.trajectory.get(this.entity);
    }

    @Override
    protected void entityCleared() {
        this.verts = null;
        this.graph = null;
        this.trajectory = null;
    }

    @Override
    public void markForUpdate() {
        EventManager.publish(Event.GPU_DISPOSE_VERTS_OBJECT, Mapper.render.get(this.entity), new Object[]{this.verts.renderGroup});
        if (this.trajectory != null) {
            this.utils.updateSize(this.body, this.trajectory, this.verts);
        }
    }

    @Override
    public PointCloudData getPointCloud() {
        return this.verts.pointCloudData;
    }

    @Override
    public float[] getColor() {
        return this.body.color;
    }

    @Override
    public double getAlpha() {
        return this.trajectory != null ? this.trajectory.alpha : (double)this.body.color[3];
    }

    @Override
    public Matrix4 getLocalTransform() {
        return this.graph.localTransform;
    }

    @Override
    public Entity getParentEntity() {
        return this.graph.parent;
    }

    @Override
    public boolean isClosedLoop() {
        return this.trajectory != null ? this.trajectory.closedLoop : this.verts.closedLoop;
    }

    @Override
    public void setClosedLoop(boolean closedLoop) {
        if (this.trajectory != null) {
            this.trajectory.closedLoop = closedLoop;
        }
        this.verts.closedLoop = closedLoop;
    }

    @Override
    public void blend() {
        EntityUtils.blend(this.verts);
    }

    @Override
    public void depth() {
        EntityUtils.depth(this.verts);
    }

    @Override
    public int getGlPrimitive() {
        return this.verts.glPrimitive;
    }

    public void setGlPrimitive(int glPrimitive) {
        this.verts.glPrimitive = glPrimitive;
    }

    @Override
    public float getPrimitiveSize() {
        return this.verts.primitiveSize;
    }

    @Override
    public void setPrimitiveSize(float size) {
        this.verts.primitiveSize = size;
    }

    @Override
    public double getDistToCamera() {
        return this.body.distToCamera;
    }

    @Override
    public float getOpacity() {
        return this.base.opacity;
    }

    public void setPoints(double[] points) {
        int n = points.length;
        if (n % 3 != 0) {
            n -= n % 3;
        }
        if (this.verts.pointCloudData == null) {
            this.verts.pointCloudData = new PointCloudData(n / 3);
        } else {
            this.verts.pointCloudData.clear();
        }
        this.verts.pointCloudData.addPoints(points);
        this.markForUpdate();
    }

    public void addPoints(double[] points) {
        if (this.verts.pointCloudData == null) {
            this.setPoints(points);
        } else {
            this.verts.pointCloudData.addPoints(points);
            this.markForUpdate();
        }
    }

    public void addPoint(Vector3D point) {
        if (this.verts.pointCloudData == null) {
            this.setPoints(point.values());
        } else {
            this.verts.pointCloudData.addPoint(point);
            this.markForUpdate();
        }
    }

    public void setRenderGroup(RenderGroup renderGroup) {
        this.verts.renderGroup = renderGroup;
    }

    @Override
    public boolean isEmpty() {
        return this.verts.pointCloudData.isEmpty();
    }

    public void clear() {
        this.setPoints(new double[0]);
    }
}

