/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import gaiasky.script.EventScriptingInterface;
import gaiasky.script.IScriptingInterface;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.script.v2.meta.ModuleDesc;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class ConsoleManager {
    private final Array<Message> messages = new Array();
    private final Array<String> cmdHistory = new Array();
    private Map<String, Array<Method>> apiV1Methods;
    private Map<String, Array<Method>> apiV2Methods;
    private final Map<String, Array<Method>> allMethods;
    private Map<String, String> shortcutMap;
    private Map<String, Object> instances;
    private final IScriptingInterface script;

    public ConsoleManager(IScriptingInterface script) {
        this.script = script;
        this.initAPIv2Methods();
        this.initAPIv1Methods();
        this.initShortcuts();
        this.initInstances();
        this.allMethods = new HashMap<String, Array<Method>>();
        this.allMethods.putAll(this.apiV1Methods);
        this.allMethods.putAll(this.apiV2Methods);
    }

    public void addCommandToHistory(String cmd) {
        this.cmdHistory.add((Object)cmd);
    }

    public Array<String> cmdHistory() {
        return this.cmdHistory;
    }

    public Array<Message> messages() {
        return this.messages;
    }

    public boolean hasMethod(String methodName) {
        return this.allMethods.containsKey(methodName);
    }

    public Array<Method> getMethods(String methodName) {
        return this.allMethods.get(methodName);
    }

    public Map<String, Array<Method>> methodMap() {
        return this.allMethods;
    }

    public Map<String, Array<Method>> methodMapAPIv1() {
        return this.apiV1Methods;
    }

    public Map<String, Array<Method>> methodMapAPIv2() {
        return this.apiV2Methods;
    }

    public Map<String, Array<Method>> methodMapAPIv2(String module) {
        Map<String, Array<Method>> result = this.apiV2Methods.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(module)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }

    public Map<String, String> shortcutMap() {
        return this.shortcutMap;
    }

    public Object getInstance(String path) {
        return this.instances.get(path);
    }

    public String unwrapShortcut(String command) {
        if (this.shortcutMap.containsKey(command)) {
            return this.shortcutMap.get(command);
        }
        return command;
    }

    private void initShortcuts() {
        this.shortcutMap = new HashMap<String, String>();
        this.shortcutMap.put("goto", "goToObject");
        this.shortcutMap.put("gotonow", "goToObjectInstant");
        this.shortcutMap.put("land", "landOnObject");
        this.shortcutMap.put("distance", "getDistanceTo");
        this.shortcutMap.put("pos", "getObjectPosition");
        this.shortcutMap.put("find", "setCameraFocus");
        this.shortcutMap.put("focus", "setCameraFocus");
        this.shortcutMap.put("free", "setCameraFree");
        this.shortcutMap.put("starttime", "startSimulationTime");
        this.shortcutMap.put("stoptime", "stopSimulationTime");
        this.shortcutMap.put("time", "setSimulationTime");
        this.shortcutMap.put("timewarp", "setTimeWarp");
        this.shortcutMap.put("startexindex", "setStarTextureIndex");
        this.shortcutMap.put("fov", "setFov");
        this.shortcutMap.put("forward", "cameraForward");
        this.shortcutMap.put("rotate", "cameraRotate");
        this.shortcutMap.put("turn", "cameraTurn");
        this.shortcutMap.put("stop", "cameraStop");
        this.shortcutMap.put("roll", "cameraRoll");
        this.shortcutMap.put("pitch", "cameraPitch");
        this.shortcutMap.put("yaw", "cameraYaw");
        this.shortcutMap.put("setcampos", "setCameraPosition");
        this.shortcutMap.put("campos", "getCameraPosition");
        this.shortcutMap.put("setcamdir", "setCameraDirection");
        this.shortcutMap.put("camdir", "getCameraDirection");
        this.shortcutMap.put("setcamup", "setCameraUp");
        this.shortcutMap.put("camup", "getCameraUp");
        this.shortcutMap.put("direquatorial", "setCameraDirectionEquatorial");
        this.shortcutMap.put("dirgalactic", "setCameraDirectionGalactic");
        this.shortcutMap.put("screenshot", "saveScreenshot");
        this.shortcutMap.put("version", "getVersion");
        this.shortcutMap.put("log", "log");
        this.shortcutMap.put("print", "print");
        this.shortcutMap.put("exit", "quit");
    }

    private void initAPIv1Methods() {
        if (this.apiV1Methods == null) {
            Class<IScriptingInterface> iScriptingInterfaceClass = IScriptingInterface.class;
            Method[] allMethods = iScriptingInterfaceClass.getDeclaredMethods();
            this.apiV1Methods = new HashMap<String, Array<Method>>();
            for (Method method : allMethods) {
                Array<Method> matches = this.apiV1Methods.containsKey(method.getName()) ? this.apiV1Methods.get(method.getName()) : new Array<Method>(false, 1);
                if (!matches.contains((Object)method, true)) {
                    matches.add((Object)method);
                }
                this.apiV1Methods.put(method.getName(), matches);
            }
        }
    }

    private void initAPIv2Methods() {
        if (this.apiV2Methods == null) {
            this.apiV2Methods = new HashMap<String, Array<Method>>();
            ModuleDesc root = ModuleDesc.of(Path.of("", new String[0]), APIv2.class, true);
            this.addAPIv2Methods(root);
        }
    }

    private void addAPIv2Methods(ModuleDesc module) {
        if (module.methodMap() != null && !module.methodMap().isEmpty()) {
            this.apiV2Methods.putAll(module.methodMap());
        }
        if (module.modules() != null && !module.modules().isEmpty()) {
            for (ModuleDesc m : module.modules()) {
                this.addAPIv2Methods(m);
            }
        }
    }

    private void initInstances() {
        if (this.instances == null) {
            this.instances = new HashMap<String, Object>();
        }
        this.instances.put(".", this.script);
        this.initInstances(((EventScriptingInterface)this.script).apiv2, "");
    }

    private void initInstances(Object o, String prefix) {
        Field[] fields;
        for (Field f : fields = o.getClass().getDeclaredFields()) {
            if (!Modifier.isPublic(f.getModifiers()) || !APIModule.class.isAssignableFrom(f.getType())) continue;
            String path = prefix + (prefix.isEmpty() ? "" : ".") + f.getName().toLowerCase(Locale.ROOT);
            try {
                this.instances.put(path + ".", f.get(o));
                this.initInstances(f.get(o), path);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum MsgType {
        INFO("info", ColorUtils.gYellowC, ColorUtils.gWhiteC),
        ERROR("error", ColorUtils.gRedC, ColorUtils.gPinkC),
        RETURN("return", ColorUtils.gBlueC, ColorUtils.gWhiteC),
        OK("ok", ColorUtils.gGreenC, ColorUtils.gWhiteC);

        private final String code;
        private final Color msgColor;
        private final Color tagColor;

        private MsgType(String code, Color tagColor, Color msgColor) {
            this.code = code;
            this.tagColor = tagColor;
            this.msgColor = msgColor;
        }

        public String getCodeString() {
            return I18n.msg("gui." + this.code + ".code");
        }

        public String getNameString() {
            return I18n.msg("gui." + this.code + ".name");
        }

        public Color getTagColor() {
            return this.tagColor;
        }

        public Color getMsgColor() {
            return this.msgColor;
        }
    }

    public record Message(String msg, MsgType type, Instant time) {
        public String cleanMessage() {
            return TextUtils.stripAnsiCodes(this.msg);
        }
    }
}

