/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import gaiasky.data.group.DatasetOptions;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.entity.TrajectoryUtils;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.VertsView;
import gaiasky.script.IScriptingInterface;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.CatalogInfo;
import gaiasky.util.CatalogManager;
import gaiasky.util.Logger;
import gaiasky.util.LruCache;
import gaiasky.util.Settings;
import gaiasky.util.coord.IPythonCoordinatesProvider;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.ac.starlink.util.DataSource;

public final class EventScriptingInterface
implements IScriptingInterface {
    private static final Logger.Log logger = Logger.getLogger(EventScriptingInterface.class);
    private final EventManager em = EventManager.instance;
    private LruCache<String, Texture> textures;
    private TrajectoryUtils trajectoryUtils;
    public final APIv2 apiv2;

    public EventScriptingInterface(AssetManager manager, CatalogManager catalogManager) {
        this.apiv2 = new APIv2(manager, catalogManager);
    }

    private void initializeTextures() {
        if (this.textures == null) {
            this.textures = new LruCache(100);
        }
    }

    private double[] dArray(List<?> l) {
        if (l == null) {
            return null;
        }
        double[] res = new double[l.size()];
        int i = 0;
        for (Object o : l) {
            res[i++] = (Double)o;
        }
        return res;
    }

    private int[] iArray(List<?> l) {
        if (l == null) {
            return null;
        }
        int[] res = new int[l.size()];
        int i = 0;
        for (Object o : l) {
            res[i++] = (Integer)o;
        }
        return res;
    }

    @Override
    public void activateRealTimeFrame() {
        this.apiv2.time.activate_real_time_frame();
    }

    @Override
    public void activateSimulationTimeFrame() {
        this.apiv2.time.activate_simulation_time_frame();
    }

    @Override
    public void displayPopupNotification(String message) {
        this.apiv2.ui.display_popup_notification(message);
    }

    @Override
    public void displayPopupNotification(String message, float duration) {
        this.apiv2.ui.display_popup_notification(message, duration);
    }

    public void displayPopupNotification(String message, Double duration) {
        this.apiv2.ui.display_popup_notification(message, duration);
    }

    @Override
    public void setHeadlineMessage(String headline) {
        this.apiv2.ui.set_headline_message(headline);
    }

    @Override
    public void setSubheadMessage(String subhead) {
        this.apiv2.ui.set_subhead_message(subhead);
    }

    @Override
    public void clearHeadlineMessage() {
        this.apiv2.ui.clear_headline_message();
    }

    @Override
    public void clearSubheadMessage() {
        this.apiv2.ui.clear_subhead_message();
    }

    @Override
    public void clearAllMessages() {
        this.apiv2.ui.clear_all_messages();
    }

    @Override
    public void disableInput() {
        this.apiv2.input.disable();
    }

    @Override
    public void enableInput() {
        this.apiv2.input.enable();
    }

    @Override
    public void setCinematicCamera(boolean cinematic) {
        this.apiv2.camera.interactive.set_cinematic(cinematic);
    }

    @Override
    public void setCameraFocus(String focusName) {
        this.apiv2.camera.focus_mode(focusName);
    }

    @Override
    public void setCameraFocus(String focusName, float waitTimeSeconds) {
        this.apiv2.camera.focus_mode(focusName, waitTimeSeconds);
    }

    public void setCameraFocus(String focusName, int waitTimeSeconds) {
        this.apiv2.camera.focus_mode(focusName, waitTimeSeconds);
    }

    public void setCameraFocus(Entity entity, float waitTimeSeconds) {
        this.apiv2.camera.focus_mode(entity, waitTimeSeconds);
    }

    @Override
    public void setCameraFocusInstant(String focusName) {
        this.apiv2.camera.focus_mode_instant(focusName);
    }

    @Override
    public void setCameraFocusInstantAndGo(String focusName) {
        this.apiv2.camera.focus_mode_instant_go(focusName);
    }

    public void setCameraFocusInstantAndGo(String focusName, boolean sleep) {
        this.apiv2.camera.focus_mode_instant_go(focusName, sleep);
    }

    @Override
    public void setCameraLock(boolean lock) {
        this.apiv2.camera.set_focus_lock(lock);
    }

    @Override
    public void setCameraCenterFocus(boolean centerFocus) {
        this.apiv2.camera.center_focus(centerFocus);
    }

    @Override
    public void setCameraFree() {
        this.apiv2.camera.free_mode();
    }

    @Override
    public void setCameraPostion(double[] vec) {
        this.apiv2.camera.set_position(vec);
    }

    @Override
    public void setCameraPosition(double x, double y, double z) {
        this.apiv2.camera.set_position(x, y, z);
    }

    @Override
    public void setCameraPosition(double x, double y, double z, String units) {
        this.apiv2.camera.set_position(x, y, z, units);
    }

    @Override
    public void setCameraPosition(double x, double y, double z, boolean immediate) {
        this.apiv2.camera.set_position(x, y, z, immediate);
    }

    @Override
    public void setCameraPosition(double x, double y, double z, String units, boolean immediate) {
        this.apiv2.camera.set_position(x, y, z, units, immediate);
    }

    public void setCameraPosition(List<?> vec, boolean immediate) {
        this.apiv2.camera.set_position(vec, immediate);
    }

    @Override
    public void setCameraPosition(double[] position, boolean immediate) {
        this.apiv2.camera.set_position(position, immediate);
    }

    @Override
    public void setCameraPosition(double[] position, String units, boolean immediate) {
        this.apiv2.camera.set_position(position, units, immediate);
    }

    public void setCameraPosition(List<Double> position, String units, boolean immediate) {
        this.apiv2.camera.set_position(position, units, immediate);
    }

    @Override
    public double[] getCameraPosition() {
        return this.apiv2.camera.get_position();
    }

    @Override
    public double[] getCameraPosition(String units) {
        return this.apiv2.camera.get_position(units);
    }

    @Override
    public void setCameraPosition(double[] position) {
        this.apiv2.camera.set_position(position);
    }

    @Override
    public void setCameraPosition(double[] position, String units) {
        this.apiv2.camera.set_position(position, units);
    }

    public void setCameraPosition(List<?> vec) {
        this.apiv2.camera.set_position(vec);
    }

    public void setCameraPosition(List<?> vec, String units) {
        this.apiv2.camera.set_position(vec, units);
    }

    public void setCameraDirection(List<?> dir, boolean immediate) {
        this.apiv2.camera.set_direction(dir, immediate);
    }

    @Override
    public void setCameraDirection(double[] direction, boolean immediate) {
        this.apiv2.camera.set_direction(direction, immediate);
    }

    @Override
    public double[] getCameraDirection() {
        return this.apiv2.camera.get_direction();
    }

    @Override
    public void setCameraDirection(double[] direction) {
        this.apiv2.camera.set_direction(direction);
    }

    @Override
    public void setCameraDirectionEquatorial(double alpha, double delta) {
        this.apiv2.camera.set_direction_equatorial(alpha, delta);
    }

    @Override
    public void setCameraDirectionGalactic(double l, double b) {
        this.apiv2.camera.set_direction_galactic(l, b);
    }

    public void setCameraDirection(List<?> dir) {
        this.apiv2.camera.set_direction(dir);
    }

    public void setCameraUp(List<?> up, boolean immediate) {
        this.apiv2.camera.set_up(up, immediate);
    }

    @Override
    public void setCameraUp(double[] up, boolean immediate) {
        this.apiv2.camera.set_up(up, immediate);
    }

    @Override
    public double[] getCameraUp() {
        return this.apiv2.camera.get_up();
    }

    @Override
    public void setCameraUp(double[] up) {
        this.apiv2.camera.set_up(up);
    }

    public void setCameraUp(List<?> up) {
        this.apiv2.camera.set_up(up);
    }

    @Override
    public void setCameraOrientationQuaternion(double[] quaternion) {
        this.apiv2.camera.set_orientation_quaternion(quaternion);
    }

    public void setCameraOrientationQuaternion(List<?> quaternion) {
        this.apiv2.camera.set_orientation_quaternion(quaternion);
    }

    @Override
    public double[] getCameraOrientationQuaternion() {
        return this.apiv2.camera.get_orientation_quaternion();
    }

    @Override
    public void pointAtSkyCoordinate(double ra, double dec) {
        this.apiv2.camera.point_at_equatorial(ra, dec);
    }

    public void pointAtSkyCoordinate(long ra, long dec) {
        this.apiv2.camera.point_at_equatorial(ra, dec);
    }

    @Override
    public void setCameraPositionAndFocus(String focus, String other, double rotation, double solidAngle) {
        this.apiv2.camera.set_position_and_focus(focus, other, rotation, solidAngle);
    }

    public void setCameraPositionAndFocus(String focus, String other, long rotation, long solidAngle) {
        this.apiv2.camera.set_position_and_focus(focus, other, rotation, solidAngle);
    }

    @Override
    public double getCameraSpeed() {
        return this.apiv2.camera.interactive.get_speed();
    }

    @Override
    public void setCameraSpeed(float speed) {
        this.apiv2.camera.interactive.speed_setting(speed);
    }

    public void setCameraSpeed(int speed) {
        this.apiv2.camera.interactive.speed_setting(speed);
    }

    @Override
    public void setCameraRotationSpeed(float speed) {
        this.apiv2.camera.interactive.rotation_speed_setting(speed);
    }

    public void setCameraRotationSpeed(int speed) {
        this.apiv2.camera.interactive.rotation_speed_setting(speed);
    }

    @Override
    public void setRotationCameraSpeed(float speed) {
        this.apiv2.camera.interactive.rotation_speed_setting(speed);
    }

    public void setRotationCameraSpeed(int speed) {
        this.apiv2.camera.interactive.rotation_speed_setting(speed);
    }

    @Override
    public void setCameraTurningSpeed(float speed) {
        this.apiv2.camera.interactive.turning_speed_setting(speed);
    }

    public void setCameraTurningSpeed(int speed) {
        this.apiv2.camera.interactive.turning_speed_setting(speed);
    }

    @Override
    public void setTurningCameraSpeed(float speed) {
        this.apiv2.camera.interactive.turning_speed_setting(speed);
    }

    public void setTurningCameraSpeed(int speed) {
        this.apiv2.camera.interactive.turning_speed_setting(speed);
    }

    @Override
    public void setCameraSpeedLimit(int index) {
        this.apiv2.camera.set_max_speed(index);
    }

    @Override
    public void setCameraTrackingObject(String objectName) {
        this.apiv2.camera.set_tracking_object(objectName);
    }

    @Override
    public void removeCameraTrackingObject() {
        this.apiv2.camera.remove_tracking_object();
    }

    @Override
    public void setCameraOrientationLock(boolean lock) {
        this.apiv2.camera.set_orientation_lock(lock);
    }

    @Override
    public void cameraForward(double value) {
        this.apiv2.camera.interactive.add_forward(value);
    }

    public void cameraForward(long value) {
        this.apiv2.camera.interactive.add_forward(value);
    }

    @Override
    public void cameraRotate(double deltaX, double deltaY) {
        this.apiv2.camera.interactive.add_rotation(deltaX, deltaY);
    }

    public void cameraRotate(double deltaX, long deltaY) {
        this.apiv2.camera.interactive.add_rotation(deltaX, deltaY);
    }

    public void cameraRotate(long deltaX, double deltaY) {
        this.apiv2.camera.interactive.add_rotation(deltaX, deltaY);
    }

    @Override
    public void cameraRoll(double roll) {
        this.apiv2.camera.interactive.add_roll(roll);
    }

    public void cameraRoll(long roll) {
        this.apiv2.camera.interactive.add_roll(roll);
    }

    @Override
    public void cameraTurn(double deltaX, double deltaY) {
        this.apiv2.camera.interactive.add_turn(deltaX, deltaY);
    }

    public void cameraTurn(double deltaX, long deltaY) {
        this.apiv2.camera.interactive.add_turn(deltaX, deltaY);
    }

    public void cameraTurn(long deltaX, double deltaY) {
        this.apiv2.camera.interactive.add_turn(deltaX, deltaY);
    }

    public void cameraTurn(long deltaX, long deltaY) {
        this.apiv2.camera.interactive.add_turn(deltaX, deltaY);
    }

    @Override
    public void cameraYaw(double amount) {
        this.apiv2.camera.interactive.add_yaw(amount);
    }

    public void cameraYaw(long amount) {
        this.apiv2.camera.interactive.add_yaw(amount);
    }

    @Override
    public void cameraPitch(double amount) {
        this.apiv2.camera.interactive.add_pitch(amount);
    }

    public void cameraPitch(long amount) {
        this.apiv2.camera.interactive.add_pitch(amount);
    }

    @Override
    public void cameraStop() {
        this.apiv2.camera.stop();
    }

    @Override
    public void cameraCenter() {
        this.apiv2.camera.center();
    }

    @Override
    public IFocus getClosestObjectToCamera() {
        return this.apiv2.camera.get_closest_object();
    }

    @Override
    public void setFov(float newFov) {
        this.apiv2.camera.set_fov(newFov);
    }

    public void setFov(int newFov) {
        this.apiv2.camera.set_fov(newFov);
    }

    @Override
    public void setVisibility(String key, boolean visible) {
        this.apiv2.scene.set_component_type_visibility(key, visible);
    }

    @Override
    public void setComponentTypeVisibility(String key, boolean visible) {
        this.apiv2.scene.set_component_type_visibility(key, visible);
    }

    @Override
    public boolean getComponentTypeVisibility(String key) {
        return this.apiv2.scene.get_component_type_visibility(key);
    }

    @Override
    public double[] getObjectScreenCoordinates(String name) {
        return this.apiv2.scene.get_object_screen_coordinates(name);
    }

    @Override
    public boolean setObjectVisibility(String name, boolean visible) {
        return this.apiv2.scene.set_object_visibility(name, visible);
    }

    @Override
    public boolean getObjectVisibility(String name) {
        return this.apiv2.scene.get_object_visibility(name);
    }

    @Override
    public boolean setObjectQuaternionSlerpOrientation(String name, String file) {
        return this.apiv2.scene.set_object_quaternion_slerp_orientation(name, file);
    }

    @Override
    public boolean setObjectQuaternionNlerpOrientation(String name, String file) {
        return this.apiv2.scene.set_object_quaternion_nlerp_orientation(name, file);
    }

    @Override
    public void setLabelSizeFactor(float factor) {
        this.apiv2.scene.set_label_size_factor(factor);
    }

    public void setLabelSizeFactor(int factor) {
        this.apiv2.scene.set_label_size_factor(factor);
    }

    @Override
    public void setForceDisplayLabel(String name, boolean forceLabel) {
        this.apiv2.scene.set_force_display_label(name, forceLabel);
    }

    @Override
    public void setLabelColor(String name, double[] color) {
        this.apiv2.scene.set_label_color(name, color);
    }

    public void setLabelColor(String name, List<?> color) {
        this.apiv2.scene.set_label_color(name, color);
    }

    @Override
    public boolean getForceDisplayLabel(String name) {
        return this.apiv2.scene.get_force_dispaly_label(name);
    }

    @Override
    public void setLineWidthFactor(float factor) {
        this.apiv2.scene.set_line_width_factor(factor);
    }

    public void setLineWidthFactor(int factor) {
        this.apiv2.scene.set_line_width_factor(factor);
    }

    @Override
    public void setProperMotionsNumberFactor(float factor) {
        this.apiv2.scene.set_velocity_vectors_number_factor(factor);
    }

    public void setProperMotionsNumberFactor(int factor) {
        this.apiv2.scene.set_velocity_vectors_number_factor(factor);
    }

    public void setUnfilteredProperMotionsNumberFactor(float factor) {
        this.apiv2.scene.set_unfiltered_velocity_vectors_number_factor(factor);
    }

    @Override
    public void setProperMotionsColorMode(int mode) {
        this.apiv2.scene.set_velocity_vectors_color_mode(mode);
    }

    @Override
    public void setProperMotionsArrowheads(boolean arrowheadsEnabled) {
        this.apiv2.scene.set_velocity_vectors_arrowheads(arrowheadsEnabled);
    }

    @Override
    public void setProperMotionsLengthFactor(float factor) {
        this.apiv2.scene.set_velocity_vectors_length_factor(factor);
    }

    public void setProperMotionsLengthFactor(int factor) {
        this.apiv2.scene.set_velocity_vectors_length_factor(factor);
    }

    @Override
    public long getProperMotionsMaxNumber() {
        return this.apiv2.scene.get_velocity_vector_max_number();
    }

    @Override
    public void setProperMotionsMaxNumber(long maxNumber) {
        this.apiv2.scene.set_velocity_vector_max_number(maxNumber);
    }

    @Override
    public void setCrosshairVisibility(boolean visible) {
        this.apiv2.ui.set_crosshair_visibility(visible);
    }

    @Override
    public void setFocusCrosshairVisibility(boolean visible) {
        this.apiv2.ui.set_focus_crosshair_visibility(visible);
    }

    @Override
    public void setClosestCrosshairVisibility(boolean visible) {
        this.apiv2.ui.set_closest_crosshair_visibility(visible);
    }

    @Override
    public void setHomeCrosshairVisibility(boolean visible) {
        this.apiv2.ui.set_home_crosshair_visibility(visible);
    }

    @Override
    public void setMinimapVisibility(boolean visible) {
        this.apiv2.ui.set_minimap_visibility(visible);
    }

    @Override
    public void setAmbientLight(float value) {
        this.apiv2.graphics.set_ambient_light(value);
    }

    public void setAmbientLight(int value) {
        this.apiv2.graphics.set_ambient_light(value);
    }

    @Override
    public void setSimulationTime(int year, int month, int day, int hour, int min, int sec, int millisec) {
        this.apiv2.time.set_clock(year, month, day, hour, min, sec, millisec);
    }

    @Override
    public void setSimulationTime(long time) {
        this.apiv2.time.set_clock(time);
    }

    @Override
    public long getSimulationTime() {
        return this.apiv2.time.get_clock();
    }

    @Override
    public int[] getSimulationTimeArr() {
        return this.apiv2.time.get_clock_array();
    }

    @Override
    public void startSimulationTime() {
        this.apiv2.time.start_clock();
    }

    @Override
    public void stopSimulationTime() {
        this.apiv2.time.stop_clock();
    }

    @Override
    public boolean isSimulationTimeOn() {
        return this.apiv2.time.is_clock_on();
    }

    @Override
    public void setSimulationPace(double warp) {
        this.apiv2.time.set_time_warp(warp);
    }

    public void setSimulationPace(long warp) {
        this.apiv2.time.set_time_warp(warp);
    }

    @Override
    public void setTimeWarp(double warp) {
        this.apiv2.time.set_time_warp(warp);
    }

    public void setTimeWarp(long warp) {
        this.apiv2.time.set_time_warp(warp);
    }

    @Override
    public void setTargetTime(long ms) {
        this.apiv2.time.set_target_time(ms);
    }

    @Override
    public void setTargetTime(int year, int month, int day, int hour, int min, int sec, int millisec) {
        this.apiv2.time.set_target_time(year, month, day, hour, min, sec, millisec);
    }

    @Override
    public void unsetTargetTime() {
        this.apiv2.time.remove_target_time();
    }

    @Override
    public void setStarBrightnessPower(float power) {
        this.apiv2.graphics.set_star_brightness_power(power);
    }

    @Override
    public void setStarGlowFactor(float glowFactor) {
        this.apiv2.graphics.set_star_glow_factor(glowFactor);
    }

    @Override
    public float getStarBrightness() {
        return this.apiv2.graphics.get_star_brightness();
    }

    @Override
    public void setStarBrightness(float brightness) {
        this.apiv2.graphics.set_star_brightness(brightness);
    }

    public void setStarBrightness(int brightness) {
        this.apiv2.graphics.set_star_brightness(brightness);
    }

    @Override
    public float getPointSize() {
        return this.apiv2.graphics.get_point_size();
    }

    @Override
    public float getStarSize() {
        return this.apiv2.graphics.get_point_size();
    }

    @Override
    public void setPointSize(float size) {
        this.apiv2.graphics.set_point_size(size);
    }

    @Override
    public void setStarSize(float size) {
        this.apiv2.graphics.set_point_size(size);
    }

    public void setStarSize(int size) {
        this.apiv2.graphics.set_point_size(size);
    }

    @Override
    public float getStarBaseOpacity() {
        return this.apiv2.graphics.get_star_base_opacity();
    }

    @Override
    public float getStarMinOpacity() {
        return this.apiv2.graphics.get_star_base_opacity();
    }

    @Override
    public void setStarBaseOpacity(float opacity) {
        this.apiv2.graphics.set_star_base_opacity(opacity);
    }

    @Override
    public void setStarMinOpacity(float minOpacity) {
        this.apiv2.graphics.set_star_base_opacity(minOpacity);
    }

    public float getMinStarOpacity() {
        return this.apiv2.graphics.get_star_base_opacity();
    }

    public void setMinStarOpacity(float minOpacity) {
        this.apiv2.graphics.set_star_base_opacity(minOpacity);
    }

    public void setMinStarOpacity(int opacity) {
        this.apiv2.graphics.set_star_base_opacity(opacity);
    }

    @Override
    public void setStarTextureIndex(int index) {
        this.apiv2.graphics.set_star_texture_index(index);
    }

    @Override
    public void setStarGroupNearestNumber(int n) {
        this.apiv2.graphics.set_star_set_metadata_size(n);
    }

    @Override
    public void setStarGroupBillboard(boolean flag) {
        this.apiv2.graphics.set_star_set_billboard(flag);
    }

    @Override
    public void setOrbitSolidAngleThreshold(float angleDeg) {
        this.apiv2.graphics.set_orbit_solid_angle_threshold(angleDeg);
    }

    @Override
    public void setProjectionYaw(float yaw) {
        this.apiv2.instances.set_projection_yaw(yaw);
    }

    @Override
    public void setProjectionPitch(float pitch) {
        this.apiv2.instances.set_projection_pitch(pitch);
    }

    @Override
    public void setProjectionRoll(float roll) {
        this.apiv2.instances.set_projection_roll(roll);
    }

    @Override
    public void setProjectionFov(float fov) {
        this.apiv2.instances.set_projection_fov(fov);
    }

    @Override
    public void setLimitFps(double limitFps) {
        this.apiv2.graphics.set_limit_fps(limitFps);
    }

    @Override
    public void setLimitFps(int limitFps) {
        this.apiv2.graphics.set_limit_fps(limitFps);
    }

    @Override
    public void configureScreenshots(int width, int height, String directory, String namePrefix) {
        this.apiv2.output.configure_screenshots(width, height, directory, namePrefix);
    }

    @Override
    public void setScreenshotsMode(String mode) {
        this.apiv2.output.screenshot_mode(mode);
    }

    @Override
    public void saveScreenshot() {
        this.apiv2.output.screenshot();
    }

    @Override
    public void takeScreenshot() {
        this.apiv2.output.screenshot();
    }

    @Override
    public void configureFrameOutput(int width, int height, int fps, String directory, String namePrefix) {
        this.apiv2.output.configure_frame_output(width, height, fps, directory, namePrefix);
    }

    @Override
    public void configureFrameOutput(int width, int height, double fps, String directory, String namePrefix) {
        this.apiv2.output.configure_frame_output(width, height, fps, directory, namePrefix);
    }

    @Override
    public void configureRenderOutput(int width, int height, int fps, String directory, String namePrefix) {
        this.apiv2.output.configure_frame_output(width, height, fps, directory, namePrefix);
    }

    @Override
    public void setFrameOutputMode(String mode) {
        this.apiv2.output.frame_output_mode(mode);
    }

    @Override
    public boolean isFrameOutputActive() {
        return this.apiv2.output.is_frame_output_active();
    }

    @Override
    public boolean isRenderOutputActive() {
        return this.apiv2.output.is_frame_output_active();
    }

    @Override
    public double getFrameOutputFps() {
        return this.apiv2.output.get_frame_output_fps();
    }

    @Override
    public double getRenderOutputFps() {
        return this.apiv2.output.get_frame_output_fps();
    }

    @Override
    public void setFrameOutput(boolean active) {
        this.apiv2.output.frame_output(active);
    }

    @Override
    public FocusView getObject(String name) {
        return this.apiv2.scene.get_object(name);
    }

    @Override
    public FocusView getObject(String name, double timeOutSeconds) {
        return this.apiv2.scene.get_object(name, timeOutSeconds);
    }

    @Override
    public VertsView getLineObject(String name) {
        return this.apiv2.scene.get_line_object(name);
    }

    @Override
    public VertsView getLineObject(String name, double timeOutSeconds) {
        return this.apiv2.scene.get_line_object(name, timeOutSeconds);
    }

    public Entity getEntity(String name) {
        return this.apiv2.scene.get_entity(name);
    }

    public Entity getEntity(String name, double timeOutSeconds) {
        return this.apiv2.scene.get_entity(name, timeOutSeconds);
    }

    private Entity getFocus(String name) {
        return this.apiv2.scene.get_focus(name);
    }

    private Entity getFocusEntity(String name) {
        return this.apiv2.scene.get_focus_entity(name);
    }

    @Override
    public void setObjectSizeScaling(String name, double scalingFactor) {
        this.apiv2.scene.set_object_size_scaling(name, scalingFactor);
    }

    public void setObjectSizeScaling(Entity object, double scalingFactor) {
        this.apiv2.scene.set_object_size_scaling(object, scalingFactor);
    }

    @Override
    public void setOrbitCoordinatesScaling(String name, double scalingFactor) {
        this.apiv2.scene.set_orbit_coordinates_scaling(name, scalingFactor);
    }

    @Override
    public void refreshAllOrbits() {
        this.apiv2.scene.refresh_all_orbits();
    }

    @Override
    public void forceUpdateScene() {
        this.apiv2.scene.force_update_scene();
    }

    @Override
    public void refreshObjectOrbit(String name) {
        this.apiv2.scene.refresh_object_orbit(name);
    }

    @Override
    public double getObjectRadius(String name) {
        return this.apiv2.scene.get_object_radius(name);
    }

    @Override
    public void goToObject(String name) {
        this.apiv2.camera.interactive.go_to_object(name);
    }

    @Override
    public void goToObject(String name, double solidAngle) {
        this.apiv2.camera.interactive.go_to_object(name, solidAngle);
    }

    @Override
    public void goToObject(String name, double solidAngle, float waitTimeSeconds) {
        this.apiv2.camera.interactive.go_to_object(name, solidAngle, waitTimeSeconds);
    }

    public void goToObject(String name, double solidAngle, int waitTimeSeconds) {
        this.apiv2.camera.interactive.go_to_object(name, solidAngle, waitTimeSeconds);
    }

    public void goToObject(String name, long solidAngle, int waitTimeSeconds) {
        this.apiv2.camera.interactive.go_to_object(name, solidAngle, waitTimeSeconds);
    }

    public void goToObject(String name, long solidAngle, float waitTimeSeconds) {
        this.apiv2.camera.interactive.go_to_object(name, solidAngle, waitTimeSeconds);
    }

    public void goToObject(String name, double solidAngle, int waitTimeSeconds, AtomicBoolean stop) {
        this.apiv2.camera.interactive.go_to_object(name, solidAngle, waitTimeSeconds);
    }

    public void goToObject(Entity object, double solidAngle, int waitTimeSeconds, AtomicBoolean stop) {
        this.apiv2.camera.interactive.go_to_object(object, solidAngle, waitTimeSeconds, stop);
    }

    @Override
    public void goToObjectInstant(String name) {
        this.apiv2.camera.go_to_object_instant(name);
    }

    @Override
    public void goToObjectSmooth(String name, double positionDurationSeconds, double orientationDurationSeconds) {
        this.apiv2.camera.go_to_object(name, positionDurationSeconds, orientationDurationSeconds);
    }

    @Override
    public void goToObjectSmooth(String name, double solidAngle, double positionDurationSeconds, double orientationDurationSeconds) {
        this.apiv2.camera.go_to_object(name, solidAngle, positionDurationSeconds, orientationDurationSeconds);
    }

    @Override
    public void goToObjectSmooth(String name, double positionDurationSeconds, double orientationDurationSeconds, boolean sync) {
        this.apiv2.camera.go_to_object(name, positionDurationSeconds, orientationDurationSeconds, sync);
    }

    @Override
    public void goToObjectSmooth(String name, double solidAngle, double positionDurationSeconds, double orientationDurationSeconds, boolean sync) {
        this.apiv2.camera.go_to_object(name, solidAngle, positionDurationSeconds, orientationDurationSeconds, sync);
    }

    public void goToObjectSmooth(Entity object, double positionDurationSeconds, double orientationDurationSeconds, boolean sync) {
        this.apiv2.camera.go_to_object(object, positionDurationSeconds, orientationDurationSeconds, sync);
    }

    public void goToObjectSmooth(Entity object, double solidAngle, double positionDurationSeconds, double orientationDurationSeconds, boolean sync) {
        this.apiv2.camera.go_to_object(object, solidAngle, positionDurationSeconds, orientationDurationSeconds, sync);
    }

    public void goToObjectSmooth(Entity object, double solidAngle, double positionDurationSeconds, double orientationDurationSeconds, boolean sync, AtomicBoolean stop) {
        this.apiv2.camera.go_to_object(object, solidAngle, positionDurationSeconds, orientationDurationSeconds, sync, stop);
    }

    @Override
    public void landOnObject(String name) {
        this.apiv2.camera.interactive.land_on(name);
    }

    void landOnObject(Entity object, AtomicBoolean stop) {
        this.apiv2.camera.interactive.land_on(object, stop);
    }

    @Override
    public void landAtObjectLocation(String name, String locationName) {
        this.apiv2.camera.interactive.land_at_location(name, locationName);
    }

    public void landAtObjectLocation(String name, String locationName, AtomicBoolean stop) {
        this.apiv2.camera.interactive.land_at_location(name, locationName, stop);
    }

    public void landAtObjectLocation(Entity object, String locationName, AtomicBoolean stop) {
        this.apiv2.camera.interactive.land_at_location(object, locationName, stop);
    }

    @Override
    public void landAtObjectLocation(String name, double longitude, double latitude) {
        this.apiv2.camera.interactive.land_at_location(name, longitude, latitude);
    }

    public void landAtObjectLocation(Entity object, double longitude, double latitude, AtomicBoolean stop) {
        this.apiv2.camera.interactive.land_at_location(object, longitude, latitude, stop);
    }

    @Override
    public double getDistanceTo(String name) {
        return this.apiv2.camera.get_distance_to_object(name);
    }

    @Override
    public double[] getStarParameters(String id) {
        return this.apiv2.scene.get_star_parameters(id);
    }

    @Override
    public double[] getObjectPosition(String name) {
        return this.apiv2.scene.get_object_position(name);
    }

    @Override
    public double[] getObjectPosition(String name, String units) {
        return this.apiv2.scene.get_object_position(name, units);
    }

    @Override
    public double[] getObjectPredictedPosition(String name) {
        return this.apiv2.scene.get_object_predicted_position(name);
    }

    @Override
    public double[] getObjectPredictedPosition(String name, String units) {
        return this.apiv2.scene.get_object_predicted_position(name, units);
    }

    @Override
    public void setObjectPosition(String name, double[] position) {
        this.apiv2.scene.set_object_posiiton(name, position);
    }

    @Override
    public void setObjectPosition(String name, double[] position, String units) {
        this.apiv2.scene.set_object_posiiton(name, position, units);
    }

    public void setObjectPosition(String name, List<?> position) {
        this.apiv2.scene.set_object_posiiton(name, position);
    }

    public void setObjectPosition(String name, List<?> position, String units) {
        this.apiv2.scene.set_object_posiiton(name, position, units);
    }

    @Override
    public void setObjectPosition(FocusView object, double[] position) {
        this.apiv2.scene.set_object_posiiton(object, position);
    }

    @Override
    public void setObjectPosition(FocusView object, double[] position, String units) {
        this.apiv2.scene.set_object_posiiton(object, position, units);
    }

    public void setObjectPosition(FocusView object, List<?> position) {
        this.apiv2.scene.set_object_posiiton(object, position);
    }

    public void setObjectPosition(FocusView object, List<?> position, String units) {
        this.apiv2.scene.set_object_posiiton(object, position, units);
    }

    @Override
    public void setObjectPosition(Entity object, double[] position) {
        this.apiv2.scene.set_object_posiiton(object, position);
    }

    @Override
    public void setObjectPosition(Entity object, double[] position, String units) {
        this.apiv2.scene.set_object_posiiton(object, position, units);
    }

    @Override
    public void setObjectCoordinatesProvider(String name, IPythonCoordinatesProvider provider) {
        this.apiv2.scene.set_object_coordinates_provider(name, provider);
    }

    @Override
    public void removeObjectCoordinatesProvider(String name) {
        this.apiv2.scene.remove_object_coordinates_provider(name);
    }

    public void setObjectPosition(Entity object, List<?> position) {
        this.apiv2.scene.set_object_posiiton(object, position);
    }

    @Override
    public void setGuiScrollPosition(float pixelY) {
        this.postRunnable(() -> this.em.post(Event.GUI_SCROLL_POSITION_CMD, this, Float.valueOf(pixelY)));
    }

    public void setGuiScrollPosition(int pixelY) {
        this.setGuiScrollPosition((float)pixelY);
    }

    @Override
    public void enableGui() {
        this.apiv2.ui.enable();
    }

    @Override
    public void disableGui() {
        this.apiv2.ui.disable();
    }

    @Override
    public float getGuiScaleFactor() {
        return Settings.settings.program.ui.scale;
    }

    @Override
    public void displayMessageObject(int id, String message, float x, float y, float r, float g, float b, float a, float fontSize) {
        this.apiv2.ui.display_message(id, message, x, y, r, g, b, a, fontSize);
    }

    @Override
    public void displayMessageObject(int id, String message, double x, double y, double[] color, double fontSize) {
        this.apiv2.ui.display_message(id, message, x, y, color, fontSize);
    }

    public void displayMessageObject(int id, String message, double x, double y, List<?> color, double fontSize) {
        this.apiv2.ui.display_message(id, message, x, y, color, fontSize);
    }

    public void displayMessageObject(int id, String message, float x, float y, float r, float g, float b, float a, int fontSize) {
        this.apiv2.ui.display_message(id, message, x, y, r, g, b, a, fontSize);
    }

    @Override
    public void displayTextObject(int id, String text, float x, float y, float maxWidth, float maxHeight, float r, float g, float b, float a, float fontSize) {
        this.apiv2.ui.display_text(id, text, x, y, maxWidth, maxHeight, r, g, b, a, fontSize);
    }

    public void displayTextObject(int id, String text, float x, float y, float maxWidth, float maxHeight, float r, float g, float b, float a, int fontSize) {
        this.apiv2.ui.display_text(id, text, x, y, maxWidth, maxHeight, r, g, b, a, fontSize);
    }

    @Override
    public void displayImageObject(int id, String path, float x, float y, float r, float g, float b, float a) {
        this.apiv2.ui.display_image(id, path, x, y, r, g, b, a);
    }

    @Override
    public void displayImageObject(int id, String path, double x, double y, double[] color) {
        this.apiv2.ui.display_image(id, path, x, y, color);
    }

    public void displayImageObject(int id, String path, double x, double y, List<?> color) {
        this.apiv2.ui.display_image(id, path, x, y, color);
    }

    @Override
    public void displayImageObject(int id, String path, float x, float y) {
        this.apiv2.ui.display_image(id, path, x, y);
    }

    @Override
    public void removeAllObjects() {
        this.apiv2.ui.remove_all_objects();
    }

    @Override
    public void removeObject(int id) {
        this.apiv2.ui.remove_object(id);
    }

    @Override
    public void removeObjects(int[] ids) {
        this.apiv2.ui.remove_objects(ids);
    }

    public void removeObjects(List<?> ids) {
        this.apiv2.ui.remove_objects(ids);
    }

    @Override
    public void maximizeInterfaceWindow() {
        this.postRunnable(() -> this.em.post(Event.GUI_FOLD_CMD, this, false));
    }

    @Override
    public void minimizeInterfaceWindow() {
        this.postRunnable(() -> this.em.post(Event.GUI_FOLD_CMD, this, true));
    }

    @Override
    public void expandUIPane(String paneName) {
        this.apiv2.ui.expand_pane(paneName);
    }

    @Override
    public void collapseUIPane(String paneName) {
        this.apiv2.ui.collapse_pane(paneName);
    }

    @Override
    public void expandGuiComponent(String paneName) {
        this.apiv2.ui.expand_pane(paneName);
    }

    @Override
    public void collapseGuiComponent(String paneName) {
        this.apiv2.ui.collapse_pane(paneName);
    }

    @Override
    public void setGuiPosition(float x, float y) {
        this.postRunnable(() -> this.em.post(Event.GUI_MOVE_CMD, this, Float.valueOf(x), Float.valueOf(y)));
    }

    public void setGuiPosition(int x, int y) {
        this.setGuiPosition((float)x, (float)y);
    }

    public void setGuiPosition(float x, int y) {
        this.setGuiPosition(x, (float)y);
    }

    public void setGuiPosition(int x, float y) {
        this.setGuiPosition((float)x, y);
    }

    @Override
    public void waitForInput() {
        this.apiv2.input.wait_input();
    }

    @Override
    public void waitForEnter() {
        this.apiv2.input.wait_enter();
    }

    @Override
    public void waitForInput(int keyCode) {
        this.apiv2.input.wait_input(keyCode);
    }

    @Override
    public int getScreenWidth() {
        return this.apiv2.ui.get_client_width();
    }

    @Override
    public int getScreenHeight() {
        return this.apiv2.ui.get_client_height();
    }

    @Override
    public float[] getPositionAndSizeGui(String name) {
        return this.apiv2.ui.get_position_and_size(name);
    }

    @Override
    public String getVersion() {
        return this.apiv2.base.get_version();
    }

    @Override
    public String getVersionNumber() {
        return Settings.settings.version.version;
    }

    @Override
    public String getBuildString() {
        return this.apiv2.base.get_build_string();
    }

    @Override
    public boolean waitFocus(String name, long timeoutMs) {
        return this.apiv2.camera.wait_focus(name, timeoutMs);
    }

    @Override
    public void setCamcorderFps(double targetFps) {
        this.apiv2.camcorder.set_fps(targetFps);
    }

    @Override
    public void setCameraRecorderFps(double targetFps) {
        this.apiv2.camcorder.set_fps(targetFps);
    }

    @Override
    public double getCamcorderFps() {
        return this.apiv2.camcorder.get_fps();
    }

    @Override
    public String getAssetsLocation() {
        return this.apiv2.base.get_assets_dir();
    }

    @Override
    public void preloadTexture(String path) {
        this.apiv2.ui.preload_texture(path);
    }

    @Override
    public void preloadTextures(String[] paths) {
        this.apiv2.ui.preload_textures(paths);
    }

    @Override
    public void startRecordingCameraPath() {
        this.apiv2.camcorder.start();
    }

    @Override
    public void startRecordingCameraPath(String fileName) {
        this.apiv2.camcorder.start();
    }

    @Override
    public void stopRecordingCameraPath() {
        this.apiv2.camcorder.stop();
    }

    @Override
    public void playCameraPath(String file, boolean sync) {
        this.apiv2.camcorder.play(file, sync);
    }

    @Override
    public void runCameraPath(String file, boolean sync) {
        this.apiv2.camcorder.play(file, sync);
    }

    @Override
    public void playCameraPath(String file) {
        this.apiv2.camcorder.play(file);
    }

    @Override
    public void runCameraPath(String file) {
        this.apiv2.camcorder.play(file);
    }

    @Override
    public void runCameraRecording(String file) {
        this.apiv2.camcorder.play(file);
    }

    @Override
    public void cameraTransitionKm(double[] camPos, double[] camDir, double[] camUp, double seconds) {
        this.apiv2.camera.transition_km(camPos, camDir, camUp, seconds);
    }

    public void cameraTransitionKm(List<?> camPos, List<?> camDir, List<?> camUp, double seconds) {
        this.apiv2.camera.transition_km(camPos, camDir, camUp, seconds);
    }

    public void cameraTransitionKm(List<?> camPos, List<?> camDir, List<?> camUp, long seconds) {
        this.apiv2.camera.transition_km(camPos, camDir, camUp, seconds);
    }

    @Override
    public void cameraTransition(double[] camPos, double[] camDir, double[] camUp, double seconds) {
        this.apiv2.camera.transition(camPos, camDir, camUp, seconds);
    }

    @Override
    public void cameraTransition(double[] camPos, String units, double[] camDir, double[] camUp, double seconds) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, seconds);
    }

    public void cameraTransition(double[] camPos, double[] camDir, double[] camUp, long seconds) {
        this.apiv2.camera.transition(camPos, camDir, camUp, seconds);
    }

    public void cameraTransition(double[] camPos, String units, double[] camDir, double[] camUp, long seconds) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, seconds);
    }

    public void cameraTransition(List<?> camPos, List<?> camDir, List<?> camUp, double seconds) {
        this.apiv2.camera.transition(camPos, camDir, camUp, seconds);
    }

    public void cameraTransition(List<?> camPos, String units, List<?> camDir, List<?> camUp, double seconds) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, seconds);
    }

    public void cameraTransition(List<?> camPos, List<?> camDir, List<?> camUp, long seconds) {
        this.apiv2.camera.transition(camPos, camDir, camUp, seconds);
    }

    public void cameraTransition(List<?> camPos, String units, List<?> camDir, List<?> camUp, long seconds) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, seconds);
    }

    @Override
    public void cameraTransition(double[] camPos, double[] camDir, double[] camUp, double seconds, boolean sync) {
        this.apiv2.camera.transition(camPos, camDir, camUp, seconds, sync);
    }

    @Override
    public void cameraTransition(double[] camPos, String units, double[] camDir, double[] camUp, double seconds, boolean sync) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, seconds, sync);
    }

    public void cameraTransition(List<?> camPos, List<?> camDir, List<?> camUp, double seconds, String positionSmoothType, double positionSmoothFactor, String orientationSmoothType, double orientationSmoothFactor) {
        this.apiv2.camera.transition(camPos, camDir, camUp, seconds, positionSmoothType, positionSmoothFactor, orientationSmoothType, orientationSmoothFactor);
    }

    @Override
    public void cameraTransition(double[] camPos, double[] camDir, double[] camUp, double positionDurationSeconds, String positionSmoothType, double positionSmoothFactor, double orientationDurationSeconds, String orientationSmoothType, double orientationSmoothFactor) {
        this.apiv2.camera.transition(camPos, camDir, camUp, positionDurationSeconds, positionSmoothType, positionSmoothFactor, orientationDurationSeconds, orientationSmoothType, orientationSmoothFactor);
    }

    public void cameraTransition(List<?> camPos, String units, List<?> camDir, List<?> camUp, double positionDurationSeconds, String positionSmoothType, double positionSmoothFactor, double orientationDurationSeconds, String orientationSmoothType, double orientationSmoothFactor, boolean sync) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, positionDurationSeconds, positionSmoothType, positionSmoothFactor, orientationDurationSeconds, orientationSmoothType, orientationSmoothFactor, sync);
    }

    @Override
    public void cameraTransition(double[] camPos, String units, double[] camDir, double[] camUp, double positionDurationSeconds, String positionSmoothType, double positionSmoothFactor, double orientationDurationSeconds, String orientationSmoothType, double orientationSmoothFactor, boolean sync) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, positionDurationSeconds, positionSmoothType, positionSmoothFactor, orientationDurationSeconds, orientationSmoothType, orientationSmoothFactor, sync);
    }

    public void cameraTransition(double[] camPos, String units, double[] camDir, double[] camUp, double positionDurationSeconds, String positionSmoothType, double positionSmoothFactor, double orientationDurationSeconds, String orientationSmoothType, double orientationSmoothFactor, boolean sync, AtomicBoolean stop) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, positionDurationSeconds, positionSmoothType, positionSmoothFactor, orientationDurationSeconds, orientationSmoothType, orientationSmoothFactor, sync, stop);
    }

    @Override
    public void cameraPositionTransition(double[] camPos, String units, double durationSeconds, String smoothType, double smoothFactor, boolean sync) {
        this.apiv2.camera.transition_position(camPos, units, durationSeconds, smoothType, smoothFactor, sync);
    }

    public void cameraPositionTransition(double[] camPos, String units, double durationSeconds, String smoothType, double smoothFactor, boolean sync, AtomicBoolean stop) {
        this.apiv2.camera.transition_position(camPos, units, durationSeconds, smoothType, smoothFactor, sync, stop);
    }

    @Override
    public void cameraOrientationTransition(double[] camDir, double[] camUp, double durationSeconds, String smoothType, double smoothFactor, boolean sync) {
        this.apiv2.camera.transition_orientation(camDir, camUp, durationSeconds, smoothType, smoothFactor, sync);
    }

    public void cameraOrientationTransition(double[] camDir, double[] camUp, double durationSeconds, String smoothType, double smoothFactor, boolean sync, AtomicBoolean stop) {
        this.apiv2.camera.transition_orientation(camDir, camUp, durationSeconds, smoothType, smoothFactor, sync, stop);
    }

    public void cameraTransition(List<?> camPos, List<?> camDir, List<?> camUp, double seconds, boolean sync) {
        this.apiv2.camera.transition(camPos, camDir, camUp, seconds, sync);
    }

    public void cameraTransition(List<?> camPos, String units, List<?> camDir, List<?> camUp, double seconds, boolean sync) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, seconds, sync);
    }

    public void cameraTransition(List<?> camPos, List<?> camDir, List<?> camUp, long seconds, boolean sync) {
        this.apiv2.camera.transition(camPos, camDir, camUp, seconds, sync);
    }

    public void cameraTransition(List<?> camPos, String units, List<?> camDir, List<?> camUp, long seconds, boolean sync) {
        this.apiv2.camera.transition(camPos, units, camDir, camUp, seconds, sync);
    }

    public void cameraOrientationTransition(List<?> camDir, List<?> camUp, double durationSeconds, String smoothType, double smoothFactor, boolean sync) {
        this.apiv2.camera.transition_orientation(camDir, camUp, durationSeconds, smoothType, smoothFactor, sync);
    }

    public void cameraPositionTransition(List<?> camPos, String units, double durationSeconds, String smoothType, double smoothFactor, boolean sync) {
        this.apiv2.camera.transition_position(camPos, units, durationSeconds, smoothType, smoothFactor, sync);
    }

    @Override
    public void timeTransition(int year, int month, int day, int hour, int min, int sec, int milliseconds, double durationSeconds, String smoothType, double smoothFactor, boolean sync) {
        this.apiv2.time.transition(year, month, day, hour, min, sec, milliseconds, durationSeconds, smoothType, smoothFactor, sync);
    }

    public void timeTransition(int year, int month, int day, int hour, int min, int sec, int milliseconds, double durationSeconds, String smoothType, double smoothFactor, boolean sync, AtomicBoolean stop) {
        this.apiv2.time.transition(year, month, day, hour, min, sec, milliseconds, durationSeconds, smoothType, smoothFactor, sync, stop);
    }

    @Override
    public void sleep(float seconds) {
        this.apiv2.base.sleep(seconds);
    }

    public void sleep(int seconds) {
        this.apiv2.base.sleep(seconds);
    }

    @Override
    public void sleepFrames(long frames) {
        this.apiv2.base.sleep_frames(frames);
    }

    @Override
    public double[] galacticToInternalCartesian(double l, double b, double r) {
        return this.apiv2.refsys.galactic_to_cartesian(l, b, r);
    }

    public double[] galacticToInternalCartesian(int l, int b, int r) {
        return this.apiv2.refsys.galactic_to_cartesian(l, b, r);
    }

    @Override
    public double[] eclipticToInternalCartesian(double l, double b, double r) {
        return this.apiv2.refsys.ecliptic_to_cartesian(l, b, r);
    }

    public double[] eclipticToInternalCartesian(int l, int b, int r) {
        return this.apiv2.refsys.ecliptic_to_cartesian(l, b, r);
    }

    @Override
    public double[] equatorialToInternalCartesian(double ra, double dec, double r) {
        return this.apiv2.refsys.equatorial_to_cartesian(ra, dec, r);
    }

    public double[] equatorialToInternalCartesian(int ra, int dec, int r) {
        return this.apiv2.refsys.equatorial_to_cartesian(ra, dec, r);
    }

    @Override
    public double[] internalCartesianToEquatorial(double x, double y, double z) {
        return this.apiv2.refsys.cartesian_to_equatorial(x, y, z);
    }

    public double[] internalCartesianToEquatorial(int x, int y, int z) {
        return this.apiv2.refsys.cartesian_to_equatorial(x, y, z);
    }

    @Override
    public double[] equatorialCartesianToInternalCartesian(double[] eq, double kmFactor) {
        return this.apiv2.refsys.equatorial_cartesian_to_internal(eq, kmFactor);
    }

    public double[] equatorialCartesianToInternalCartesian(List<?> eq, double kmFactor) {
        return this.apiv2.refsys.equatorial_cartesian_to_internal(eq, kmFactor);
    }

    @Override
    public double[] equatorialToGalactic(double[] eq) {
        return this.apiv2.refsys.equatorial_to_galactic(eq);
    }

    public double[] equatorialToGalactic(List<?> eq) {
        return this.apiv2.refsys.equatorial_to_galactic(eq);
    }

    @Override
    public double[] equatorialToEcliptic(double[] eq) {
        return this.apiv2.refsys.equatorial_to_ecliptic(eq);
    }

    public double[] equatorialToEcliptic(List<?> eq) {
        return this.apiv2.refsys.equatorial_to_ecliptic(eq);
    }

    @Override
    public double[] galacticToEquatorial(double[] gal) {
        return this.apiv2.refsys.galactic_to_equatorial(gal);
    }

    public double[] galacticToEquatorial(List<?> gal) {
        return this.apiv2.refsys.galactic_to_equatorial(gal);
    }

    @Override
    public double[] eclipticToEquatorial(double[] ecl) {
        return this.apiv2.refsys.ecliptic_to_equatorial(ecl);
    }

    public double[] eclipticToEquatorial(List<?> ecl) {
        return this.apiv2.refsys.ecliptic_to_equatorial(ecl);
    }

    @Override
    public void setBrightnessLevel(double level) {
        this.apiv2.graphics.set_image_brightness(level);
    }

    public void setBrightnessLevel(long level) {
        this.apiv2.graphics.set_image_brightness(level);
    }

    @Override
    public void setContrastLevel(double level) {
        this.apiv2.graphics.set_image_contrast(level);
    }

    public void setContrastLevel(long level) {
        this.apiv2.graphics.set_image_contrast(level);
    }

    @Override
    public void setHueLevel(double level) {
        this.apiv2.graphics.set_image_hue(level);
    }

    public void setHueLevel(long level) {
        this.apiv2.graphics.set_image_hue(level);
    }

    @Override
    public void setSaturationLevel(double level) {
        this.apiv2.graphics.set_image_saturation(level);
    }

    public void setSaturationLevel(long level) {
        this.apiv2.graphics.set_image_saturation(level);
    }

    @Override
    public void setGammaCorrectionLevel(double level) {
        this.apiv2.graphics.set_gamma_correction(level);
    }

    public void setGammaCorrectionLevel(long level) {
        this.apiv2.graphics.set_gamma_correction(level);
    }

    @Override
    public void setHDRToneMappingType(String type) {
        this.apiv2.graphics.set_hdr_tone_mapping(type);
    }

    @Override
    public void setExposureToneMappingLevel(double level) {
        this.apiv2.graphics.set_exposure_tone_mapping(level);
    }

    public void setExposureToneMappingLevel(long level) {
        this.apiv2.graphics.set_exposure_tone_mapping(level);
    }

    @Override
    public void setCubemapMode(boolean state, String projection) {
        this.apiv2.graphics.mode_cubemap(state, projection);
    }

    @Override
    public void setPanoramaMode(boolean state) {
        this.apiv2.graphics.mode_panorama(state);
    }

    @Override
    public void setReprojectionMode(String mode) {
        this.apiv2.graphics.mode_reprojection(mode);
    }

    @Override
    public void setBackBufferScale(float scale) {
        this.apiv2.graphics.set_back_buffer_scale(scale);
    }

    @Override
    public void setIndexOfRefraction(float ior) {
        this.apiv2.graphics.set_index_of_refraction(ior);
    }

    @Override
    public void setPlanetariumMode(boolean state) {
        this.apiv2.graphics.mode_planetarium(state);
    }

    @Override
    public void setCubemapResolution(int resolution) {
        this.apiv2.graphics.set_cubemap_resolution(resolution);
    }

    @Override
    public void setCubemapProjection(String projection) {
        this.apiv2.graphics.set_cubemap_projection(projection);
    }

    @Override
    public void setOrthosphereViewMode(boolean state) {
        this.apiv2.graphics.mode_orthosphere(state);
    }

    @Override
    public void setStereoscopicMode(boolean state) {
        this.apiv2.graphics.mode_stereoscopic(state);
    }

    @Override
    public void setStereoscopicProfile(int index) {
        this.apiv2.graphics.set_stereo_profile(index);
    }

    @Override
    public long getCurrentFrameNumber() {
        return this.apiv2.graphics.get_current_frame_number();
    }

    @Override
    public void setLensFlare(boolean state) {
        this.apiv2.graphics.effect_lens_flare(state);
    }

    @Override
    public void setLensFlare(double strength) {
        this.apiv2.graphics.effect_lens_flare(strength);
    }

    @Override
    public void setMotionBlur(boolean active) {
        this.apiv2.graphics.effect_motion_blur(active);
    }

    @Override
    public void setMotionBlur(double value) {
        this.apiv2.graphics.effect_motion_blur(value);
    }

    @Override
    public void setStarGlow(boolean state) {
        this.apiv2.graphics.effect_star_glow(state);
    }

    @Override
    public void setStarGlowOverObjects(boolean state) {
        this.apiv2.graphics.effect_star_glow(state);
    }

    @Override
    public void setBloom(float value) {
        this.apiv2.graphics.effect_bloom(value);
    }

    @Override
    public void setChromaticAberration(float value) {
        this.apiv2.graphics.effect_chromatic_aberration(value);
    }

    public void setBloom(int level) {
        this.apiv2.graphics.effect_bloom(level);
    }

    @Override
    public void setSmoothLodTransitions(boolean value) {
        this.apiv2.graphics.set_smooth_lod_transitions(value);
    }

    @Override
    public double[] rotate3(double[] vector, double[] axis, double angle) {
        return this.apiv2.geom.rotate3(vector, axis, angle);
    }

    public double[] rotate3(double[] vector, double[] axis, long angle) {
        return this.apiv2.geom.rotate3(vector, axis, angle);
    }

    public double[] rotate3(List<?> vector, List<?> axis, double angle) {
        return this.apiv2.geom.rotate3(vector, axis, angle);
    }

    public double[] rotate3(List<?> vector, List<?> axis, long angle) {
        return this.apiv2.geom.rotate3(vector, axis, angle);
    }

    @Override
    public double[] rotate2(double[] vector, double angle) {
        return this.apiv2.geom.rotate2(vector, angle);
    }

    public double[] rotate2(double[] vector, long angle) {
        return this.apiv2.geom.rotate2(vector, angle);
    }

    public double[] rotate2(List<?> vector, double angle) {
        return this.apiv2.geom.rotate2(vector, angle);
    }

    public double[] rotate2(List<?> vector, long angle) {
        return this.apiv2.geom.rotate2(vector, angle);
    }

    @Override
    public double[] cross3(double[] vec1, double[] vec2) {
        return this.apiv2.geom.cross3(vec1, vec2);
    }

    public double[] cross3(List<?> vec1, List<?> vec2) {
        return this.apiv2.geom.cross3(vec1, vec2);
    }

    @Override
    public double dot3(double[] vec1, double[] vec2) {
        return this.apiv2.geom.dot3(vec1, vec2);
    }

    public double dot3(List<?> vec1, List<?> vec2) {
        return this.apiv2.geom.dot3(vec1, vec2);
    }

    @Override
    public void addTrajectoryLine(String name, double[] points, double[] color) {
        this.apiv2.scene.add_trajectory_line(name, points, color);
    }

    public void addTrajectoryLine(String name, List<?> points, List<?> color) {
        this.apiv2.scene.add_trajectory_line(name, points, color);
    }

    @Override
    public void addTrajectoryLine(String name, double[] points, double[] color, double trailMap) {
        this.apiv2.scene.add_trajectory_line(name, points, color, trailMap);
    }

    public void addTrajectoryLine(String name, List<?> points, List<?> color, double trailMap) {
        this.apiv2.scene.add_trajectory_line(name, points, color, trailMap);
    }

    @Override
    public void addPolyline(String name, double[] points, double[] color) {
        this.apiv2.scene.add_polyline(name, points, color);
    }

    public void addPolyline(String name, List<?> points, List<?> color) {
        this.apiv2.scene.add_polyline(name, points, color);
    }

    @Override
    public void addPolyline(String name, double[] points, double[] color, double lineWidth) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth);
    }

    @Override
    public void addPolyline(String name, double[] points, double[] color, double lineWidth, boolean arrowCaps) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, arrowCaps);
    }

    @Override
    public void addPolyline(String name, double[] points, double[] color, double lineWidth, int primitive) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, primitive);
    }

    @Override
    public void addPolyline(String name, double[] points, double[] color, double lineWidth, int primitive, boolean arrowCaps) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, primitive, arrowCaps);
    }

    public void addPolyline(String name, double[] points, double[] color, int lineWidth) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth);
    }

    public void addPolyline(String name, double[] points, double[] color, int lineWidth, int primitive) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, primitive);
    }

    public void addPolyline(String name, List<?> points, List<?> color, float lineWidth) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth);
    }

    public void addPolyline(String name, List<?> points, List<?> color, float lineWidth, boolean arrowCaps) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, arrowCaps);
    }

    public void addPolyline(String name, List<?> points, List<?> color, float lineWidth, int primitive) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, primitive);
    }

    public void addPolyline(String name, List<?> points, List<?> color, float lineWidth, int primitive, boolean arrowCaps) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, primitive, arrowCaps);
    }

    public void addPolyline(String name, List<?> points, List<?> color, int lineWidth) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth);
    }

    public void addPolyline(String name, List<?> points, List<?> color, int lineWidth, boolean arrowCaps) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, arrowCaps);
    }

    public void addPolyline(String name, List<?> points, List<?> color, int lineWidth, int primitive) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, primitive);
    }

    public void addPolyline(String name, List<?> points, List<?> color, int lineWidth, int primitive, boolean arrowCaps) {
        this.apiv2.scene.add_polyline(name, points, color, lineWidth, primitive, arrowCaps);
    }

    @Override
    public void removeModelObject(String name) {
        this.apiv2.scene.remove_object(name);
    }

    @Override
    public void postRunnable(Runnable runnable) {
        this.apiv2.base.post_runnable(runnable);
    }

    @Override
    public void parkRunnable(String id, Runnable runnable) {
        this.apiv2.base.park_runnable(id, runnable);
    }

    @Override
    public void parkSceneRunnable(String id, Runnable runnable) {
        this.apiv2.base.park_scene_runnable(id, runnable);
    }

    @Override
    public void parkCameraRunnable(String id, Runnable runnable) {
        this.apiv2.base.park_camera_runnable(id, runnable);
    }

    @Override
    public void removeRunnable(String id) {
        this.apiv2.base.remove_runnable(id);
    }

    @Override
    public void unparkRunnable(String id) {
        this.apiv2.base.remove_runnable(id);
    }

    @Override
    public void setCameraState(double[] pos, double[] dir, double[] up) {
        this.apiv2.camera.set_state(pos, dir, up);
    }

    public void setCameraState(List<?> pos, List<?> dir, List<?> up) {
        this.apiv2.camera.set_state(pos, dir, up);
    }

    @Override
    public void setCameraStateAndTime(double[] pos, double[] dir, double[] up, long time) {
        this.apiv2.camera.set_state_and_time(pos, dir, up, time);
    }

    public void setCameraStateAndTime(List<?> pos, List<?> dir, List<?> up, long time) {
        this.apiv2.camera.set_state_and_time(pos, dir, up, time);
    }

    @Override
    public void resetImageSequenceNumber() {
        this.apiv2.output.reset_frame_output_sequence_number();
    }

    @Override
    public boolean loadDataset(String dsName, String absolutePath) {
        return this.apiv2.data.load_dataset(dsName, absolutePath);
    }

    @Override
    public boolean loadDataset(String dsName, String path, boolean sync) {
        return this.apiv2.data.load_dataset(dsName, path, sync);
    }

    public boolean loadDataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, boolean sync) {
        return this.apiv2.data.load_dataset(dsName, path, type, sync);
    }

    @Override
    public boolean loadDataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, DatasetOptions datasetOptions, boolean sync) {
        return this.apiv2.data.load_dataset(dsName, path, type, datasetOptions, sync);
    }

    public boolean loadDataset(String dsName, DataSource ds, CatalogInfo.CatalogInfoSource type, DatasetOptions datasetOptions, boolean sync) {
        return this.apiv2.data.load_dataset(dsName, ds, type, datasetOptions, sync);
    }

    @Override
    public boolean loadStarDataset(String dsName, String path, boolean sync) {
        return this.apiv2.data.load_star_dataset(dsName, path, sync);
    }

    @Override
    public boolean loadStarDataset(String dsName, String path, double magnitudeScale, boolean sync) {
        return this.apiv2.data.load_star_dataset(dsName, path, magnitudeScale, sync);
    }

    @Override
    public boolean loadStarDataset(String dsName, String path, double magnitudeScale, double[] labelColor, boolean sync) {
        return this.apiv2.data.load_star_dataset(dsName, path, magnitudeScale, labelColor, sync);
    }

    public boolean loadStarDataset(String dsName, String path, double magnitudeScale, List<?> labelColor, boolean sync) {
        return this.apiv2.data.load_star_dataset(dsName, path, magnitudeScale, labelColor, sync);
    }

    @Override
    public boolean loadStarDataset(String dsName, String path, double magnitudeScale, double[] labelColor, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_star_dataset(dsName, path, magnitudeScale, labelColor, fadeIn, fadeOut, sync);
    }

    public boolean loadStarDataset(String dsName, String path, double magnitudeScale, List<?> labelColor, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.apiv2.data.load_star_dataset(dsName, path, magnitudeScale, labelColor, fadeIn, fadeOut, sync);
    }

    public boolean loadStarDataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, double magnitudeScale, double[] labelColor, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_star_dataset(dsName, path, type, magnitudeScale, labelColor, fadeIn, fadeOut, sync);
    }

    @Override
    public boolean loadParticleDataset(String dsName, String path, double profileDecay, double[] particleColor, double colorNoise, double[] labelColor, double particleSize, String ct, boolean sync) {
        return this.apiv2.data.load_particle_dataset(dsName, path, profileDecay, particleColor, colorNoise, labelColor, particleSize, ct, sync);
    }

    public boolean loadParticleDataset(String dsName, String path, double profileDecay, List<?> particleColor, double colorNoise, List<?> labelColor, double particleSize, String ct, boolean sync) {
        return this.apiv2.data.load_particle_dataset(dsName, path, profileDecay, particleColor, colorNoise, labelColor, particleSize, ct, sync);
    }

    @Override
    public boolean loadParticleDataset(String dsName, String path, double profileDecay, double[] particleColor, double colorNoise, double[] labelColor, double particleSize, String ct, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_particle_dataset(dsName, path, profileDecay, particleColor, colorNoise, labelColor, particleSize, ct, fadeIn, fadeOut, sync);
    }

    public boolean loadParticleDataset(String dsName, String path, double profileDecay, List<?> particleColor, double colorNoise, List<?> labelColor, double particleSize, String ct, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.apiv2.data.load_particle_dataset(dsName, path, profileDecay, particleColor, colorNoise, labelColor, particleSize, ct, fadeIn, fadeOut, sync);
    }

    @Override
    public boolean loadParticleDataset(String dsName, String path, double profileDecay, double[] particleColor, double colorNoise, double[] labelColor, double particleSize, double[] sizeLimits, String ct, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_particle_dataset(dsName, path, profileDecay, particleColor, colorNoise, labelColor, particleSize, sizeLimits, ct, fadeIn, fadeOut, sync);
    }

    public boolean loadParticleDataset(String dsName, String path, double profileDecay, List<?> particleColor, double colorNoise, List<?> labelColor, double particleSize, List<?> sizeLimits, String ct, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.apiv2.data.load_particle_dataset(dsName, path, profileDecay, particleColor, colorNoise, labelColor, particleSize, sizeLimits, ct, fadeIn, fadeOut, sync);
    }

    public boolean loadParticleDataset(String dsName, String path, double profileDecay, double[] particleColor, double colorNoise, double[] labelColor, double particleSize, double[] sizeLimits, ComponentTypes.ComponentType ct, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_particle_dataset(dsName, path, profileDecay, particleColor, colorNoise, labelColor, particleSize, sizeLimits, ct, fadeIn, fadeOut, sync);
    }

    public boolean loadParticleDataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, double profileDecay, double[] particleColor, double colorNoise, double[] labelColor, double particleSize, double[] sizeLimits, ComponentTypes.ComponentType ct, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_particle_dataset(dsName, path, type, profileDecay, particleColor, colorNoise, labelColor, particleSize, sizeLimits, ct, fadeIn, fadeOut, sync);
    }

    @Override
    public boolean loadStarClusterDataset(String dsName, String path, double[] particleColor, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_star_cluster_dataset(dsName, path, particleColor, fadeIn, fadeOut, sync);
    }

    public boolean loadStarClusterDataset(String dsName, String path, List<?> particleColor, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.apiv2.data.load_star_cluster_dataset(dsName, path, particleColor, fadeIn, fadeOut, sync);
    }

    @Override
    public boolean loadStarClusterDataset(String dsName, String path, double[] particleColor, double[] labelColor, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_star_cluster_dataset(dsName, path, particleColor, labelColor, fadeIn, fadeOut, sync);
    }

    public boolean loadStarClusterDataset(String dsName, String path, List<?> particleColor, List<?> labelColor, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.apiv2.data.load_star_cluster_dataset(dsName, path, particleColor, fadeIn, fadeOut, sync);
    }

    @Override
    public boolean loadStarClusterDataset(String dsName, String path, double[] particleColor, String ct, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_star_cluster_dataset(dsName, path, particleColor, ct, fadeIn, fadeOut, sync);
    }

    public boolean loadStarClusterDataset(String dsName, String path, List<?> particleColor, String ct, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.apiv2.data.load_star_cluster_dataset(dsName, path, particleColor, ct, fadeIn, fadeOut, sync);
    }

    @Override
    public boolean loadStarClusterDataset(String dsName, String path, double[] particleColor, double[] labelColor, String ct, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_star_cluster_dataset(dsName, path, particleColor, labelColor, ct, fadeIn, fadeOut, sync);
    }

    @Override
    public boolean loadVariableStarDataset(String dsName, String path, double magnitudeScale, double[] labelColor, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_variable_star_dataset(dsName, path, magnitudeScale, labelColor, fadeIn, fadeOut, sync);
    }

    public boolean loadVariableStarDataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, double magnitudeScale, double[] labelColor, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.apiv2.data.load_variable_star_dataset(dsName, path, type, magnitudeScale, labelColor, fadeIn, fadeOut, sync);
    }

    public boolean loadStarClusterDataset(String dsName, String path, List<?> particleColor, List<?> labelColor, String ct, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.apiv2.data.load_star_cluster_dataset(dsName, path, particleColor, labelColor, ct, fadeIn, fadeOut, sync);
    }

    @Override
    public boolean loadJsonCatalog(String dsName, String path) {
        return this.apiv2.data.load_json_dataset(dsName, path);
    }

    @Override
    public boolean loadJsonDataset(String dsName, String path) {
        return this.apiv2.data.load_json_dataset(dsName, path);
    }

    @Override
    public boolean loadJsonDataset(String dsName, String pathString, boolean sync) {
        return this.apiv2.data.load_json_dataset(dsName, pathString, sync);
    }

    @Override
    public boolean loadJsonDataset(String dsName, String pathString, boolean select, boolean sync) {
        return this.apiv2.data.load_json_dataset(dsName, pathString, select, sync);
    }

    @Override
    public boolean hasDataset(String dsName) {
        return this.apiv2.data.dataset_exists(dsName);
    }

    @Override
    public boolean setDatasetTransformationMatrix(String dsName, double[] matrix) {
        return this.apiv2.data.set_dataset_transform_matrix(dsName, matrix);
    }

    @Override
    public boolean clearDatasetTransformationMatrix(String dsName) {
        return this.apiv2.data.clear_dataset_transform_matrix(dsName);
    }

    @Override
    public boolean removeDataset(String dsName) {
        return this.apiv2.data.remove_dataset(dsName);
    }

    @Override
    public boolean hideDataset(String dsName) {
        return this.apiv2.data.hide_dataset(dsName);
    }

    @Override
    public boolean showDataset(String dsName) {
        return this.apiv2.data.show_dataset(dsName);
    }

    @Override
    public boolean highlightDataset(String dsName, boolean highlight) {
        return this.apiv2.data.highlight_dataset(dsName, highlight);
    }

    @Override
    public boolean highlightDataset(String dsName, int colorIndex, boolean highlight) {
        return this.apiv2.data.highlight_dataset(dsName, colorIndex, highlight);
    }

    @Override
    public boolean highlightDataset(String dsName, float r, float g, float b, float a, boolean highlight) {
        float[] color = new float[]{r, g, b, a};
        return this.apiv2.data.highlight_dataset(dsName, color, highlight);
    }

    @Override
    public boolean highlightDataset(String dsName, String attributeName, String colorMap, double minMap, double maxMap, boolean highlight) {
        return this.apiv2.data.highlight_dataset(dsName, attributeName, colorMap, minMap, maxMap, highlight);
    }

    @Override
    public boolean setDatasetHighlightSizeFactor(String dsName, float sizeFactor) {
        return this.apiv2.data.set_dataset_highlight_size_factor(dsName, sizeFactor);
    }

    @Override
    public boolean setDatasetHighlightAllVisible(String dsName, boolean allVisible) {
        return this.apiv2.data.set_dataset_highlight_all_visible(dsName, allVisible);
    }

    @Override
    public void setDatasetPointSizeMultiplier(String dsName, double multiplier) {
        this.apiv2.data.set_dataset_point_size_factor(dsName, multiplier);
    }

    @Override
    public void addShapeAroundObject(String shapeName, String shapeType, String primitive, double size, String objectName, float r, float g, float b, float a, boolean showLabel, boolean trackObject) {
        this.apiv2.scene.add_shape_around_object(shapeName, shapeType, primitive, size, objectName, r, g, b, a, showLabel, trackObject);
    }

    @Override
    public void addShapeAroundObject(String shapeName, String shapeType, String primitive, String orientation, double size, String objectName, float r, float g, float b, float a, boolean showLabel, boolean trackObject) {
        this.apiv2.scene.add_shape_around_object(shapeName, shapeType, primitive, size, objectName, r, g, b, a, showLabel, trackObject);
    }

    @Override
    public void backupSettings() {
        this.apiv2.base.settings_backup();
    }

    @Override
    public boolean restoreSettings() {
        return this.apiv2.base.settings_restore();
    }

    @Override
    public void clearSettingsStack() {
        this.apiv2.base.settings_clear_stack();
    }

    @Override
    public void resetUserInterface() {
        this.apiv2.ui.reload();
    }

    @Override
    public double[] getRefSysTransform(String name) {
        return this.apiv2.refsys.get_transform_matrix(name);
    }

    @Override
    public void setMaximumSimulationTime(long years) {
        this.apiv2.time.setMaximumSimulationTime((double)years);
    }

    public void setMaximumSimulationTime(double years) {
        this.apiv2.time.setMaximumSimulationTime(years);
    }

    public void setMaximumSimulationTime(Long years) {
        this.apiv2.time.setMaximumSimulationTime(years);
    }

    public void setMaximumSimulationTime(Double years) {
        this.apiv2.time.setMaximumSimulationTime(years);
    }

    public void setMaximumSimulationTime(Integer years) {
        this.apiv2.time.setMaximumSimulationTime(years);
    }

    @Override
    public double getMeterToInternalUnitConversion() {
        return this.apiv2.base.m_to_internal();
    }

    @Override
    public double getInternalUnitToMeterConversion() {
        return this.apiv2.base.internal_to_m();
    }

    @Override
    public double internalUnitsToMetres(double internalUnits) {
        return this.apiv2.base.internal_to_m(internalUnits);
    }

    @Override
    public double internalUnitsToKilometres(double internalUnits) {
        return this.apiv2.base.internal_to_km(internalUnits);
    }

    @Override
    public double[] internalUnitsToKilometres(double[] internalUnits) {
        return this.apiv2.base.internal_to_km(internalUnits);
    }

    @Override
    public double internalUnitsToParsecs(double internalUnits) {
        return this.apiv2.base.internal_to_pc(internalUnits);
    }

    @Override
    public double[] internalUnitsToParsecs(double[] internalUnits) {
        return this.apiv2.base.internal_to_pc(internalUnits);
    }

    public double[] internalUnitsToKilometres(List<?> internalUnits) {
        return this.apiv2.base.internal_to_km(internalUnits);
    }

    @Override
    public double metresToInternalUnits(double metres) {
        return this.apiv2.base.m_to_internal(metres);
    }

    @Override
    public double kilometresToInternalUnits(double kilometres) {
        return this.apiv2.base.km_to_internal(kilometres);
    }

    @Override
    public double parsecsToInternalUnits(double parsecs) {
        return this.apiv2.base.pc_to_internal(parsecs);
    }

    public double kilometersToInternalUnits(double kilometres) {
        return this.apiv2.base.km_to_internal(kilometres);
    }

    @Override
    public List<String> listDatasets() {
        return this.apiv2.data.list_datasets();
    }

    @Override
    public long getFrameNumber() {
        return this.apiv2.graphics.get_current_frame_number();
    }

    @Override
    public String getDefaultFramesDir() {
        return this.apiv2.base.get_default_frame_output_dir();
    }

    @Override
    public String getDefaultScreenshotsDir() {
        return this.apiv2.base.get_default_screenshots_dir();
    }

    @Override
    public String getDefaultCameraDir() {
        return this.apiv2.base.get_camcorder_dir();
    }

    @Override
    public String getDefaultMappingsDir() {
        return this.apiv2.base.get_mappings_dir();
    }

    @Override
    public String getDataDir() {
        return this.apiv2.data.get_datasets_directory();
    }

    @Override
    public String getConfigDir() {
        return this.apiv2.base.get_config_dir();
    }

    @Override
    public String getLocalDataDir() {
        return this.apiv2.base.get_data_dir();
    }

    @Override
    public void print(String message) {
        this.apiv2.base.print(message);
    }

    @Override
    public void log(String message) {
        this.apiv2.base.log(message);
    }

    @Override
    public void error(String message) {
        this.apiv2.base.error(message);
    }

    @Override
    public void quit() {
        this.apiv2.base.quit();
    }
}

