/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Scene;
import gaiasky.scene.view.FocusView;
import gaiasky.script.EventScriptingInterface;
import java.util.concurrent.atomic.AtomicBoolean;

public class HiddenHelperUser
implements IObserver {
    private static HiddenHelperUser hhu;
    private final Array<HelperTask> currentTasks = new Array(false, 5);
    private long lastCommandTime = -1L;
    private Scene scene;
    private final FocusView view = new FocusView();

    private HiddenHelperUser() {
        EventManager.instance.subscribe((IObserver)this, Event.SCENE_LOADED, Event.NAVIGATE_TO_OBJECT, Event.LAND_ON_OBJECT, Event.LAND_AT_LOCATION_OF_OBJECT, Event.INPUT_EVENT);
    }

    public static HiddenHelperUser instance() {
        if (hhu == null) {
            hhu = new HiddenHelperUser();
        }
        return hhu;
    }

    public static void initialize() {
        HiddenHelperUser.instance();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case SCENE_LOADED: {
                this.scene = (Scene)data[0];
                break;
            }
            case NAVIGATE_TO_OBJECT: {
                FocusView body;
                if (data[0] instanceof String) {
                    Entity entity = this.scene.findFocus((String)data[0]);
                    this.view.setEntity(entity);
                    body = this.view;
                } else {
                    body = (FocusView)data[0];
                }
                GoToObjectTask gotoTask = new GoToObjectTask(body.getEntity(), this.currentTasks);
                Thread gotoT = new Thread(gotoTask);
                gotoT.start();
                this.currentTasks.add((Object)gotoTask);
                this.lastCommandTime = TimeUtils.millis();
                break;
            }
            case LAND_ON_OBJECT: {
                FocusView body;
                if (data[0] instanceof String) {
                    Entity entity = this.scene.findFocus((String)data[0]);
                    this.view.setEntity(entity);
                    body = this.view;
                } else {
                    body = (FocusView)data[0];
                }
                LandOnObjectTask landOnTask = new LandOnObjectTask(body.getEntity(), this.currentTasks);
                Thread landonT = new Thread(landOnTask);
                landonT.start();
                this.currentTasks.add((Object)landOnTask);
                this.lastCommandTime = TimeUtils.millis();
                break;
            }
            case LAND_AT_LOCATION_OF_OBJECT: {
                LandAtLocationTask landAtTask;
                FocusView body;
                if (data[0] instanceof String) {
                    Entity entity = this.scene.findFocus((String)data[0]);
                    this.view.setEntity(entity);
                    body = this.view;
                } else if (data[0] instanceof Entity) {
                    this.view.setEntity((Entity)data[0]);
                    body = this.view;
                } else {
                    body = (FocusView)data[0];
                }
                Object object = data[1];
                if (object instanceof String) {
                    String locName = (String)object;
                    landAtTask = new LandAtLocationTask(body.getEntity(), locName, this.currentTasks);
                } else {
                    Double lon = (Double)data[1];
                    Double lat = (Double)data[2];
                    landAtTask = new LandAtLocationTask(body.getEntity(), lon, lat, this.currentTasks);
                }
                Thread landAtLoc = new Thread(landAtTask);
                landAtLoc.start();
                this.currentTasks.add((Object)landAtTask);
                this.lastCommandTime = TimeUtils.millis();
                break;
            }
            case INPUT_EVENT: {
                if (TimeUtils.millis() - this.lastCommandTime <= 1000L) break;
                for (HelperTask tsk : this.currentTasks) {
                    tsk.stop();
                }
                this.currentTasks.clear();
                break;
            }
        }
    }

    private static class GoToObjectTask
    extends HelperTask {
        private final Entity body;
        private final EventScriptingInterface scripting;

        GoToObjectTask(Entity entity, Array<HelperTask> currentTasks) {
            super(currentTasks);
            this.body = entity;
            this.scripting = (EventScriptingInterface)GaiaSky.instance.scripting();
        }

        @Override
        public void run() {
            this.scripting.goToObjectSmooth(this.body, -1.0, 10.0, 4.0, true, this.stop);
            this.scripting.setCameraFocus(this.body, -1.0f);
            this.currentTasks.removeValue((Object)this, true);
        }
    }

    private static class LandOnObjectTask
    extends HelperTask {
        Entity body;

        LandOnObjectTask(Entity body, Array<HelperTask> currentTasks) {
            super(currentTasks);
            this.body = body;
        }

        @Override
        public void run() {
            ((EventScriptingInterface)GaiaSky.instance.scripting()).landOnObject(this.body, this.stop);
            this.currentTasks.removeValue((Object)this, true);
        }
    }

    private static class LandAtLocationTask
    extends HelperTask {
        Entity body;
        String locName;
        Double lon;
        Double lat;

        LandAtLocationTask(Entity body, String locName, Array<HelperTask> currentTasks) {
            super(currentTasks);
            this.body = body;
            this.locName = locName;
        }

        LandAtLocationTask(Entity body, double lon, double lat, Array<HelperTask> currentTasks) {
            super(currentTasks);
            this.body = body;
            this.lon = lon;
            this.lat = lat;
        }

        @Override
        public void run() {
            if (this.locName == null) {
                ((EventScriptingInterface)GaiaSky.instance.scripting()).landAtObjectLocation(this.body, this.lon, this.lat, this.stop);
            } else {
                ((EventScriptingInterface)GaiaSky.instance.scripting()).landAtObjectLocation(this.body, this.locName, this.stop);
            }
            this.currentTasks.removeValue((Object)this, true);
        }
    }

    private static abstract class HelperTask
    implements Runnable {
        protected AtomicBoolean stop = new AtomicBoolean(false);
        Array<HelperTask> currentTasks;

        HelperTask(Array<HelperTask> currentTasks) {
            this.currentTasks = currentTasks;
        }

        public void stop() {
            this.stop.set(true);
        }
    }
}

