/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script;

import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.script.IScriptingInterface;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import java.util.concurrent.atomic.AtomicInteger;
import py4j.ClientServer;
import py4j.DefaultGatewayServerListener;
import py4j.GatewayServerListener;
import py4j.Py4JServerConnection;

public class ScriptingServer {
    private static final Logger.Log logger = Logger.getLogger(ScriptingServer.class);
    private static final AtomicInteger connections = new AtomicInteger(0);
    private static ClientServer gatewayServer;
    private static GatewayServerListener listener;

    public static void initialize(IScriptingInterface scriptingInterface) {
        ScriptingServer.initialize(scriptingInterface, false);
    }

    public static void initialize(final IScriptingInterface scriptingInterface, final boolean force) {
        if (!Settings.settings.program.net.slave.active) {
            if (force && gatewayServer != null) {
                try {
                    ScriptingServer.dispose();
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
            if (gatewayServer == null) {
                try {
                    gatewayServer = new ClientServer((Object)scriptingInterface);
                    listener = new DefaultGatewayServerListener(){

                        public void connectionStarted(Py4JServerConnection gatewayConnection) {
                            logger.info("Connection started (" + connections.incrementAndGet() + "): " + gatewayConnection.getSocket().toString());
                        }

                        public void connectionStopped(Py4JServerConnection gatewayConnection) {
                            GaiaSky.postRunnable(() -> EventManager.publish(Event.INPUT_ENABLED_CMD, (Object)this, true));
                            logger.info("Connection stopped (" + connections.decrementAndGet() + "): " + gatewayConnection.getSocket().toString());
                        }

                        public void serverPostShutdown() {
                            logger.debug("Post shutdown");
                        }

                        public void serverPreShutdown() {
                            logger.debug("Pre shutdown");
                        }

                        public void serverStarted() {
                            logger.info("Server started on port " + gatewayServer.getJavaServer().getListeningPort());
                        }

                        public void serverStopped() {
                            logger.info("Server stopped");
                            ScriptingServer.initialize(scriptingInterface, true);
                        }

                        public void connectionError(Exception e) {
                            logger.error(e);
                        }

                        public void serverError(Exception e) {
                            logger.error(e);
                            ScriptingServer.initialize(scriptingInterface, force);
                        }
                    };
                    gatewayServer.getJavaServer().addListener(listener);
                }
                catch (Exception e) {
                    logger.error("Could not initialize the Py4J gateway server, is there another instance of Gaia Sky running? Proceeding without scripting...");
                    logger.error(e);
                }
            }
            try {
                gatewayServer.startServer();
            }
            catch (Exception e) {
                logger.error("Could not initialize the Py4J gateway server, is there another instance of Gaia Sky running? Proceeding without scripting...");
                logger.error(e);
            }
        }
    }

    public static void dispose() {
        if (gatewayServer != null) {
            if (listener != null) {
                gatewayServer.getJavaServer().removeListener(listener);
                listener = null;
            }
            gatewayServer.shutdown();
            gatewayServer = null;
        }
    }
}

