/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.BaseModule;
import gaiasky.script.v2.impl.CamcorderModule;
import gaiasky.script.v2.impl.CameraModule;
import gaiasky.script.v2.impl.DataModule;
import gaiasky.script.v2.impl.GeomModule;
import gaiasky.script.v2.impl.GraphicsModule;
import gaiasky.script.v2.impl.InputModule;
import gaiasky.script.v2.impl.InstancesModule;
import gaiasky.script.v2.impl.OutputModule;
import gaiasky.script.v2.impl.ParameterValidator;
import gaiasky.script.v2.impl.RefsysModule;
import gaiasky.script.v2.impl.SceneModule;
import gaiasky.script.v2.impl.TimeModule;
import gaiasky.script.v2.impl.UiModule;
import gaiasky.util.CatalogManager;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;

public class APIv2
implements IObserver {
    protected final AssetManager assetManager;
    protected final CatalogManager catalogManager;
    protected final EventManager em;
    final ParameterValidator validator;
    public final BaseModule base;
    public final CameraModule camera;
    public final TimeModule time;
    public final SceneModule scene;
    public final GraphicsModule graphics;
    public final DataModule data;
    public final InputModule input;
    public final OutputModule output;
    public final UiModule ui;
    public final CamcorderModule camcorder;
    public final RefsysModule refsys;
    public final GeomModule geom;
    public final InstancesModule instances;
    final ObjectMap<Class<?>, APIModule> modules;
    final Vector3D aux3d1;
    final Vector3D aux3d2;
    final Vector3D aux3d3;
    final Vector3D aux3d4;
    final Vector3D aux3d5;
    final Vector3D aux3d6;
    final Vector3Q aux3b1;
    final Vector3Q aux3b2;
    final Vector3Q aux3b3;
    final Vector3Q aux3b4;
    final Vector3Q aux3b5;
    final Vector2D aux2d1;

    public APIv2(AssetManager assetManager, CatalogManager catalogManager) {
        this.assetManager = assetManager;
        this.catalogManager = catalogManager;
        this.em = EventManager.instance;
        this.validator = new ParameterValidator(this);
        this.modules = new ObjectMap(15);
        this.base = new BaseModule(this.em, this, "base");
        this.camera = new CameraModule(this.em, this, "camera");
        this.time = new TimeModule(this.em, this, "time");
        this.scene = new SceneModule(this.em, this, "scene");
        this.graphics = new GraphicsModule(this.em, this, "graphics");
        this.data = new DataModule(this.em, this, "data");
        this.input = new InputModule(this.em, this, "input");
        this.output = new OutputModule(this.em, this, "output");
        this.ui = new UiModule(this.em, this, "ui");
        this.camcorder = new CamcorderModule(this.em, this, "camcorder");
        this.refsys = new RefsysModule(this.em, this, "refsys");
        this.geom = new GeomModule(this.em, this, "geom");
        this.instances = new InstancesModule(this.em, this, "instances");
        this.addModules(this.base, this.camera, this.time, this.scene, this.graphics, this.data, this.input, this.output, this.ui, this.camcorder, this.refsys, this.instances);
        this.aux3d1 = new Vector3D();
        this.aux3d2 = new Vector3D();
        this.aux3d3 = new Vector3D();
        this.aux3d4 = new Vector3D();
        this.aux3d5 = new Vector3D();
        this.aux3d6 = new Vector3D();
        this.aux3b1 = new Vector3Q();
        this.aux3b2 = new Vector3Q();
        this.aux3b3 = new Vector3Q();
        this.aux3b4 = new Vector3Q();
        this.aux3b5 = new Vector3Q();
        this.aux2d1 = new Vector2D();
        this.em.subscribe((IObserver)this, Event.DISPOSE);
    }

    private void addModules(APIModule ... ms) {
        for (APIModule m : ms) {
            Field[] fields;
            this.modules.put(m.getClass(), (Object)m);
            for (Field field : fields = m.getClass().getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !APIModule.class.isAssignableFrom(field.getType())) continue;
                try {
                    APIModule value = (APIModule)field.get(m);
                    this.modules.put(field.getType(), (Object)value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public APIModule getModuleInstance(Class<?> clazz) {
        return (APIModule)this.modules.get(clazz);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (Objects.requireNonNull(event) == Event.DISPOSE) {
            this.em.removeAllSubscriptions((IObserver)this);
            for (ObjectMap.Entry module : this.modules) {
                ((APIModule)module.value).dispose();
            }
        }
    }

    double[] dArray(List<?> l) {
        if (l == null) {
            return null;
        }
        double[] res = new double[l.size()];
        int i = 0;
        for (Object o : l) {
            res[i++] = (Double)o;
        }
        return res;
    }

    int[] iArray(List<?> l) {
        if (l == null) {
            return null;
        }
        int[] res = new int[l.size()];
        int i = 0;
        for (Object o : l) {
            res[i++] = (Integer)o;
        }
        return res;
    }
}

