/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import com.badlogic.gdx.Gdx;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.script.v2.api.BaseAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.SysUtils;
import gaiasky.util.camera.rec.Camcorder;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.jafama.FastMath;

public class BaseModule
extends APIModule
implements BaseAPI {
    private final Deque<Settings> settingsStack = new ConcurrentLinkedDeque<Settings>();

    public BaseModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    @Override
    public String get_version() {
        return Settings.settings.version.version + "\n" + Settings.settings.version.build + "\n" + Settings.settings.version.system + "\n" + Settings.settings.version.builder + "\n" + String.valueOf(Settings.settings.version.buildTime);
    }

    @Override
    public String get_version_number() {
        return Settings.settings.version.version;
    }

    @Override
    public String get_build_string() {
        return Settings.settings.version.build;
    }

    @Override
    public String get_assets_dir() {
        return Settings.ASSETS_LOC;
    }

    @Override
    public String get_default_frame_output_dir() {
        return SysUtils.getDefaultFramesDir().toAbsolutePath().toString();
    }

    @Override
    public String get_default_screenshots_dir() {
        return SysUtils.getDefaultScreenshotsDir().toAbsolutePath().toString();
    }

    @Override
    public String get_camcorder_dir() {
        return SysUtils.getDefaultCameraDir().toAbsolutePath().toString();
    }

    @Override
    public String get_mappings_dir() {
        return SysUtils.getDefaultMappingsDir().toAbsolutePath().toString();
    }

    @Override
    public String get_data_dir() {
        return SysUtils.getDataDir().toAbsolutePath().toString();
    }

    @Override
    public String get_config_dir() {
        return SysUtils.getConfigDir().toAbsolutePath().toString();
    }

    @Override
    public String get_default_datasets_dir() {
        return SysUtils.getDefaultDatasetsDir().toAbsolutePath().toString();
    }

    @Override
    public void sleep(float value) {
        if (this.api.validator.checkNum(value, 0.0f, Float.MAX_VALUE, "seconds")) {
            if (value == 0.0f) {
                return;
            }
            if (this.api.output.is_frame_output_active()) {
                this.sleep_frames(Math.max(1L, FastMath.round((double)(this.api.output.get_frame_output_fps() * (double)value))));
            } else if (Camcorder.instance.isRecording()) {
                this.sleep_frames(Math.max(1L, FastMath.round((double)(this.api.camcorder.get_fps() * (double)value))));
            } else {
                try {
                    Thread.sleep(Math.round(value * 1000.0f));
                }
                catch (InterruptedException e) {
                    this.logger.error(e);
                }
            }
        }
    }

    public void sleep(int seconds) {
        this.sleep((float)seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sleep_frames(long frames) {
        long frameCount = 0L;
        while (frameCount < frames) {
            try {
                Object object = GaiaSky.instance.frameMonitor;
                synchronized (object) {
                    GaiaSky.instance.frameMonitor.wait();
                }
                ++frameCount;
            }
            catch (InterruptedException e) {
                this.logger.error("Error while waiting on frameMonitor", e);
            }
        }
    }

    @Override
    public void post_runnable(Runnable r) {
        GaiaSky.postRunnable(r);
    }

    @Override
    public void park_scene_runnable(String id, Runnable r) {
        if (this.api.validator.checkString(id, "id")) {
            this.em.post(Event.PARK_RUNNABLE, this, id, r);
        }
    }

    public void park_runnable(String id, Runnable runnable) {
        this.park_scene_runnable(id, runnable);
    }

    @Override
    public void park_camera_runnable(String id, Runnable r) {
        if (this.api.validator.checkString(id, "id")) {
            this.em.post(Event.PARK_CAMERA_RUNNABLE, this, id, r);
        }
    }

    @Override
    public void remove_runnable(String id) {
        if (this.api.validator.checkString(id, "id")) {
            this.em.post(Event.UNPARK_RUNNABLE, this, id);
        }
    }

    @Override
    public void settings_backup() {
        this.settingsStack.push(Settings.settings.clone());
    }

    @Override
    public boolean settings_restore() {
        if (this.settingsStack.isEmpty()) {
            return false;
        }
        if (SettingsManager.setSettingsInstance(this.settingsStack.pop())) {
            Settings.settings.apply();
            return true;
        }
        return false;
    }

    @Override
    public void settings_clear_stack() {
        this.settingsStack.clear();
    }

    @Override
    public double m_to_internal() {
        return Constants.M_TO_U;
    }

    @Override
    public double internal_to_m() {
        return Constants.U_TO_M;
    }

    @Override
    public double internal_to_m(double iu) {
        return iu * Constants.U_TO_M;
    }

    @Override
    public double internal_to_km(double iu) {
        return iu * Constants.U_TO_KM;
    }

    @Override
    public double[] internal_to_km(double[] iu) {
        double[] result = new double[iu.length];
        for (int i = 0; i < iu.length; ++i) {
            result[i] = this.internal_to_km(iu[i]);
        }
        return result;
    }

    @Override
    public double internal_to_pc(double iu) {
        return iu * Constants.U_TO_PC;
    }

    @Override
    public double[] internal_to_pc(double[] iu) {
        double[] result = new double[iu.length];
        for (int i = 0; i < iu.length; ++i) {
            result[i] = this.internal_to_pc(iu[i]);
        }
        return result;
    }

    public double[] internal_to_km(List<?> internalUnits) {
        double[] result = new double[internalUnits.size()];
        for (int i = 0; i < internalUnits.size(); ++i) {
            result[i] = this.internal_to_km((Double)internalUnits.get(i));
        }
        return result;
    }

    @Override
    public double m_to_internal(double m) {
        return m * Constants.M_TO_U;
    }

    @Override
    public double km_to_internal(double km) {
        return km * Constants.KM_TO_U;
    }

    @Override
    public double pc_to_internal(double pc) {
        return pc * Constants.PC_TO_U;
    }

    public double kilometersToInternalUnits(double kilometres) {
        return kilometres * Constants.KM_TO_U;
    }

    @Override
    public void print(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void log(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void error(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void quit() {
        Gdx.app.exit();
    }
}

