/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.script.v2.api.CamcorderAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Settings;
import java.nio.file.Path;
import java.util.Objects;

public class CamcorderModule
extends APIModule
implements CamcorderAPI {
    public CamcorderModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    @Override
    public void set_fps(double fps) {
        if (this.api.validator.checkNum(fps, 0.05, 1000.0, "targetFps")) {
            this.em.post(Event.CAMRECORDER_FPS_CMD, this, fps);
        }
    }

    @Override
    public double get_fps() {
        return Settings.settings.camrecorder.targetFps;
    }

    @Override
    public void start() {
        this.em.post(Event.RECORD_CAMERA_CMD, this, true, null);
    }

    @Override
    public void start(String path) {
        this.em.post(Event.RECORD_CAMERA_CMD, this, true, Path.of(path, new String[0]).getFileName().toString());
    }

    @Override
    public void stop() {
        this.em.post(Event.RECORD_CAMERA_CMD, this, false, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(String path, boolean sync) {
        this.em.post(Event.PLAY_CAMERA_CMD, this, true, path);
        if (sync) {
            Object monitor = new Object();
            IObserver watcher = (event, source, data) -> {
                Boolean status;
                if (Objects.requireNonNull(event) == Event.CAMERA_PLAY_INFO && !(status = (Boolean)data[0]).booleanValue()) {
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                }
            };
            this.em.subscribe(watcher, Event.CAMERA_PLAY_INFO);
            Object object = monitor;
            synchronized (object) {
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    this.logger.error(e, "Error waiting for camera file to finish");
                }
            }
        }
    }

    @Override
    public void play(String path) {
        this.play(path, false);
    }
}

