/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.view.FocusView;
import gaiasky.script.v2.api.CameraAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.script.v2.impl.InteractiveCameraModule;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.SlaveManager;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.LinearDouble;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.PathDouble;
import gaiasky.util.math.Quadruple;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.math.VectorDouble;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.jafama.FastMath;

public class CameraModule
extends APIModule
implements IObserver,
CameraAPI {
    private Scene scene;
    private final FocusView focusView;
    private int cTransSeq = 0;
    private final Vector3Q aux3b1 = new Vector3Q();
    public InteractiveCameraModule interactive;

    public CameraModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
        this.focusView = new FocusView();
        this.interactive = new InteractiveCameraModule(em, api, "interactive");
        em.subscribe((IObserver)this, Event.SCENE_LOADED);
    }

    @Override
    public void focus_mode(String name) {
        this.focus_mode(name, 0.0f);
    }

    @Override
    public void focus_mode(String name, float wait) {
        if (this.api.validator.checkString(name, "focusName") && this.api.validator.checkFocusName(name)) {
            Entity entity = this.api.scene.get_focus(name);
            this.focusView.setEntity(entity);
            this.focusView.getFocus(name);
            this.focus_mode(entity, wait);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focus_mode(Entity entity, float waitTimeSeconds) {
        if (this.api.validator.checkNotNull(entity, "Entity is null")) {
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(entity);
                if (Mapper.focus.has(entity)) {
                    NaturalCamera cam = GaiaSky.instance.cameraManager.naturalCamera;
                    this.changeFocus(this.focusView, cam, waitTimeSeconds);
                } else {
                    this.logger.error("Object can't be set as focus: " + this.focusView.getName());
                }
            }
        }
    }

    public void focus_mode(String focusName, int waitTimeSeconds) {
        this.focus_mode(focusName, (float)waitTimeSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focus_mode_instant(String name) {
        if (this.api.validator.checkString(name, "focusName")) {
            Entity entity = this.api.scene.get_entity(name);
            if (Mapper.focus.has(entity)) {
                FocusView focusView = this.focusView;
                synchronized (focusView) {
                    this.focusView.setEntity(entity);
                    this.focusView.getFocus(name);
                    this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                    this.em.post(Event.FOCUS_CHANGE_CMD, this, this.focusView.getEntity());
                }
                this.api.base.post_runnable(() -> {
                    Vector3Q camPos = GaiaSky.instance.cameraManager.getPos();
                    Vector3Q dir = new Vector3Q();
                    FocusView focusView = this.focusView;
                    synchronized (focusView) {
                        this.focusView.setEntity(entity);
                        this.focusView.getAbsolutePosition(dir).sub(camPos);
                    }
                    this.em.post(Event.CAMERA_DIR_CMD, this, new Object[]{dir.nor().valuesD()});
                });
                this.api.base.sleep_frames(2L);
            } else {
                this.logger.error("FOCUS_MODE object does not exist: " + name);
            }
        }
    }

    @Override
    public void focus_mode_instant_go(String name) {
        this.focus_mode_instant_go(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focus_mode_instant_go(String focusName, boolean sleep) {
        Entity entity;
        if (this.api.validator.checkString(focusName, "focusName") && Mapper.focus.has(entity = this.api.scene.get_entity(focusName))) {
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(entity);
                this.focusView.getFocus(focusName);
                this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                this.em.post(Event.FOCUS_CHANGE_CMD, this, this.focusView.getEntity(), true);
                this.em.post(Event.GO_TO_OBJECT_CMD, this);
            }
            if (sleep) {
                this.api.base.sleep_frames(2L);
            }
        }
    }

    protected void changeFocus(FocusView object, NaturalCamera cam, double waitTimeSeconds) {
        FocusView currentFocus = (FocusView)cam.getFocus();
        if (currentFocus == null || currentFocus.isSet() || currentFocus.getEntity() != object.getEntity()) {
            this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
            this.em.post(Event.FOCUS_CHANGE_CMD, this, object.getEntity());
            if (waitTimeSeconds < 0.0) {
                waitTimeSeconds = Double.MAX_VALUE;
            }
            long start = System.currentTimeMillis();
            double elapsedSeconds = 0.0;
            while (!cam.facingFocus && elapsedSeconds < waitTimeSeconds) {
                try {
                    this.api.base.sleep_frames(1L);
                }
                catch (Exception e) {
                    this.logger.error(e);
                }
                elapsedSeconds = (double)(System.currentTimeMillis() - start) / 1000.0;
            }
        }
    }

    @Override
    public boolean wait_focus(String name, long timeout) {
        long iniTime = TimeUtils.millis();
        NaturalCamera cam = GaiaSky.instance.cameraManager.naturalCamera;
        while (cam.focus == null || !cam.focus.getName().equalsIgnoreCase(name)) {
            this.api.base.sleep_frames(1L);
            long spent = TimeUtils.millis() - iniTime;
            if (timeout <= 0L || spent <= timeout) continue;
            return true;
        }
        return false;
    }

    @Override
    public void set_focus_lock(boolean lock) {
        this.api.base.post_runnable(() -> this.em.post(Event.FOCUS_LOCK_CMD, this, lock));
    }

    @Override
    public void center_focus(boolean center) {
        this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_CENTER_FOCUS_CMD, this, center));
    }

    @Override
    public void stop() {
        this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_STOP, this));
    }

    @Override
    public void center() {
        this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_CENTER, this));
    }

    @Override
    public void free_mode() {
        this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE}));
    }

    @Override
    public void set_position(double[] pos) {
        this.set_position(pos, "km");
    }

    @Override
    public void set_position(double x, double y, double z) {
        this.set_position(new double[]{x, y, z});
    }

    @Override
    public void set_position(double x, double y, double z, String units) {
        this.set_position(new double[]{x, y, z}, units);
    }

    @Override
    public void set_position(double x, double y, double z, boolean immediate) {
        this.set_position(new double[]{x, y, z}, immediate);
    }

    @Override
    public void set_position(double x, double y, double z, String units, boolean immediate) {
        this.set_position(new double[]{x, y, z}, units, immediate);
    }

    public void set_position(List<?> vec, boolean immediate) {
        this.set_position(this.api.dArray(vec), immediate);
    }

    @Override
    public void set_position(double[] pos, boolean immediate) {
        this.set_position(pos, "km", immediate);
    }

    @Override
    public void set_position(double[] pos, String units, boolean immediate) {
        if (this.api.validator.checkLength(pos, 3, "position") && this.api.validator.checkDistanceUnits(units)) {
            Settings.DistanceUnits u = Settings.DistanceUnits.valueOf(units.toUpperCase(Locale.ROOT));
            if (immediate) {
                this.sendPositionEvent(pos, u);
            } else {
                this.api.base.post_runnable(() -> this.sendPositionEvent(pos, u));
            }
        }
    }

    public void set_position(List<Double> position, String units, boolean immediate) {
        this.set_position(this.api.dArray(position), units, immediate);
    }

    private void sendPositionEvent(double[] position, Settings.DistanceUnits units) {
        position[0] = units.toInternalUnits(position[0]);
        position[1] = units.toInternalUnits(position[1]);
        position[2] = units.toInternalUnits(position[2]);
        this.em.post(Event.CAMERA_POS_CMD, this, new Object[]{position});
    }

    @Override
    public double[] get_position() {
        return this.get_position("km");
    }

    @Override
    public double[] get_position(String units) {
        if (this.api.validator.checkDistanceUnits(units)) {
            Settings.DistanceUnits u = Settings.DistanceUnits.valueOf(units.toUpperCase(Locale.ROOT));
            Vector3D campos = GaiaSky.instance.cameraManager.getPos().tov3d(this.api.aux3d1);
            return new double[]{u.fromInternalUnits(campos.x), u.fromInternalUnits(campos.y), u.fromInternalUnits(campos.z)};
        }
        return null;
    }

    @Override
    public void set_position(double[] dir, String units) {
        this.set_position(dir, units, false);
    }

    public void set_position(List<?> vec) {
        this.set_position(vec, "km");
    }

    public void set_position(List<?> vec, String units) {
        this.set_position(this.api.dArray(vec), units);
    }

    public void set_direction(List<?> dir, boolean immediate) {
        this.set_direction(this.api.dArray(dir), immediate);
    }

    @Override
    public void set_direction(double[] dir, boolean immediate) {
        if (this.api.validator.checkLength(dir, 3, "direction")) {
            if (immediate) {
                this.sendDirectionEvent(dir);
            } else {
                this.api.base.post_runnable(() -> this.sendDirectionEvent(dir));
            }
        }
    }

    private void sendDirectionEvent(double[] direction) {
        this.em.post(Event.CAMERA_DIR_CMD, this, new Object[]{direction});
    }

    @Override
    public double[] get_direction() {
        Vector3D camDir = GaiaSky.instance.cameraManager.getDirection();
        return new double[]{camDir.x, camDir.y, camDir.z};
    }

    @Override
    public void set_direction(double[] direction) {
        this.set_direction(direction, false);
    }

    @Override
    public void set_direction_equatorial(double ra, double dec) {
        if (this.api.validator.checkNum(dec, -90.0, 90.0, "declination")) {
            this.free_mode();
            this.api.aux3d1.set(FastMath.toRadians((double)ra), FastMath.toRadians((double)dec), Constants.PC_TO_U);
            Vector3D targetPoint = Coordinates.sphericalToCartesian(this.api.aux3d1, this.api.aux3d2);
            Vector3D dir = targetPoint.sub(GaiaSky.instance.cameraManager.getPos()).nor();
            this.api.aux3d3.set(0.0, 1.5707963267948966, Constants.PC_TO_U);
            Vector3D targetUp = Coordinates.sphericalToCartesian(this.api.aux3d3, this.api.aux3d4).nor();
            dir.put(this.api.aux3d5).crs(targetUp);
            Vector3D up = this.api.aux3d5.crs(dir).nor();
            this.transition_orientation(new double[]{dir.x, dir.y, dir.z}, new double[]{up.x, up.y, up.z}, 2.5, "logisticsigmoid", 0.2, false);
        }
    }

    @Override
    public void set_direction_galactic(double l, double b) {
        if (this.api.validator.checkNum(b, -90.0, 90.0, "galactic latitude")) {
            Vector2D eq = Coordinates.galacticToEquatorial(FastMath.toRadians((double)l), FastMath.toRadians((double)b), new Vector2D());
            this.set_direction_equatorial(FastMath.toDegrees((double)eq.x), FastMath.toDegrees((double)eq.y));
        }
    }

    public void set_direction(List<?> dir) {
        this.set_direction(this.api.dArray(dir));
    }

    public void set_up(List<?> up, boolean immediate) {
        this.set_up(this.api.dArray(up), immediate);
    }

    @Override
    public void set_up(double[] up, boolean immediate) {
        if (this.api.validator.checkLength(up, 3, "up")) {
            if (immediate) {
                this.sendUpEvent(up);
            } else {
                this.api.base.post_runnable(() -> this.sendUpEvent(up));
            }
        }
    }

    private void sendUpEvent(double[] up) {
        this.em.post(Event.CAMERA_UP_CMD, this, new Object[]{up});
    }

    @Override
    public double[] get_up() {
        Vector3D camUp = GaiaSky.instance.cameraManager.getUp();
        return new double[]{camUp.x, camUp.y, camUp.z};
    }

    @Override
    public void set_up(double[] up) {
        this.set_up(up, false);
    }

    public void set_up(List<?> up) {
        this.set_up(this.api.dArray(up));
    }

    @Override
    public void set_state(double[] pos, double[] dir, double[] up) {
        this.api.base.post_runnable(() -> {
            this.em.post(Event.CAMERA_POS_CMD, this, new Object[]{pos});
            this.em.post(Event.CAMERA_DIR_CMD, this, new Object[]{dir});
            this.em.post(Event.CAMERA_UP_CMD, this, new Object[]{up});
        });
    }

    public void set_state(List<?> pos, List<?> dir, List<?> up) {
        this.set_state(this.api.dArray(pos), this.api.dArray(dir), this.api.dArray(up));
    }

    @Override
    public void set_state_and_time(double[] pos, double[] dir, double[] up, long time) {
        this.api.base.post_runnable(() -> {
            this.em.post(Event.CAMERA_PROJECTION_CMD, this, pos, dir, up);
            this.em.post(Event.TIME_CHANGE_CMD, this, Instant.ofEpochMilli(time));
        });
    }

    public void set_state_and_time(List<?> pos, List<?> dir, List<?> up, long time) {
        this.set_state_and_time(this.api.dArray(pos), this.api.dArray(dir), this.api.dArray(up), time);
    }

    @Override
    public void set_orientation_quaternion(double[] quaternion) {
        if (this.api.validator.checkLength(quaternion, 4, "quaternion")) {
            QuaternionDouble q = new QuaternionDouble(quaternion[0], quaternion[1], quaternion[2], quaternion[3]);
            Vector3D dir = this.api.aux3d1;
            Vector3D up = this.api.aux3d2;
            q.getDirection(dir);
            q.getUp(up);
            this.em.post(Event.CAMERA_DIR_CMD, this, new Object[]{dir.values()});
            this.em.post(Event.CAMERA_UP_CMD, this, new Object[]{up.values()});
        }
    }

    public void set_orientation_quaternion(List<?> quaternion) {
        this.set_orientation_quaternion(this.api.dArray(quaternion));
    }

    @Override
    public double[] get_orientation_quaternion() {
        ICamera cam = GaiaSky.instance.getICamera();
        QuaternionDouble q = new QuaternionDouble();
        q.setFromCamera(cam.getDirection(), cam.getUp());
        return q.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set_position_and_focus(String name, String other, double rot, double solidAngle) {
        if (this.api.validator.checkNum(solidAngle, 1.0E-50, Double.MAX_VALUE, "solidAngle") && this.api.validator.checkNotNull(name, "focus") && this.api.validator.checkNotNull(other, "other") && this.scene.index().containsEntity(name) && this.scene.index().containsEntity(other)) {
            Entity otherObj;
            Entity focusObj;
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                focusObj = this.scene.findFocus(name);
                this.focusView.setEntity(focusObj);
                this.focusView.getFocus(name);
                otherObj = this.scene.findFocus(other);
                this.focusView.setEntity(otherObj);
                this.focusView.getFocus(other);
            }
            this.set_position_and_focus(focusObj, otherObj, rot, solidAngle);
        }
    }

    public void set_position_and_focus(String focus, String other, long rotation, long solidAngle) {
        this.set_position_and_focus(focus, other, (double)rotation, (double)solidAngle);
    }

    @Override
    public void point_at_equatorial(double ra, double dec) {
        this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
        this.em.post(Event.FREE_MODE_COORD_CMD, this, ra, dec);
    }

    public void point_at_sky_coordinate(long ra, long dec) {
        this.point_at_equatorial(ra, dec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set_position_and_focus(Entity focus, Entity other, double rotation, double solidAngle) {
        if (this.api.validator.checkNum(solidAngle, 1.0E-50, Double.MAX_VALUE, "solidAngle") && this.api.validator.checkNotNull(focus, "focus") && this.api.validator.checkNotNull(other, "other")) {
            this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
            this.em.post(Event.FOCUS_CHANGE_CMD, this, focus);
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(focus);
                double radius = this.focusView.getRadius();
                double dist = radius / FastMath.tan((double)Math.toRadians(solidAngle / 2.0)) + radius;
                Vector3D up = new Vector3D(0.0, 1.0, 0.0).mul(Coordinates.eclToEq());
                Vector3Q focusPos = this.api.aux3b1;
                this.focusView.getAbsolutePosition(focusPos);
                this.focusView.setEntity(other);
                Vector3Q otherPos = this.api.aux3b2;
                this.focusView.getAbsolutePosition(otherPos);
                this.focusView.clearEntity();
                Vector3Q otherToFocus = this.api.aux3b3;
                otherToFocus.set(focusPos).sub(otherPos).nor();
                Vector3D focusToOther = this.api.aux3d4.set(otherToFocus);
                focusToOther.scl(-dist).rotate(up, rotation);
                Vector3D newCamPos = this.api.aux3d5.set(focusToOther).add(focusPos).scl(Constants.U_TO_KM);
                Vector3D newCamDir = this.api.aux3d6.set(focusToOther);
                newCamDir.scl(-1.0).nor();
                this.set_position(newCamPos.values());
                this.set_direction(newCamDir.values());
                this.set_up(up.values());
            }
        }
    }

    @Override
    public void go_to_object_instant(String name) {
        this.focus_mode_instant_go(name);
    }

    @Override
    public void go_to_object(String name, double positionDurationSeconds, double ori_duration) {
        this.go_to_object(name, positionDurationSeconds, ori_duration, true);
    }

    @Override
    public void go_to_object(String name, double sa, double pos_duration, double ori_duration) {
        this.go_to_object(name, sa, pos_duration, ori_duration, true);
    }

    @Override
    public void go_to_object(String name, double positionDurationSeconds, double ori_duration, boolean sync) {
        this.go_to_object(name, -1.0, positionDurationSeconds, ori_duration, true);
    }

    @Override
    public void go_to_object(String name, double sa, double pos_duration, double ori_duration, boolean sync) {
        if (this.api.validator.checkString(name, "name") && this.api.validator.checkObjectName(name)) {
            Entity focus = this.scene.findFocus(name);
            this.go_to_object(focus, sa, pos_duration, ori_duration, sync);
        } else {
            this.logger.error("Could not find position of " + name);
        }
    }

    public void go_to_object(Entity object, double positionDurationSeconds, double orientationDurationSeconds, boolean sync) {
        this.go_to_object(object, -1.0, positionDurationSeconds, orientationDurationSeconds, sync);
    }

    public void go_to_object(Entity object, double solidAngle, double positionDurationSeconds, double orientationDurationSeconds, boolean sync) {
        this.go_to_object(object, solidAngle, positionDurationSeconds, orientationDurationSeconds, sync, null);
    }

    public void go_to_object(Entity object, double solidAngle, double positionDurationSeconds, double orientationDurationSeconds, boolean sync, AtomicBoolean stop) {
        this.focusView.setEntity(object);
        double radius = this.focusView.getRadius();
        Vector3Q objectPos = this.focusView.getAbsolutePosition(this.focusView.getName(), this.api.aux3b1);
        Vector3Q camPos = this.api.aux3b2.set(GaiaSky.instance.cameraManager.getPos());
        Vector3Q camUp = this.api.aux3b3.set(GaiaSky.instance.cameraManager.getUp());
        if (objectPos != null && camPos != null) {
            Vector3Q o = objectPos;
            Vector3Q c = camPos;
            Vector3Q u = camUp;
            Vector3Q camObj = this.api.aux3b4.set(o).sub(c);
            Vector3Q dir = this.api.aux3b5.set(camObj).nor();
            Vector3Q up = this.api.aux3b1.set(camUp).crs(dir).crs(dir).scl(-1.0).nor();
            double targetAngle = FastMath.toRadians((double)solidAngle);
            if (targetAngle < 0.0) {
                if (this.focusView.isParticleSet()) {
                    double rx0 = 1.31;
                    double rx1 = 2805.0;
                    double y0 = 1.0;
                    double y1 = 0.001;
                    targetAngle = FastMath.toRadians((double)(y0 + (y1 - y0) * (this.focusView.getAbsolutePosition(this.api.aux3b1).lenDouble() * Constants.U_TO_PC - rx0) / (rx1 - rx0)));
                } else {
                    targetAngle = FastMath.toRadians((double)20.0);
                }
            }
            double targetDistance = radius / FastMath.tan((double)(targetAngle * 0.5));
            Quadruple len = camObj.len().subtract(new Quadruple(targetDistance));
            Vector3Q pos = camObj.nor().scl(len).add(c);
            this.transition(pos.valuesD(), "internal", dir.valuesD(), up.valuesD(), positionDurationSeconds, "logisticsigmoid", 60.0, orientationDurationSeconds, "logisticsigmoid", 17.0, sync, stop);
        }
    }

    @Override
    public double get_distance_to_object(String name) {
        Entity entity;
        if (this.api.validator.checkObjectName(name) && Mapper.focus.has(entity = this.api.scene.get_entity(name))) {
            this.focusView.setEntity(entity);
            this.focusView.getFocus(name);
            if (this.focusView.getSet() != null) {
                Vector3Q pos = this.focusView.getAbsolutePosition(name, this.aux3b1);
                return pos.sub(GaiaSky.instance.getICamera().getPos()).lenDouble() * Constants.U_TO_KM;
            }
            return (this.focusView.getDistToCamera() - this.focusView.getRadius()) * Constants.U_TO_KM;
        }
        return -1.0;
    }

    @Override
    public void set_max_speed(int index) {
        if (this.api.validator.checkNum(index, 0, 21, "index")) {
            this.api.base.post_runnable(() -> this.em.post(Event.SPEED_LIMIT_CMD, this, index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set_tracking_object(String name) {
        if (name == null) {
            this.remove_tracking_object();
        } else if (this.api.validator.checkFocusName(name)) {
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                Entity trackingObject = this.api.scene.get_focus(name);
                this.em.post(Event.CAMERA_TRACKING_OBJECT_CMD, this, trackingObject, name);
            }
        } else {
            this.remove_tracking_object();
        }
    }

    @Override
    public void remove_tracking_object() {
        this.em.post(Event.CAMERA_TRACKING_OBJECT_CMD, this, null, null);
    }

    @Override
    public void set_orientation_lock(boolean lock) {
        this.api.base.post_runnable(() -> this.em.post(Event.ORIENTATION_LOCK_CMD, this, lock));
    }

    @Override
    public IFocus get_closest_object() {
        return GaiaSky.instance.cameraManager.getClosestBody();
    }

    @Override
    public void set_fov(float fov) {
        if (!SlaveManager.projectionActive() && this.api.validator.checkNum(fov, 1.0f, 150.0f, "newFov")) {
            this.api.base.post_runnable(() -> this.em.post(Event.FOV_CHANGED_CMD, this, Float.valueOf(fov)));
        }
    }

    public void set_fov(int newFov) {
        this.set_fov((float)newFov);
    }

    @Override
    public void transition_km(double[] pos, double[] dir, double[] up, double duration) {
        this.transition(pos, "km", dir, up, duration, true);
    }

    public void transition_km(List<?> camPos, List<?> camDir, List<?> camUp, double seconds) {
        this.transition_km(this.api.dArray(camPos), this.api.dArray(camDir), this.api.dArray(camUp), seconds);
    }

    public void transition_km(List<?> camPos, List<?> camDir, List<?> camUp, long seconds) {
        this.transition_km(camPos, camDir, camUp, (double)seconds);
    }

    @Override
    public void transition(double[] pos, double[] dir, double[] up, double duration) {
        this.transition(pos, "internal", dir, up, duration);
    }

    @Override
    public void transition(double[] pos, String units, double[] dir, double[] up, double duration) {
        this.transition(pos, units, dir, up, duration, true);
    }

    public void transition(double[] camPos, double[] camDir, double[] camUp, long seconds) {
        this.transition(camPos, "internal", camDir, camUp, seconds);
    }

    public void transition(double[] camPos, String units, double[] camDir, double[] camUp, long seconds) {
        this.transition(camPos, units, camDir, camUp, (double)seconds);
    }

    public void transition(List<?> camPos, List<?> camDir, List<?> camUp, double seconds) {
        this.transition(camPos, "internal", camDir, camUp, seconds);
    }

    public void transition(List<?> camPos, String units, List<?> camDir, List<?> camUp, double seconds) {
        this.transition(this.api.dArray(camPos), units, this.api.dArray(camDir), this.api.dArray(camUp), seconds);
    }

    public void transition(List<?> camPos, List<?> camDir, List<?> camUp, long seconds) {
        this.transition(camPos, "internal", camDir, camUp, seconds);
    }

    public void transition(List<?> camPos, String units, List<?> camDir, List<?> camUp, long seconds) {
        this.transition(this.api.dArray(camPos), units, this.api.dArray(camDir), this.api.dArray(camUp), seconds);
    }

    @Override
    public void transition(double[] pos, double[] dir, double[] camUp, double duration, boolean sync) {
        this.transition(pos, "internal", dir, camUp, duration, sync);
    }

    @Override
    public void transition(double[] pos, String units, double[] dir, double[] up, double duration, boolean sync) {
        this.transition(pos, units, dir, up, duration, "none", 0.0, duration, "none", 0.0, sync);
    }

    public void transition(List<?> camPos, List<?> camDir, List<?> camUp, double seconds, String positionSmoothType, double positionSmoothFactor, String orientationSmoothType, double orientationSmoothFactor) {
        this.transition(this.api.dArray(camPos), "internal", this.api.dArray(camDir), this.api.dArray(camUp), seconds, positionSmoothType, positionSmoothFactor, seconds, orientationSmoothType, orientationSmoothFactor, true);
    }

    @Override
    public void transition(double[] pos, double[] dir, double[] up, double pos_duration, String pos_smooth_type, double pos_smooth_factor, double ori_duration, String ori_smooth_type, double ori_smooth_factor) {
        this.transition(pos, "internal", dir, up, pos_duration, pos_smooth_type, pos_smooth_factor, ori_duration, ori_smooth_type, ori_smooth_factor, true);
    }

    public void transition(List<?> camPos, String units, List<?> camDir, List<?> camUp, double positionDurationSeconds, String positionSmoothType, double positionSmoothFactor, double orientationDurationSeconds, String orientationSmoothType, double orientationSmoothFactor, boolean sync) {
        this.transition(this.api.dArray(camPos), units, this.api.dArray(camDir), this.api.dArray(camUp), positionDurationSeconds, positionSmoothType, positionSmoothFactor, orientationDurationSeconds, orientationSmoothType, orientationSmoothFactor, sync);
    }

    @Override
    public void transition(double[] pos, String units, double[] dir, double[] up, double pos_duration, String pos_smooth_type, double pos_smooth_factor, double ori_duration, String ori_smooth_type, double ori_smooth_factor, boolean sync) {
        this.transition(pos, units, dir, up, pos_duration, pos_smooth_type, pos_smooth_factor, ori_duration, ori_smooth_type, ori_smooth_factor, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(double[] camPos, String units, double[] camDir, double[] camUp, double positionDurationSeconds, String positionSmoothType, double positionSmoothFactor, double orientationDurationSeconds, String orientationSmoothType, double orientationSmoothFactor, boolean sync, AtomicBoolean stop) {
        if (this.api.validator.checkDistanceUnits(units) && this.api.validator.checkSmoothType(positionSmoothType, "positionSmoothType") && this.api.validator.checkSmoothType(orientationSmoothType, "orientationSmoothType")) {
            NaturalCamera cam = GaiaSky.instance.cameraManager.naturalCamera;
            this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
            String name = "cameraTransition" + this.cTransSeq++;
            Runnable end = null;
            if (!sync) {
                end = () -> this.api.base.remove_runnable(name);
            }
            Settings.DistanceUnits u = Settings.DistanceUnits.valueOf(units.toUpperCase(Locale.ROOT));
            double[] finalPosition = new double[]{u.toInternalUnits(camPos[0]), u.toInternalUnits(camPos[1]), u.toInternalUnits(camPos[2])};
            CameraTransitionRunnable r = new CameraTransitionRunnable(cam, finalPosition, camDir, camUp, positionDurationSeconds, positionSmoothType, positionSmoothFactor, orientationDurationSeconds, orientationSmoothType, orientationSmoothFactor, end, stop);
            this.api.base.park_runnable(name, r);
            if (sync) {
                Object object = r.lock;
                synchronized (object) {
                    try {
                        r.lock.wait();
                    }
                    catch (InterruptedException e) {
                        this.logger.error(e);
                    }
                }
                this.api.base.remove_runnable(name);
            }
        }
    }

    @Override
    public void transition_position(double[] pos, String units, double duration, String smoothType, double smooth_factor, boolean sync) {
        this.transition_position(pos, units, duration, smoothType, smooth_factor, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition_position(double[] camPos, String units, double durationSeconds, String smoothType, double smoothFactor, boolean sync, AtomicBoolean stop) {
        if (this.api.validator.checkDistanceUnits(units) && this.api.validator.checkSmoothType(smoothType, "smoothType")) {
            NaturalCamera cam = GaiaSky.instance.cameraManager.naturalCamera;
            this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
            String name = "cameraTransition" + this.cTransSeq++;
            Runnable end = null;
            if (!sync) {
                end = () -> this.api.base.remove_runnable(name);
            }
            Settings.DistanceUnits u = Settings.DistanceUnits.valueOf(units.toUpperCase(Locale.ROOT));
            double[] posUnits = new double[]{u.toInternalUnits(camPos[0]), u.toInternalUnits(camPos[1]), u.toInternalUnits(camPos[2])};
            CameraTransitionRunnable r = new CameraTransitionRunnable(cam, posUnits, durationSeconds, smoothType, smoothFactor, end, stop);
            this.api.base.park_runnable(name, r);
            if (sync) {
                Object object = r.lock;
                synchronized (object) {
                    try {
                        r.lock.wait();
                    }
                    catch (InterruptedException e) {
                        this.logger.error(e);
                    }
                }
                this.api.base.remove_runnable(name);
            }
        }
    }

    @Override
    public void transition_orientation(double[] dir, double[] up, double duration, String smooth_type, double smooth_factor, boolean sync) {
        this.transition_orientation(dir, up, duration, smooth_type, smooth_factor, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition_orientation(double[] camDir, double[] camUp, double durationSeconds, String smoothType, double smoothFactor, boolean sync, AtomicBoolean stop) {
        if (this.api.validator.checkSmoothType(smoothType, "smoothType")) {
            NaturalCamera cam = GaiaSky.instance.cameraManager.naturalCamera;
            this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
            String name = "cameraTransition" + this.cTransSeq++;
            Runnable end = null;
            if (!sync) {
                end = () -> this.api.base.remove_runnable(name);
            }
            CameraTransitionRunnable r = new CameraTransitionRunnable(cam, camDir, camUp, durationSeconds, smoothType, smoothFactor, end, stop);
            this.api.base.park_runnable(name, r);
            if (sync) {
                Object object = r.lock;
                synchronized (object) {
                    try {
                        r.lock.wait();
                    }
                    catch (InterruptedException e) {
                        this.logger.error(e);
                    }
                }
                this.api.base.remove_runnable(name);
            }
        }
    }

    public void transition(List<?> camPos, List<?> camDir, List<?> camUp, double seconds, boolean sync) {
        this.transition(camPos, "internal", camDir, camUp, seconds, sync);
    }

    public void transition(List<?> camPos, String units, List<?> camDir, List<?> camUp, double seconds, boolean sync) {
        this.transition(this.api.dArray(camPos), units, this.api.dArray(camDir), this.api.dArray(camUp), seconds, sync);
    }

    public void transition(List<?> camPos, List<?> camDir, List<?> camUp, long seconds, boolean sync) {
        this.transition(camPos, "internal", camDir, camUp, seconds, sync);
    }

    public void transition(List<?> camPos, String units, List<?> camDir, List<?> camUp, long seconds, boolean sync) {
        this.transition(camPos, units, camDir, camUp, (double)seconds, sync);
    }

    public void transition_orientation(List<?> camDir, List<?> camUp, double durationSeconds, String smoothType, double smoothFactor, boolean sync) {
        this.transition_orientation(this.api.dArray(camDir), this.api.dArray(camUp), durationSeconds, smoothType, smoothFactor, sync);
    }

    public void transition_position(List<?> camPos, String units, double durationSeconds, String smoothType, double smoothFactor, boolean sync) {
        this.transition_position(this.api.dArray(camPos), units, durationSeconds, smoothType, smoothFactor, sync);
    }

    @Override
    public void dispose() {
        this.interactive.dispose();
        super.dispose();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (Objects.requireNonNull(event) == Event.SCENE_LOADED) {
            this.scene = (Scene)data[0];
            this.focusView.setScene(this.scene);
            this.interactive.scene = this.scene;
            this.interactive.focusView.setScene(this.scene);
        }
    }

    static class CameraTransitionRunnable
    implements Runnable {
        final Object lock;
        final Vector3D v3d1;
        final Vector3D v3d2;
        final Vector3D v3d3;
        final Vector3D aux3d3 = new Vector3D();
        final AtomicBoolean stop;
        NaturalCamera cam;
        double posDuration;
        double orientationDuration;
        double elapsed;
        double start;
        Vector3D targetDir;
        Vector3D targetUp;
        PathDouble<Vector3D> posInterpolator;
        QuaternionDouble startOrientation;
        QuaternionDouble endOrientation;
        QuaternionDouble qd;
        Runnable end;
        Function<Double, Double> positionMapper;
        Function<Double, Double> orientationMapper;
        final TransitionType type;

        public CameraTransitionRunnable(NaturalCamera cam, double[] pos, double[] dir, double[] up, double seconds, Runnable end, AtomicBoolean stop) {
            this(cam, pos, dir, up, seconds, "", 0.0, seconds, "", 0.0, end, stop);
        }

        public CameraTransitionRunnable(NaturalCamera cam, double[] dir, double[] up, double durationSeconds, String smoothType, double smoothFactor, Runnable end, AtomicBoolean stop) {
            this(cam, null, dir, up, -1.0, null, -1.0, durationSeconds, smoothType, smoothFactor, end, stop);
        }

        public CameraTransitionRunnable(NaturalCamera cam, double[] pos, double durationSeconds, String smoothType, double smoothFactor, Runnable end, AtomicBoolean stop) {
            this(cam, pos, null, null, durationSeconds, smoothType, smoothFactor, -1.0, null, -1.0, end, stop);
        }

        public CameraTransitionRunnable(NaturalCamera cam, double[] pos, double[] dir, double[] up, double positionDurationSeconds, String positionSmoothType, double positionSmoothFactor, double orientationDurationSeconds, String orientationSmoothType, double orientationSmoothFactor, Runnable end, AtomicBoolean stop) {
            this.type = pos == null ? TransitionType.ORIENTATION : (dir == null || up == null ? TransitionType.POSITION : TransitionType.ALL);
            this.cam = cam;
            if (this.type.isPosition() && pos != null) {
                this.posDuration = positionDurationSeconds;
            }
            if (this.type.isOrientation() && dir != null && up != null) {
                this.targetDir = new Vector3D(dir).nor();
                this.targetUp = new Vector3D(up).nor();
                this.orientationDuration = orientationDurationSeconds;
            }
            this.start = GaiaSky.instance.getT();
            this.elapsed = 0.0;
            this.end = end;
            this.lock = new Object();
            this.stop = stop;
            if (this.type.isPosition()) {
                String posType = positionSmoothType.toLowerCase(Locale.ROOT).strip();
                this.positionMapper = this.getMapper(posType, positionSmoothFactor);
                this.posInterpolator = this.getPath(cam.getPos().tov3d(this.aux3d3), pos);
            }
            if (this.type.isOrientation()) {
                String orientationType = orientationSmoothType.toLowerCase(Locale.ROOT).strip();
                this.orientationMapper = this.getMapper(orientationType, orientationSmoothFactor);
                this.startOrientation = new QuaternionDouble();
                this.startOrientation.setFromCamera(cam.direction, cam.up);
                this.endOrientation = new QuaternionDouble();
                this.endOrientation.setFromCamera(this.targetDir, this.targetUp);
            }
            this.v3d1 = new Vector3D();
            this.v3d2 = new Vector3D();
            this.v3d3 = new Vector3D();
            this.qd = new QuaternionDouble();
        }

        private Function<Double, Double> getMapper(String smoothingType, double smoothingFactor) {
            Function<Double, Double> mapper;
            if (Objects.equals(smoothingType, "logisticsigmoid")) {
                double fac = MathUtilsDouble.clamp(smoothingFactor, 12.0, 500.0);
                mapper = x -> MathUtilsDouble.clamp(MathUtilsDouble.logisticSigmoid(x, fac), 0.0, 1.0);
            } else if (Objects.equals(smoothingType, "logit")) {
                double fac = MathUtilsDouble.clamp(smoothingFactor, 0.01, 0.09);
                mapper = x -> MathUtilsDouble.clamp(MathUtilsDouble.logit(x) * fac + 0.5, 0.0, 1.0);
            } else {
                mapper = x -> x;
            }
            return mapper;
        }

        private PathDouble<Vector3D> getPath(Vector3D p0, double[] p1) {
            VectorDouble[] points = new Vector3D[]{new Vector3D(p0), new Vector3D(p1)};
            return new LinearDouble(points);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.elapsed = GaiaSky.instance.getT() - this.start;
            if (this.type.isPosition()) {
                double alphaPos = MathUtilsDouble.clamp(this.elapsed / this.posDuration, 0.0, 1.0);
                this.cam.setPos(this.posInterpolator.valueAt(this.v3d1, this.positionMapper.apply(alphaPos)));
            }
            if (this.type.isOrientation()) {
                double alphaOrientation = MathUtilsDouble.clamp(this.elapsed / this.orientationDuration, 0.0, 1.0);
                this.qd.set(this.startOrientation).slerp(this.endOrientation, this.orientationMapper.apply(alphaOrientation));
                Vector3D up = this.qd.getUp(this.v3d3);
                this.cam.setUp(up);
                Vector3D direction = this.qd.getDirection(this.v3d3);
                this.cam.setDirection(this.v3d3);
            }
            if (this.stop != null && this.stop.get() || this.elapsed >= this.posDuration && this.elapsed >= this.orientationDuration) {
                if (this.end != null) {
                    this.end.run();
                } else {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notify();
                    }
                }
            }
        }
    }

    static enum TransitionType {
        POSITION,
        ORIENTATION,
        ALL;


        public boolean isPosition() {
            return this == ALL || this == POSITION;
        }

        public boolean isOrientation() {
            return this == ALL || this == ORIENTATION;
        }

        public boolean isAll() {
            return this == ALL;
        }
    }
}

