/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.GaiaSky;
import gaiasky.data.SceneJsonLoader;
import gaiasky.data.StarClusterLoader;
import gaiasky.data.group.DatasetOptions;
import gaiasky.data.group.STILDataProvider;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.window.ColormapPicker;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.entity.SetUtils;
import gaiasky.scene.view.FocusView;
import gaiasky.script.v2.api.DataAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.filter.attrib.AttributeUCD;
import gaiasky.util.filter.attrib.IAttribute;
import gaiasky.util.i18n.I18n;
import gaiasky.util.ucd.UCD;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.jafama.FastMath;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public class DataModule
extends APIModule
implements IObserver,
DataAPI {
    private Scene scene;
    private final FocusView focusView = new FocusView();

    public DataModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
        em.subscribe((IObserver)this, Event.SCENE_LOADED);
    }

    @Override
    public String get_datasets_directory() {
        return Settings.settings.data.location;
    }

    @Override
    public boolean load_dataset(String name, String absolutePath) {
        return this.load_dataset(name, absolutePath, CatalogInfo.CatalogInfoSource.SCRIPT, true);
    }

    @Override
    public boolean load_dataset(String name, String path, boolean sync) {
        return this.load_dataset(name, path, CatalogInfo.CatalogInfoSource.SCRIPT, sync);
    }

    public boolean load_dataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, boolean sync) {
        if (sync) {
            return this.loadDatasetImmediate(dsName, path, type, true);
        }
        Thread t = new Thread(() -> this.loadDatasetImmediate(dsName, path, type, false));
        t.start();
        return true;
    }

    @Override
    public boolean load_dataset(String name, String path, CatalogInfo.CatalogInfoSource type, DatasetOptions datasetOptions, boolean sync) {
        if (sync) {
            return this.loadDatasetImmediate(name, path, type, datasetOptions, true);
        }
        Thread t = new Thread(() -> this.loadDatasetImmediate(name, path, type, datasetOptions, false));
        t.start();
        return true;
    }

    public boolean load_dataset(String dsName, DataSource ds, CatalogInfo.CatalogInfoSource type, DatasetOptions datasetOptions, boolean sync) {
        if (sync) {
            return this.loadDatasetImmediate(dsName, ds, type, datasetOptions, true);
        }
        Thread t = new Thread(() -> this.loadDatasetImmediate(dsName, ds, type, datasetOptions, false));
        t.start();
        return true;
    }

    @Override
    public boolean load_star_dataset(String name, String path, boolean sync) {
        return this.load_star_dataset(name, path, CatalogInfo.CatalogInfoSource.SCRIPT, 1.0, new double[]{0.0, 0.0, 0.0, 0.0}, null, null, sync);
    }

    @Override
    public boolean load_star_dataset(String name, String path, double factor, boolean sync) {
        return this.load_star_dataset(name, path, CatalogInfo.CatalogInfoSource.SCRIPT, factor, new double[]{0.0, 0.0, 0.0, 0.0}, null, null, sync);
    }

    @Override
    public boolean load_star_dataset(String name, String path, double factor, double[] label_color, boolean sync) {
        return this.load_star_dataset(name, path, CatalogInfo.CatalogInfoSource.SCRIPT, factor, label_color, null, null, sync);
    }

    public boolean load_star_dataset(String dsName, String path, double magnitudeScale, List<?> labelColor, boolean sync) {
        return this.load_star_dataset(dsName, path, magnitudeScale, this.api.dArray(labelColor), sync);
    }

    @Override
    public boolean load_star_dataset(String name, String path, double factor, double[] label_color, double[] fadein, double[] fadeout, boolean sync) {
        return this.load_star_dataset(name, path, CatalogInfo.CatalogInfoSource.SCRIPT, factor, label_color, fadein, fadeout, sync);
    }

    public boolean load_star_dataset(String dsName, String path, double magnitudeScale, List<?> labelColor, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.load_star_dataset(dsName, path, magnitudeScale, this.api.dArray(labelColor), this.api.dArray(fadeIn), this.api.dArray(fadeOut), sync);
    }

    public boolean load_star_dataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, double magnitudeScale, double[] labelColor, double[] fadeIn, double[] fadeOut, boolean sync) {
        DatasetOptions datasetOptions = DatasetOptions.getStarDatasetOptions(dsName, magnitudeScale, labelColor, fadeIn, fadeOut);
        return this.load_dataset(dsName, path, type, datasetOptions, sync);
    }

    @Override
    public boolean load_particle_dataset(String name, String path, double decay, double[] color, double noise, double[] label_color, double size, String ct, boolean sync) {
        return this.load_particle_dataset(name, path, decay, color, noise, label_color, size, new double[]{1.5, 100.0}, ct, null, null, sync);
    }

    public boolean load_particle_dataset(String dsName, String path, double profileDecay, List<?> particleColor, double colorNoise, List<?> labelColor, double particleSize, String ct, boolean sync) {
        return this.load_particle_dataset(dsName, path, profileDecay, this.api.dArray(particleColor), colorNoise, this.api.dArray(labelColor), particleSize, ct, null, null, sync);
    }

    @Override
    public boolean load_particle_dataset(String name, String path, double decay, double[] color, double noise, double[] label_color, double size, String ct, double[] fadein, double[] fadeout, boolean sync) {
        return this.load_particle_dataset(name, path, decay, color, noise, label_color, size, new double[]{Math.tan(Math.toRadians(0.1)), FastMath.tan((double)Math.toRadians(3.0))}, ct, fadein, fadeout, sync);
    }

    public boolean load_particle_dataset(String dsName, String path, double profileDecay, List<?> particleColor, double colorNoise, List<?> labelColor, double particleSize, String ct, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.load_particle_dataset(dsName, path, profileDecay, this.api.dArray(particleColor), colorNoise, this.api.dArray(labelColor), particleSize, ct, this.api.dArray(fadeIn), this.api.dArray(fadeOut), sync);
    }

    @Override
    public boolean load_particle_dataset(String name, String path, double decay, double[] color, double noise, double[] label_color, double size, double[] size_limits, String ct, double[] fadein, double[] fadeout, boolean sync) {
        ComponentTypes.ComponentType compType = ComponentTypes.ComponentType.valueOf(ct);
        return this.load_particle_dataset(name, path, decay, color, noise, label_color, size, size_limits, compType, fadein, fadeout, sync);
    }

    public boolean load_particle_dataset(String dsName, String path, double profileDecay, List<?> particleColor, double colorNoise, List<?> labelColor, double particleSize, List<?> sizeLimits, String ct, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.load_particle_dataset(dsName, path, profileDecay, this.api.dArray(particleColor), colorNoise, this.api.dArray(labelColor), particleSize, this.api.dArray(sizeLimits), ct, this.api.dArray(fadeIn), this.api.dArray(fadeOut), sync);
    }

    public boolean load_particle_dataset(String dsName, String path, double profileDecay, double[] particleColor, double colorNoise, double[] labelColor, double particleSize, double[] sizeLimits, ComponentTypes.ComponentType ct, double[] fadeIn, double[] fadeOut, boolean sync) {
        return this.load_particle_dataset(dsName, path, CatalogInfo.CatalogInfoSource.SCRIPT, profileDecay, particleColor, colorNoise, labelColor, particleSize, sizeLimits, ct, fadeIn, fadeOut, sync);
    }

    public boolean load_particle_dataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, double profileDecay, double[] particleColor, double colorNoise, double[] labelColor, double particleSize, double[] sizeLimits, ComponentTypes.ComponentType ct, double[] fadeIn, double[] fadeOut, boolean sync) {
        DatasetOptions datasetOptions = DatasetOptions.getParticleDatasetOptions(dsName, profileDecay, particleColor, colorNoise, labelColor, particleSize, sizeLimits, ct, fadeIn, fadeOut);
        return this.load_dataset(dsName, path, type, datasetOptions, sync);
    }

    @Override
    public boolean load_star_cluster_dataset(String name, String path, double[] particleColor, double[] fadein, double[] fadeout, boolean sync) {
        return this.load_star_cluster_dataset(name, path, particleColor, ComponentTypes.ComponentType.Clusters.toString(), fadein, fadeout, sync);
    }

    public boolean load_star_cluster_dataset(String dsName, String path, List<?> particleColor, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.load_star_cluster_dataset(dsName, path, this.api.dArray(particleColor), this.api.dArray(fadeIn), this.api.dArray(fadeOut), sync);
    }

    @Override
    public boolean load_star_cluster_dataset(String name, String path, double[] color, double[] label_color, double[] fadein, double[] fadeout, boolean sync) {
        return this.load_star_cluster_dataset(name, path, color, label_color, ComponentTypes.ComponentType.Clusters.toString(), fadein, fadeout, sync);
    }

    public boolean load_star_cluster_dataset(String dsName, String path, List<?> particleColor, List<?> labelColor, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.load_star_cluster_dataset(dsName, path, this.api.dArray(particleColor), this.api.dArray(labelColor), this.api.dArray(fadeIn), this.api.dArray(fadeOut), sync);
    }

    @Override
    public boolean load_star_cluster_dataset(String name, String path, double[] color, String ct, double[] fadein, double[] fadeout, boolean sync) {
        ComponentTypes.ComponentType compType = ComponentTypes.ComponentType.valueOf(ct);
        DatasetOptions datasetOptions = DatasetOptions.getStarClusterDatasetOptions(name, color, (double[])color.clone(), compType, fadein, fadeout);
        return this.load_dataset(name, path, CatalogInfo.CatalogInfoSource.SCRIPT, datasetOptions, sync);
    }

    public boolean load_star_cluster_dataset(String dsName, String path, List<?> particleColor, String ct, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.load_star_cluster_dataset(dsName, path, this.api.dArray(particleColor), ct, this.api.dArray(fadeIn), this.api.dArray(fadeOut), sync);
    }

    @Override
    public boolean load_star_cluster_dataset(String name, String path, double[] color, double[] label_color, String ct, double[] fadein, double[] fadeout, boolean sync) {
        ComponentTypes.ComponentType compType = ComponentTypes.ComponentType.valueOf(ct);
        DatasetOptions datasetOptions = DatasetOptions.getStarClusterDatasetOptions(name, color, label_color, compType, fadein, fadeout);
        return this.load_dataset(name, path, CatalogInfo.CatalogInfoSource.SCRIPT, datasetOptions, sync);
    }

    @Override
    public boolean load_variable_star_dataset(String name, String path, double factor, double[] label_color, double[] fadein, double[] fadeout, boolean sync) {
        return this.load_variable_star_dataset(name, path, CatalogInfo.CatalogInfoSource.SCRIPT, factor, label_color, fadein, fadeout, sync);
    }

    public boolean load_variable_star_dataset(String dsName, String path, CatalogInfo.CatalogInfoSource type, double magnitudeScale, double[] labelColor, double[] fadeIn, double[] fadeOut, boolean sync) {
        DatasetOptions datasetOptions = DatasetOptions.getVariableStarDatasetOptions(dsName, magnitudeScale, labelColor, ComponentTypes.ComponentType.Stars, fadeIn, fadeOut);
        return this.load_dataset(dsName, path, type, datasetOptions, sync);
    }

    public boolean load_star_cluster_dataset(String dsName, String path, List<?> particleColor, List<?> labelColor, String ct, List<?> fadeIn, List<?> fadeOut, boolean sync) {
        return this.load_star_cluster_dataset(dsName, path, this.api.dArray(particleColor), this.api.dArray(labelColor), ct, this.api.dArray(fadeIn), this.api.dArray(fadeOut), sync);
    }

    private boolean loadDatasetImmediate(String dsName, String path, CatalogInfo.CatalogInfoSource type, boolean sync) {
        return this.loadDatasetImmediate(dsName, path, type, null, sync);
    }

    private boolean loadDatasetImmediate(String dsName, String path, CatalogInfo.CatalogInfoSource type, DatasetOptions datasetOptions, boolean sync) {
        Path p = Paths.get(path, new String[0]);
        if (Files.exists(p, new LinkOption[0]) && Files.isReadable(p)) {
            try {
                return this.loadDatasetImmediate(dsName, (DataSource)new FileDataSource(p.toFile()), type, datasetOptions, sync);
            }
            catch (Exception e) {
                this.logger.error("Error loading file: " + String.valueOf(p), e);
            }
        } else {
            this.logger.error("Can't read file: " + path);
        }
        return false;
    }

    private List<IParticleRecord> loadParticleBeans(DataSource ds, DatasetOptions opts, STILDataProvider provider) {
        provider.setDatasetOptions(opts);
        String catalogName = opts != null && opts.catalogName != null ? opts.catalogName : ds.getName();
        return provider.loadData(ds, 1.0, () -> EventManager.publish(Event.UPDATE_LOAD_PROGRESS, this, catalogName, Float.valueOf(0.01f)), (current, count) -> {
            EventManager.publish(Event.UPDATE_LOAD_PROGRESS, this, catalogName, Float.valueOf((float)current.longValue() / (float)count.longValue()));
            if (current % 250000L == 0L) {
                this.logger.info(current + " objects loaded...");
            }
        }, () -> EventManager.publish(Event.UPDATE_LOAD_PROGRESS, this, catalogName, Float.valueOf(2.0f)));
    }

    @Override
    public boolean load_json_dataset(String name, String path) {
        return this.load_json_dataset(name, path, true);
    }

    @Override
    public boolean load_json_dataset(String name, String pathString, boolean sync) {
        return this.load_json_dataset(name, pathString, false, sync);
    }

    @Override
    public boolean load_json_dataset(String name, String pathString, boolean select, boolean sync) {
        try {
            this.logger.info(I18n.msg("notif.catalog.loading", pathString));
            Array<Entity> objects = SceneJsonLoader.loadJsonFile(Gdx.files.absolute(pathString), this.scene);
            int i = 0;
            for (Entity e : objects) {
                if (e == null) {
                    this.logger.error("Entity is null: " + i);
                }
                ++i;
            }
            this.logger.info(I18n.msg("notif.catalog.loaded", objects.size, I18n.msg("gui.objects")));
            if (objects.size > 0) {
                this.api.base.post_runnable(() -> {
                    objects.forEach(arg_0 -> ((Engine)this.scene.engine).addEntity(arg_0));
                    objects.forEach(this.scene::initializeEntity);
                    objects.forEach(this.scene::addToIndex);
                    GaiaSky.instance.getExecutorService().execute(() -> {
                        while (!GaiaSky.instance.assetManager.isFinished()) {
                            this.api.base.sleep_frames(1L);
                        }
                        this.api.base.post_runnable(() -> {
                            objects.forEach(entity -> EventManager.publish(Event.SCENE_ADD_OBJECT_NO_POST_CMD, this, entity, false));
                            objects.forEach(this.scene::setUpEntity);
                            GaiaSky.instance.touchSceneGraph();
                            if (select) {
                                this.focusView.setEntity((Entity)objects.get(0));
                                this.api.camera.focus_mode(this.focusView.getName());
                            }
                        });
                    });
                });
            }
        }
        catch (Exception e) {
            this.notifyErrorPopup(I18n.msg("error.loading.format", pathString), e);
            return false;
        }
        return true;
    }

    private boolean loadDatasetImmediate(String name, DataSource ds, CatalogInfo.CatalogInfoSource type, DatasetOptions opts, boolean sync) {
        try {
            this.logger.info(I18n.msg("notif.catalog.loading", name));
            if (this.api.validator.checkString(name, "datasetName") && !this.api.catalogManager.contains(name)) {
                Path path = null;
                if (ds instanceof FileDataSource) {
                    File file = ((FileDataSource)ds).getFile();
                    path = file.toPath();
                    String pathString = file.getAbsolutePath();
                    if (!Files.exists(file.toPath(), new LinkOption[0])) {
                        this.notifyErrorPopup(I18n.msg("error.loading.notexistent", pathString));
                        return false;
                    }
                    if (!Files.isReadable(path)) {
                        this.notifyErrorPopup(I18n.msg("error.file.read", pathString));
                        return false;
                    }
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        this.notifyErrorPopup(I18n.msg("error.file.isdir", pathString));
                        return false;
                    }
                }
                if (path != null && path.getFileName().toString().endsWith(".json")) {
                    this.load_json_dataset(name, path.toString(), sync);
                } else if (opts == null || opts.type == DatasetOptions.DatasetLoadType.STARS || opts.type == DatasetOptions.DatasetLoadType.VARIABLES) {
                    provider = new STILDataProvider();
                    data = this.loadParticleBeans(ds, opts, provider);
                    if (data != null && !data.isEmpty()) {
                        AtomicReference starGroup = new AtomicReference();
                        this.api.base.post_runnable(() -> {
                            if (opts != null) {
                                opts.initializeCatalogInfo = false;
                            }
                            starGroup.set(SetUtils.createStarSet(this.scene, name, ds.getName(), data, provider.getColumnInfoList(), opts, false));
                            new CatalogInfo(name, ds.getName(), null, type, 1.5f, (Entity)starGroup.get());
                            EventManager.publish(Event.SCENE_ADD_OBJECT_CMD, this, starGroup.get(), true);
                            this.scene.initializeEntity((Entity)starGroup.get());
                            this.scene.setUpEntity((Entity)starGroup.get());
                            String typeStr = opts == null || opts.type == DatasetOptions.DatasetLoadType.STARS ? I18n.msg("gui.dsload.stars.name") : I18n.msg("gui.dsload.variablestars.name");
                            this.logger.info(I18n.msg("notif.catalog.loaded", data.size(), typeStr));
                            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, name + ": " + I18n.msg("notif.catalog.loaded", data.size(), typeStr));
                        });
                        while (sync && (starGroup.get() == null || ((GraphNode)Mapper.graph.get((Entity)((Entity)starGroup.get()))).parent != null)) {
                            this.api.base.sleep_frames(1L);
                        }
                    }
                } else if (opts.type == DatasetOptions.DatasetLoadType.PARTICLES) {
                    provider = new STILDataProvider();
                    data = this.loadParticleBeans(ds, opts, provider);
                    if (data != null && !data.isEmpty()) {
                        AtomicReference particleGroup = new AtomicReference();
                        this.api.base.post_runnable(() -> {
                            opts.initializeCatalogInfo = false;
                            particleGroup.set(SetUtils.createParticleSet(this.scene, name, ds.getName(), data, provider.getColumnInfoList(), opts, false));
                            CatalogInfo ci = new CatalogInfo(name, ds.getName(), ds.getURL().toString(), type, 1.5f, (Entity)particleGroup.get());
                            EventManager.publish(Event.SCENE_ADD_OBJECT_CMD, this, ci.entity, true);
                            this.scene.setUpEntity((Entity)particleGroup.get());
                            String typeStr = I18n.msg("gui.dsload.objects.name");
                            this.logger.info(I18n.msg("notif.catalog.loaded", data.size(), typeStr));
                            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, name + ": " + I18n.msg("notif.catalog.loaded", data.size(), typeStr));
                        });
                        while (sync && (particleGroup.get() == null || ((GraphNode)Mapper.graph.get((Entity)((Entity)particleGroup.get()))).parent != null)) {
                            this.api.base.sleep_frames(1L);
                        }
                    }
                } else if (opts.type == DatasetOptions.DatasetLoadType.PARTICLES_EXT) {
                    provider = new STILDataProvider();
                    data = this.loadParticleBeans(ds, opts, provider);
                    if (data != null && !data.isEmpty()) {
                        AtomicReference particleGroup = new AtomicReference();
                        this.api.base.post_runnable(() -> {
                            opts.initializeCatalogInfo = false;
                            particleGroup.set(SetUtils.createParticleSet(this.scene, name, ds.getName(), data, provider.getColumnInfoList(), opts, false));
                            CatalogInfo ci = new CatalogInfo(name, ds.getName(), ds.getURL().toString(), type, 1.5f, (Entity)particleGroup.get());
                            EventManager.publish(Event.SCENE_ADD_OBJECT_CMD, this, ci.entity, true);
                            this.scene.setUpEntity((Entity)particleGroup.get());
                            String typeStr = I18n.msg("gui.dsload.objects.name");
                            this.logger.info(I18n.msg("notif.catalog.loaded", data.size(), typeStr));
                            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, name + ": " + I18n.msg("notif.catalog.loaded", data.size(), typeStr));
                        });
                        while (sync && (particleGroup.get() == null || ((GraphNode)Mapper.graph.get((Entity)((Entity)particleGroup.get()))).parent != null)) {
                            this.api.base.sleep_frames(1L);
                        }
                    }
                } else if (opts.type == DatasetOptions.DatasetLoadType.CLUSTERS) {
                    int loaded;
                    Archetype archetype = this.scene.archetypes().get("GenericCatalog");
                    Entity entity = archetype.createEntity();
                    Base base = (Base)Mapper.base.get(entity);
                    base.setName(name);
                    base.setCt(opts.ct.toString());
                    Body body = (Body)Mapper.body.get(entity);
                    body.setColor(opts.particleColor);
                    body.setLabelColor(opts.labelColor);
                    body.setPosition(new double[]{0.0, 0.0, 0.0});
                    Fade fade = (Fade)Mapper.fade.get(entity);
                    fade.setFadeIn(opts.fadeIn);
                    fade.setFadeOut(opts.fadeOut);
                    GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                    graph.setParent("Universe");
                    AtomicInteger numLoaded = new AtomicInteger(-5);
                    this.api.base.post_runnable(() -> {
                        StarClusterLoader scl = new StarClusterLoader();
                        scl.initialize(ds, this.scene);
                        scl.setParentName(name);
                        scl.loadData();
                        Array<Entity> clusters = scl.getClusters();
                        numLoaded.set(clusters.size);
                        if (!clusters.isEmpty()) {
                            this.scene.initializeEntity(entity);
                            for (Entity cluster : clusters) {
                                this.scene.initializeEntity(cluster);
                                Body cBody = (Body)Mapper.body.get(cluster);
                                cBody.setColor(opts.particleColor);
                                cBody.setLabelColor(opts.labelColor);
                            }
                            this.scene.insert(entity, true);
                            for (Entity cluster : clusters) {
                                this.scene.insert(cluster, true);
                            }
                            this.scene.setUpEntity(entity);
                            for (Entity cluster : clusters) {
                                this.scene.setUpEntity(cluster);
                            }
                            String typeStr = I18n.msg("gui.dsload.clusters.name");
                            this.logger.info(I18n.msg("notif.catalog.loaded", graph.children.size, typeStr));
                            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, name + ": " + I18n.msg("notif.catalog.loaded", graph.children.size, typeStr));
                        }
                    });
                    while (sync && graph.parent == null && (loaded = numLoaded.get()) != 0) {
                        this.api.base.sleep_frames(1L);
                    }
                }
                this.api.base.sleep_frames(1L);
                return true;
            }
            this.logger.error(name + ": invalid or already existing dataset name");
            return false;
        }
        catch (Exception e) {
            this.logger.error(e);
            return false;
        }
    }

    @Override
    public boolean dataset_exists(String name) {
        return this.api.validator.checkString(name, "datasetName") && this.api.validator.checkDatasetName(name);
    }

    @Override
    public boolean set_dataset_transform_matrix(String name, double[] matrix) {
        CatalogInfo ci;
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkDatasetName(name) && this.api.validator.checkNotNull(matrix, "matrix") && (ci = this.api.catalogManager.get(name)) != null && ci.entity != null) {
            AffineTransformations affine = (AffineTransformations)Mapper.affine.get(ci.entity);
            if (affine != null) {
                affine.clear();
                affine.setMatrix(matrix);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean clear_dataset_transform_matrix(String name) {
        AffineTransformations affine;
        CatalogInfo ci;
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkDatasetName(name) && (ci = this.api.catalogManager.get(name)) != null && ci.entity != null && (affine = (AffineTransformations)Mapper.affine.get(ci.entity)) != null) {
            affine.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove_dataset(String name) {
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkDatasetName(name)) {
            this.api.base.post_runnable(() -> EventManager.publish(Event.CATALOG_REMOVE, this, name));
            return true;
        }
        return false;
    }

    @Override
    public boolean hide_dataset(String name) {
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkDatasetName(name)) {
            this.api.base.post_runnable(() -> EventManager.publish(Event.CATALOG_VISIBLE, this, name, false));
            return true;
        }
        return false;
    }

    @Override
    public boolean show_dataset(String name) {
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkDatasetName(name)) {
            this.api.base.post_runnable(() -> EventManager.publish(Event.CATALOG_VISIBLE, this, name, true));
            return true;
        }
        return false;
    }

    @Override
    public boolean highlight_dataset(String name, boolean highlight) {
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkDatasetName(name)) {
            CatalogInfo ci = this.api.catalogManager.get(name);
            this.api.base.post_runnable(() -> EventManager.publish(Event.CATALOG_HIGHLIGHT, this, ci, highlight));
            return true;
        }
        return false;
    }

    @Override
    public boolean highlight_dataset(String name, int color_idx, boolean highlight) {
        float[] color = ColorUtils.getColorFromIndex(color_idx);
        return this.highlight_dataset(name, color, highlight);
    }

    @Override
    public boolean highlight_dataset(String name, float[] color, boolean highlight) {
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkLength(color, 4, "color") && this.api.validator.checkDatasetName(name)) {
            CatalogInfo ci = this.api.catalogManager.get(name);
            ci.plainColor = true;
            ci.hlColor[0] = color[0];
            ci.hlColor[1] = color[1];
            ci.hlColor[2] = color[2];
            ci.hlColor[3] = color[3];
            this.api.base.post_runnable(() -> EventManager.publish(Event.CATALOG_HIGHLIGHT, this, ci, highlight));
            return true;
        }
        return false;
    }

    @Override
    public boolean highlight_dataset(String name, String attr_name, String colmap, double min, double max, boolean highlight) {
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkDatasetName(name)) {
            CatalogInfo ci = this.api.catalogManager.get(name);
            IAttribute attribute = this.getAttributeByName(attr_name, ci);
            int cmapIndex = this.getCmapIndexByName(colmap);
            if (attribute != null && cmapIndex >= 0) {
                ci.plainColor = false;
                ci.hlCmapIndex = cmapIndex;
                ci.hlCmapMin = min;
                ci.hlCmapMax = max;
                ci.hlCmapAttribute = attribute;
                this.api.base.post_runnable(() -> EventManager.publish(Event.CATALOG_HIGHLIGHT, this, ci, highlight));
            } else {
                if (attribute == null) {
                    this.logger.error("Could not find attribute with name '" + attr_name + "'");
                }
                if (cmapIndex < 0) {
                    this.logger.error("Could not find color map with name '" + colmap + "'");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean set_dataset_highlight_size_factor(String name, float factor) {
        if (this.api.validator.checkString(name, "datasetName") && this.api.validator.checkNum(factor, 0.01f, 100.0f, "sizeFactor")) {
            boolean exists = this.api.catalogManager.contains(name);
            if (exists) {
                CatalogInfo ci = this.api.catalogManager.get(name);
                ci.setHlSizeFactor(factor);
            } else {
                this.logger.warn("Dataset with name " + name + " does not exist");
            }
            return exists;
        }
        return false;
    }

    @Override
    public boolean set_dataset_highlight_all_visible(String name, boolean visible) {
        if (this.api.validator.checkString(name, "datasetName")) {
            boolean exists = this.api.catalogManager.contains(name);
            if (exists) {
                CatalogInfo ci = this.api.catalogManager.get(name);
                ci.setHlAllVisible(visible);
            } else {
                this.logger.warn("Dataset with name " + name + " does not exist");
            }
            return exists;
        }
        return false;
    }

    @Override
    public void set_dataset_point_size_factor(String name, double multiplier) {
        if (this.api.validator.checkString(name, "datasetName")) {
            boolean exists = this.api.catalogManager.contains(name);
            if (exists) {
                this.em.post(Event.CATALOG_POINT_SIZE_SCALING_CMD, this, name, multiplier);
            } else {
                this.logger.warn("Catalog does not exist: " + name);
            }
        }
    }

    private void notifyErrorPopup(String message) {
        this.notifyErrorPopup(message, null);
    }

    private void notifyErrorPopup(String message, Exception e) {
        if (e != null) {
            this.logger.error(message, e);
        } else {
            this.logger.error(message);
        }
        EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, message);
    }

    @Override
    public List<String> list_datasets() {
        Set<String> names = this.api.catalogManager.getDatasetNames();
        if (names != null) {
            return new ArrayList<String>(names);
        }
        return new ArrayList<String>();
    }

    private int getCmapIndexByName(String name) {
        for (Pair cmap : ColormapPicker.cmapList) {
            if (!name.equalsIgnoreCase((String)cmap.getFirst())) continue;
            return (Integer)cmap.getSecond();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAttribute getAttributeByName(String name, CatalogInfo ci) {
        try {
            Class<?> clazz = Class.forName("gaiasky.util.filter.attrib.Attribute" + name);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (IAttribute)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (ci.entity != null) {
                Entity entity = ci.entity;
                FocusView focusView = this.focusView;
                synchronized (focusView) {
                    this.focusView.setEntity(entity);
                    if (this.focusView.isSet()) {
                        ObjectMap.Keys<UCD> ucds = this.focusView.getSet().data().getFirst().extraKeys();
                        for (UCD ucd : ucds) {
                            if (!ucd.colName.equalsIgnoreCase(name)) continue;
                            return new AttributeUCD(ucd);
                        }
                    }
                }
            }
            return null;
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (Objects.requireNonNull(event) == Event.SCENE_LOADED) {
            this.scene = (Scene)data[0];
            this.focusView.setScene(this.scene);
        }
    }
}

