/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.postprocess.effects.CubmeapProjectionEffect;
import gaiasky.script.v2.api.GraphicsAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Settings;
import gaiasky.util.math.MathUtilsDouble;
import java.util.Locale;

public class GraphicsModule
extends APIModule
implements GraphicsAPI {
    public GraphicsModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    @Override
    public void set_image_brightness(double level) {
        if (this.api.validator.checkNum(level, -1.0, 1.0, "brightness")) {
            this.api.base.post_runnable(() -> this.em.post(Event.BRIGHTNESS_CMD, this, Float.valueOf((float)level)));
        }
    }

    public void set_image_brightness(long level) {
        this.set_image_brightness((double)level);
    }

    @Override
    public void set_image_contrast(double level) {
        if (this.api.validator.checkNum(level, 0.0, 2.0, "contrast")) {
            this.api.base.post_runnable(() -> this.em.post(Event.CONTRAST_CMD, this, Float.valueOf((float)level)));
        }
    }

    public void set_image_contrast(long level) {
        this.set_image_contrast((double)level);
    }

    @Override
    public void set_image_hue(double level) {
        if (this.api.validator.checkNum(level, 0.0, 2.0, "hue")) {
            this.api.base.post_runnable(() -> this.em.post(Event.HUE_CMD, this, Float.valueOf((float)level)));
        }
    }

    public void set_image_hue(long level) {
        this.set_image_hue((double)level);
    }

    @Override
    public void set_image_saturation(double level) {
        if (this.api.validator.checkNum(level, 0.0, 2.0, "saturation")) {
            this.api.base.post_runnable(() -> this.em.post(Event.SATURATION_CMD, this, Float.valueOf((float)level)));
        }
    }

    public void set_image_saturation(long level) {
        this.set_image_saturation((double)level);
    }

    @Override
    public void set_gamma_correction(double level) {
        if (this.api.validator.checkNum(level, 0.0, 3.0, "gamma correction")) {
            this.api.base.post_runnable(() -> this.em.post(Event.GAMMA_CMD, this, Float.valueOf((float)level)));
        }
    }

    public void set_gamma_correction(long level) {
        this.set_gamma_correction((double)level);
    }

    @Override
    public void set_hdr_tone_mapping(String type) {
        if (this.api.validator.checkString(type, new String[]{"auto", "AUTO", "exposure", "EXPOSURE", "none", "NONE"}, "tone mapping type")) {
            this.api.base.post_runnable(() -> this.em.post(Event.TONEMAPPING_TYPE_CMD, this, new Object[]{Settings.ToneMapping.valueOf(type.toUpperCase(Locale.ROOT))}));
        }
    }

    @Override
    public void set_exposure_tone_mapping(double level) {
        if (this.api.validator.checkNum(level, 0.0, 20.0, "exposure")) {
            this.api.base.post_runnable(() -> this.em.post(Event.EXPOSURE_CMD, this, Float.valueOf((float)level)));
        }
    }

    public void set_exposure_tone_mapping(long level) {
        this.set_exposure_tone_mapping((double)level);
    }

    @Override
    public void mode_cubemap(boolean state, String projection) {
        if (this.api.validator.checkStringEnum(projection, CubmeapProjectionEffect.CubemapProjection.class, "projection")) {
            CubmeapProjectionEffect.CubemapProjection newProj = CubmeapProjectionEffect.CubemapProjection.valueOf(projection.toUpperCase(Locale.ROOT));
            this.api.base.post_runnable(() -> this.em.post(Event.CUBEMAP_CMD, this, new Object[]{state, newProj}));
        }
    }

    @Override
    public void mode_panorama(boolean state) {
        this.api.base.post_runnable(() -> this.em.post(Event.CUBEMAP_CMD, this, new Object[]{state, CubmeapProjectionEffect.CubemapProjection.EQUIRECTANGULAR}));
    }

    @Override
    public void mode_reprojection(String mode) {
        if (this.api.validator.checkStringEnum(mode, Settings.ReprojectionMode.class, "re-projection mode")) {
            Settings.ReprojectionMode newMode = Settings.ReprojectionMode.valueOf(mode.toUpperCase(Locale.ROOT));
            this.api.base.post_runnable(() -> this.em.post(Event.REPROJECTION_CMD, this, new Object[]{newMode != Settings.ReprojectionMode.DISABLED, newMode}));
        }
    }

    @Override
    public void set_back_buffer_scale(float scale) {
        if (this.api.validator.checkNum(scale, 0.5f, 4.0f, "back buffer scale")) {
            this.api.base.post_runnable(() -> GaiaSky.instance.resetDynamicResolution());
            this.api.base.post_runnable(() -> this.em.post(Event.BACKBUFFER_SCALE_CMD, this, Float.valueOf(scale)));
        }
    }

    @Override
    public void set_index_of_refraction(float ior) {
        this.em.post(Event.INDEXOFREFRACTION_CMD, this, Float.valueOf(ior));
    }

    @Override
    public void mode_planetarium(boolean state) {
        this.api.base.post_runnable(() -> this.em.post(Event.CUBEMAP_CMD, this, new Object[]{state, CubmeapProjectionEffect.CubemapProjection.AZIMUTHAL_EQUIDISTANT}));
    }

    @Override
    public void set_cubemap_resolution(int resolution) {
        if (this.api.validator.checkNum(resolution, 20, 15000, "resolution")) {
            this.api.base.post_runnable(() -> this.em.post(Event.CUBEMAP_RESOLUTION_CMD, this, resolution));
        }
    }

    @Override
    public void set_cubemap_projection(String projection) {
        if (this.api.validator.checkStringEnum(projection, CubmeapProjectionEffect.CubemapProjection.class, "projection")) {
            CubmeapProjectionEffect.CubemapProjection newProj = CubmeapProjectionEffect.CubemapProjection.valueOf(projection.toUpperCase(Locale.ROOT));
            this.em.post(Event.CUBEMAP_PROJECTION_CMD, this, new Object[]{newProj});
        }
    }

    @Override
    public void mode_orthosphere(boolean state) {
        this.api.base.post_runnable(() -> this.em.post(Event.CUBEMAP_CMD, this, new Object[]{state, CubmeapProjectionEffect.CubemapProjection.ORTHOSPHERE}));
    }

    @Override
    public void mode_stereoscopic(boolean state) {
        this.api.base.post_runnable(() -> this.em.post(Event.STEREOSCOPIC_CMD, this, state));
    }

    @Override
    public void set_stereo_profile(int index) {
        this.api.base.post_runnable(() -> this.em.post(Event.STEREO_PROFILE_CMD, this, index));
    }

    @Override
    public long get_current_frame_number() {
        return GaiaSky.instance.frames;
    }

    @Override
    public void effect_lens_flare(boolean state) {
        this.api.base.post_runnable(() -> this.em.post(Event.LENS_FLARE_CMD, this, Float.valueOf(state ? 1.0f : 0.0f)));
    }

    @Override
    public void effect_lens_flare(double value) {
        if (this.api.validator.checkNum(value, 0.0, 1.5, "strength")) {
            this.api.base.post_runnable(() -> this.em.post(Event.LENS_FLARE_CMD, this, Float.valueOf((float)value)));
        }
    }

    @Override
    public void effect_motion_blur(boolean active) {
        float strength = active ? 0.8f : 0.0f;
        this.api.base.post_runnable(() -> this.em.post(Event.MOTION_BLUR_CMD, this, Float.valueOf(strength)));
    }

    @Override
    public void effect_motion_blur(double value) {
        this.api.base.post_runnable(() -> this.em.post(Event.MOTION_BLUR_CMD, this, Float.valueOf((float)value)));
    }

    @Override
    public void effect_star_glow(boolean state) {
        this.api.base.post_runnable(() -> this.em.post(Event.LIGHT_GLOW_CMD, this, state));
    }

    @Override
    public void effect_bloom(float value) {
        if (this.api.validator.checkNum(value, 0.0f, 1.0f, "bloom strength")) {
            this.api.base.post_runnable(() -> this.em.post(Event.BLOOM_CMD, this, Float.valueOf(value)));
        }
    }

    @Override
    public void effect_chromatic_aberration(float value) {
        if (this.api.validator.checkNum(value, 0.0f, 0.05f, "chromatic aberration amount")) {
            this.api.base.post_runnable(() -> this.em.post(Event.CHROMATIC_ABERRATION_CMD, this, Float.valueOf(value)));
        }
    }

    public void effect_bloom(int level) {
        this.effect_bloom((float)level);
    }

    @Override
    public void set_smooth_lod_transitions(boolean value) {
        this.api.base.post_runnable(() -> this.em.post(Event.OCTREE_PARTICLE_FADE_CMD, this, value));
    }

    @Override
    public void set_ambient_light(float value) {
        if (this.api.validator.checkNum(value, 0.0f, 1.0f, "ambientLight")) {
            this.api.base.post_runnable(() -> this.em.post(Event.AMBIENT_LIGHT_CMD, this, Float.valueOf(value)));
        }
    }

    public void set_ambient_light(int value) {
        this.set_ambient_light((float)value);
    }

    @Override
    public void set_star_brightness_power(float value) {
        if (this.api.validator.checkFinite(value, "brightness-pow")) {
            if (value < 0.9f || value > 1.1f) {
                value = 1.0f;
            }
            this.em.post(Event.STAR_BRIGHTNESS_POW_CMD, this, Float.valueOf(value));
        }
    }

    @Override
    public void set_star_glow_factor(float value) {
        if (this.api.validator.checkNum((double)value, 0.001, 5.0, "glow-factor")) {
            this.em.post(Event.STAR_GLOW_FACTOR_CMD, this, Float.valueOf(value));
        }
    }

    @Override
    public float get_star_brightness() {
        return MathUtilsDouble.lint(Settings.settings.scene.star.brightness, 0.4f, 8.0f, 0.0f, 100.0f);
    }

    @Override
    public void set_star_brightness(float value) {
        if (this.api.validator.checkNum(value, 0.0f, 100.0f, "brightness")) {
            this.em.post(Event.STAR_BRIGHTNESS_CMD, this, Float.valueOf(MathUtilsDouble.lint(value, 0.0f, 100.0f, 0.4f, 8.0f)));
        }
    }

    public void set_star_brightness(int brightness) {
        this.set_star_brightness((float)brightness);
    }

    @Override
    public float get_point_size() {
        return MathUtilsDouble.lint(Settings.settings.scene.star.pointSize, 0.1f, 20.0f, 0.0f, 100.0f);
    }

    @Override
    public void set_point_size(float size) {
        if (this.api.validator.checkNum(size, 0.1f, 20.0f, "size")) {
            this.em.post(Event.STAR_POINT_SIZE_CMD, this, Float.valueOf(size));
        }
    }

    public void set_point_size(long size) {
        this.set_point_size((float)size);
    }

    @Override
    public float get_star_base_opacity() {
        return MathUtilsDouble.lint(Settings.settings.scene.star.opacity[0], 0.0f, 0.95f, 0.0f, 100.0f);
    }

    @Override
    public void set_star_base_opacity(float opacity) {
        if (this.api.validator.checkNum(opacity, 0.0f, 0.95f, "min-opacity")) {
            EventManager.publish(Event.STAR_BASE_LEVEL_CMD, this, Float.valueOf(opacity));
        }
    }

    public void set_star_base_opacity(long opacity) {
        this.set_star_base_opacity((float)opacity);
    }

    @Override
    public void set_star_texture_index(int index) {
        if (this.api.validator.checkNum(index, 1, 4, "index")) {
            EventManager.publish(Event.BILLBOARD_TEXTURE_IDX_CMD, this, index);
        }
    }

    @Override
    public void set_star_set_metadata_size(int n) {
        if (this.api.validator.checkNum(n, 1, 1000000, "nNearest")) {
            EventManager.publish(Event.STAR_GROUP_NEAREST_CMD, this, n);
        }
    }

    @Override
    public void set_star_set_billboard(boolean flag) {
        EventManager.publish(Event.STAR_GROUP_BILLBOARD_CMD, this, flag);
    }

    @Override
    public void set_orbit_solid_angle_threshold(float deg) {
        if (this.api.validator.checkNum(deg, 0.0f, 180.0f, "solid-angle")) {
            this.api.base.post_runnable(() -> EventManager.publish(Event.ORBIT_SOLID_ANGLE_TH_CMD, this, deg));
        }
    }

    @Override
    public void set_limit_fps(double fps) {
        if (this.api.validator.checkNum(fps, -1.7976931348623157E308, 1000.0, "limitFps")) {
            this.em.post(Event.LIMIT_FPS_CMD, this, fps);
        }
    }

    @Override
    public void set_limit_fps(int fps) {
        this.set_limit_fps((double)fps);
    }
}

