/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.script.v2.api.InstancesAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Settings;
import gaiasky.util.SlaveManager;

public class InstancesModule
extends APIModule
implements InstancesAPI {
    public InstancesModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    @Override
    public void set_projection_yaw(float yaw) {
        if (SlaveManager.projectionActive()) {
            this.api.base.post_runnable(() -> {
                Settings.settings.program.net.slave.yaw = yaw;
                SlaveManager.instance.yaw = yaw;
            });
        }
    }

    @Override
    public void set_projection_pitch(float pitch) {
        if (SlaveManager.projectionActive()) {
            this.api.base.post_runnable(() -> {
                Settings.settings.program.net.slave.pitch = pitch;
                SlaveManager.instance.pitch = pitch;
            });
        }
    }

    @Override
    public void set_projection_roll(float roll) {
        if (SlaveManager.projectionActive()) {
            this.api.base.post_runnable(() -> {
                Settings.settings.program.net.slave.roll = roll;
                SlaveManager.instance.roll = roll;
            });
        }
    }

    @Override
    public void set_projection_fov(float fov) {
        if (this.api.validator.checkNum(fov, 1.0f, 170.0f, "newFov")) {
            this.api.base.post_runnable(() -> {
                SlaveManager.instance.cameraFov = fov;
                this.em.post(Event.FOV_CHANGED_CMD, this, Float.valueOf(fov));
            });
        }
    }
}

