/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.LocationMark;
import gaiasky.scene.view.FocusView;
import gaiasky.script.v2.api.InteractiveCameraAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.math.IntersectorDouble;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;

public class InteractiveCameraModule
extends APIModule
implements InteractiveCameraAPI {
    Scene scene;
    final FocusView focusView = new FocusView();
    private final Set<AtomicBoolean> stops = new HashSet<AtomicBoolean>();

    public InteractiveCameraModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    @Override
    public void set_cinematic(boolean cinematic) {
        this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_CINEMATIC_CMD, this, cinematic));
    }

    @Override
    public void go_to_object(String name) {
        this.go_to_object(name, -1.0);
    }

    @Override
    public void go_to_object(String name, double sa) {
        this.go_to_object(name, sa, -1);
    }

    @Override
    public void go_to_object(String name, double sa, float wait) {
        this.go_to_object(name, sa, wait, null);
    }

    public void go_to_object(String name, double solidAngle, int waitTimeSeconds) {
        this.go_to_object(name, solidAngle, (float)waitTimeSeconds);
    }

    public void go_to_object(String name, long solidAngle, int waitTimeSeconds) {
        this.go_to_object(name, (double)solidAngle, (float)waitTimeSeconds);
    }

    public void go_to_object(String name, long solidAngle, float waitTimeSeconds) {
        this.go_to_object(name, (double)solidAngle, waitTimeSeconds);
    }

    private void go_to_object(String name, double solidAngle, float waitTimeSeconds, AtomicBoolean stop) {
        if (this.api.validator.checkString(name, "name") && this.api.validator.checkObjectName(name)) {
            Entity focus = this.scene.findFocus(name);
            this.focusView.setEntity(focus);
            this.focusView.getFocus(name);
            this.go_to_object(focus, solidAngle, waitTimeSeconds, stop);
        }
    }

    public void go_to_object(String name, double solidAngle, int waitTimeSeconds, AtomicBoolean stop) {
        this.go_to_object(name, solidAngle, (float)waitTimeSeconds, stop);
    }

    void go_to_object(Entity object, double solidAngle, float waitTimeSeconds, AtomicBoolean stop) {
        if (this.api.validator.checkNotNull(object, "object") && this.api.validator.checkNum(solidAngle, -1.7976931348623157E308, Double.MAX_VALUE, "solidAngle")) {
            this.stops.add(stop);
            NaturalCamera cam = GaiaSky.instance.cameraManager.naturalCamera;
            this.focusView.setEntity(object);
            this.api.camera.changeFocus(this.focusView, cam, waitTimeSeconds);
            double target = FastMath.toRadians((double)solidAngle);
            if (target < 0.0) {
                if (this.focusView.isParticleSet()) {
                    double rx0 = 1.31;
                    double rx1 = 2805.0;
                    double y0 = 1.0;
                    double y1 = 0.001;
                    target = FastMath.toRadians((double)(y0 + (y1 - y0) * (this.focusView.getAbsolutePosition(this.api.aux3b1).lenDouble() * Constants.U_TO_PC - rx0) / (rx1 - rx0)));
                } else {
                    target = FastMath.toRadians((double)20.0);
                }
            }
            long prevTime = TimeUtils.millis();
            if (this.focusView.getSolidAngle() < target) {
                while (this.focusView.getSolidAngle() < target && (stop == null || !stop.get())) {
                    long dt = TimeUtils.timeSinceMillis((long)prevTime);
                    prevTime = TimeUtils.millis();
                    this.em.post(Event.CAMERA_FWD, this, dt);
                    try {
                        this.api.base.sleep(0.1f);
                    }
                    catch (Exception e) {
                        this.logger.error(e);
                    }
                }
            } else {
                while (this.focusView.getSolidAngleApparent() > target && (stop == null || !stop.get())) {
                    long dt = TimeUtils.timeSinceMillis((long)prevTime);
                    prevTime = TimeUtils.millis();
                    this.em.post(Event.CAMERA_FWD, this, -dt);
                    try {
                        this.api.base.sleep(0.1f);
                    }
                    catch (Exception e) {
                        this.logger.error(e);
                    }
                }
            }
            this.em.post(Event.CAMERA_STOP, this);
        }
    }

    public void go_to_object(Entity object, double solidAngle, int waitTimeSeconds, AtomicBoolean stop) {
        this.go_to_object(object, solidAngle, (float)waitTimeSeconds, stop);
    }

    @Override
    public void add_forward(double value) {
        if (this.api.validator.checkNum(value, -100.0, 100.0, "cameraForward")) {
            this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_FWD, this, value));
        }
    }

    public void add_forward(long value) {
        this.add_forward((double)value);
    }

    @Override
    public void add_rotation(double dx, double dy) {
        if (this.api.validator.checkNum(dx, -100.0, 100.0, "deltaX") && this.api.validator.checkNum(dy, -100.0, 100.0, "deltaY")) {
            this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_ROTATE, this, dx, dy));
        }
    }

    public void add_rotation(double deltaX, long deltaY) {
        this.add_rotation(deltaX, (double)deltaY);
    }

    public void add_rotation(long deltaX, double deltaY) {
        this.add_rotation((double)deltaX, deltaY);
    }

    @Override
    public void add_roll(double value) {
        if (this.api.validator.checkNum(value, -100.0, 100.0, "roll")) {
            this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_ROLL, this, value));
        }
    }

    public void add_roll(long roll) {
        this.add_roll((double)roll);
    }

    @Override
    public void add_turn(double dx, double dy) {
        if (this.api.validator.checkNum(dx, -100.0, 100.0, "deltaX") && this.api.validator.checkNum(dy, -100.0, 100.0, "deltaY")) {
            this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_TURN, this, dx, dy));
        }
    }

    public void add_turn(double deltaX, long deltaY) {
        this.add_turn(deltaX, (double)deltaY);
    }

    public void add_turn(long deltaX, double deltaY) {
        this.add_turn((double)deltaX, deltaY);
    }

    public void add_turn(long deltaX, long deltaY) {
        this.add_turn((double)deltaX, (double)deltaY);
    }

    @Override
    public void add_yaw(double amount) {
        this.add_turn(amount, 0.0);
    }

    public void cameraYaw(long amount) {
        this.add_yaw(amount);
    }

    @Override
    public void add_pitch(double amount) {
        this.add_turn(0.0, amount);
    }

    public void add_pitch(long amount) {
        this.add_pitch((double)amount);
    }

    @Override
    public double get_speed() {
        return GaiaSky.instance.cameraManager.getSpeed();
    }

    @Override
    public void speed_setting(float speed) {
        if (this.api.validator.checkNum(speed, 0.0f, 100.0f, "speed")) {
            this.api.base.post_runnable(() -> this.em.post(Event.CAMERA_SPEED_CMD, this, Float.valueOf(MathUtilsDouble.lint(speed, 0.0f, 100.0f, 0.1f, 15.0f)), false));
        }
    }

    public void speed_setting(int speed) {
        this.speed_setting((float)speed);
    }

    @Override
    public void rotation_speed_setting(float speed) {
        if (this.api.validator.checkNum(speed, 0.0f, 100.0f, "speed")) {
            this.api.base.post_runnable(() -> this.em.post(Event.ROTATION_SPEED_CMD, this, Float.valueOf(MathUtilsDouble.lint(speed, 0.0f, 100.0f, 200.0f, 10000.0f))));
        }
    }

    public void rotation_speed_setting(int speed) {
        this.rotation_speed_setting((float)speed);
    }

    @Override
    public void turning_speed_setting(float speed) {
        if (this.api.validator.checkNum(speed, 0.0f, 100.0f, "speed")) {
            this.api.base.post_runnable(() -> this.em.post(Event.TURNING_SPEED_CMD, this, Float.valueOf(MathUtilsDouble.lint(speed, 0.0f, 100.0f, 200.0f, 3000.0f)), false));
        }
    }

    public void turning_speed_setting(int speed) {
        this.turning_speed_setting((float)speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void land_on(String name) {
        Entity target;
        if (this.api.validator.checkString(name, "name") && Mapper.focus.has(target = this.api.scene.get_entity(name))) {
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(target);
                this.focusView.getFocus(name);
            }
            this.land_on(target, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void land_on(Entity object, AtomicBoolean stop) {
        if (this.api.validator.checkNotNull(object, "object")) {
            this.stops.add(stop);
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                if (Mapper.atmosphere.has(object)) {
                    double rollSign;
                    this.focusView.setEntity(object);
                    NaturalCamera cam = GaiaSky.instance.cameraManager.naturalCamera;
                    float waitTimeSeconds = -1.0f;
                    double speed = Settings.settings.scene.camera.speed;
                    this.em.post(Event.CAMERA_SPEED_CMD, this, Float.valueOf(2.5f), false);
                    double turnSpeedBak = Settings.settings.scene.camera.turn;
                    this.em.post(Event.TURNING_SPEED_CMD, this, Float.valueOf((float)MathUtilsDouble.flint(20.0, 0.0, 100.0, 200.0, 3000.0)), false);
                    boolean cinematic = Settings.settings.scene.camera.cinematic;
                    Settings.settings.scene.camera.cinematic = true;
                    this.api.camera.changeFocus(this.focusView, cam, waitTimeSeconds);
                    double target = 100.0 * Constants.M_TO_U;
                    Vector3Q camObj = this.api.aux3b1;
                    this.focusView.getAbsolutePosition(camObj).add(cam.posInv).nor();
                    Vector3D dir = cam.direction;
                    boolean distanceNotMet = this.focusView.getDistToCamera() - this.focusView.getRadius() > target;
                    boolean viewNotMet = FastMath.abs((double)dir.angle(camObj)) < 90.0;
                    long prevTime = TimeUtils.millis();
                    while (!(!distanceNotMet && !viewNotMet || stop != null && stop.get())) {
                        long dt = TimeUtils.timeSinceMillis((long)prevTime);
                        prevTime = TimeUtils.millis();
                        if (distanceNotMet) {
                            this.em.post(Event.CAMERA_FWD, this, 0.1 * (double)dt);
                        } else {
                            cam.stopForwardMovement();
                        }
                        if (viewNotMet) {
                            if (this.focusView.getDistToCamera() - this.focusView.getRadius() < this.focusView.getRadius() * 5.0) {
                                this.em.post(Event.CAMERA_TURN, this, 0.0, (double)dt / 500.0);
                            }
                        } else {
                            cam.stopRotateMovement();
                        }
                        try {
                            this.api.base.sleep_frames(1L);
                        }
                        catch (Exception e) {
                            this.logger.error(e);
                        }
                        viewNotMet = FastMath.abs((double)dir.angle(camObj)) < 90.0;
                        distanceNotMet = this.focusView.getDistToCamera() - this.focusView.getRadius() > target;
                    }
                    this.em.post(Event.CAMERA_STOP, this);
                    Vector3D up = cam.up;
                    camObj = this.focusView.getAbsolutePosition(this.api.aux3b1).sub(cam.pos);
                    double ang1 = up.angle(camObj);
                    double ang2 = up.cpy().rotate(cam.direction, 1.0).angle(camObj);
                    double d = rollSign = ang1 < ang2 ? -1.0 : 1.0;
                    if (ang1 < 170.0) {
                        this.rollAndWait(rollSign * 0.02, 170.0, 50L, cam, camObj, stop);
                        cam.stopMovement();
                        this.rollAndWait(rollSign * 0.006, 176.0, 50L, cam, camObj, stop);
                        cam.stopMovement();
                        this.rollAndWait(rollSign * 0.003, 178.0, 50L, cam, camObj, stop);
                    }
                    this.em.post(Event.CAMERA_STOP, this);
                    Settings.settings.scene.camera.cinematic = cinematic;
                    this.em.post(Event.CAMERA_SPEED_CMD, this, Float.valueOf((float)speed), false);
                    this.em.post(Event.TURNING_SPEED_CMD, this, Float.valueOf((float)turnSpeedBak), false);
                }
            }
        }
    }

    void rollAndWait(double roll, double target, long sleep, NaturalCamera cam, Vector3Q camObject, AtomicBoolean stop) {
        double ang = cam.up.angle(camObject);
        while (ang < target && (stop == null || !stop.get())) {
            cam.addRoll(roll, false);
            try {
                this.api.base.sleep(sleep);
            }
            catch (Exception e) {
                this.logger.error(e);
            }
            ang = cam.up.angle(this.api.aux3d1);
        }
    }

    @Override
    public void land_at_location(String name, String location) {
        this.land_at_location(name, location, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void land_at_location(String name, String locationName, AtomicBoolean stop) {
        if (this.api.validator.checkString(name, "name")) {
            this.stops.add(stop);
            Entity entity = this.api.scene.get_entity(name);
            if (Mapper.focus.has(entity)) {
                FocusView focusView = this.focusView;
                synchronized (focusView) {
                    this.focusView.setEntity(entity);
                    this.focusView.getFocus(name);
                }
                this.land_at_location(entity, locationName, stop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void land_at_location(Entity object, String locationName, AtomicBoolean stop) {
        if (this.api.validator.checkNotNull(object, "object") && this.api.validator.checkString(locationName, "locationName")) {
            this.stops.add(stop);
            if (Mapper.atmosphere.has(object)) {
                FocusView focusView = this.focusView;
                synchronized (focusView) {
                    this.focusView.setEntity(object);
                    Entity loc = this.focusView.getChildByNameAndArchetype(locationName, this.scene.archetypes().get("Loc"));
                    if (loc != null) {
                        LocationMark locMark = (LocationMark)Mapper.loc.get(loc);
                        this.land_at_location(object, locMark.location.x, locMark.location.y, stop);
                        return;
                    }
                    this.logger.info("Location '" + locationName + "' not found on object '" + this.focusView.getCandidateName() + "'");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void land_at_location(String name, double longitude, double latitude) {
        Entity entity;
        if (this.api.validator.checkString(name, "name") && Mapper.focus.has(entity = this.api.scene.get_entity(name))) {
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(entity);
                this.focusView.getFocus(name);
            }
            this.land_at_location(entity, longitude, latitude, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void land_at_location(Entity entity, double longitude, double latitude, AtomicBoolean stop) {
        if (this.api.validator.checkNotNull(entity, "object") && this.api.validator.checkNum(latitude, -90.0, 90.0, "latitude") && this.api.validator.checkNum(longitude, -360.0, 360.0, "longitude")) {
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(entity);
                this.stops.add(stop);
                String nameStub = this.focusView.getCandidateName() + " [loc]";
                if (!this.scene.index().containsEntity(nameStub)) {
                    Archetype archetype = this.scene.archetypes().get("Invisible");
                    Entity invisible = archetype.createEntity();
                    Base base = (Base)Mapper.base.get(invisible);
                    base.setName(nameStub);
                    base.setCt("Others");
                    GraphNode graph = (GraphNode)Mapper.graph.get(invisible);
                    graph.translation = new Vector3Q();
                    graph.setParent("Universe");
                    this.scene.initializeEntity(invisible);
                    this.scene.setUpEntity(invisible);
                    EventManager.publish(Event.SCENE_ADD_OBJECT_NO_POST_CMD, this, invisible, true);
                }
                Entity invisible = this.scene.getEntity(nameStub);
                if (Mapper.atmosphere.has(entity)) {
                    NaturalCamera cam = GaiaSky.instance.cameraManager.naturalCamera;
                    double targetAngle = 0.6108652381980153;
                    if (this.focusView.getSolidAngle() > targetAngle) {
                        while (this.focusView.getSolidAngle() > targetAngle && (stop == null || !stop.get())) {
                            cam.addForwardForce(-5.0);
                            this.api.base.sleep_frames(1L);
                        }
                        cam.stopMovement();
                    }
                    this.go_to_object(this.focusView.getEntity(), 15.0, -1, stop);
                    double speed = Settings.settings.scene.camera.speed;
                    this.em.post(Event.CAMERA_SPEED_CMD, this, Float.valueOf(2.5f));
                    double turnSpeedBak = Settings.settings.scene.camera.turn;
                    this.em.post(Event.TURNING_SPEED_CMD, this, Float.valueOf((float)MathUtilsDouble.flint(50.0, 0.0, 100.0, 200.0, 3000.0)));
                    double rotationSpeedBak = Settings.settings.scene.camera.rotate;
                    this.em.post(Event.ROTATION_SPEED_CMD, this, Float.valueOf((float)MathUtilsDouble.flint(20.0, 0.0, 100.0, 200.0, 10000.0)));
                    boolean cinematic = Settings.settings.scene.camera.cinematic;
                    Settings.settings.scene.camera.cinematic = true;
                    boolean crosshair = Settings.settings.scene.crosshair.focus;
                    Settings.settings.scene.crosshair.focus = false;
                    Vector3Q target = this.api.aux3b1;
                    this.focusView.getPositionAboveSurface(longitude, latitude, 50.0, target);
                    Vector3Q objectPosition = this.focusView.getAbsolutePosition(this.api.aux3b2);
                    boolean intersects = IntersectorDouble.checkIntersectSegmentSphere(cam.pos.tov3d(this.api.aux3d3), target.tov3d(this.api.aux3d1), objectPosition.tov3d(this.api.aux3d2), this.focusView.getRadius());
                    if (intersects) {
                        this.add_rotation(5.0, 5.0);
                    }
                    while (intersects && (stop == null || !stop.get())) {
                        this.api.base.sleep(0.1f);
                        objectPosition = this.focusView.getAbsolutePosition(this.api.aux3b2);
                        intersects = IntersectorDouble.checkIntersectSegmentSphere(cam.pos.tov3d(this.api.aux3d3), target.tov3d(this.api.aux3d1), objectPosition.tov3d(this.api.aux3d2), this.focusView.getRadius());
                    }
                    this.api.camera.stop();
                    ((Base)Mapper.base.get((Entity)invisible)).ct = this.focusView.getCt();
                    ((Body)Mapper.body.get((Entity)invisible)).pos.set(target);
                    this.go_to_object(nameStub, 20.0, 0, stop);
                    Settings.settings.scene.camera.cinematic = cinematic;
                    this.em.post(Event.CAMERA_SPEED_CMD, this, Float.valueOf((float)speed));
                    this.em.post(Event.TURNING_SPEED_CMD, this, Float.valueOf((float)turnSpeedBak));
                    this.em.post(Event.ROTATION_SPEED_CMD, this, Float.valueOf((float)rotationSpeedBak));
                    Settings.settings.scene.crosshair.focus = crosshair;
                    this.land_on(this.focusView.getEntity(), stop);
                }
                EventManager.publish(Event.SCENE_REMOVE_OBJECT_CMD, this, invisible, true);
            }
        }
    }

    @Override
    public void dispose() {
        for (AtomicBoolean stop : this.stops) {
            if (stop == null) continue;
            stop.set(true);
        }
        super.dispose();
    }
}

