/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.script.v2.api.OutputAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Settings;
import gaiasky.util.screenshot.ImageRenderer;

public class OutputModule
extends APIModule
implements OutputAPI {
    public OutputModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    @Override
    public void configure_screenshots(int w, int h, String path, String prefix) {
        if (this.api.validator.checkNum(w, 1, Integer.MAX_VALUE, "width") && this.api.validator.checkNum(h, 1, Integer.MAX_VALUE, "height") && this.api.validator.checkString(path, "directory") && this.api.validator.checkDirectoryExists(path, "directory") && this.api.validator.checkString(prefix, "namePrefix")) {
            this.em.post(Event.SCREENSHOT_CMD, this, w, h, path);
        }
    }

    @Override
    public String get_current_screenshots_dir() {
        return Settings.settings.screenshot.location;
    }

    @Override
    public void screenshot_mode(String mode) {
        if (mode != null && mode.equalsIgnoreCase("redraw")) {
            mode = "ADVANCED";
        }
        if (this.api.validator.checkStringEnum(mode, Settings.ScreenshotMode.class, "screenshotMode")) {
            this.em.post(Event.SCREENSHOT_MODE_CMD, this, mode);
            this.api.base.post_runnable(() -> this.em.post(Event.SCREENSHOT_SIZE_UPDATE, this, Settings.settings.screenshot.resolution[0], Settings.settings.screenshot.resolution[1]));
        }
    }

    @Override
    public void screenshot() {
        Settings.ScreenshotSettings ss = Settings.settings.screenshot;
        this.em.post(Event.SCREENSHOT_CMD, this, ss.resolution[0], ss.resolution[1], ss.location);
    }

    @Override
    public void configure_frame_output(int w, int h, int fps, String path, String prefix) {
        this.configure_frame_output(w, h, (double)fps, path, prefix);
    }

    @Override
    public String get_current_frame_output_dir() {
        return Settings.settings.frame.location;
    }

    @Override
    public void configure_frame_output(int w, int h, double fps, String path, String prefix) {
        if (this.api.validator.checkNum(w, 1, Integer.MAX_VALUE, "width") && this.api.validator.checkNum(h, 1, Integer.MAX_VALUE, "height") && this.api.validator.checkNum(fps, 0.05, 1000.0, "FPS") && this.api.validator.checkString(path, "directory") && this.api.validator.checkDirectoryExists(path, "directory") && this.api.validator.checkString(prefix, "namePrefix")) {
            this.em.post(Event.FRAME_OUTPUT_MODE_CMD, this, new Object[]{Settings.ScreenshotMode.ADVANCED});
            this.em.post(Event.CONFIG_FRAME_OUTPUT_CMD, this, w, h, fps, path, prefix);
        }
    }

    @Override
    public void frame_output_mode(String mode) {
        if (mode != null && mode.equalsIgnoreCase("redraw")) {
            mode = "ADVANCED";
        }
        if (this.api.validator.checkStringEnum(mode, Settings.ScreenshotMode.class, "screenshotMode")) {
            this.em.post(Event.FRAME_OUTPUT_MODE_CMD, this, mode);
        }
    }

    @Override
    public void frame_output(boolean active) {
        this.em.post(Event.FRAME_OUTPUT_CMD, this, active);
    }

    @Override
    public boolean is_frame_output_active() {
        return Settings.settings.frame.active;
    }

    @Override
    public double get_frame_output_fps() {
        return Settings.settings.frame.targetFps;
    }

    @Override
    public void reset_frame_output_sequence_number() {
        ImageRenderer.resetSequenceNumber();
    }
}

