/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import gaiasky.event.EventManager;
import gaiasky.script.v2.api.RefsysAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Constants;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.List;

public class RefsysModule
extends APIModule
implements RefsysAPI {
    public RefsysModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    @Override
    public double[] galactic_to_cartesian(double l, double b, double r) {
        Vector3D pos = Coordinates.sphericalToCartesian(l * (Math.PI / 180), b * (Math.PI / 180), r * Constants.KM_TO_U, new Vector3D());
        pos.mul(Coordinates.galacticToEquatorial());
        return new double[]{pos.x, pos.y, pos.z};
    }

    @Override
    public double[] get_transform_matrix(String name) {
        Matrix4D mat = Coordinates.getTransformD(name);
        if (mat != null) {
            return mat.val;
        }
        this.logger.error(name + ": no transformation found with the given name");
        return null;
    }

    public double[] galactic_to_cartesian(int l, int b, int r) {
        return this.galactic_to_cartesian((double)l, (double)b, (double)r);
    }

    @Override
    public double[] ecliptic_to_cartesian(double l, double b, double r) {
        Vector3D pos = Coordinates.sphericalToCartesian(l * (Math.PI / 180), b * (Math.PI / 180), r * Constants.KM_TO_U, new Vector3D());
        pos.mul(Coordinates.eclipticToEquatorial());
        return new double[]{pos.x, pos.y, pos.z};
    }

    public double[] ecliptic_to_cartesian(int l, int b, int r) {
        return this.ecliptic_to_cartesian((double)l, (double)b, (double)r);
    }

    @Override
    public double[] equatorial_to_cartesian(double ra, double dec, double r) {
        Vector3D pos = Coordinates.sphericalToCartesian(ra * (Math.PI / 180), dec * (Math.PI / 180), r * Constants.KM_TO_U, new Vector3D());
        return new double[]{pos.x, pos.y, pos.z};
    }

    public double[] equatorial_to_cartesian(int ra, int dec, int r) {
        return this.equatorial_to_cartesian((double)ra, (double)dec, (double)r);
    }

    @Override
    public double[] cartesian_to_equatorial(double x, double y, double z) {
        Vector3Q in = this.api.aux3b1.set(x, y, z);
        Vector3D out = this.api.aux3d6;
        Coordinates.cartesianToSpherical(in, out);
        return new double[]{out.x * 57.29577951308232, out.y * 57.29577951308232, in.lenDouble()};
    }

    public double[] cartesian_to_equatorial(int x, int y, int z) {
        return this.cartesian_to_equatorial((double)x, (double)y, (double)z);
    }

    @Override
    public double[] equatorial_cartesian_to_internal(double[] eq, double factor) {
        Vector3D v = this.api.aux3d1.set(eq).scl(factor).scl(Constants.KM_TO_U);
        return new double[]{v.y, v.z, v.x};
    }

    public double[] equatorial_cartesian_to_internal(List<?> eq, double kmFactor) {
        return this.equatorial_cartesian_to_internal(this.api.dArray(eq), kmFactor);
    }

    @Override
    public double[] equatorial_to_galactic(double[] eq) {
        this.api.aux3d1.set(eq).mul(Coordinates.eqToGal());
        return this.api.aux3d1.values();
    }

    public double[] equatorial_to_galactic(List<?> eq) {
        return this.equatorial_to_galactic(this.api.dArray(eq));
    }

    @Override
    public double[] equatorial_to_ecliptic(double[] eq) {
        this.api.aux3d1.set(eq).mul(Coordinates.eqToEcl());
        return this.api.aux3d1.values();
    }

    public double[] equatorial_to_ecliptic(List<?> eq) {
        return this.equatorial_to_ecliptic(this.api.dArray(eq));
    }

    @Override
    public double[] galactic_to_equatorial(double[] gal) {
        this.api.aux3d1.set(gal).mul(Coordinates.galToEq());
        return this.api.aux3d1.values();
    }

    public double[] galactic_to_equatorial(List<?> gal) {
        return this.galactic_to_equatorial(this.api.dArray(gal));
    }

    @Override
    public double[] ecliptic_to_equatorial(double[] ecl) {
        this.api.aux3d1.set(ecl).mul(Coordinates.eclToEq());
        return this.api.aux3d1.values();
    }

    public double[] ecliptic_to_equatorial(List<?> ecl) {
        return this.ecliptic_to_equatorial(this.api.dArray(ecl));
    }
}

