/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.data.orientation.QuaternionNlerpOrientationServer;
import gaiasky.data.orientation.QuaternionSlerpOrientationServer;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.beans.OrientationComboBoxBean;
import gaiasky.gui.beans.PrimitiveComboBoxBean;
import gaiasky.gui.beans.ShapeComboBoxBean;
import gaiasky.render.BlendMode;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Arrow;
import gaiasky.scene.component.AttitudeComponent;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.Orientation;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.component.Shape;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.entity.TrajectoryUtils;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.VertsView;
import gaiasky.script.v2.api.SceneAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Settings;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.IPythonCoordinatesProvider;
import gaiasky.util.coord.PythonBodyCoordinates;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class SceneModule
extends APIModule
implements IObserver,
SceneAPI {
    public Scene scene;
    private final FocusView focusView;
    private final VertsView vertsView;
    private TrajectoryUtils trajectoryUtils;
    private final Vector3Q aux3b1 = new Vector3Q();

    public SceneModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
        this.focusView = new FocusView();
        this.vertsView = new VertsView();
        em.subscribe((IObserver)this, Event.SCENE_LOADED);
    }

    @Override
    public FocusView get_object(String name) {
        return this.get_object(name, 0.0);
    }

    @Override
    public FocusView get_object(String name, double timeout) {
        if (this.api.validator.checkObjectName(name, timeout)) {
            Entity object = this.get_entity(name, timeout);
            return new FocusView(object);
        }
        return null;
    }

    @Override
    public VertsView get_line_object(String name) {
        return this.get_line_object(name, 0.0);
    }

    @Override
    public VertsView get_line_object(String name, double timeout) {
        if (this.api.validator.checkObjectName(name, timeout)) {
            Entity object = this.get_entity(name, timeout);
            if (Mapper.verts.has(object)) {
                return new VertsView(object);
            }
            this.logger.error(name + " is not a verts object.");
            return null;
        }
        return null;
    }

    @Override
    public Entity get_entity(String name) {
        return this.get_entity(name, 0.0);
    }

    @Override
    public Entity get_entity(String name, double timeout) {
        Entity obj = this.scene.getEntity(name);
        if (obj == null) {
            if (name.matches("[0-9]+")) {
                obj = this.scene.getEntity("hip " + name);
            } else if (name.matches("hip [0-9]+")) {
                obj = this.scene.getEntity(name.substring(4));
            }
        }
        if (timeout < 0.0) {
            timeout = Double.MAX_VALUE;
        }
        double startMs = System.currentTimeMillis();
        double elapsedSeconds = 0.0;
        while (obj == null && elapsedSeconds < timeout) {
            this.api.base.sleep_frames(1L);
            obj = this.scene.getEntity(name);
            elapsedSeconds = ((double)System.currentTimeMillis() - startMs) / 1000.0;
        }
        return obj;
    }

    @Override
    public Entity get_focus(String name) {
        return this.scene.findFocus(name);
    }

    public Entity get_focus_entity(String name) {
        return this.get_focus(name);
    }

    @Override
    public double[] get_star_parameters(String name) {
        StarSet set;
        IParticleRecord sb;
        Entity entity;
        if (this.api.validator.checkObjectName(name) && Mapper.starSet.has(entity = this.get_entity(name)) && (sb = (set = (StarSet)Mapper.starSet.get(entity)).getCandidateBean()) != null) {
            double[] rgb = sb.rgb();
            return new double[]{sb.ra(), sb.dec(), sb.parallax(), sb.muAlpha(), sb.muDelta(), sb.radVel(), sb.appMag(), rgb[0], rgb[1], rgb[2]};
        }
        return null;
    }

    @Override
    public double[] get_object_position(String name) {
        return this.get_object_position(name, "internal");
    }

    @Override
    public double[] get_object_position(String name, String units) {
        if (this.api.validator.checkObjectName(name) && this.api.validator.checkDistanceUnits(units)) {
            Entity entity = this.get_entity(name);
            this.focusView.setEntity(entity);
            this.focusView.getFocus(name);
            this.focusView.getAbsolutePosition(name, this.aux3b1);
            Settings.DistanceUnits u = Settings.DistanceUnits.valueOf(units.toUpperCase(Locale.ROOT));
            return new double[]{u.fromInternalUnits(this.aux3b1.x.doubleValue()), u.fromInternalUnits(this.aux3b1.y.doubleValue()), u.fromInternalUnits(this.aux3b1.z.doubleValue())};
        }
        return null;
    }

    @Override
    public double[] get_object_predicted_position(String name) {
        return this.get_object_predicted_position(name, "internal");
    }

    @Override
    public double[] get_object_predicted_position(String name, String units) {
        if (this.api.validator.checkObjectName(name) && this.api.validator.checkDistanceUnits(units)) {
            Entity entity = this.get_entity(name);
            this.focusView.setEntity(entity);
            this.focusView.getFocus(name);
            this.focusView.getPredictedPosition(this.aux3b1, GaiaSky.instance.time, GaiaSky.instance.getICamera(), false);
            Settings.DistanceUnits u = Settings.DistanceUnits.valueOf(units.toUpperCase(Locale.ROOT));
            return new double[]{u.fromInternalUnits(this.aux3b1.x.doubleValue()), u.fromInternalUnits(this.aux3b1.y.doubleValue()), u.fromInternalUnits(this.aux3b1.z.doubleValue())};
        }
        return null;
    }

    @Override
    public void set_object_posiiton(String name, double[] pos) {
        this.set_object_posiiton(name, pos, "internal");
    }

    @Override
    public void set_object_posiiton(String name, double[] pos, String units) {
        if (this.api.validator.checkObjectName(name)) {
            this.set_object_posiiton(this.get_object(name), pos, units);
        }
    }

    public void set_object_posiiton(String name, List<?> position) {
        this.set_object_posiiton(name, position, "internal");
    }

    public void set_object_posiiton(String name, List<?> position, String units) {
        this.set_object_posiiton(name, this.api.dArray(position), units);
    }

    @Override
    public void set_object_posiiton(FocusView object, double[] pos) {
        this.set_object_posiiton(object, pos, "internal");
    }

    @Override
    public void set_object_posiiton(FocusView object, double[] pos, String units) {
        this.set_object_posiiton(object.getEntity(), pos, units);
    }

    public void set_object_posiiton(FocusView object, List<?> position) {
        this.set_object_posiiton(object, position, "internal");
    }

    public void set_object_posiiton(FocusView object, List<?> position, String units) {
        this.set_object_posiiton(object, this.api.dArray(position), units);
    }

    @Override
    public void set_object_posiiton(Entity object, double[] pos) {
        this.set_object_posiiton(object, pos, "internal");
    }

    @Override
    public void set_object_posiiton(Entity object, double[] pos, String units) {
        if (this.api.validator.checkNotNull(object, "object") && this.api.validator.checkLength(pos, 3, "position") && this.api.validator.checkDistanceUnits(units)) {
            Settings.DistanceUnits u = Settings.DistanceUnits.valueOf(units.toUpperCase(Locale.ROOT));
            double[] posUnits = new double[]{u.toInternalUnits(pos[0]), u.toInternalUnits(pos[1]), u.toInternalUnits(pos[2])};
            Body body = (Body)Mapper.body.get(object);
            body.pos.set(posUnits);
            body.positionSetInScript = true;
        }
    }

    @Override
    public void set_object_coordinates_provider(String name, IPythonCoordinatesProvider provider) {
        gaiasky.scene.component.Coordinates coord;
        FocusView object;
        if (this.api.validator.checkObjectName(name) && this.api.validator.checkNotNull(provider, "provider") && this.api.validator.checkNotNull((object = this.get_object(name)).getEntity(), "object") && this.api.validator.checkNotNull(coord = (gaiasky.scene.component.Coordinates)Mapper.coordinates.get(object.getEntity()), "coordinates")) {
            PythonBodyCoordinates coordinates = new PythonBodyCoordinates(provider);
            this.api.base.post_runnable(() -> {
                coord.coordinates = coordinates;
                GaiaSky.instance.touchSceneGraph();
            });
        }
    }

    @Override
    public void remove_object_coordinates_provider(String name) {
        gaiasky.scene.component.Coordinates coord;
        FocusView object;
        if (this.api.validator.checkObjectName(name) && this.api.validator.checkNotNull((object = this.get_object(name)).getEntity(), "object") && this.api.validator.checkNotNull(coord = (gaiasky.scene.component.Coordinates)Mapper.coordinates.get(object.getEntity()), "coordinates")) {
            this.api.base.post_runnable(() -> {
                coord.coordinates = null;
            });
        }
    }

    public void set_object_posiiton(Entity object, List<?> position) {
        this.set_object_posiiton(object, this.api.dArray(position));
    }

    @Override
    public void set_component_type_visibility(String key, boolean visible) {
        if (this.checkCtKeyNull(key)) {
            ComponentTypes.ComponentType[] cts;
            this.logger.error("Element '" + key + "' does not exist. Possible values are:");
            for (ComponentTypes.ComponentType ct : cts = ComponentTypes.ComponentType.values()) {
                this.logger.error(ct.key);
            }
        } else {
            this.api.base.post_runnable(() -> this.em.post(Event.TOGGLE_VISIBILITY_CMD, this, key, visible));
        }
    }

    @Override
    public boolean get_component_type_visibility(String key) {
        if (this.checkCtKeyNull(key)) {
            ComponentTypes.ComponentType[] cts;
            this.logger.error("Element '" + key + "' does not exist. Possible values are:");
            for (ComponentTypes.ComponentType ct : cts = ComponentTypes.ComponentType.values()) {
                this.logger.error(ct.key);
            }
            return false;
        }
        ComponentTypes.ComponentType ct = ComponentTypes.ComponentType.getFromKey(key);
        return Settings.settings.scene.visibility.get(ct.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] get_object_screen_coordinates(String name) {
        if (this.api.validator.checkObjectName(name)) {
            Entity entity = this.get_entity(name);
            CameraManager camera = GaiaSky.instance.cameraManager;
            Vector3 posFloat = new Vector3();
            Vector3D posDouble = new Vector3D();
            Vector3Q posPrec = new Vector3Q();
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(entity);
                this.focusView.getAbsolutePosition(name, posPrec);
                posPrec.add(camera.getInversePos());
                posPrec.put(posFloat);
                posPrec.put(posDouble);
                if (camera.getCamera().direction.dot(posFloat) > 0.0f) {
                    camera.getCamera().project(posFloat);
                    if (posFloat.x < 0.0f || posFloat.x > (float)Gdx.graphics.getWidth() || posFloat.y < 0.0f || posFloat.y > (float)Gdx.graphics.getHeight()) {
                        return null;
                    }
                    return new double[]{posFloat.x, posFloat.y};
                }
            }
        }
        return null;
    }

    @Override
    public boolean set_object_visibility(String name, boolean visible) {
        if (this.api.validator.checkObjectName(name)) {
            Entity obj = this.get_entity(name);
            this.api.base.post_runnable(() -> EventManager.publish(Event.PER_OBJECT_VISIBILITY_CMD, this, obj, name, visible));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get_object_visibility(String name) {
        if (this.api.validator.checkObjectName(name)) {
            boolean visible;
            Entity obj = this.get_entity(name);
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(obj);
                visible = this.focusView.isVisible(name.toLowerCase(Locale.ROOT).strip());
            }
            return visible;
        }
        return false;
    }

    @Override
    public void set_object_size_scaling(String name, double factor) {
        if (this.api.validator.checkObjectName(name)) {
            Entity object = this.get_entity(name);
            this.set_object_size_scaling(object, factor);
        }
    }

    public void set_object_size_scaling(Entity object, double scalingFactor) {
        if (this.api.validator.checkNotNull(object, "Entity")) {
            if (Mapper.modelScaffolding.has(object)) {
                ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(object);
                scaffolding.setSizeScaleFactor(scalingFactor);
            } else if (Mapper.trajectory.has(object)) {
                Trajectory trajectory = (Trajectory)Mapper.trajectory.get(object);
                trajectory.params.multiplier = scalingFactor;
            } else {
                Base base = (Base)Mapper.base.get(object);
                this.logger.error("Object '" + base.getName() + "' is not a model or trajectory object");
            }
        }
    }

    @Override
    public void set_orbit_coordinates_scaling(String name, double factor) {
        String objectName;
        String className;
        int modified = 0;
        if (name.contains(":")) {
            int idx = name.indexOf(":");
            className = name.substring(0, idx);
            objectName = name.substring(idx + 1);
        } else {
            className = name;
            objectName = null;
        }
        List<AbstractOrbitCoordinates> aocs = AbstractOrbitCoordinates.getInstances();
        for (AbstractOrbitCoordinates aoc : aocs) {
            if (!aoc.getClass().getSimpleName().equalsIgnoreCase(className)) continue;
            if (objectName != null) {
                if (aoc.getOrbitName() == null || !aoc.getOrbitName().contains(objectName)) continue;
                aoc.setScaling(factor);
                ++modified;
                continue;
            }
            aoc.setScaling(factor);
            ++modified;
        }
        this.logger.info(name + ": modified scaling of " + modified + " orbits");
    }

    private void initializeTrajectoryUtils() {
        if (this.trajectoryUtils == null) {
            this.trajectoryUtils = new TrajectoryUtils();
        }
    }

    @Override
    public void refresh_all_orbits() {
        this.initializeTrajectoryUtils();
        this.api.base.post_runnable(() -> {
            ImmutableArray<Entity> orbits = this.scene.findEntitiesByFamily(this.scene.getFamilies().orbits);
            for (Entity orbit : orbits) {
                Trajectory trajectory = (Trajectory)Mapper.trajectory.get(orbit);
                Verts verts = (Verts)Mapper.verts.get(orbit);
                this.trajectoryUtils.refreshOrbit(trajectory, verts, true);
            }
        });
    }

    @Override
    public void force_update_scene() {
        this.api.base.post_runnable(() -> this.em.post(Event.SCENE_FORCE_UPDATE, this));
    }

    @Override
    public void refresh_object_orbit(String name) {
        String orbitName = name + " orbit";
        if (this.api.validator.checkObjectName(orbitName)) {
            FocusView view = this.get_object(orbitName);
            Trajectory trajectory = (Trajectory)Mapper.trajectory.get(view.getEntity());
            Verts verts = (Verts)Mapper.verts.get(view.getEntity());
            if (trajectory != null && verts != null) {
                this.initializeTrajectoryUtils();
                this.api.base.post_runnable(() -> this.trajectoryUtils.refreshOrbit(trajectory, verts, true));
            }
        }
    }

    @Override
    public double get_object_radius(String name) {
        if (this.api.validator.checkObjectName(name)) {
            Entity object = this.scene.findFocus(name);
            this.focusView.setEntity(object);
            this.focusView.getFocus(name);
            return this.focusView.getRadius() * Constants.U_TO_KM;
        }
        return -1.0;
    }

    private boolean setObjectQuaternionOrientation(String name, String file, boolean slerp) {
        FocusView entity;
        if (this.api.validator.checkObjectName(name) && Mapper.orientation.has((entity = this.get_object(name)).getEntity())) {
            Orientation orientation = (Orientation)Mapper.orientation.get(entity.getEntity());
            this.api.base.post_runnable(() -> {
                try {
                    AttitudeComponent quatOri = new AttitudeComponent();
                    quatOri.orientationServer = slerp ? new QuaternionSlerpOrientationServer(file) : new QuaternionNlerpOrientationServer(file);
                    orientation.attitudeComponent = quatOri;
                }
                catch (Exception e) {
                    this.logger.error(e);
                }
                finally {
                    if (orientation.rotationComponent != null) {
                        orientation.rotationComponent = null;
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean set_object_quaternion_slerp_orientation(String name, String path) {
        return this.setObjectQuaternionOrientation(name, path, true);
    }

    @Override
    public boolean set_object_quaternion_nlerp_orientation(String name, String path) {
        return this.setObjectQuaternionOrientation(name, path, false);
    }

    @Override
    public void set_label_size_factor(float factor) {
        if (this.api.validator.checkNum(factor, 0.7f, 2.5f, "labelSizeFactor")) {
            this.api.base.post_runnable(() -> this.em.post(Event.LABEL_SIZE_CMD, this, Float.valueOf(factor)));
        }
    }

    public void set_label_size_factor(int factor) {
        this.set_label_size_factor((float)factor);
    }

    @Override
    public void set_force_display_label(String name, boolean force) {
        if (this.api.validator.checkObjectName(name)) {
            Entity obj = this.get_entity(name);
            this.em.post(Event.FORCE_OBJECT_LABEL_CMD, this, obj, name, force);
        }
    }

    @Override
    public void set_label_color(String name, double[] color) {
        if (this.api.validator.checkObjectName(name)) {
            Entity obj = this.get_entity(name);
            this.em.post(Event.LABEL_COLOR_CMD, this, obj, name, GlobalResources.toFloatArray(color));
        }
    }

    public void set_label_color(String name, List<?> color) {
        this.set_label_color(name, this.api.dArray(color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get_force_dispaly_label(String name) {
        if (this.api.validator.checkFocusName(name)) {
            boolean ret;
            Entity obj = this.get_entity(name);
            FocusView focusView = this.focusView;
            synchronized (focusView) {
                this.focusView.setEntity(obj);
                ret = this.focusView.isForceLabel(name);
            }
            return ret;
        }
        return false;
    }

    @Override
    public void set_line_width_factor(float factor) {
        if (this.api.validator.checkNum(factor, 0.2f, 3.5f, "lineWidthFactor")) {
            this.api.base.post_runnable(() -> this.em.post(Event.LINE_WIDTH_CMD, this, Float.valueOf(factor)));
        }
    }

    public void set_line_width_factor(int factor) {
        this.set_line_width_factor((float)factor);
    }

    private boolean checkCtKeyNull(String key) {
        ComponentTypes.ComponentType ct = ComponentTypes.ComponentType.getFromKey(key);
        return ct == null;
    }

    @Override
    public void set_velocity_vectors_number_factor(float factor) {
        this.api.base.post_runnable(() -> EventManager.publish(Event.PM_NUM_FACTOR_CMD, this, Float.valueOf(MathUtilsDouble.lint(factor, 0.0f, 100.0f, 1.0f, 10.0f))));
    }

    public void set_velocity_vectors_number_factor(int factor) {
        this.set_velocity_vectors_number_factor((float)factor);
    }

    public void set_unfiltered_velocity_vectors_number_factor(float factor) {
        Settings.settings.scene.properMotion.number = factor;
    }

    @Override
    public void set_velocity_vectors_color_mode(int mode) {
        this.api.base.post_runnable(() -> EventManager.publish(Event.PM_COLOR_MODE_CMD, this, mode % 6));
    }

    @Override
    public void set_velocity_vectors_arrowheads(boolean enabled) {
        this.api.base.post_runnable(() -> EventManager.publish(Event.PM_ARROWHEADS_CMD, this, enabled));
    }

    @Override
    public void set_velocity_vectors_length_factor(float factor) {
        this.api.base.post_runnable(() -> EventManager.publish(Event.PM_LEN_FACTOR_CMD, this, Float.valueOf(factor)));
    }

    public void set_velocity_vectors_length_factor(int factor) {
        this.set_velocity_vectors_length_factor((float)factor);
    }

    @Override
    public long get_velocity_vector_max_number() {
        return Settings.settings.scene.star.group.numVelocityVector;
    }

    @Override
    public void set_velocity_vector_max_number(long num) {
        Settings.settings.scene.star.group.numVelocityVector = (int)num;
    }

    @Override
    public void add_trajectory_line(String name, double[] points, double[] color) {
        Entity ignored = this.addLineObject(name, points, color, 1.5, 3, false, -1.0, "Orbit");
    }

    public void add_trajectory_line(String name, List<?> points, List<?> color) {
        Entity ignored = this.addLineObject(name, points, color, 1.5, 3, false, -1.0, "Orbit");
    }

    @Override
    public void add_trajectory_line(String name, double[] points, double[] color, double trail) {
        Entity entity = this.addLineObject(name, points, color, 1.5, 3, false, trail, "Orbit");
    }

    public void add_trajectory_line(String name, List<?> points, List<?> color, double trailMap) {
        this.add_trajectory_line(name, this.api.dArray(points), this.api.dArray(color), trailMap);
    }

    @Override
    public void add_polyline(String name, double[] points, double[] color) {
        this.add_polyline(name, points, color, 1.0);
    }

    public void add_polyline(String name, List<?> points, List<?> color) {
        this.add_polyline(name, points, color, 1.0f);
    }

    @Override
    public void add_polyline(String name, double[] points, double[] color, double width) {
        this.add_polyline(name, points, color, width, false);
    }

    @Override
    public void add_polyline(String name, double[] points, double[] color, double width, boolean caps) {
        this.add_polyline(name, points, color, width, 3, caps);
    }

    @Override
    public void add_polyline(String name, double[] points, double[] color, double width, int primitive) {
        this.add_polyline(name, points, color, width, primitive, false);
    }

    @Override
    public void add_polyline(String name, double[] points, double[] color, double width, int primitive, boolean caps) {
        this.addLineObject(name, points, color, width, primitive, caps, -1.0, "Polyline");
    }

    Entity addLineObject(String name, List<?> points, List<?> color, double lineWidth, int primitive, boolean arrowCaps, double trailMap, String archetypeName) {
        return this.addLineObject(name, this.api.dArray(points), this.api.dArray(color), lineWidth, primitive, arrowCaps, trailMap, archetypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entity addLineObject(String name, double[] points, double[] color, double lineWidth, int primitive, boolean arrowCaps, double trailMap, String archetypeName) {
        if (this.api.validator.checkString(name, "name") && this.api.validator.checkNum(lineWidth, (double)0.1f, 50.0, "lineWidth") && this.api.validator.checkNum(primitive, 1, 3, "primitive")) {
            Archetype archetype = this.scene.archetypes().get(archetypeName);
            Entity entity = archetype.createEntity();
            Base base = (Base)Mapper.base.get(entity);
            base.setName(name);
            base.setComponentType(ComponentTypes.ComponentType.Orbits);
            Body body = (Body)Mapper.body.get(entity);
            body.setColor(color);
            body.setLabelColor(color);
            body.setSizePc(100.0);
            Line line = (Line)Mapper.line.get(entity);
            line.lineWidth = (float)lineWidth;
            Arrow arrow = (Arrow)Mapper.arrow.get(entity);
            arrow.arrowCap = arrowCaps;
            Verts verts = (Verts)Mapper.verts.get(entity);
            VertsView vertsView = this.vertsView;
            synchronized (vertsView) {
                this.vertsView.setEntity(entity);
                this.vertsView.setPrimitiveSize((float)lineWidth);
                this.vertsView.setPoints(points);
                this.vertsView.setRenderGroup(arrowCaps ? RenderGroup.LINE : RenderGroup.LINE_GPU);
                this.vertsView.setClosedLoop(false);
                this.vertsView.setGlPrimitive(primitive);
            }
            Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
            if (trajectory != null) {
                if (trailMap < 0.0) {
                    trajectory.orbitTrail = false;
                    trajectory.setTrailMap(trailMap);
                } else {
                    trailMap = MathUtilsDouble.clamp(trailMap, 0.0, 1.0);
                    trajectory.orbitTrail = true;
                    trajectory.setTrailMap(trailMap);
                }
            }
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            graph.setParent("Universe");
            this.scene.initializeEntity(entity);
            this.scene.setUpEntity(entity);
            this.em.post(Event.SCENE_ADD_OBJECT_CMD, this, entity, true);
            return entity;
        }
        return null;
    }

    public void add_polyline(String name, double[] points, double[] color, int lineWidth) {
        this.add_polyline(name, points, color, (double)lineWidth);
    }

    public void add_polyline(String name, double[] points, double[] color, int lineWidth, int primitive) {
        this.add_polyline(name, points, color, (double)lineWidth, primitive);
    }

    public void add_polyline(String name, List<?> points, List<?> color, float lineWidth) {
        this.add_polyline(name, this.api.dArray(points), this.api.dArray(color), (double)lineWidth);
    }

    public void add_polyline(String name, List<?> points, List<?> color, float lineWidth, boolean arrowCaps) {
        this.add_polyline(name, this.api.dArray(points), this.api.dArray(color), (double)lineWidth, arrowCaps);
    }

    public void add_polyline(String name, List<?> points, List<?> color, float lineWidth, int primitive) {
        this.add_polyline(name, this.api.dArray(points), this.api.dArray(color), (double)lineWidth, primitive);
    }

    public void add_polyline(String name, List<?> points, List<?> color, float lineWidth, int primitive, boolean arrowCaps) {
        this.add_polyline(name, this.api.dArray(points), this.api.dArray(color), (double)lineWidth, primitive, arrowCaps);
    }

    public void add_polyline(String name, List<?> points, List<?> color, int lineWidth) {
        this.add_polyline(name, points, color, (float)lineWidth);
    }

    public void add_polyline(String name, List<?> points, List<?> color, int lineWidth, boolean arrowCaps) {
        this.add_polyline(name, points, color, (float)lineWidth, arrowCaps);
    }

    public void add_polyline(String name, List<?> points, List<?> color, int lineWidth, int primitive) {
        this.add_polyline(name, points, color, (float)lineWidth, primitive);
    }

    public void add_polyline(String name, List<?> points, List<?> color, int lineWidth, int primitive, boolean arrowCaps) {
        this.add_polyline(name, points, color, (float)lineWidth, primitive, arrowCaps);
    }

    @Override
    public void remove_object(String name) {
        if (this.api.validator.checkString(name, "name")) {
            this.em.post(Event.SCENE_REMOVE_OBJECT_CMD, this, name, true);
        }
    }

    @Override
    public void add_shape_around_object(String name, String shapeType, String primitive, double size, String obj_name, float r, float g, float b, float a, boolean label, boolean track) {
        this.add_shape_around_object(name, shapeType, primitive, OrientationComboBoxBean.ShapeOrientation.EQUATORIAL.toString(), size, obj_name, r, g, b, a, label, track);
    }

    @Override
    public void add_shape_around_object(String name, String shapeType, String primitive, String ori, double size, String obj_name, float r, float g, float b, float a, boolean label, boolean track) {
        if (this.api.validator.checkString(name, "shapeName") && this.api.validator.checkStringEnum(shapeType, ShapeComboBoxBean.Shape.class, "shape") && this.api.validator.checkStringEnum(primitive, PrimitiveComboBoxBean.Primitive.class, "primitive") && this.api.validator.checkStringEnum(ori, OrientationComboBoxBean.ShapeOrientation.class, "orientation") && this.api.validator.checkNum(size, 0.0, Double.MAX_VALUE, "size") && this.api.validator.checkObjectName(obj_name)) {
            String shapeLc = shapeType.toLowerCase(Locale.ROOT);
            this.api.base.post_runnable(() -> {
                Entity trackingObject = this.get_focus_entity(obj_name);
                float[] color = new float[]{r, g, b, a};
                int primitiveInt = PrimitiveComboBoxBean.Primitive.valueOf(primitive.toUpperCase(Locale.ROOT)).equals((Object)PrimitiveComboBoxBean.Primitive.LINES) ? 1 : 4;
                Archetype at = this.scene.archetypes().get("ShapeObject");
                Entity newShape = at.createEntity();
                Base base = (Base)Mapper.base.get(newShape);
                base.setName(name.trim());
                base.ct = new ComponentTypes(ComponentTypes.ComponentType.Others.ordinal());
                Body body = (Body)Mapper.body.get(newShape);
                body.setColor(color);
                body.setLabelColor(new float[]{r, g, b, a});
                body.size = (float)(size * Constants.KM_TO_U);
                GraphNode graph = (GraphNode)Mapper.graph.get(newShape);
                graph.setParent("Universe");
                Focus focus = (Focus)Mapper.focus.get(newShape);
                focus.focusable = false;
                Shape shape = (Shape)Mapper.shape.get(newShape);
                if (track) {
                    shape.track = new FocusView(trackingObject);
                } else {
                    body.setPos(EntityUtils.getAbsolutePosition(trackingObject, obj_name, new Vector3Q()));
                }
                shape.trackName = obj_name;
                RefSysTransform trf = (RefSysTransform)Mapper.transform.get(newShape);
                Matrix4 m = new Matrix4();
                OrientationComboBoxBean.ShapeOrientation orient = OrientationComboBoxBean.ShapeOrientation.valueOf(ori.toUpperCase(Locale.ROOT));
                switch (orient) {
                    case CAMERA: {
                        PerspectiveCamera camera = GaiaSky.instance.cameraManager.getCamera();
                        m.rotateTowardDirection(camera.direction, camera.up);
                        break;
                    }
                    case EQUATORIAL: {
                        m.idt();
                        break;
                    }
                    case ECLIPTIC: {
                        m.set(Coordinates.eclipticToEquatorialF());
                        break;
                    }
                    case GALACTIC: {
                        m.set(Coordinates.galacticToEquatorialF());
                    }
                }
                trf.setTransformMatrix(m);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("quality", 25L);
                params.put("divisions", shapeLc.equalsIgnoreCase(ShapeComboBoxBean.Shape.OCTAHEDRONSPHERE.toString()) ? 3L : 35L);
                params.put("recursion", 3L);
                params.put("diameter", 1.0);
                params.put("width", 1.0);
                params.put("height", 1.0);
                params.put("depth", 1.0);
                params.put("innerradius", 0.6);
                params.put("outerradius", 1.0);
                params.put("sphere-in-ring", false);
                params.put("flip", false);
                Model model = (Model)Mapper.model.get(newShape);
                model.model = new ModelComponent();
                model.model.type = shapeLc;
                model.model.setPrimitiveType(primitiveInt);
                model.model.setParams(params);
                model.model.setStaticLight(true);
                model.model.setUseColor(true);
                model.model.setBlendMode(BlendMode.ADDITIVE);
                model.model.setCulling(false);
                RenderType rt = (RenderType)Mapper.renderType.get(newShape);
                rt.renderGroup = RenderGroup.MODEL_VERT_ADDITIVE;
                this.scene.initializeEntity(newShape);
                this.scene.setUpEntity(newShape);
                EventManager.publish(Event.SCENE_ADD_OBJECT_NO_POST_CMD, this, newShape, false);
            });
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (Objects.requireNonNull(event) == Event.SCENE_LOADED) {
            this.scene = (Scene)data[0];
            this.focusView.setScene(this.scene);
        }
    }
}

