/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.script.v2.api.TimeAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.Settings;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.time.ITimeFrameProvider;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class TimeModule
extends APIModule
implements TimeAPI {
    private int cTransSeq = 0;

    public TimeModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    @Override
    public void activate_real_time_frame() {
        this.api.base.post_runnable(() -> this.em.post(Event.EVENT_TIME_FRAME_CMD, this, new Object[]{EventManager.TimeFrame.REAL_TIME}));
    }

    @Override
    public void activate_simulation_time_frame() {
        this.api.base.post_runnable(() -> this.em.post(Event.EVENT_TIME_FRAME_CMD, this, new Object[]{EventManager.TimeFrame.SIMULATION_TIME}));
    }

    @Override
    public void set_clock(int yr, int month, int day, int hour, int min, int sec, int ms) {
        if (this.api.validator.checkDateTime(yr, month, day, hour, min, sec, ms)) {
            LocalDateTime date = LocalDateTime.of(yr, month, day, hour, min, sec, ms);
            this.em.post(Event.TIME_CHANGE_CMD, this, date.toInstant(ZoneOffset.UTC));
        }
    }

    @Override
    public long get_clock() {
        ITimeFrameProvider time = GaiaSky.instance.time;
        return time.getTime().toEpochMilli();
    }

    @Override
    public void set_clock(long time) {
        if (this.api.validator.checkNum(time, -9223372036854775807L, Long.MAX_VALUE, "time")) {
            this.em.post(Event.TIME_CHANGE_CMD, this, Instant.ofEpochMilli(time));
        }
    }

    @Override
    public int[] get_clock_array() {
        ITimeFrameProvider time = GaiaSky.instance.time;
        Instant instant = time.getTime();
        LocalDateTime c = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        int[] result = new int[]{c.get(ChronoField.YEAR_OF_ERA), c.getMonthValue(), c.getDayOfMonth(), c.getHour(), c.getMinute(), c.getSecond(), c.get(ChronoField.MILLI_OF_SECOND)};
        return result;
    }

    @Override
    public void start_clock() {
        this.em.post(Event.TIME_STATE_CMD, this, true);
    }

    @Override
    public void stop_clock() {
        this.em.post(Event.TIME_STATE_CMD, this, false);
    }

    @Override
    public boolean is_clock_on() {
        return GaiaSky.instance.time.isTimeOn();
    }

    @Override
    public void set_time_warp(double warp) {
        this.em.post(Event.TIME_WARP_CMD, this, warp);
    }

    public void set_time_warp(long warp) {
        this.set_time_warp((double)warp);
    }

    @Override
    public void set_target_time(long ms) {
        this.em.post(Event.TARGET_TIME_CMD, this, Instant.ofEpochMilli(ms));
    }

    @Override
    public void set_target_time(int yr, int month, int day, int hour, int min, int sec, int ms) {
        if (this.api.validator.checkDateTime(yr, month, day, hour, min, sec, ms)) {
            this.em.post(Event.TARGET_TIME_CMD, this, LocalDateTime.of(yr, month, day, hour, min, sec, ms).toInstant(ZoneOffset.UTC));
        }
    }

    @Override
    public void remove_target_time() {
        this.em.post(Event.TARGET_TIME_CMD, this);
    }

    @Override
    public void set_max_simulation_time(long yr) {
        if (this.api.validator.checkFinite(yr, "years")) {
            Settings.settings.runtime.setMaxTime(Math.abs(yr));
        }
    }

    public void setMaximumSimulationTime(double years) {
        this.set_max_simulation_time((long)years);
    }

    public void setMaximumSimulationTime(Long years) {
        this.set_max_simulation_time(years);
    }

    public void setMaximumSimulationTime(Double years) {
        this.set_max_simulation_time(years.longValue());
    }

    public void setMaximumSimulationTime(Integer years) {
        this.set_max_simulation_time(years.longValue());
    }

    @Override
    public void transition(int yr, int month, int day, int hour, int min, int sec, int ms, double duration, String smooth_type, double smooth_factor, boolean sync) {
        this.transition(yr, month, day, hour, min, sec, ms, duration, smooth_type, smooth_factor, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(int year, int month, int day, int hour, int min, int sec, int milliseconds, double durationSeconds, String smoothType, double smoothFactor, boolean sync, AtomicBoolean stop) {
        block12: {
            if (this.api.validator.checkDateTime(year, month, day, hour, min, sec, milliseconds)) {
                String name = "timeTransition" + this.cTransSeq++;
                Runnable end = null;
                if (!sync) {
                    end = () -> this.api.base.remove_runnable(name);
                }
                TimeTransitionRunnable r = new TimeTransitionRunnable(year, month, day, hour, min, sec, milliseconds, durationSeconds, smoothType, smoothFactor, end, stop);
                try {
                    this.api.base.park_runnable(name, r);
                    if (!sync) break block12;
                    Object object = r.lock;
                    synchronized (object) {
                        try {
                            r.lock.wait();
                        }
                        catch (InterruptedException e) {
                            this.logger.error(e);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error(e);
                }
                finally {
                    this.api.base.remove_runnable(name);
                }
            }
        }
    }

    class TimeTransitionRunnable
    implements Runnable {
        final Object lock = new Object();
        final Long currentTimeMs;
        final AtomicBoolean stop;
        Long targetTimeMs;
        Long dt;
        final double duration;
        double elapsed;
        double start;
        Runnable end;
        Function<Double, Double> mapper;

        public TimeTransitionRunnable(int year, int month, int day, int hour, int min, int sec, int milliseconds, double durationSeconds, String smoothType, double smoothFactor, Runnable end, AtomicBoolean stop) {
            this.duration = durationSeconds;
            this.start = GaiaSky.instance.getT();
            this.currentTimeMs = GaiaSky.instance.time.getTime().toEpochMilli();
            this.mapper = this.getMapper(smoothType, smoothFactor);
            this.stop = stop;
            try {
                LocalDateTime date = LocalDateTime.of(year, month, day, hour, min, sec, milliseconds);
                Instant instant = date.toInstant(ZoneOffset.UTC);
                this.targetTimeMs = instant.toEpochMilli();
                this.dt = this.targetTimeMs - this.currentTimeMs;
            }
            catch (DateTimeException e) {
                TimeModule.this.logger.error("Could not create time transition: bad date.", e);
            }
        }

        private Function<Double, Double> getMapper(String smoothingType, double smoothingFactor) {
            Function<Double, Double> mapper;
            if (Objects.equals(smoothingType, "logisticsigmoid")) {
                double fac = MathUtilsDouble.clamp(smoothingFactor, 12.0, 500.0);
                mapper = x -> MathUtilsDouble.clamp(MathUtilsDouble.logisticSigmoid(x, fac), 0.0, 1.0);
            } else if (Objects.equals(smoothingType, "logit")) {
                double fac = MathUtilsDouble.clamp(smoothingFactor, 0.01, 0.09);
                mapper = x -> MathUtilsDouble.clamp(MathUtilsDouble.logit(x) * fac + 0.5, 0.0, 1.0);
            } else {
                mapper = x -> x;
            }
            return mapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.elapsed = GaiaSky.instance.getT() - this.start;
            double alpha = MathUtilsDouble.clamp(this.elapsed / this.duration, 0.0, 1.0);
            alpha = this.mapper.apply(alpha);
            long t = this.currentTimeMs + (long)(alpha * (double)this.dt.longValue());
            TimeModule.this.em.post(Event.TIME_CHANGE_CMD, this, Instant.ofEpochMilli(t));
            if (this.stop != null && this.stop.get() || this.elapsed >= this.duration) {
                if (this.end != null) {
                    this.end.run();
                } else {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notify();
                    }
                }
            }
        }
    }
}

