/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.impl;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.api.IGui;
import gaiasky.script.v2.api.UiAPI;
import gaiasky.script.v2.impl.APIModule;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.util.LruCache;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import java.util.List;

public class UiModule
extends APIModule
implements UiAPI {
    private LruCache<String, Texture> textures;

    public UiModule(EventManager em, APIv2 api, String name) {
        super(em, api, name);
    }

    private void initializeTextures() {
        if (this.textures == null) {
            this.textures = new LruCache(100);
        }
    }

    @Override
    public void display_message(int id, String msg, float x, float y, float r, float g, float b, float a, float size) {
        this.api.base.post_runnable(() -> this.em.post(Event.ADD_CUSTOM_MESSAGE, this, id, msg, Float.valueOf(x), Float.valueOf(y), Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(a), Float.valueOf(size)));
    }

    @Override
    public void display_message(int id, String msg, double x, double y, double[] color, double size) {
        if (this.api.validator.checkNotNull(color, "color") && this.api.validator.checkLengths(color, 3, 4, "color")) {
            float a = color.length > 3 ? (float)color[3] : 1.0f;
            this.display_message(id, msg, (float)x, (float)y, (float)color[0], (float)color[1], (float)color[2], a, (float)size);
        }
    }

    public void display_message(int id, String message, double x, double y, List<?> color, double fontSize) {
        this.display_message(id, message, x, y, this.api.dArray(color), fontSize);
    }

    public void display_message(int id, String message, float x, float y, float r, float g, float b, float a, int fontSize) {
        this.display_message(id, message, x, y, r, g, b, a, (float)fontSize);
    }

    @Override
    public void display_text(int id, String msg, float x, float y, float max_w, float max_h, float r, float g, float b, float a, float size) {
        this.api.base.post_runnable(() -> this.em.post(Event.ADD_CUSTOM_TEXT, this, id, msg, Float.valueOf(x), Float.valueOf(y), Float.valueOf(max_w), Float.valueOf(max_h), Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(a), Float.valueOf(size)));
    }

    public void display_text(int id, String text, float x, float y, float maxWidth, float maxHeight, float r, float g, float b, float a, int fontSize) {
        this.display_text(id, text, x, y, maxWidth, maxHeight, r, g, b, a, (float)fontSize);
    }

    @Override
    public void display_image(int id, String path, float x, float y, float r, float g, float b, float a) {
        this.api.base.post_runnable(() -> {
            Texture tex = this.getTexture(path);
            this.em.post(Event.ADD_CUSTOM_IMAGE, this, id, tex, Float.valueOf(x), Float.valueOf(y), Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(a));
        });
    }

    @Override
    public void display_image(int id, String path, double x, double y, double[] color) {
        if (this.api.validator.checkNotNull(color, "color") && this.api.validator.checkLengths(color, 3, 4, "color")) {
            float a = color.length > 3 ? (float)color[3] : 1.0f;
            this.display_image(id, path, (float)x, (float)y, (float)color[0], (float)color[1], (float)color[2], a);
        }
    }

    public void display_image(int id, String path, double x, double y, List<?> color) {
        this.display_image(id, path, x, y, this.api.dArray(color));
    }

    @Override
    public void display_image(int id, String path, float x, float y) {
        this.api.base.post_runnable(() -> {
            Texture tex = this.getTexture(path);
            this.em.post(Event.ADD_CUSTOM_IMAGE, this, id, tex, Float.valueOf(x), Float.valueOf(y));
        });
    }

    @Override
    public void remove_all_objects() {
        this.api.base.post_runnable(() -> this.em.post(Event.REMOVE_ALL_OBJECTS, this));
    }

    @Override
    public void remove_object(int id) {
        this.api.base.post_runnable(() -> this.em.post(Event.REMOVE_OBJECTS, this, new Object[]{new int[]{id}}));
    }

    @Override
    public void remove_objects(int[] ids) {
        this.api.base.post_runnable(() -> this.em.post(Event.REMOVE_OBJECTS, this, new Object[]{ids}));
    }

    public void remove_objects(List<?> ids) {
        this.remove_objects(this.api.iArray(ids));
    }

    @Override
    public void enable() {
        this.api.base.post_runnable(() -> this.em.post(Event.DISPLAY_GUI_CMD, this, true, I18n.msg("notif.cleanmode")));
    }

    @Override
    public void disable() {
        this.api.base.post_runnable(() -> this.em.post(Event.DISPLAY_GUI_CMD, this, false, I18n.msg("notif.cleanmode")));
    }

    @Override
    public int get_client_width() {
        return Gdx.graphics.getWidth();
    }

    @Override
    public int get_client_height() {
        return Gdx.graphics.getHeight();
    }

    @Override
    public float[] get_position_and_size(String name) {
        IGui gui = GaiaSky.instance.mainGui;
        Actor actor = gui.getGuiStage().getRoot().findActor(name);
        if (actor != null) {
            float x = actor.getX();
            float y = actor.getY();
            for (Group parent = actor.getParent(); parent != null; parent = parent.getParent()) {
                x += parent.getX();
                y += parent.getY();
            }
            return new float[]{x, y, actor.getWidth(), actor.getHeight()};
        }
        return null;
    }

    @Override
    public float get_ui_scale_factor() {
        return Settings.settings.program.ui.scale;
    }

    @Override
    public void expand_pane(String name) {
        if (this.api.validator.checkString(name, new String[]{"Time", "Camera", "Visibility", "VisualSettings", "Datasets", "LocationLog", "Bookmarks"}, "panelName")) {
            this.api.base.post_runnable(() -> this.em.post(Event.EXPAND_COLLAPSE_PANE_CMD, this, name + "Component", true));
        }
    }

    @Override
    public void collapse_pane(String name) {
        if (this.api.validator.checkString(name, new String[]{"Time", "Camera", "Visibility", "VisualSettings", "Datasets", "LocationLog", "Bookmarks"}, "panelName")) {
            this.api.base.post_runnable(() -> this.em.post(Event.EXPAND_COLLAPSE_PANE_CMD, this, name + "Component", false));
        }
    }

    @Override
    public void display_popup_notification(String msg) {
        if (this.api.validator.checkString(msg, "message")) {
            this.em.post(Event.POST_POPUP_NOTIFICATION, this, msg);
        }
    }

    @Override
    public void display_popup_notification(String msg, float duration) {
        if (this.api.validator.checkString(msg, "message")) {
            this.em.post(Event.POST_POPUP_NOTIFICATION, this, msg, Float.valueOf(duration));
        }
    }

    public void display_popup_notification(String message, Double duration) {
        this.display_popup_notification(message, duration.floatValue());
    }

    @Override
    public void set_headline_message(String msg) {
        this.api.base.post_runnable(() -> this.em.post(Event.POST_HEADLINE_MESSAGE, this, msg));
    }

    @Override
    public void set_subhead_message(String msg) {
        this.api.base.post_runnable(() -> this.em.post(Event.POST_SUBHEAD_MESSAGE, this, msg));
    }

    @Override
    public void clear_headline_message() {
        this.api.base.post_runnable(() -> this.em.post(Event.CLEAR_HEADLINE_MESSAGE, this));
    }

    @Override
    public void clear_subhead_message() {
        this.api.base.post_runnable(() -> this.em.post(Event.CLEAR_SUBHEAD_MESSAGE, this));
    }

    @Override
    public void clear_all_messages() {
        this.api.base.post_runnable(() -> this.em.post(Event.CLEAR_MESSAGES, this));
    }

    @Override
    public void set_crosshair_visibility(boolean visible) {
        this.set_focus_crosshair_visibility(visible);
        this.set_closest_crosshair_visibility(visible);
        this.set_home_crosshair_visibility(visible);
    }

    @Override
    public void set_focus_crosshair_visibility(boolean visible) {
        this.api.base.post_runnable(() -> this.em.post(Event.CROSSHAIR_FOCUS_CMD, this, visible));
    }

    @Override
    public void set_closest_crosshair_visibility(boolean visible) {
        this.api.base.post_runnable(() -> this.em.post(Event.CROSSHAIR_CLOSEST_CMD, this, visible));
    }

    @Override
    public void set_home_crosshair_visibility(boolean visible) {
        this.api.base.post_runnable(() -> this.em.post(Event.CROSSHAIR_HOME_CMD, this, visible));
    }

    @Override
    public void set_minimap_visibility(boolean visible) {
        this.api.base.post_runnable(() -> this.em.post(Event.MINIMAP_DISPLAY_CMD, this, visible));
    }

    @Override
    public void preload_texture(String path) {
        this.preload_textures(new String[]{path});
    }

    @Override
    public void preload_textures(String[] paths) {
        this.initializeTextures();
        for (String path : paths) {
            this.api.base.post_runnable(() -> this.api.assetManager.load(path, Texture.class));
            while (!this.api.assetManager.isLoaded(path)) {
                this.api.base.sleep_frames(1L);
            }
            Texture tex = (Texture)this.api.assetManager.get(path, Texture.class);
            this.textures.put(path, tex);
        }
    }

    private Texture getTexture(String path) {
        if (this.textures == null || !this.textures.containsKey(path)) {
            this.preload_texture(path);
        }
        return (Texture)this.textures.get(path);
    }

    @Override
    public void reload() {
        EventManager.publish(Event.UI_RELOAD_CMD, this, GaiaSky.instance.getGlobalResources());
    }
}

