/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.script.v2.meta;

import com.badlogic.gdx.utils.Array;
import gaiasky.script.v2.impl.APIModule;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public record ModuleDesc(String name, Path path, Class<?> clazz, Map<String, Array<Method>> methodMap, Array<ModuleDesc> modules) {
    public static ModuleDesc of(Path path, Class<?> clazz) {
        return ModuleDesc.of(path, clazz, false);
    }

    public static ModuleDesc of(Path path, Class<?> clazz, boolean prefixPath) {
        if (!APIModule.class.isAssignableFrom(clazz)) {
            return new ModuleDesc("root", path, clazz, null, ModuleDesc.getModules(clazz, path, prefixPath));
        }
        Method[] allMethods = clazz.getDeclaredMethods();
        HashMap<String, Array<Method>> map = new HashMap<String, Array<Method>>();
        for (Method method : allMethods) {
            Object key;
            if (!Modifier.isPublic(method.getModifiers())) continue;
            if (prefixPath) {
                String prefix = path.toString().replace(File.separator, ".");
                key = prefix + "." + method.getName();
            } else {
                key = method.getName();
            }
            Array matches = map.containsKey(key) ? (Array)map.get(key) : new Array(false, 1);
            if (!matches.contains((Object)method, true)) {
                matches.add((Object)method);
            }
            map.put((String)key, (Array<Method>)matches);
        }
        String name = clazz.getSimpleName().substring(0, clazz.getSimpleName().indexOf("Module")).toLowerCase();
        return new ModuleDesc(name, path, clazz, map, ModuleDesc.getModules(clazz, path, prefixPath));
    }

    private static Array<ModuleDesc> getModules(Class<?> clazz, Path parentPath, boolean prefixPath) {
        Array l = new Array();
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> fieldClass = field.getType();
            if (!APIModule.class.isAssignableFrom(fieldClass)) continue;
            l.add((Object)ModuleDesc.of(parentPath.resolve(field.getName()), fieldClass, prefixPath));
        }
        return l.isEmpty() ? null : l;
    }
}

