/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

public class BinarySearchTree<T extends Comparable<T>> {
    protected BinaryNode<T> root = null;

    public void insert(T x) {
        this.root = this.insert(x, this.root);
    }

    public void remove(T x) {
        this.root = this.remove((Comparable<T>)x, this.root);
    }

    public Comparable<T> findMin() {
        return this.elementAt(this.findMin(this.root));
    }

    public Comparable<T> findMax() {
        return this.elementAt(this.findMax(this.root));
    }

    public Comparable<T> find(Comparable<T> x) {
        return this.elementAt(this.find(x, this.root));
    }

    public Comparable<T> findIntervalStart(Comparable<T> x) {
        return this.elementAt(this.findIntervalStart(x, this.root));
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    private Comparable<T> elementAt(BinaryNode<T> t) {
        return t == null ? null : (Comparable)t.element;
    }

    protected BinaryNode<T> insert(T x, BinaryNode<T> t) {
        if (t == null) {
            t = new BinaryNode<T>(x);
        } else if (x.compareTo((Comparable)((Comparable)t.element)) < 0) {
            t.left = this.insert(x, t.left);
        } else if (x.compareTo((Comparable)((Comparable)t.element)) > 0) {
            t.right = this.insert(x, t.right);
        } else {
            throw new RuntimeException("Duplicate item: " + String.valueOf(x));
        }
        return t;
    }

    protected BinaryNode<T> remove(Comparable<T> x, BinaryNode<T> t) {
        if (t == null) {
            throw new RuntimeException("Item not found: " + x.toString());
        }
        if (x.compareTo((Comparable)t.element) < 0) {
            t.left = this.remove(x, t.left);
        } else if (x.compareTo((Comparable)t.element) > 0) {
            t.right = this.remove(x, t.right);
        } else if (t.left != null && t.right != null) {
            t.element = this.findMin(t.right).element;
            t.right = this.removeMin(t.right);
        } else {
            t = t.left != null ? t.left : t.right;
        }
        return t;
    }

    protected BinaryNode<T> removeMin(BinaryNode<T> t) {
        if (t == null) {
            throw new RuntimeException("Item not found");
        }
        if (t.left != null) {
            t.left = this.removeMin(t.left);
            return t;
        }
        return t.right;
    }

    protected BinaryNode<T> findMin(BinaryNode<T> t) {
        if (t != null) {
            while (t.left != null) {
                t = t.left;
            }
        }
        return t;
    }

    private BinaryNode<T> findMax(BinaryNode<T> t) {
        if (t != null) {
            while (t.right != null) {
                t = t.right;
            }
        }
        return t;
    }

    private BinaryNode<T> find(Comparable<T> x, BinaryNode<T> t) {
        while (t != null) {
            if (x.compareTo((Comparable)t.element) < 0) {
                t = t.left;
                continue;
            }
            if (x.compareTo((Comparable)t.element) > 0) {
                t = t.right;
                continue;
            }
            return t;
        }
        return null;
    }

    private BinaryNode<T> findIntervalStart(Comparable<T> x, BinaryNode<T> t) {
        BinaryNode<T> lastPrev = null;
        while (t != null) {
            if (x.compareTo((Comparable)t.element) < 0) {
                t = t.left;
                continue;
            }
            if (x.compareTo((Comparable)t.element) > 0) {
                lastPrev = t;
                t = t.right;
                continue;
            }
            return t;
        }
        return lastPrev;
    }

    public static class BinaryNode<T> {
        T element;
        BinaryNode<T> left;
        BinaryNode<T> right;

        BinaryNode(T theElement) {
            this.element = theElement;
            this.right = null;
            this.left = null;
        }
    }
}

