/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.ashley.core.Entity;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.filter.Filter;
import gaiasky.util.filter.attrib.IAttribute;
import gaiasky.util.i18n.I18n;
import java.time.Instant;

public class CatalogInfo {
    private static final Logger.Log logger = Logger.getLogger(CatalogInfo.class);
    private static int colorIndexSequence = 0;
    private final FocusView view;
    public String name;
    public String description;
    public String source;
    public long nParticles;
    public long sizeBytes;
    public Instant loadDateUTC;
    public boolean highlighted;
    public boolean plainColor;
    public float[] hlColor;
    public float hlSizeFactor;
    public boolean hlAllVisible;
    public int hlCmapIndex = 0;
    public float hlCmapAlpha = 1.0f;
    public IAttribute hlCmapAttribute;
    public double hlCmapMin = 0.0;
    public double hlCmapMax = 0.0;
    public Filter filter;
    public CatalogInfoSource type;
    public Entity entity;

    public CatalogInfo(String name, String description, String source, CatalogInfoSource type, float hlSizeFactor, Entity entity) {
        this(name, description, source, type, hlSizeFactor);
        this.setEntity(entity);
    }

    public CatalogInfo(String name, String description, String source, CatalogInfoSource type, float hlSizeFactor) {
        this.name = name;
        this.description = description;
        this.source = source;
        this.type = type;
        this.loadDateUTC = Instant.now();
        this.plainColor = true;
        this.hlColor = new float[4];
        this.hlSizeFactor = hlSizeFactor;
        this.hlAllVisible = true;
        this.view = new FocusView();
        System.arraycopy(ColorUtils.getColorFromIndex(colorIndexSequence++), 0, this.hlColor, 0, 4);
    }

    public void setEntity(Entity entity) {
        if (entity != null) {
            this.entity = entity;
            this.view.setEntity(this.entity);
            if (Mapper.datasetDescription.has(entity)) {
                ((DatasetDescription)Mapper.datasetDescription.get(entity)).setCatalogInfo(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(boolean visibility) {
        if (this.entity != null) {
            FocusView focusView = this.view;
            synchronized (focusView) {
                this.view.setEntity(this.entity);
                this.view.setVisibleGroup(visibility);
            }
        }
    }

    public boolean isVisible() {
        return this.isVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(boolean attributeValue) {
        if (this.entity != null) {
            boolean ret;
            FocusView focusView = this.view;
            synchronized (focusView) {
                this.view.setEntity(this.entity);
                ret = this.view.isVisibleGroup(attributeValue);
            }
            return ret;
        }
        return true;
    }

    public void setColor(float r, float g, float b, float a) {
        this.hlColor[0] = r;
        this.hlColor[1] = g;
        this.hlColor[2] = b;
        this.hlColor[3] = a;
        this.highlight(this.highlighted);
    }

    public float[] getHlColor() {
        return this.hlColor;
    }

    public void setHlColor(float[] hlColor) {
        this.plainColor = true;
        this.setColor(hlColor[0], hlColor[1], hlColor[2], hlColor[3]);
    }

    public void setHlColormap(int cmapIndex, IAttribute cmapAttribute, double cmapMin, double cmapMax) {
        this.plainColor = false;
        this.hlCmapIndex = cmapIndex;
        this.hlCmapAttribute = cmapAttribute;
        this.hlCmapMin = cmapMin;
        this.hlCmapMax = cmapMax;
        this.highlight(this.highlighted);
    }

    public void setHlSizeFactor(float hlSizeFactor) {
        this.hlSizeFactor = hlSizeFactor;
        this.highlight(this.highlighted);
    }

    public void setHlAllVisible(boolean allVisible) {
        this.hlAllVisible = allVisible;
        this.highlight(this.highlighted);
    }

    public void removeCatalog() {
        if (this.entity != null) {
            EventManager.publish(Event.SCENE_REMOVE_OBJECT_CMD, this, this.entity, true);
            logger.info(I18n.msg("gui.dataset.remove.info", this.name));
            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("gui.dataset.remove.info", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlight(boolean hl) {
        this.highlighted = hl;
        if (this.entity != null) {
            FocusView focusView = this.view;
            synchronized (focusView) {
                this.view.setEntity(this.entity);
                if (this.plainColor) {
                    this.view.highlight(hl, this.hlColor, this.hlAllVisible);
                } else {
                    this.view.highlight(hl, this.hlCmapIndex, this.hlCmapAlpha, this.hlCmapAttribute, this.hlCmapMin, this.hlCmapMax, this.hlAllVisible);
                }
            }
        }
    }

    public boolean isHighlightable() {
        return this.entity != null && this.isBaseDataset(this.entity);
    }

    private boolean isBaseDataset(Entity entity) {
        return Mapper.particleSet.has(entity) || Mapper.starSet.has(entity) || Mapper.octree.has(entity) || Mapper.orbitElementsSet.has(entity);
    }

    public boolean hasParticleAttributes() {
        if (this.entity != null) {
            return Mapper.particleSet.has(this.entity) || Mapper.starSet.has(this.entity) || Mapper.octree.has(this.entity);
        }
        return false;
    }

    public boolean isParticleSet() {
        if (this.entity != null) {
            return Mapper.particleSet.has(this.entity);
        }
        return false;
    }

    public boolean isStarSet() {
        if (this.entity != null) {
            return Mapper.starSet.has(this.entity);
        }
        return false;
    }

    public ComponentTypes getCt() {
        if (this.entity != null) {
            return ((Base)Mapper.base.get((Entity)this.entity)).ct;
        }
        return null;
    }

    public static enum CatalogInfoSource {
        INTERNAL,
        LOD,
        SAMP,
        SCRIPT,
        UI;

    }
}

