/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.ashley.core.Entity;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.Octant;
import gaiasky.scene.view.OctreeObjectView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Logger;
import gaiasky.util.i18n.I18n;
import gaiasky.util.tree.IOctreeObject;
import gaiasky.util.tree.OctreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CatalogManager
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(CatalogManager.class);
    private final Map<String, CatalogInfo> ciMap = new HashMap<String, CatalogInfo>();
    private final List<CatalogInfo> cis = new ArrayList<CatalogInfo>(5);

    public CatalogManager() {
        EventManager.instance.subscribe((IObserver)this, Event.CATALOG_ADD, Event.CATALOG_REMOVE, Event.CATALOG_VISIBLE, Event.CATALOG_HIGHLIGHT, Event.CATALOG_POINT_SIZE_SCALING_CMD);
    }

    public Collection<CatalogInfo> getCatalogInfos() {
        return this.cis;
    }

    public boolean contains(String dsName) {
        return this.ciMap.containsKey(dsName);
    }

    public CatalogInfo get(String dsName) {
        return this.ciMap.get(dsName);
    }

    public Set<String> getDatasetNames() {
        if (this.ciMap != null) {
            return this.ciMap.keySet();
        }
        return null;
    }

    public Optional<CatalogInfo> getByEntity(Entity entity) {
        OctreeNode octant = null;
        if (Mapper.octant.has(entity)) {
            Octant oct = (Octant)Mapper.octant.get(entity);
            octant = oct.octant != null ? oct.octant.getRoot() : null;
        }
        for (CatalogInfo ci : this.cis) {
            if (ci.entity == null || !(octant != null ? Mapper.octree.has(ci.entity) && ((Octant)Mapper.octant.get((Entity)ci.entity)).octant == octant : ci.entity == entity)) continue;
            return Optional.of(ci);
        }
        return Optional.empty();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case CATALOG_ADD: {
                Object key;
                CatalogInfo ci = (CatalogInfo)data[0];
                boolean addToSg = (Boolean)data[1];
                if (addToSg && ci.entity != null) {
                    EventManager.publish(Event.SCENE_ADD_OBJECT_CMD, this, ci.entity, true);
                }
                if (this.ciMap.containsKey(key = ci.name)) {
                    int i = 1;
                    String newKey = ci.name + " (" + i + ")";
                    while (this.ciMap.containsKey(newKey)) {
                        newKey = ci.name + " (" + ++i + ")";
                    }
                    ci.name = newKey;
                    key = newKey;
                }
                this.ciMap.put((String)key, ci);
                this.cis.add(ci);
                break;
            }
            case CATALOG_REMOVE: {
                String dsName = (String)data[0];
                if (!this.ciMap.containsKey(dsName)) break;
                CatalogInfo ci = this.ciMap.get(dsName);
                EventManager.publish(Event.FOCUS_NOT_AVAILABLE, this, ci.entity);
                ci.removeCatalog();
                this.ciMap.remove(dsName);
                this.cis.remove(ci);
                break;
            }
            case CATALOG_VISIBLE: {
                String dsName = (String)data[0];
                boolean visible = (Boolean)data[1];
                if (!this.ciMap.containsKey(dsName)) break;
                CatalogInfo ci = this.ciMap.get(dsName);
                if (!visible) {
                    EventManager.publish(Event.FOCUS_NOT_AVAILABLE, this, ci.entity);
                }
                ci.setVisibility(visible);
                logger.info(I18n.msg("notif.visibility." + (visible ? "on" : "off"), ci.name));
                break;
            }
            case CATALOG_HIGHLIGHT: {
                CatalogInfo ci = (CatalogInfo)data[0];
                boolean highlight = (Boolean)data[1];
                if (ci == null) break;
                ci.highlight(highlight);
                if (ci.highlighted) {
                    logger.info(I18n.msg("notif.highlight.on", ci.name));
                    break;
                }
                logger.info(I18n.msg("notif.highlight.off", ci.name));
                break;
            }
            case CATALOG_POINT_SIZE_SCALING_CMD: {
                String dsName = (String)data[0];
                double scaling = (Double)data[1];
                if (!this.ciMap.containsKey(dsName)) break;
                CatalogInfo ci = this.ciMap.get(dsName);
                if (ci.entity == null) break;
                Highlight hl = (Highlight)Mapper.highlight.get(ci.entity);
                hl.pointscaling = (float)scaling;
                hl.dirty = true;
                Octant oc = (Octant)Mapper.octant.get(ci.entity);
                if (oc == null || oc.octant == null) break;
                ArrayList<OctreeNode> l = new ArrayList<OctreeNode>(oc.octant.numChildrenRec);
                oc.octant.addChildrenToList(l);
                for (OctreeNode node : l) {
                    if (node.objects == null || node.objects.isEmpty()) continue;
                    for (IOctreeObject object : node.objects) {
                        OctreeObjectView ov = (OctreeObjectView)object;
                        if (ov == null || ov.getEntity() == null || !Mapper.highlight.has(ov.getEntity())) continue;
                        ((Highlight)Mapper.highlight.get((Entity)ov.getEntity())).dirty = true;
                    }
                }
                break;
            }
        }
    }
}

