/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import gaiasky.event.Event;
import gaiasky.event.EventManager;
import net.jafama.FastMath;

public class Constants {
    public static final int DEFAULT_RESOLUTION_WIDTH = 1920;
    public static final int DEFAULT_RESOLUTION_HEIGHT = 1080;
    public static final double DEFAULT_MAG = 15.0;
    public static final double DEFAULT_COLOR = 0.656;
    public static final double DEFAULT_PARALLAX = 0.04;
    public static final double C_KMH = 1.079253E9;
    public static final double Ro_TO_KM = 695796.4;
    public static final double MB_TO_BYTE = 1000000.0;
    public static final double BYTE_TO_MB = 1.0E-6;
    public static final double STAR_SOLID_ANGLE_THRESHOLD_BOTTOM = 5.0E-7;
    public static final double STAR_SOLID_ANGLE_THRESHOLD_TOP = 0.01;
    public static final double PARTICLE_DISC_FACTOR = 1.5;
    public static final double STAR_SIZE_FACTOR = 1.31526E-6;
    public static final float MIN_SLIDER = 0.0f;
    public static final float MIN_SLIDER_1 = 1.0f;
    public static final float MAX_SLIDER = 100.0f;
    public static final float SLIDER_STEP = 1.0f;
    public static final float SLIDER_STEP_SMALL = 0.1f;
    public static final float SLIDER_STEP_WEENY = 1.0E-4f;
    public static final float SLIDER_STEP_TINY = 0.01f;
    public static final float MIN_POINT_SIZE_SCALE = 0.1f;
    public static final float MAX_POINT_SIZE_SCALE = 5.0f;
    public static final long MIN_FADE_TIME_MS = 0L;
    public static final long MAX_FADE_TIME_MS = 30000L;
    public static final float MAX_FOV = 150.0f;
    public static final float MIN_FOV = 1.0f;
    public static final double MIN_FPS = 0.05;
    public static final double MAX_FPS = 1000.0;
    public static final float MAX_CAM_SPEED = 15.0f;
    public static final float MIN_CAM_SPEED = 0.1f;
    public static final float MAX_ROT_SPEED = 10000.0f;
    public static final float MIN_ROT_SPEED = 200.0f;
    public static final float MAX_TURN_SPEED = 3000.0f;
    public static final float MIN_TURN_SPEED = 200.0f;
    public static final float MIN_STAR_BRIGHTNESS = 0.4f;
    public static final float MAX_STAR_BRIGHTNESS = 8.0f;
    public static final float MIN_CHROMATIC_ABERRATION_AMOUNT = 0.0f;
    public static final float MAX_CHROMATIC_ABERRATION_AMOUNT = 0.05f;
    public static final float MIN_FILM_GRAIN_INTENSITY = 0.0f;
    public static final float MAX_FILM_GRAIN_INTENSITY = 1.0f;
    public static final float MIN_LENS_FLARE_STRENGTH = 0.0f;
    public static final float MAX_LENS_FLARE_STRENGTH = 1.5f;
    public static final float MIN_UNSHARP_MASK_FACTOR = 0.0f;
    public static final float MAX_UNSHARP_MASK_FACTOR = 3.0f;
    public static final float MIN_STAR_BRIGHTNESS_POW = 0.9f;
    public static final float MAX_STAR_BRIGHTNESS_POW = 1.1f;
    public static final float MIN_STAR_GLOW_FACTOR = 0.01f;
    public static final float MAX_STAR_GLOW_FACTOR = 0.5f;
    public static final float MIN_STAR_POINT_SIZE = 0.1f;
    public static final float MAX_STAR_POINT_SIZE = 20.0f;
    public static final float MIN_STAR_MIN_OPACITY = 0.0f;
    public static final float MAX_STAR_MIN_OPACITY = 0.95f;
    public static final float MIN_PM_NUM_FACTOR = 1.0f;
    public static final float MAX_PM_NUM_FACTOR = 10.0f;
    public static final float MIN_PM_LEN_FACTOR = 500.0f;
    public static final float MAX_PM_LEN_FACTOR = 50000.0f;
    public static final float MIN_LOD_TRANS_ANGLE_DEG = 0.0f;
    public static final float MAX_LOD_TRANS_ANGLE_DEG = 120.0f;
    public static final int MIN_VELOCITY_VECTORS_STAR_GROUP = 40;
    public static final int MAX_VELOCITY_VECTORS_STAR_GROUP = 500;
    public static final float MIN_AMBIENT_LIGHT = 0.0f;
    public static final float MAX_AMBIENT_LIGHT = 1.0f;
    public static final float MIN_SC_RESPONSIVENESS = 500000.0f;
    public static final float MAX_SC_RESPONSIVENESS = 5000000.0f;
    public static final float MIN_BRIGHTNESS = -1.0f;
    public static final float MAX_BRIGHTNESS = 1.0f;
    public static final float MIN_CONTRAST = 0.0f;
    public static final float MAX_CONTRAST = 2.0f;
    public static final float MIN_HUE = 0.0f;
    public static final float MAX_HUE = 2.0f;
    public static final float MIN_SATURATION = 0.0f;
    public static final float MAX_SATURATION = 2.0f;
    public static final float MIN_GAMMA = 0.001f;
    public static final float MAX_GAMMA = 3.0f;
    public static final float MIN_EXPOSURE = 0.0f;
    public static final float MAX_EXPOSURE = 10.0f;
    public static final float MIN_BLOOM = 0.0f;
    public static final float MAX_BLOOM = 2.0f;
    public static final float MIN_LABEL_SIZE = 0.7f;
    public static final float MAX_LABEL_SIZE = 2.5f;
    public static final float MIN_LINE_WIDTH = 0.2f;
    public static final float MAX_LINE_WIDTH = 3.5f;
    public static final float MIN_ELEVATION_MULT = 0.0f;
    public static final float MAX_ELEVATION_MULT = 15.0f;
    public static final float MIN_TESS_QUALITY = 1.0f;
    public static final float MAX_TESS_QUALITY = 10.0f;
    public static final float MIN_SCREENSHOT_QUALITY = 1.0f;
    public static final float MAX_SCREENSHOT_QUALITY = 100.0f;
    public static final float MIN_PARTICLE_SIZE = 0.5f;
    public static final float MAX_PARTICLE_SIZE = 50.0f;
    public static final float MIN_MIN_SOLID_ANGLE = 0.0f;
    public static final float MAX_MIN_SOLID_ANGLE = 0.01f;
    public static final float MIN_MAX_SOLID_ANGLE = 0.01f;
    public static final float MAX_MAX_SOLID_ANGLE = 0.1f;
    public static final int MIN_NUM_LABELS = 0;
    public static final int MAX_NUM_LABELS = 300;
    public static final float MIN_COLOR_NOISE = 0.0f;
    public static final float MAX_COLOR_NOISE = 1.0f;
    public static final float MIN_ATM_FOG_DENSITY = 0.01f;
    public static final float MAX_ATM_FOG_DENSITY = 3.5f;
    public static final float MIN_POINTER_GUIDES_WIDTH = 0.5f;
    public static final float MAX_POINTER_GUIDES_WIDTH = 20.0f;
    public static final int MIN_TILE_CACHE = 4;
    public static final int MAX_TILE_CACHE = 20;
    public static final float UI_SCALE_MIN = 0.7f;
    public static final float UI_SCALE_MAX = 2.0f;
    public static final int PG_RESOLUTION_MIN = 400;
    public static final int PG_RESOLUTION_MAX = 6000;
    public static final float BACKBUFFER_SCALE_MIN = 0.1f;
    public static final float BACKBUFFER_SCALE_MAX = 4.0f;
    public static final float BACKBUFFER_SCALE_STEP = 0.1f;
    public static final float MOTIONBLUR_MIN = 0.0f;
    public static final float MOTIONBLUR_MAX = 2.0f;
    public static final long MAX_VSOP_TIME_MS = 631152000000000L;
    public static final long MIN_VSOP_TIME_MS = -631152000000000L;
    public static final int WARP_STEPS = 45;
    public static final double MAX_WARP = FastMath.pow((double)2.0, (double)45.0);
    public static final double MIN_WARP = -MAX_WARP;
    public static final float MAX_DATASET_SIZE_FACTOR = 100.0f;
    public static final float MIN_DATASET_SIZE_FACTOR = 0.01f;
    public static final float MAX_MINIMAP_SIZE = 350.0f;
    public static final float MIN_MINIMAP_SIZE = 150.0f;
    public static final String nameSeparatorRegex = "\\|";
    public static final String nameSeparator = "|";
    public static final String STAR_SUBSTITUTE = "%#QUAL#%";
    public static final String DATA_LOCATION_TOKEN = "$data/";
    public static final String DEFAULT_DATASET_KEY = "default-data";
    public static final String HI_RES_TEXTURES_DATASET_KEY = "hi-res-textures";
    public static final String GEN_KEYWORD = "generate";
    public static final String URL_GAIA_JSON_SOURCE = "https://gaia.ari.uni-heidelberg.de/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+*+FROM+gaiadr3.gaia_source+WHERE+source_id=";
    public static final String URL_HIP_JSON_SOURCE = "https://gaia.ari.uni-heidelberg.de/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+*+FROM+extcat.hipparcos+WHERE+hip=";
    public static final String URL_GAIA_WEB_SOURCE = "https://gaia.ari.uni-heidelberg.de/singlesource.html#id=";
    public static final String URL_SIMBAD = "https://simbad.u-strasbg.fr/simbad/sim-id?Ident=";
    public static final int N_DIR_LIGHTS = 3;
    public static final int N_POINT_LIGHTS = 3;
    public static final int N_SPOT_LIGHTS = 0;
    public static double DISTANCE_SCALE_FACTOR = 1.0;
    public static double ORIGINAL_M_TO_U = 1.0E-9;
    public static double M_TO_U = ORIGINAL_M_TO_U * DISTANCE_SCALE_FACTOR;
    public static double U_TO_M = 1.0 / M_TO_U;
    public static double KM_TO_U = M_TO_U * 1000.0;
    public static double U_TO_KM = 1.0 / KM_TO_U;
    public static double AU_TO_U = 1.49597871E8 * KM_TO_U;
    public static double U_TO_AU = 1.0 / AU_TO_U;
    public static double LY_TO_U = 9.46073E12 * KM_TO_U;
    public static double U_TO_LY = 1.0 / LY_TO_U;
    public static double PC_TO_U = 3.08567758149137E13 * KM_TO_U;
    public static double KPC_TO_U = PC_TO_U * 1000.0;
    public static double MPC_TO_U = KPC_TO_U * 1000.0;
    public static double U_TO_PC = 1.0 / PC_TO_U;
    public static double U_TO_KPC = U_TO_PC / 1000.0;
    public static double Ro_TO_U = 695796.4 * KM_TO_U;
    public static double U_TO_Ro = 1.0 / Ro_TO_U;
    public static double C_US = 2.99792458E8 * M_TO_U;
    private static double CAMERA_K = 1.0E7 / DISTANCE_SCALE_FACTOR;
    private static final long PART_FILE_MAX_AGE_MS = 21600000L;

    public static float getCameraK() {
        return (float)CAMERA_K;
    }

    public static long getPartFileMaxAgeMs() {
        return 21600000L;
    }

    public static void initialize(double distanceScaleFactor) {
        DISTANCE_SCALE_FACTOR = distanceScaleFactor;
        M_TO_U = ORIGINAL_M_TO_U * DISTANCE_SCALE_FACTOR;
        U_TO_M = 1.0 / M_TO_U;
        KM_TO_U = M_TO_U * 1000.0;
        U_TO_KM = 1.0 / KM_TO_U;
        AU_TO_U = 1.49597871E8 * KM_TO_U;
        U_TO_AU = 1.0 / AU_TO_U;
        PC_TO_U = 3.08567758149137E13 * KM_TO_U;
        U_TO_PC = 1.0 / PC_TO_U;
        KPC_TO_U = PC_TO_U * 1000.0;
        U_TO_KPC = U_TO_PC / 1000.0;
        MPC_TO_U = KPC_TO_U * 1000.0;
        C_US = 2.99792458E8 * M_TO_U;
        Ro_TO_U = 695796.4 * KM_TO_U;
        U_TO_Ro = 1.0 / Ro_TO_U;
        CAMERA_K = 1.0E7 / DISTANCE_SCALE_FACTOR;
        EventManager.publish(Event.NEW_DISTANCE_SCALE_FACTOR, null, new Object[0]);
    }

    public static boolean notWithinVSOPTime(long time) {
        return time > 631152000000000L || time < -631152000000000L;
    }
}

