/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.iface.NotificationsInterface;
import gaiasky.gui.main.MessageBean;
import gaiasky.util.Logger;
import gaiasky.util.MemInfo;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.vr.openxr.XrDriver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.jafama.FastMath;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;

public class CrashReporter {
    public static void reportCrash(Throwable t, Logger.Log logger) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        Path crashDir = SysUtils.getCrashReportsDir();
        try {
            Files.createDirectories(crashDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error(e);
        }
        Date now = new Date();
        String dateString = df.format(now);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();
        Array crashInfo = new Array();
        crashInfo.add((Object)"#");
        crashInfo.add((Object)"# GAIA SKY CRASH REPORT");
        crashInfo.add((Object)("# " + String.valueOf(now)));
        crashInfo.add((Object)"");
        crashInfo.add((Object)"## STACK TRACE");
        crashInfo.add((Object)stackTrace);
        CrashReporter.appendSystemInfo((Array<String>)crashInfo);
        Path logFile = CrashReporter.writeLog(logger, crashDir, dateString);
        crashInfo.forEach(str -> CrashReporter.print(logger, str));
        Path crashReportFile = CrashReporter.writeCrash(logger, crashDir, dateString, (Array<String>)crashInfo);
        String crf1 = "Crash report file saved to: " + String.valueOf(crashReportFile.toAbsolutePath());
        String crf4 = "Full log file saved to: " + String.valueOf(logFile != null ? logFile.toAbsolutePath() : "permission error");
        String crf2 = "Please attach these files to the bug report";
        String crf3 = "Create a bug report here: https://codeberg.org/gaiasky/gaiasky/issues";
        int len = FastMath.max((int)crf1.length(), (int)FastMath.max((int)crf3.length(), (int)crf4.length()));
        char[] chars = new char[len];
        Arrays.fill(chars, '#');
        String separatorLine = new String(chars);
        CrashReporter.print(logger, "");
        CrashReporter.print(logger, separatorLine);
        CrashReporter.print(logger, crf1);
        CrashReporter.print(logger, crf4);
        CrashReporter.print(logger, crf2);
        CrashReporter.print(logger, crf3);
        CrashReporter.print(logger, separatorLine);
        CrashReporter.print(logger, "");
    }

    public static void writeLastSessionLog(Logger.Log logger) {
        Path logDir = SysUtils.getLogDir();
        try {
            Files.createDirectories(logDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error(e);
        }
        CrashReporter.writeLog(logger, logDir, "lastsession");
    }

    private static Path writeLog(Logger.Log logger, Path dir, String suffixString) {
        if (Files.exists(dir, new LinkOption[0]) && Files.isWritable(dir)) {
            Path logFile;
            block13: {
                List<MessageBean> logMessages = NotificationsInterface.getHistorical();
                logFile = dir.resolve("gaiasky_log_" + suffixString + ".txt");
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFile.toFile()));){
                    try {
                        for (MessageBean b : logMessages) {
                            writer.write(b.formatMessage(true));
                            writer.newLine();
                        }
                    }
                    catch (Exception e) {
                        if (logger != null) {
                            logger.error("Writing log crashed... Inception level 1 achieved! :_D", e);
                        } else {
                            System.err.println("Writing log crashed... Inception level 1 achieved! :_D");
                            e.printStackTrace(System.err);
                        }
                    }
                }
                catch (Exception e) {
                    if (logger == null) break block13;
                    logger.error("Closing writer crashed (inception level 2 achieved!)", e);
                }
            }
            return logFile;
        }
        System.err.println("Log directory (" + String.valueOf(dir.toAbsolutePath()) + ") does not exist or is not writable");
        return null;
    }

    private static Path writeCrash(Logger.Log logger, Path crashDir, String dateString, Array<String> crashInfo) {
        Path crashReportFile = crashDir.resolve("gaiasky_crash_" + dateString + ".txt");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(crashReportFile.toFile()));
            crashInfo.forEach(str -> {
                try {
                    writer.write((String)str);
                    writer.newLine();
                }
                catch (Exception e) {
                    if (logger != null) {
                        logger.error("Writing crash report crashed (inception level 1 achieved!)", e);
                    }
                    System.err.println("Writing crash report crashed (inception level 1 achieved!)");
                    e.printStackTrace(System.err);
                }
            });
            try {
                writer.close();
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Closing writer crashed (inception level 2 achieved!)", e);
                }
            }
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error("Creating crash writer crashed (inception level 1 achieved!)", e);
            }
            System.err.println("Creating crash writer crashed (inception level 1 achieved!)");
            e.printStackTrace(System.err);
        }
        return crashReportFile;
    }

    private static void print(Logger.Log logger, String str) {
        if (logger == null || !EventManager.instance.hasSubscriptors(Event.POST_NOTIFICATION)) {
            System.err.println(str);
        } else {
            logger.error(str);
        }
    }

    private static void appendSystemInfo(Array<String> strArray) {
        XrDriver driver;
        File[] roots;
        if (Settings.settings != null && Settings.settings.version != null) {
            strArray.add((Object)"");
            strArray.add((Object)"## GAIA SKY INFORMATION");
            strArray.add((Object)("Version: " + Settings.settings.version.version));
            strArray.add((Object)("Build: " + Settings.settings.version.build));
            strArray.add((Object)("Builder: " + Settings.settings.version.builder));
            strArray.add((Object)("System: " + Settings.settings.version.system));
            strArray.add((Object)("Build time: " + String.valueOf(Settings.settings.version.buildTime)));
        } else {
            strArray.add((Object)"");
            strArray.add((Object)"## Can't get Gaia Sky version information");
            strArray.add((Object)"## Settings.settings[.version] is null!");
        }
        strArray.add((Object)"");
        strArray.add((Object)"## JAVA INFORMATION");
        strArray.add((Object)("Java version: " + System.getProperty("java.version")));
        strArray.add((Object)("Java runtime name: " + System.getProperty("java.runtime.name")));
        strArray.add((Object)("Java VM name: " + System.getProperty("java.vm.name")));
        strArray.add((Object)("Java VM version: " + System.getProperty("java.vm.version")));
        strArray.add((Object)("Java VM vendor: " + System.getProperty("java.vm.vendor")));
        strArray.add((Object)"");
        strArray.add((Object)"## SYSTEM INFORMATION");
        try {
            SystemInfo si = new SystemInfo();
            HardwareAbstractionLayer hal = si.getHardware();
            File[] cp = hal.getProcessor();
            strArray.add((Object)("CPU: " + cp.getProcessorIdentifier().getName()));
            strArray.add((Object)cp.getProcessorIdentifier().getIdentifier());
            strArray.add((Object)("Proc ID: " + cp.getProcessorIdentifier().getProcessorID()));
            strArray.add((Object)("CPU Family: " + cp.getProcessorIdentifier().getFamily()));
            strArray.add((Object)(cp.getPhysicalPackageCount() + " physical CPU package(s)"));
            strArray.add((Object)(cp.getPhysicalProcessorCount() + " physical CPU core(s)"));
            int nLp = cp.getLogicalProcessorCount();
            strArray.add((Object)(nLp + " logical CPU(s)"));
        }
        catch (Exception ignored) {
            strArray.add((Object)"Could not get CPU information!");
        }
        String mbUnits = " MB";
        strArray.add((Object)("Java used memory: " + MemInfo.getUsedMemory() + mbUnits));
        strArray.add((Object)("Java free memory: " + MemInfo.getFreeMemory() + mbUnits));
        strArray.add((Object)("Java total memory: " + MemInfo.getTotalMemory() + mbUnits));
        strArray.add((Object)("Java max memory (-Xmx): " + MemInfo.getMaxMemory() + mbUnits));
        strArray.add((Object)("Total system RAM: " + MemInfo.getTotalRam() + mbUnits));
        for (File root : roots = File.listRoots()) {
            strArray.add((Object)(" # File system root: " + root.getAbsolutePath()));
            strArray.add((Object)("   Total space: " + (double)root.getTotalSpace() * 1.0E-6 + mbUnits));
            strArray.add((Object)("   Free space: " + (double)root.getFreeSpace() * 1.0E-6 + mbUnits));
            strArray.add((Object)("   Usable space: " + (double)root.getUsableSpace() * 1.0E-6 + mbUnits));
        }
        strArray.add((Object)"");
        strArray.add((Object)"## OS INFORMATION");
        try {
            SystemInfo si = new SystemInfo();
            OperatingSystem os = si.getOperatingSystem();
            strArray.add((Object)("OS name: " + os.toString()));
            strArray.add((Object)("OS version: " + System.getProperty("os.version")));
            strArray.add((Object)("OS architecture: " + System.getProperty("os.arch")));
            strArray.add((Object)("Booted: " + String.valueOf(Instant.ofEpochSecond(os.getSystemBootTime()))));
            strArray.add((Object)("Uptime: " + FormatUtil.formatElapsedSecs((long)si.getOperatingSystem().getSystemUptime())));
        }
        catch (Exception e) {
            strArray.add((Object)("OS name: " + System.getProperty("os.name")));
            strArray.add((Object)("OS version: " + System.getProperty("os.version")));
            strArray.add((Object)("OS architecture: " + System.getProperty("os.arch")));
        }
        try {
            strArray.add((Object)"");
            strArray.add((Object)"## GL INFORMATION");
            strArray.add((Object)("Graphics device: " + Gdx.gl.glGetString(7937)));
            strArray.add((Object)("GL vendor: " + Gdx.gl.glGetString(7936)));
            strArray.add((Object)("GL version: " + Gdx.gl.glGetString(7938)));
            strArray.add((Object)("GLSL version: " + Gdx.gl.glGetString(35724)));
            IntBuffer buf = BufferUtils.newIntBuffer((int)16);
            Gdx.gl.glGetIntegerv(33309, buf);
            int extensionCount = buf.get(0);
            if (extensionCount > 0) {
                String[] extensionsString = new String[extensionCount];
                for (int i = 0; i < extensionCount; ++i) {
                    extensionsString[i] = Gdx.gl30.glGetStringi(7939, i);
                }
                String extensions = TextUtils.arrayToStr(extensionsString, "", "", " ");
                strArray.add((Object)("GL extensions: " + extensions));
            }
            Gdx.gl.glGetIntegerv(3379, buf);
            int maxSize = buf.get(0);
            strArray.add((Object)("GL max texture size: " + maxSize));
        }
        catch (Exception e) {
            strArray.add((Object)"## GL INFORMATION not available");
        }
        if (Settings.settings != null && Settings.settings.runtime.openXr && (driver = GaiaSky.instance.xrDriver) != null) {
            strArray.add((Object)"");
            strArray.add((Object)"## VR INFORMATION");
            strArray.add((Object)("VR resolution: " + driver.getWidth() + "x" + driver.getHeight()));
            strArray.add((Object)("OpenXR runtime name: " + driver.runtimeName));
            strArray.add((Object)("OpenXR runtime version: " + driver.runtimeVersionString));
        }
    }
}

