/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import gaiasky.render.RenderingContext;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.gdx.g2d.BitmapFont;
import gaiasky.util.gdx.g2d.ExtBatch;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.g2d.Sprite;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class DecalUtils {
    static Vector3 tmp = new Vector3();
    static Vector3 tmp2 = new Vector3();
    static Vector3 tmp3 = new Vector3();
    static Matrix4 idt = new Matrix4();
    static Matrix4 aux1 = new Matrix4();
    static Matrix4 aux2 = new Matrix4();
    static Quaternion qAux = new Quaternion();

    public static void drawSprite(Sprite sprite, SpriteBatch batch, float x, float y, float z, double size, float rotationCenter, ICamera cam, boolean faceCamera, float minSizeDegrees, float maxSizeDegrees) {
        sprite.setPosition(0.0f, 0.0f);
        sprite.setCenter(0.0f, 0.0f);
        aux1.set(batch.getTransformMatrix());
        aux2.set(batch.getProjectionMatrix());
        PerspectiveCamera camera = cam.getCamera();
        if (minSizeDegrees > 0.0f || maxSizeDegrees > 0.0f) {
            double dist = camera.position.dst(tmp3.set(x, y, z));
            double minSize = minSizeDegrees > 0.0f ? FastMath.tan((double)Math.toRadians(minSizeDegrees)) * dist : 0.0;
            double maxSize = maxSizeDegrees > 0.0f ? FastMath.tan((double)Math.toRadians(maxSizeDegrees)) * dist : 1.0E20;
            size = MathUtils.clamp((double)size, (double)((float)minSize), (double)((float)maxSize));
        }
        Quaternion rotation = DecalUtils.getBillboardRotation(faceCamera ? camera.direction : tmp3.set(x, y, z).nor(), camera.up, qAux);
        float sizeF = (float)size;
        batch.getTransformMatrix().set(camera.combined).translate(x, y, z).rotate(rotation).rotate(0.0f, 1.0f, 0.0f, 180.0f).rotate(0.0f, 0.0f, 1.0f, rotationCenter).scale(sizeF, sizeF, sizeF);
        batch.setProjectionMatrix(idt);
        sprite.draw((Batch)batch);
        batch.setTransformMatrix(aux1);
        batch.setProjectionMatrix(aux2);
    }

    public static void drawFont3D(BitmapFont font, ExtSpriteBatch batch, String text, Vector3 position, ICamera camera, boolean faceCamera) {
        DecalUtils.drawFont3D(font, batch, text, position, 1.0f, camera, faceCamera);
    }

    public static void drawFont3D(BitmapFont font, ExtSpriteBatch batch, String text, float x, float y, float z, float size, float rotationCenter, ICamera camera, boolean faceCamera) {
        DecalUtils.drawFont3D(font, batch, text, x, y, z, size, rotationCenter, camera, faceCamera, -1.0f, -1.0f);
    }

    public static void drawFont3D(BitmapFont font, ExtSpriteBatch batch, String text, float x, float y, float z, double size, float rotationCenter, ICamera cam, boolean faceCamera, float minSizeDegrees, float maxSizeDegrees) {
        aux1.set(batch.getTransformMatrix());
        aux2.set(batch.getProjectionMatrix());
        PerspectiveCamera camera = cam.getCamera();
        if (minSizeDegrees > 0.0f || maxSizeDegrees > 0.0f) {
            double dist = camera.position.dst(tmp3.set(x, y, z));
            double minSize = minSizeDegrees > 0.0f ? FastMath.tan((double)Math.toRadians(minSizeDegrees)) * dist : 0.0;
            double maxSize = maxSizeDegrees > 0.0f ? FastMath.tan((double)Math.toRadians(maxSizeDegrees)) * dist : 1.0E20;
            size = MathUtils.clamp((double)size, (double)((float)minSize), (double)((float)maxSize));
        }
        Quaternion rotation = DecalUtils.getBillboardRotation(faceCamera ? camera.direction : tmp3.set(x, y, z).nor(), camera.up, qAux);
        float sizeF = (float)size;
        batch.getTransformMatrix().set(camera.combined).translate(x, y, z).rotate(rotation).rotate(0.0f, 1.0f, 0.0f, 180.0f).rotate(0.0f, 0.0f, 1.0f, rotationCenter).scale(sizeF, sizeF, sizeF);
        batch.setProjectionMatrix(idt);
        font.draw((ExtBatch)batch, text, 0.0f, 0.0f);
        batch.setTransformMatrix(aux1);
        batch.setProjectionMatrix(aux2);
    }

    public static void drawFont3D(BitmapFont font, ExtSpriteBatch batch, String text, Vector3 position, float scale, ICamera camera, boolean faceCamera) {
        DecalUtils.drawFont3D(font, batch, text, position.x, position.y, position.z, scale, 0.0f, camera, faceCamera);
    }

    public static void drawFont2D(BitmapFont font, ExtSpriteBatch batch, String text, Vector3 position) {
        font.draw((ExtBatch)batch, text, position.x, position.y);
    }

    public static void drawFont2D(BitmapFont font, ExtSpriteBatch batch, String text, float x, float y) {
        font.draw((ExtBatch)batch, text, x, y);
    }

    public static void drawFont2D(BitmapFont font, ExtSpriteBatch batch, RenderingContext rc, String text, float x, float y, float scale, float width) {
        DecalUtils.drawFont2D(font, batch, rc, text, x, y, scale, -1);
    }

    public static void drawFont2D(BitmapFont font, ExtSpriteBatch batch, RenderingContext rc, String text, float x, float y, float scale, int align) {
        float scaleXBak = font.getData().scaleX;
        float scaleYBak = font.getData().scaleY;
        aux1.set(batch.getProjectionMatrix());
        batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)rc.w(), (float)rc.h());
        font.getData().setScale(scale);
        if (align > 0) {
            font.draw(batch, text, x, y, align == 16 ? 150.0f : 75.0f, align, false);
        } else {
            font.draw((ExtBatch)batch, text, x, y);
        }
        batch.setProjectionMatrix(aux1);
        font.getData().setScale(scaleXBak, scaleYBak);
    }

    private static void lookAtRotation(Quaternion quaternion, Vector3 direction, Vector3 up) {
        direction.nor();
        up = up.sub(direction.scl(up.dot(direction)));
        up.nor();
        Vector3 right = up.crs(direction);
        quaternion.w = (float)FastMath.sqrt((double)(1.0f + right.x + up.y + direction.z)) * 0.5f;
        double w4Recip = 1.0 / (4.0 * (double)quaternion.w);
        quaternion.x = (float)((double)(up.z - direction.y) * w4Recip);
        quaternion.y = (float)((double)(direction.x - right.z) * w4Recip);
        quaternion.z = (float)((double)(right.y - up.x) * w4Recip);
    }

    public static Quaternion getBillboardRotation(Vector3 direction, Vector3 up, Quaternion out) {
        DecalUtils.setBillboardRotation(out, direction, up);
        return out;
    }

    public static void setBillboardRotation(Quaternion rotation, Vector3 direction, Vector3 up) {
        tmp.set(up).crs(direction).nor();
        tmp2.set(direction).crs(tmp).nor();
        rotation.setFromAxes(DecalUtils.tmp.x, DecalUtils.tmp2.x, direction.x, DecalUtils.tmp.y, DecalUtils.tmp2.y, direction.y, DecalUtils.tmp.z, DecalUtils.tmp2.z, direction.z);
    }

    public static void setBillboardRotation(Quaternion rotation, Vector3D direction, Vector3D up) {
        tmp.set((float)up.x, (float)up.y, (float)up.z).crs((float)direction.x, (float)direction.y, (float)direction.z).nor();
        tmp2.set((float)direction.x, (float)direction.y, (float)direction.z).crs(tmp).nor();
        rotation.setFromAxes(DecalUtils.tmp.x, DecalUtils.tmp2.x, (float)direction.x, DecalUtils.tmp.y, DecalUtils.tmp2.y, (float)direction.y, DecalUtils.tmp.z, DecalUtils.tmp2.z, (float)direction.z);
    }
}

